/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.client.util;

import com.ibm.team.enterprise.common.common.ZComponentNature;
import com.ibm.team.enterprise.common.common.ZHfsComponentNature;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ZComponentUtils {
    private ZComponentUtils() {
    }

    public static IProject getProject(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public static IFolder getContainer(String projectName, String containerName) {
        IFolder container = null;
        IProject project = ZComponentUtils.getProject(projectName);
        if (project != null) {
            container = project.getFolder((IPath)new Path("zOSsrc/" + containerName));
        }
        return container;
    }

    public static boolean isZComponentProject(String projectName) {
        return ZComponentUtils.isZComponentProject(projectName, ZComponentNature.ID);
    }

    public static boolean isZHfsComponentProject(String projectName) {
        return ZComponentUtils.isZComponentProject(projectName, ZHfsComponentNature.ID);
    }

    private static boolean isZComponentProject(String projectName, String nature) {
        boolean hasNature = false;
        IProject project = ZComponentUtils.getProject(projectName);
        if (project != null && project.exists()) {
            try {
                hasNature = project.hasNature(nature);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return hasNature;
    }

    public static boolean isZComponentProject(IConfiguration configuration, IFileContentManager contentManager, IFileItemHandle fileItemHandle) throws Exception {
        return ZComponentUtils.isZComponentProject(configuration, contentManager, fileItemHandle, ZComponentNature.ID);
    }

    public static boolean isZHfsComponentProject(IConfiguration configuration, IFileContentManager contentManager, IFileItemHandle fileItemHandle) throws Exception {
        return ZComponentUtils.isZComponentProject(configuration, contentManager, fileItemHandle, ZHfsComponentNature.ID);
    }

    private static boolean isZComponentProject(IConfiguration configuration, IFileContentManager contentManager, IFileItemHandle fileItemHandle, String nature) throws Exception {
        boolean result = false;
        IFileItem fileItem = (IFileItem)configuration.fetchCompleteItem((IVersionableHandle)fileItemHandle, null);
        InputStream inputStream = contentManager.retrieveContentStream((IFileItemHandle)fileItem, fileItem.getContent(), null);
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(inputStream);
        NodeList list = doc.getElementsByTagName("nature");
        int i = 0;
        while (i < list.getLength() && !result) {
            Element el;
            Node node = list.item(i);
            if (node.getNodeType() == 1 && (el = (Element)node).getTextContent().equals(nature)) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public static IProject[] getZComponentProjects() {
        return ZComponentUtils.getZComponentProjects(ZComponentNature.ID);
    }

    public static IProject[] getZHfsComponentProjects() {
        return ZComponentUtils.getZComponentProjects(ZHfsComponentNature.ID);
    }

    private static IProject[] getZComponentProjects(String nature) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            try {
                if (projects[i].hasNature(nature)) {
                    projectList.add(projects[i]);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++i;
        }
        IProject[] buildZProjects = new IProject[projectList.size()];
        return projectList.toArray(buildZProjects);
    }

    public static IFolder[] getZFolders(String projectName) {
        IProject project;
        block5: {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project != null && project.hasNature(ZComponentNature.ID)) break block5;
            return null;
        }
        try {
            IFolder buildZResourceFolder = project.getFolder("zOSsrc");
            IResource[] resources = buildZResourceFolder.members();
            ArrayList<IResource> containerList = new ArrayList<IResource>();
            int i = 0;
            while (i < resources.length) {
                if (resources[i].getType() == 2) {
                    containerList.add(resources[i]);
                }
                ++i;
            }
            IFolder[] containers = new IFolder[containerList.size()];
            return containerList.toArray(containers);
        }
        catch (CoreException ce) {
            return null;
        }
    }

    public static String buildCSList(List<String> elements) {
        StringBuffer sBuf = new StringBuffer();
        int numElements = elements == null ? 0 : elements.size();
        int i = 0;
        while (i < numElements) {
            sBuf.append(String.valueOf(elements.get(i)) + ",");
            ++i;
        }
        return sBuf.toString();
    }

    public static boolean isZComponentProject(Object element) throws CoreException {
        return element != null && element instanceof IProject && ((IProject)element).hasNature(ZComponentNature.ID);
    }

    public static boolean isZHfsComponentProject(Object element) throws CoreException {
        return element != null && element instanceof IProject && ((IProject)element).hasNature(ZHfsComponentNature.ID);
    }

    public static boolean isZSourceFolder(Object element) throws CoreException {
        IFolder folder;
        boolean flag = false;
        if (element != null && element instanceof IFolder && (folder = (IFolder)element).getParent() == folder.getProject() && ZComponentUtils.isZComponentProject(folder.getProject()) && folder.getName().equals("zOSsrc")) {
            flag = true;
        }
        return flag;
    }

    public static boolean isZBinSourceFolder(Object element) throws CoreException {
        IFolder folder;
        boolean flag = false;
        if (element != null && element instanceof IFolder && (folder = (IFolder)element).getParent() == folder.getProject() && ZComponentUtils.isZComponentProject(folder.getProject()) && folder.getName().equals(".zOSbin")) {
            flag = true;
        }
        return flag;
    }

    public static boolean isZFolder(Object element) throws CoreException {
        return element != null && element instanceof IFolder && ZComponentUtils.isZSourceFolder(((IFolder)element).getParent());
    }

    public static boolean isZBinFolder(Object element) throws CoreException {
        return element != null && element instanceof IFolder && ZComponentUtils.isZBinSourceFolder(((IFolder)element).getParent());
    }

    public static boolean isZFile(Object element) throws CoreException {
        return element != null && element instanceof IFile && ZComponentUtils.isZFolder(((IFile)element).getParent());
    }

    public static boolean isZObject(Object element) throws CoreException {
        return ZComponentUtils.isZComponentProject(element) || ZComponentUtils.isZSourceFolder(element) || ZComponentUtils.isZBinSourceFolder(element) || ZComponentUtils.isZFolder(element) || ZComponentUtils.isZBinFolder(element) || ZComponentUtils.isZFile(element) || ZComponentUtils.isUSSFolder(element);
    }

    public static IFolder getZFolderPropertiesFolder(IFolder zFolder) throws CoreException {
        IFolder srcFolder;
        IProject project;
        IFolder antzBuild;
        IFolder propertiesFolder = null;
        if (ZComponentUtils.isZFolder(zFolder) && (antzBuild = (project = zFolder.getProject()).getFolder(".antzBuild")) != null && antzBuild.exists() && (srcFolder = antzBuild.getFolder("zOSsrc")) != null && srcFolder.exists()) {
            propertiesFolder = srcFolder.getFolder(zFolder.getName());
        }
        return propertiesFolder;
    }

    public static IFolder getZSrcFolderPropertiesSrcFolder(IFolder zSrcFolder) throws CoreException {
        IProject project;
        IFolder antzBuild;
        IFolder propertiesZSrcFolder = null;
        if (ZComponentUtils.isZSourceFolder(zSrcFolder) && (antzBuild = (project = zSrcFolder.getProject()).getFolder(".antzBuild")) != null && antzBuild.exists()) {
            propertiesZSrcFolder = antzBuild.getFolder("zOSsrc");
        }
        return propertiesZSrcFolder;
    }

    public static IFile getZFilePropertiesFile(IFile zFile) throws CoreException {
        IFolder propertiesFolder;
        IFolder srcFolder;
        IProject project;
        IFolder antzBuild;
        IFile propertiesFile = null;
        if (ZComponentUtils.isZFile(zFile) && (antzBuild = (project = zFile.getProject()).getFolder(".antzBuild")) != null && antzBuild.exists() && (srcFolder = antzBuild.getFolder("zOSsrc")) != null && srcFolder.exists() && (propertiesFolder = srcFolder.getFolder(zFile.getParent().getName())) != null && propertiesFolder.exists()) {
            propertiesFile = propertiesFolder.getFile(String.valueOf(zFile.getName()) + ".properties");
        }
        return propertiesFile;
    }

    public static boolean isUSSFolder(Object element) throws CoreException {
        boolean result = false;
        if (element instanceof IFolder && !ZComponentUtils.isZFolder(element) && !ZComponentUtils.isZSourceFolder(element) && ZComponentUtils.isZComponentProject(((IFolder)element).getParent())) {
            result = true;
        } else if (element instanceof IFolder && ZComponentUtils.isZHfsComponentProject(((IFolder)element).getParent())) {
            result = true;
        }
        return result;
    }

    public static ITeamRepository getTeamRepository(IShareable shareable) {
        if (shareable == null) {
            return null;
        }
        IShare share = null;
        try {
            share = shareable.getShare((IProgressMonitor)new NullProgressMonitor());
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        if (share == null) {
            return null;
        }
        ISharingDescriptor descriptor = share.getSharingDescriptor();
        return ZComponentUtils.getTeamRepository(descriptor.getRepositoryId());
    }

    public static ITeamRepository getTeamRepository(ISharingDescriptor desc) {
        return ZComponentUtils.getTeamRepository(desc.getRepositoryId());
    }

    public static ITeamRepository getTeamRepository(UUID repositoryId) {
        ITeamRepository[] repositories;
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            if (repositoryId.equals((Object)repository.getId())) {
                return repository;
            }
            ++n2;
        }
        return null;
    }

    public static IShareable getSharable(IAdaptable resource) {
        if (resource == null) {
            return null;
        }
        return (IShareable)resource.getAdapter(IShareable.class);
    }

    public static IShareable getSharable(IProject project) {
        if (project == null) {
            return null;
        }
        return (IShareable)project.getAdapter(IShareable.class);
    }

    public static IShareable getSharable(IResource resource) {
        if (resource == null) {
            return null;
        }
        return (IShareable)resource.getAdapter(IShareable.class);
    }

    public static boolean isShared(IAdaptable adaptable) {
        if (adaptable == null) {
            return false;
        }
        IShareable share = (IShareable)adaptable.getAdapter(IShareable.class);
        return ZComponentUtils.getTeamRepository(share) != null;
    }

    public static boolean isShared(IProject project) {
        IShareable shareable = ZComponentUtils.getSharable(project);
        if (shareable == null) {
            return false;
        }
        IShare share = null;
        try {
            share = shareable.getShare((IProgressMonitor)new NullProgressMonitor());
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        return share != null;
    }
}

