/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.client.util;

import com.ibm.team.enterprise.common.common.utils.ItemUtilities;
import com.ibm.team.foundation.client.internal.util.ClientURIUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import org.eclipse.core.runtime.IProgressMonitor;

public class URIUtilities {
    private static final String DEFAULT_ENCODING = "UTF-8";

    public static URI createItemURI(ITeamRepository teamRepository, IItem item) {
        return ItemUtilities.createItemURI((IItem)item, (String)teamRepository.getRepositoryURI());
    }

    public static URI createItemURI(ITeamRepository teamRepository, IItemHandle itemHandle) {
        return ItemUtilities.createItemURI((IItemHandle)itemHandle, (String)teamRepository.getRepositoryURI());
    }

    public static String decode(String string) {
        block3: {
            try {
                if (string != null) break block3;
                return null;
            }
            catch (UnsupportedEncodingException x) {
                throw new RuntimeException(x);
            }
        }
        return URLDecoder.decode(string.replace("%20", "+"), DEFAULT_ENCODING);
    }

    public static IItemType findItemType(URI uri) {
        return ItemUtilities.findItemType((URI)uri);
    }

    public static ITeamRepository findTeamRepository(URI uri) {
        URI repoUri = uri;
        if (uri != null) {
            String baseUrl = uri.toString();
            if (uri.getRawQuery() != null) {
                int indexOfQuery = baseUrl.indexOf(uri.getRawQuery().toString());
                baseUrl = indexOfQuery > -1 ? baseUrl.substring(0, indexOfQuery - 1) : URIUtilities.buildDefaultURIString(uri);
            }
            repoUri = URI.create(baseUrl);
        }
        return ClientURIUtils.findTeamRepository((URI)repoUri);
    }

    public static IItemHandle getItemHandle(URI uri) {
        return ItemUtilities.getItemHandle((URI)uri);
    }

    public static Object resolveObject(URI uri, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemType itemType = URIUtilities.findItemType(uri);
        if (itemType == null) {
            return null;
        }
        return URIUtilities.resolveItem(uri, monitor);
    }

    private static IItem resolveItem(URI uri, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = URIUtilities.findTeamRepository(uri);
        if (teamRepository == null) {
            return null;
        }
        Location location = null;
        try {
            location = Location.location((URI)uri);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        if (location != null && location.getItemType() != null) {
            try {
                return teamRepository.itemManager().fetchCompleteItem(location, 0, monitor);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String buildDefaultURIString(URI uri) {
        StringBuilder uriBuilder = new StringBuilder();
        if (uri.getScheme() != null) {
            uriBuilder.append(String.valueOf(uri.getScheme()) + ":");
        }
        if (uri.getHost() != null) {
            uriBuilder.append("//").append(uri.getHost());
        }
        if (uri.getPort() != -1) {
            uriBuilder.append(":" + uri.getPort());
        }
        if (uri.getPath() != null) {
            uriBuilder.append(uri.getPath());
        }
        return uriBuilder.toString();
    }
}

