/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.common.client;

import com.ibm.team.enterprise.common.common.AntzBuildNature;
import com.ibm.team.enterprise.common.common.RdzLocalNature;
import com.ibm.team.enterprise.common.common.ZComponentException;
import com.ibm.team.enterprise.common.common.ZHfsComponentNature;
import com.ibm.team.enterprise.internal.common.client.nls.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ZHfsComponentFactory {
    private static List<String> defaultHfsNatures = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(AntzBuildNature.ID);
            this.add(ZHfsComponentNature.ID);
            this.add(RdzLocalNature.ID);
        }
    };

    public static IProject createZComponentProject(String projectName, List<String> natures, IProgressMonitor monitor) throws ZComponentException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (natures == null) {
            natures = defaultHfsNatures;
        } else {
            natures.add(ZHfsComponentNature.ID);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ZHfsComponentFactory.validateName(projectName);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (project.exists()) {
            throw new ZComponentException(NLS.bind((String)Messages.ZHfsComponent_PROJECT_NAME_EXISTS, (Object)projectName));
        }
        IProjectDescription description = workspace.newProjectDescription(project.getName());
        description.setName(projectName);
        description.setNatureIds(natures.toArray(new String[natures.size()]));
        try {
            project.create(description, monitor);
            project.open(monitor);
            project.refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            throw new ZComponentException((Throwable)e);
        }
        return project;
    }

    private static void validateName(String name) throws ZComponentException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus nameStatus = workspace.validateName(name, 4);
        if (!nameStatus.isOK()) {
            throw new ZComponentException(NLS.bind((String)Messages.ZHfsComponent_PROJECT_NAME_INVALID, (Object)name, (Object)nameStatus.getMessage()), nameStatus);
        }
        if (name.indexOf(32) > -1) {
            throw new ZComponentException(NLS.bind((String)Messages.ZHfsComponent_PROJECT_NAME_INVALID, (Object)name, (Object)Messages.ZHfsComponent_INVALID_NAME_SPACE));
        }
    }
}

