/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.buildablesubset.common.util;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableFileDesc;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubset;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubsetCriteria;
import com.ibm.team.enterprise.buildablesubset.common.dto.IBuildableFileDesc2;
import com.ibm.team.enterprise.buildablesubset.common.dto.IBuildableSubset2;
import com.ibm.team.enterprise.buildablesubset.common.dto.IBuildableSubsetCriteria2;
import com.ibm.team.enterprise.buildablesubset.common.dto.IBuildableSubsetSubsetCriteria2;
import com.ibm.team.enterprise.buildablesubset.common.dto.IBuildableSubsetWorkItemCriteria2;
import com.ibm.team.enterprise.buildablesubset.common.internal.model.CriteriaSubset;
import com.ibm.team.enterprise.buildablesubset.common.internal.model.ModelFactory;
import com.ibm.team.enterprise.buildablesubset.common.internal.model.StringHelper;
import com.ibm.team.enterprise.buildablesubset.common.internal.model.SubsetFileDesc;
import com.ibm.team.enterprise.buildablesubset.common.model.ICriteriaSubset;
import com.ibm.team.enterprise.buildablesubset.common.model.ICriteriaWorkItem;
import com.ibm.team.enterprise.buildablesubset.common.model.IStringHelper;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetCriteria;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetFileDesc;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;

public class BuildableSubsetUtil {
    public static IComponentHandle createComponentHandle(String componentId) {
        return (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)componentId), null);
    }

    public static IBuildDefinitionHandle createBuildDefinitionHandle(String itemUUID) {
        return (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemUUID), null);
    }

    public static IContributorHandle createContributorHandle(String itemUUID) {
        return (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemUUID), null);
    }

    public static IWorkspaceHandle createWorkspaceHandle(String itemUUID) {
        return (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemUUID), null);
    }

    public static IFileItemHandle createFileItemHandle(String itemUUID) {
        return (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemUUID), null);
    }

    public static String getOldSlug(String label, String workspaceUUID) {
        StringBuffer slugBuffer = new StringBuffer("_workspaceUUID=");
        slugBuffer.append(workspaceUUID);
        slugBuffer.append("_buildableSubsetLabel=");
        slugBuffer.append(BuildableSubsetUtil.createURLEncodedName(label));
        return slugBuffer.toString();
    }

    public static String getSlug(String label, String buildDefinitionUUID) {
        StringBuffer slugBuffer = new StringBuffer("_buildDefinitionUUID=");
        slugBuffer.append(buildDefinitionUUID);
        slugBuffer.append("_buildableSubsetLabel=");
        slugBuffer.append(label == null ? label : BuildableSubsetUtil.createURLEncodedName(label));
        return slugBuffer.toString();
    }

    public static String getLabelFromSlug(String slug) {
        int idx;
        if (slug != null && !slug.isEmpty() && (idx = slug.indexOf("_buildableSubsetLabel=")) > -1) {
            String encodedLabel = slug.substring(idx += "_buildableSubsetLabel=".length());
            try {
                return URLDecoder.decode(encodedLabel, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return encodedLabel;
            }
        }
        return slug;
    }

    public static IBuildDefinitionHandle getBuildDefinitionFromSlug(String slug) {
        int stopIdx;
        int idx;
        if (slug != null && !slug.isEmpty() && (idx = slug.indexOf("_buildDefinitionUUID=")) > -1 && (stopIdx = slug.indexOf("_buildableSubsetLabel=")) > (idx += "_buildDefinitionUUID=".length())) {
            String uuid = slug.substring(idx, stopIdx);
            try {
                return (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isOldSlug(String buildableSubsetSlug) {
        return buildableSubsetSlug.indexOf("_workspaceUUID=") > -1;
    }

    public static String convertToNewSlug(String oldSlug, String buildDefinitionUUID) {
        int index = oldSlug.indexOf("_buildableSubsetLabel=");
        if (index > -1) {
            String encodedLabel = oldSlug.substring(index);
            return "_buildDefinitionUUID=" + buildDefinitionUUID + encodedLabel;
        }
        return oldSlug;
    }

    public static String createURLEncodedName(String name) {
        try {
            return URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return name;
        }
    }

    public static String getReferencedCriterionUUID(String reference) {
        int slash = reference.indexOf(47);
        if (slash != -1) {
            return reference.substring(0, slash);
        }
        return reference;
    }

    public static boolean reconcile(ISubsetCriteria newCriteria, ISubsetCriteria existingCriteria, Collection<ISubsetFileDesc> files) {
        boolean result = false;
        if (newCriteria == null || existingCriteria == null) {
            return result;
        }
        if (newCriteria instanceof ICriteriaWorkItem && existingCriteria instanceof ICriteriaWorkItem) {
            List existingWIHandles;
            ICriteriaWorkItem newWiCriteria = (ICriteriaWorkItem)newCriteria;
            ICriteriaWorkItem existingWiCriteria = (ICriteriaWorkItem)existingCriteria;
            List newWIHandles = newWiCriteria.getWorkItems().stream().map(wi -> ((IWorkItemHandle)wi).getItemId()).collect(Collectors.toList());
            if (newWIHandles.containsAll(existingWIHandles = existingWiCriteria.getWorkItems().stream().map(wi -> ((IWorkItemHandle)wi).getItemId()).collect(Collectors.toList()))) {
                existingWiCriteria.setIncludeChildren(newWiCriteria.isIncludeChildren());
                existingWiCriteria.setIncludeImpacted(newWiCriteria.isIncludeImpacted());
                existingWiCriteria.getAdditionalWorkItems().addAll(newWiCriteria.getAdditionalWorkItems());
                return true;
            }
        }
        if (newCriteria instanceof CriteriaSubset && existingCriteria instanceof CriteriaSubset) {
            CriteriaSubset newSubsetCriteria = (CriteriaSubset)newCriteria;
            CriteriaSubset existingSubsetCriteria = (CriteriaSubset)existingCriteria;
            if (newSubsetCriteria.getSubset().getItemId().equals((Object)existingSubsetCriteria.getSubset().getItemId())) {
                BuildableSubsetUtil.mergeCriteria2(existingSubsetCriteria.getChildCriteria().getReferences(), newSubsetCriteria.getChildCriteria().getReferences(), files, false);
                return true;
            }
        }
        return result;
    }

    public static List<Object> getReferencedCriterion(IBuildableFileDesc file, List<IBuildableSubsetCriteria> criteria) {
        ArrayList<Object> result = null;
        if (file != null && criteria != null) {
            result = new ArrayList<Object>();
            for (String reference : file.getCriteriaReferences()) {
                String uuid = BuildableSubsetUtil.getReferencedCriterionUUID(reference);
                for (IBuildableSubsetCriteria criterion : criteria) {
                    Object o;
                    if (!uuid.equals(criterion.getUUID().getUuidValue()) || (o = criterion.deref(reference)) == null) continue;
                    result.add(o);
                }
            }
        }
        return result;
    }

    public static List<IBuildableFileDesc> merge(List<IBuildableFileDesc> existingFiles, Collection<IBuildableFileDesc> newFiles, boolean forceSCMPathUpdate) {
        return BuildableSubsetUtil.merge(existingFiles, newFiles, forceSCMPathUpdate, false);
    }

    public static List<IBuildableFileDesc> merge(List<IBuildableFileDesc> existingFiles, Collection<IBuildableFileDesc> newFiles, boolean forceSCMPathUpdate, boolean returnMergedFiles) {
        ArrayList<IBuildableFileDesc> result = new ArrayList<IBuildableFileDesc>();
        if (newFiles == null || newFiles.isEmpty()) {
            return result;
        }
        for (IBuildableFileDesc newFile : newFiles) {
            int existingIndex = existingFiles.indexOf(newFile);
            if (existingIndex >= 0) {
                IBuildableFileDesc existingFile = existingFiles.get(existingIndex);
                boolean origAlwaysBuild = existingFile.isAlwaysBuild();
                String origScmPath = existingFile.getScmPath();
                int origReferenceCount = existingFile.getCriteriaReferences().size();
                for (String reference : newFile.getCriteriaReferences()) {
                    if (existingFile.getCriteriaReferences().contains(reference)) continue;
                    existingFile.getCriteriaReferences().add(reference);
                }
                existingFile.setAlwaysBuild(existingFile.isAlwaysBuild() || newFile.isAlwaysBuild());
                if (forceSCMPathUpdate || existingFile.getScmPath() == null || existingFile.getScmPath().isEmpty()) {
                    existingFile.setScmPath(newFile.getScmPath());
                }
                if (!returnMergedFiles || origAlwaysBuild == existingFile.isAlwaysBuild() && origReferenceCount == existingFile.getCriteriaReferences().size() && BuildableSubsetUtil.equivalent(origScmPath, existingFile.getScmPath())) continue;
                result.add(existingFile);
                continue;
            }
            existingFiles.add(newFile);
            result.add(newFile);
        }
        return result;
    }

    private static boolean equivalent(String s1, String s2) {
        if (s1 == null || s1.isEmpty()) {
            return s2 == null || s2.isEmpty();
        }
        if (s2 == null || s2.isEmpty()) {
            return false;
        }
        return s1.equals(s2);
    }

    public static List<IBuildableFileDesc2> merge2(List<IBuildableFileDesc2> existingFiles, Collection<IBuildableFileDesc2> newFiles, boolean updateSCMPath) {
        ArrayList<IBuildableFileDesc2> result = new ArrayList<IBuildableFileDesc2>();
        if (newFiles == null || newFiles.isEmpty()) {
            return result;
        }
        HashMap<BuildableFileDesc2Key, IBuildableFileDesc2> cachedExistingFiles = new HashMap<BuildableFileDesc2Key, IBuildableFileDesc2>(existingFiles.size() + newFiles.size());
        for (IBuildableFileDesc2 file : existingFiles) {
            cachedExistingFiles.put(new BuildableFileDesc2Key(file), file);
        }
        for (IBuildableFileDesc2 newFile : newFiles) {
            BuildableFileDesc2Key key = new BuildableFileDesc2Key(newFile);
            IBuildableFileDesc2 existingFile = (IBuildableFileDesc2)cachedExistingFiles.get(key);
            if (existingFile != null) {
                for (String reference : newFile.getCriteriaReferences()) {
                    if (existingFile.getCriteriaReferences().contains(reference)) continue;
                    existingFile.getCriteriaReferences().add(reference);
                }
                existingFile.setAlwaysBuild(existingFile.isAlwaysBuild() || newFile.isAlwaysBuild());
                if (!updateSCMPath && existingFile.getScmPath() != null && !existingFile.getScmPath().isEmpty()) continue;
                existingFile.setScmPath(newFile.getScmPath());
                continue;
            }
            existingFiles.add(newFile);
            result.add(newFile);
            cachedExistingFiles.put(key, newFile);
        }
        return result;
    }

    private static void updateExistingEntry(ISubsetFileDesc newFile, ISubsetFileDesc existingFile) {
        ArrayList<StringHelper> missingRefs = new ArrayList<StringHelper>();
        for (StringHelper reference : newFile.getCriteriaRefs()) {
            ArrayList<String> refs = new ArrayList<String>();
            for (Object o : existingFile.getCriteriaRefs()) {
                if (!(o instanceof StringHelper)) continue;
                StringHelper helper = (StringHelper)o;
                refs.add(helper.getValue());
            }
            if (refs.contains(reference.getValue())) continue;
            missingRefs.add(reference);
        }
        existingFile.getCriteriaRefs().addAll(missingRefs);
        existingFile.setAlwaysBuild(existingFile.isAlwaysBuild() || newFile.isAlwaysBuild());
    }

    public static List<ISubsetFileDesc> merge3(List<ISubsetFileDesc> existingFiles, List<ISubsetFileDesc> newFiles) {
        if (newFiles == null || newFiles.isEmpty()) {
            return existingFiles;
        }
        HashMap cachedExistingFiles = new HashMap(existingFiles.size() + newFiles.size());
        existingFiles.stream().forEach(file -> {
            ISubsetFileDesc iSubsetFileDesc = cachedExistingFiles.put(new FileDescKey((ISubsetFileDesc)file), file);
        });
        newFiles.stream().forEach(newFile -> {
            FileDescKey key = new FileDescKey((ISubsetFileDesc)newFile);
            ISubsetFileDesc exisitingFile = (ISubsetFileDesc)cachedExistingFiles.get(key);
            if (exisitingFile != null) {
                BuildableSubsetUtil.updateExistingEntry(newFile, exisitingFile);
            } else {
                existingFiles.add((ISubsetFileDesc)newFile);
                cachedExistingFiles.put(key, newFile);
            }
        });
        return existingFiles;
    }

    public static List<IBuildableSubsetCriteria> merge(List<IBuildableSubsetCriteria> existingCriteria, Collection<IBuildableSubsetCriteria> newCriteria) {
        return BuildableSubsetUtil.mergeCriteria(existingCriteria, newCriteria, true);
    }

    public static List<ISubsetCriteria> merge3(Collection<ISubsetCriteria> existingCriteria, Collection<ISubsetCriteria> newCriteria, Collection<ISubsetFileDesc> files) {
        return BuildableSubsetUtil.mergeCriteria2(existingCriteria, newCriteria, files, true);
    }

    public static List<ISubsetCriteria> mergeCriteria2(Collection<ISubsetCriteria> existingCriteria, Collection<ISubsetCriteria> newCriteria, Collection<ISubsetFileDesc> files, boolean updateReferences) {
        ArrayList<ISubsetCriteria> result = new ArrayList<ISubsetCriteria>();
        if (newCriteria == null || newCriteria.isEmpty()) {
            return result;
        }
        for (ISubsetCriteria newCriterion : newCriteria) {
            boolean isNew = true;
            if (existingCriteria != null) {
                for (ISubsetCriteria existingCriterion : existingCriteria) {
                    if (BuildableSubsetUtil.isDynamic(existingCriterion) != BuildableSubsetUtil.isDynamic(newCriterion) || !BuildableSubsetUtil.reconcile(newCriterion, existingCriterion, files)) continue;
                    isNew = false;
                    if (!updateReferences) continue;
                    String existingUUID = existingCriterion.getInternalId().getUuidValue();
                    String newUUID = newCriterion.getInternalId().getUuidValue();
                    for (ISubsetFileDesc file : files) {
                        ListIterator iterator = file.getCriteriaRefs().listIterator();
                        while (iterator.hasNext()) {
                            BuildableSubsetUtil.updateRefForStringHelper((StringHelper)iterator.next(), newUUID, existingUUID);
                        }
                    }
                }
            }
            if (!isNew) continue;
            existingCriteria.add(newCriterion);
            result.add(newCriterion);
            isNew = false;
        }
        return result;
    }

    public static boolean isDynamic(ISubsetCriteria criterion) {
        boolean result = false;
        if (criterion instanceof ICriteriaSubset && ((ICriteriaSubset)criterion).isDynamic()) {
            result = true;
        }
        if (criterion instanceof ICriteriaWorkItem && ((ICriteriaWorkItem)criterion).isDynamic()) {
            result = true;
        }
        return result;
    }

    public static List<IBuildableSubsetCriteria> mergeCriteria(List<IBuildableSubsetCriteria> existingCriteria, Collection<IBuildableSubsetCriteria> newCriteria, boolean updateReferences) {
        ArrayList<IBuildableSubsetCriteria> result = new ArrayList<IBuildableSubsetCriteria>();
        if (newCriteria == null || newCriteria.isEmpty()) {
            return result;
        }
        for (IBuildableSubsetCriteria newCriterion : newCriteria) {
            boolean isNew = true;
            if (existingCriteria != null) {
                for (IBuildableSubsetCriteria existingCriterion : existingCriteria) {
                    if (existingCriterion.isDynamic() != newCriterion.isDynamic() || !newCriterion.reconcile(existingCriterion)) continue;
                    isNew = false;
                    if (!updateReferences) continue;
                    String existingUUID = existingCriterion.getUUID().getUuidValue();
                    String newUUID = newCriterion.getUUID().getUuidValue();
                    for (IBuildableFileDesc file : newCriterion.getBuildableFileDescs()) {
                        ListIterator<String> iterator = file.getCriteriaReferences().listIterator();
                        while (iterator.hasNext()) {
                            String newRef = BuildableSubsetUtil.getUpdatedRef(iterator.next(), newUUID, existingUUID);
                            if (newRef == null || file.getCriteriaReferences().contains(newRef)) continue;
                            iterator.set(newRef);
                        }
                    }
                }
            }
            if (!isNew) continue;
            existingCriteria.add(newCriterion);
            result.add(newCriterion);
            isNew = false;
        }
        return result;
    }

    public static ISubsetFileDesc createFileDesc(String compUUID, String fileUUID) {
        SubsetFileDesc desc = ModelFactory.eINSTANCE.createSubsetFileDesc();
        desc.setComponent(BuildableSubsetUtil.createComponentHandle(compUUID));
        desc.setFileItem((IVersionableHandle)BuildableSubsetUtil.createFileItemHandle(fileUUID));
        return desc;
    }

    public static SubsetMergeResults2 merge3(List<ISubsetFileDesc> files, List<ISubsetCriteria> criteria, ISubset mergeSubset) {
        SubsetMergeResults2 result = new SubsetMergeResults2();
        if (mergeSubset != null) {
            mergeSubset = mergeSubset.isWorkingCopy() ? mergeSubset : (ISubset)mergeSubset.getWorkingCopy();
            List<ISubsetCriteria> newCriteria = mergeSubset.getCriteria().getReferences();
            List newFiles = mergeSubset.getFileDescs();
            if (newCriteria != null && newCriteria.size() > 0 || newFiles != null && newFiles.size() > 0) {
                result.addedCriteria = BuildableSubsetUtil.merge3(criteria, newCriteria, newFiles);
                result.addedAndMergedFiles = BuildableSubsetUtil.merge3(files, newFiles);
            }
        }
        return result;
    }

    public static boolean containsFile(Collection<ISubsetFileDesc> currFiles, IVersionableHandle file, IComponentHandle component) {
        boolean alreadyContains = currFiles.stream().anyMatch(f -> f.getComponent().getItemId().equals((Object)component.getItemId()) && f.getFileItem().getItemId().equals((Object)file.getItemId()));
        return alreadyContains;
    }

    public static boolean containsFile(ISubsetFileDesc file, Collection<UUID> files) {
        if (file instanceof SubsetFileDesc) {
            SubsetFileDesc subsetFile = (SubsetFileDesc)file;
            UUID fileUUID = subsetFile.getFileItem().getItemId();
            if (fileUUID == null) {
                return false;
            }
            return files.stream().anyMatch(uuid -> uuid.equals((Object)fileUUID));
        }
        return false;
    }

    public static boolean containsFileWithRef(ISubsetFileDesc file, Collection<ISubsetFileDesc> files) {
        List subsetFiles = files.stream().map(SubsetFileDesc.class::cast).collect(Collectors.toList());
        if (file instanceof SubsetFileDesc) {
            SubsetFileDesc f = (SubsetFileDesc)file;
            UUID fileUUID = f.getInternalId();
            if (fileUUID == null) {
                return false;
            }
            return subsetFiles.stream().anyMatch(subsetFile -> subsetFile.getInternalId().equals((Object)fileUUID) && BuildableSubsetUtil.areCriteriaRefsSame(subsetFile.getCriteriaRefs(), file.getCriteriaRefs()));
        }
        return false;
    }

    public static boolean areCriteriaRefsSame(List<IStringHelper> criteriaRefs1, List<IStringHelper> criteriaRefs2) {
        String criteriaRefsString1 = criteriaRefs1.stream().map(helper -> helper.getValue()).collect(Collectors.joining());
        String criteriaRefsString2 = criteriaRefs2.stream().map(helper -> helper.getValue()).collect(Collectors.joining());
        return criteriaRefsString1.equals(criteriaRefsString2);
    }

    public static List<UUID> collectSubsetFileDescUUIDs(Collection<ISubsetFileDesc> files) {
        List subsetFiles = files.stream().filter(SubsetFileDesc.class::isInstance).map(SubsetFileDesc.class::cast).collect(Collectors.toList());
        return subsetFiles.stream().map(file -> file.getFileItem().getItemId()).filter(uuid -> uuid != null).collect(Collectors.toList());
    }

    public static SubsetMergeResults merge(List<IBuildableFileDesc> files, List<IBuildableSubsetCriteria> criteria, IBuildableSubset mergeSubset) {
        SubsetMergeResults result = new SubsetMergeResults();
        if (mergeSubset != null) {
            List<IBuildableSubsetCriteria> newCriteria = mergeSubset.getCriteria();
            List<IBuildableFileDesc> newFiles = mergeSubset.getBuildableFileDescs();
            if (newCriteria != null && newCriteria.size() > 0 || newFiles != null && newFiles.size() > 0) {
                result.addedCriteria = BuildableSubsetUtil.merge(criteria, newCriteria);
                result.addedAndMergedFiles = BuildableSubsetUtil.merge(files, newFiles, true, true);
            }
        }
        return result;
    }

    public static String getUpdatedRef(String reference, String newUUID, String existingUUID) {
        String result = null;
        if (reference != null && reference.startsWith(newUUID)) {
            result = reference.replace(newUUID, existingUUID);
        }
        return result;
    }

    public static void updateRefForStringHelper(StringHelper referenceHelper, String newUUID, String existingUUID) {
        String reference = referenceHelper.getValue();
        if (reference != null && reference.startsWith(existingUUID)) {
            referenceHelper.setValue(reference.replace(newUUID, existingUUID));
        }
    }

    public static void associateFilesWithCriteria(IBuildableSubset2 subset) {
        if (subset != null) {
            for (IBuildableSubsetCriteria2 criterion : subset.getCriteria()) {
                String uuidAsString = criterion.getUUID().getUuidValue();
                block1: for (IBuildableFileDesc2 fileDesc : subset.getBuildableFileDescs()) {
                    for (String reference : fileDesc.getCriteriaReferences()) {
                        if (!reference.startsWith(uuidAsString)) continue;
                        criterion.getBuildableFileDescs().add(fileDesc);
                        continue block1;
                    }
                }
            }
        }
    }

    public static String createTransitoryFileListSlug(String subsetId) {
        return "_transitoryFileListId=" + subsetId;
    }

    public static Set<Integer> getWorkItemsFromCriteria(IBuildableSubset2 subset, boolean isIncludeChildren) {
        HashSet<Integer> workItems = new HashSet<Integer>();
        BuildableSubsetUtil.retrieveWorkItemsFromCriteria(subset.getCriteria(), workItems, isIncludeChildren);
        return workItems;
    }

    public static void retrieveWorkItemsFromCriteria(List<IBuildableSubsetCriteria2> criteria, Set<Integer> workItems, boolean isIncludeChildren) {
        for (IBuildableSubsetCriteria2 criterion : criteria) {
            if (criterion instanceof IBuildableSubsetWorkItemCriteria2) {
                IBuildableSubsetWorkItemCriteria2 wiCriterion = (IBuildableSubsetWorkItemCriteria2)criterion;
                workItems.addAll(wiCriterion.getWorkItems());
                if (!isIncludeChildren) continue;
                workItems.addAll(wiCriterion.getAdditionalWorkItems());
                continue;
            }
            if (!(criterion instanceof IBuildableSubsetSubsetCriteria2)) continue;
            BuildableSubsetUtil.retrieveWorkItemsFromCriteria(((IBuildableSubsetSubsetCriteria2)criterion).getChildCriteria(), workItems, isIncludeChildren);
        }
    }

    public static class BuildableFileDesc2Key {
        UUID componentId;
        UUID fileItemId;

        public BuildableFileDesc2Key(IBuildableFileDesc2 desc) {
            this.componentId = desc.getComponent().getItemId();
            this.fileItemId = desc.getFileItem().getItemId();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BuildableFileDesc2Key key = (BuildableFileDesc2Key)obj;
            return key.componentId.equals((Object)this.componentId) && key.fileItemId.equals((Object)this.fileItemId);
        }

        public int hashCode() {
            int PRIME = 31;
            return 31 + (this.componentId == null ? 0 : this.componentId.hashCode()) + (this.fileItemId == null ? 0 : this.fileItemId.hashCode());
        }
    }

    public static class FileDescKey {
        UUID componentId;
        UUID fileItemId;

        public FileDescKey(ISubsetFileDesc desc) {
            this.componentId = desc.getComponent().getItemId();
            this.fileItemId = desc.getFileItem().getItemId();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileDescKey key = (FileDescKey)obj;
            return key.componentId.equals((Object)this.componentId) && key.fileItemId.equals((Object)this.fileItemId);
        }

        public int hashCode() {
            int PRIME = 31;
            return 31 + (this.componentId == null ? 0 : this.componentId.hashCode()) + (this.fileItemId == null ? 0 : this.fileItemId.hashCode());
        }
    }

    public static class SubsetMergeResults {
        public List<IBuildableSubsetCriteria> addedCriteria = null;
        public List<IBuildableFileDesc> addedAndMergedFiles = null;
    }

    public static class SubsetMergeResults2 {
        public List<ISubsetCriteria> addedCriteria = null;
        public List<ISubsetFileDesc> addedAndMergedFiles = null;
    }
}

