/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.buildablesubset.common.util;

import com.ibm.team.enterprise.buildablesubset.common.IBuildableFileDesc;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubset;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubsetCriteria;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubsetSubsetCriteria;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubsetWorkItemCriteria;
import com.ibm.team.enterprise.buildablesubset.common.impl.BuildableFileDesc;
import com.ibm.team.enterprise.buildablesubset.common.impl.BuildableSubset;
import com.ibm.team.enterprise.buildablesubset.common.impl.BuildableSubsetSubsetCriteria;
import com.ibm.team.enterprise.buildablesubset.common.impl.BuildableSubsetWorkItemCriteria;
import com.ibm.team.enterprise.buildablesubset.common.util.Constants;
import com.ibm.team.repository.common.UUID;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class BuildableSubsetParser
extends DefaultHandler
implements Constants {
    private XMLReader fParser = XMLReaderFactory.createXMLReader();
    private IBuildableSubset fSubset;
    private StringBuilder chars;
    protected boolean inLabel = false;
    protected boolean inWorkspace = false;
    protected boolean inBuildDefinition = false;
    protected boolean inFileItem = false;
    protected boolean inDescription = false;
    protected boolean inOwnerId = false;
    protected boolean inVisibility = false;
    protected boolean inFileDescReference = false;
    protected boolean inName;
    protected boolean inValue;
    protected int criteriaDepth = 0;
    protected Stack<Object> criteriaStack;
    protected boolean isIgnoreScmPath = false;
    private static final String UTF_8 = "UTF-8";
    protected Property currentProperty;

    public BuildableSubsetParser() throws SAXException {
        this.fParser.setContentHandler(this);
        this.fParser.setDTDHandler(this);
        this.fParser.setEntityResolver(this);
        this.fParser.setErrorHandler(this);
        this.criteriaStack = new Stack();
        this.createSubset();
    }

    protected void createSubset() {
        this.fSubset = new BuildableSubset();
        this.fSubset.setBuildableFileDescs(new ArrayList<IBuildableFileDesc>());
    }

    public Object parse(InputStream inputStream, boolean ignoreScmPath) throws SAXException, IOException {
        this.isIgnoreScmPath = ignoreScmPath;
        InputSource source = new InputSource(inputStream);
        source.setEncoding(UTF_8);
        this.fParser.parse(source);
        return this.fSubset;
    }

    public Object parse(String input) throws SAXException, IOException {
        return this.parse(input, false);
    }

    public Object parse(String input, boolean ignoreScmPath) throws SAXException, IOException {
        return this.parse(new ByteArrayInputStream(input.getBytes(UTF_8)), ignoreScmPath);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.equals("label")) {
            this.inLabel = true;
            this.chars = new StringBuilder();
        } else if (localName.equals("workspaceUUID")) {
            this.inWorkspace = true;
            this.chars = new StringBuilder();
        } else if (localName.equals("buildDefinitionUUID")) {
            this.inBuildDefinition = true;
            this.chars = new StringBuilder();
        } else if (localName.equals("fileDesc")) {
            this.inFileItem = true;
            this.chars = new StringBuilder();
        } else if (localName.equals("description")) {
            this.inDescription = true;
            this.chars = new StringBuilder();
        } else if (localName.equals("ownerId")) {
            this.inOwnerId = true;
            this.chars = new StringBuilder();
        } else if (localName.equals("visibility")) {
            this.inVisibility = true;
            this.chars = new StringBuilder();
        } else if (localName.equals("fileDescRef")) {
            this.inFileDescReference = true;
            this.chars = new StringBuilder();
        } else if (localName.equals("criteria")) {
            ++this.criteriaDepth;
        } else if (localName.equals("type") || localName.equals("dynamic") || localName.equals("uuid") || localName.equals("includeChildren") || localName.equals("includeImpacted") || localName.equals("workItems") || localName.equals("extraWorkItems") || localName.equals("slug")) {
            if (this.criteriaDepth > 0) {
                this.chars = new StringBuilder();
            }
        } else if (localName.equals("property")) {
            this.currentProperty = new Property();
        } else if (localName.equals("name")) {
            this.inName = true;
            this.chars = new StringBuilder();
        } else if (localName.equals("value")) {
            this.inValue = true;
            this.chars = new StringBuilder();
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (localName.equals("label")) {
            this.inLabel = false;
            this.setLabel(this.chars.toString());
        } else if (localName.equals("workspaceUUID")) {
            this.inWorkspace = false;
            this.setWorkspaceUUID(this.chars.toString());
        } else if (localName.equals("buildDefinitionUUID")) {
            this.inBuildDefinition = false;
            this.setBuildDefinitionUUID(this.chars.toString());
        } else if (localName.equals("fileDesc")) {
            this.inFileItem = false;
            this.createBuildableFileDesc(this.chars.toString());
        } else if (localName.equals("description")) {
            this.inDescription = false;
            String desc = this.chars.toString();
            try {
                desc = URLDecoder.decode(desc, UTF_8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.setDescription(desc);
        } else if (localName.equals("ownerId")) {
            this.inOwnerId = false;
            this.setOwner(this.chars.toString());
        } else if (localName.equals("visibility")) {
            this.inVisibility = false;
            this.setVisibility(this.chars.toString());
        } else if (localName.equals("fileDescRef")) {
            this.inFileDescReference = false;
            if (this.chars.length() > 0) {
                this.addFileReference(this.chars.toString());
            }
        } else if (localName.equals("criteria")) {
            --this.criteriaDepth;
            this.criteriaStack.pop();
        } else if (localName.equals("type")) {
            if (this.criteriaDepth > 0 && this.chars.length() > 0) {
                String type = this.chars.toString();
                if ("workItem".equals(type)) {
                    this.createWorkItemCriterion();
                } else if ("subset".equals(type)) {
                    this.createSubsetCriterion();
                }
            }
        } else if (localName.equals("dynamic")) {
            if (this.criteriaDepth > 0 && this.chars.length() > 0) {
                this.setCriterionDynamic(Boolean.valueOf(this.chars.toString()));
            }
        } else if (localName.equals("uuid")) {
            if (this.criteriaDepth > 0 && this.chars.length() > 0) {
                this.setCriterionUUID(UUID.valueOf((String)this.chars.toString()));
            }
        } else if (localName.equals("includeChildren")) {
            if (this.criteriaDepth > 0 && this.chars.length() > 0) {
                this.setCriterionIncludeChildren(Boolean.valueOf(this.chars.toString()));
            }
        } else if (localName.equals("includeImpacted")) {
            if (this.criteriaDepth > 0 && this.chars.length() > 0) {
                this.setCriterionIncludeImpacted(Boolean.valueOf(this.chars.toString()));
            }
        } else if (localName.equals("workItems")) {
            if (this.criteriaDepth > 0) {
                this.addWorkItems(BuildableSubsetParser.parseWorkItems(this.chars.toString()));
            }
        } else if (localName.equals("extraWorkItems")) {
            if (this.criteriaDepth > 0) {
                this.addAdditionalWorkItems(BuildableSubsetParser.parseWorkItems(this.chars.toString()));
            }
        } else if (localName.equals("slug")) {
            if (this.criteriaDepth > 0) {
                this.setCriterionSlug(this.chars.toString());
            }
        } else if (localName.equals("property")) {
            if (this.currentProperty != null && this.currentProperty.name != null && this.currentProperty.value != null) {
                this.addProperty(this.currentProperty);
            }
            this.currentProperty = null;
        } else if (localName.equals("name")) {
            this.inName = false;
            if (this.currentProperty != null) {
                this.currentProperty.name = this.chars.toString();
                try {
                    this.currentProperty.name = URLDecoder.decode(this.currentProperty.name, UTF_8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        } else if (localName.equals("value")) {
            this.inValue = false;
            if (this.currentProperty != null) {
                this.currentProperty.value = this.chars.toString();
                try {
                    this.currentProperty.value = URLDecoder.decode(this.currentProperty.value, UTF_8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
    }

    protected void setLabel(String label) {
        if (!this.criteriaStack.isEmpty()) {
            Object criterion = this.criteriaStack.peek();
            if (criterion instanceof IBuildableSubsetSubsetCriteria) {
                ((IBuildableSubsetSubsetCriteria)criterion).setLabel(label);
            }
        } else {
            this.fSubset.setLabel(label);
        }
    }

    protected void setDescription(String desc) {
        this.fSubset.setDescription(desc);
    }

    protected void setOwner(String owner) {
        this.fSubset.setOwnerID(owner);
    }

    protected void setVisibility(String visibility) {
        this.fSubset.setVisibility(IBuildableSubset.Visibility.valueOf(visibility));
    }

    protected void setWorkspaceUUID(String uuid) {
        this.fSubset.setWorkspaceUUID(uuid);
    }

    protected void setBuildDefinitionUUID(String uuid) {
        this.fSubset.setBuildDefinitionUUID(uuid);
    }

    protected void setCriterionDynamic(boolean dynamic) {
        if (!this.criteriaStack.isEmpty()) {
            ((IBuildableSubsetCriteria)this.criteriaStack.peek()).setDynamic(dynamic);
        }
    }

    protected void setCriterionUUID(UUID uuid) {
        if (!this.criteriaStack.isEmpty()) {
            ((IBuildableSubsetCriteria)this.criteriaStack.peek()).setUUID(uuid);
        }
    }

    protected void setCriterionIncludeChildren(boolean includeChildren) {
        Object criterion;
        if (!this.criteriaStack.isEmpty() && (criterion = this.criteriaStack.peek()) instanceof IBuildableSubsetWorkItemCriteria) {
            ((IBuildableSubsetWorkItemCriteria)criterion).setIncludeChildren(includeChildren);
        }
    }

    protected void setCriterionIncludeImpacted(boolean includeImpacted) {
        Object criterion;
        if (!this.criteriaStack.isEmpty() && (criterion = this.criteriaStack.peek()) instanceof IBuildableSubsetWorkItemCriteria) {
            ((IBuildableSubsetWorkItemCriteria)criterion).setIncludeImpacted(includeImpacted);
        }
    }

    protected void setCriterionSlug(String slug) {
        Object criterion;
        if (!this.criteriaStack.isEmpty() && (criterion = this.criteriaStack.peek()) instanceof IBuildableSubsetSubsetCriteria) {
            ((IBuildableSubsetSubsetCriteria)criterion).setSlug(slug);
        }
    }

    protected void addFileReference(String reference) {
        if (this.fSubset.getBuildableFileDescs().size() > 0) {
            IBuildableFileDesc latestDesc = this.fSubset.getBuildableFileDescs().get(this.fSubset.getBuildableFileDescs().size() - 1);
            latestDesc.getCriteriaReferences().add(reference);
        }
    }

    protected void addWorkItems(List<Integer> workItems) {
        Object criterion;
        if (workItems.size() > 0 && !this.criteriaStack.isEmpty() && (criterion = this.criteriaStack.peek()) instanceof IBuildableSubsetWorkItemCriteria) {
            ((IBuildableSubsetWorkItemCriteria)criterion).getWorkItems().addAll(workItems);
        }
    }

    protected void addAdditionalWorkItems(List<Integer> workItems) {
        Object criterion;
        if (workItems.size() > 0 && !this.criteriaStack.isEmpty() && (criterion = this.criteriaStack.peek()) instanceof IBuildableSubsetWorkItemCriteria) {
            ((IBuildableSubsetWorkItemCriteria)criterion).getAdditionalWorkItems().addAll(workItems);
        }
    }

    protected void addProperty(Property property) {
        this.fSubset.getProperties().put(property.name, property.value);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inLabel || this.inWorkspace || this.inBuildDefinition || this.inFileItem || this.inDescription || this.inOwnerId || this.inVisibility || this.inFileDescReference || this.criteriaDepth > 0 || this.inName || this.inValue) {
            this.chars.append(new String(ch, start, length));
        }
    }

    private void createBuildableFileDesc(String fileDesc) {
        int cIdx = fileDesc.indexOf("_componentId=");
        int fIdx = fileDesc.indexOf("_fileItemId=");
        if (cIdx > -1 && fIdx > -1) {
            String fileItemId;
            boolean alwaysBuild = false;
            int alwaysBuildIdx = fileDesc.indexOf("_alwaysBuild=");
            if (alwaysBuildIdx != -1) {
                alwaysBuild = Boolean.parseBoolean(fileDesc.substring(alwaysBuildIdx + "_alwaysBuild=".length(), cIdx));
            }
            String componentId = fileDesc.substring("_componentId=".length() + cIdx, fIdx);
            String scmPath = null;
            int scmPathIndex = fileDesc.indexOf("_scmPath=");
            if (scmPathIndex == -1) {
                fileItemId = fileDesc.substring("_fileItemId=".length() + fIdx);
            } else {
                fileItemId = fileDesc.substring("_fileItemId=".length() + fIdx, scmPathIndex);
                if (!this.isIgnoreScmPath) {
                    scmPath = fileDesc.substring("_scmPath=".length() + scmPathIndex);
                    try {
                        scmPath = URLDecoder.decode(scmPath, UTF_8);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
            }
            this.addBuildableFileDesc(componentId, fileItemId, scmPath, alwaysBuild);
        }
    }

    protected void createWorkItemCriterion() {
        BuildableSubsetWorkItemCriteria criterion = new BuildableSubsetWorkItemCriteria();
        criterion.setSubset(this.fSubset);
        if (!this.criteriaStack.isEmpty() && this.criteriaStack.peek() instanceof IBuildableSubsetSubsetCriteria) {
            ((IBuildableSubsetSubsetCriteria)this.criteriaStack.peek()).getChildCriteria().add(criterion);
        } else {
            this.fSubset.getCriteria().add(criterion);
        }
        this.criteriaStack.push(criterion);
    }

    protected void createSubsetCriterion() {
        BuildableSubsetSubsetCriteria criterion = new BuildableSubsetSubsetCriteria();
        criterion.setSubset(this.fSubset);
        if (!this.criteriaStack.isEmpty() && this.criteriaStack.peek() instanceof IBuildableSubsetSubsetCriteria) {
            ((IBuildableSubsetSubsetCriteria)this.criteriaStack.peek()).getChildCriteria().add(criterion);
        } else {
            this.fSubset.getCriteria().add(criterion);
        }
        this.criteriaStack.push(criterion);
    }

    protected void addBuildableFileDesc(String componentId, String fileItemId, String scmPath, boolean alwaysBuild) {
        BuildableFileDesc desc = new BuildableFileDesc(componentId, fileItemId, alwaysBuild);
        if (scmPath != null) {
            desc.setScmPath(scmPath);
        }
        this.fSubset.getBuildableFileDescs().add(desc);
    }

    public static List<Integer> parseWorkItems(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        String[] wis = value.split(",");
        ArrayList<Integer> ids = new ArrayList<Integer>();
        String[] stringArray = wis;
        int n = wis.length;
        int n2 = 0;
        while (n2 < n) {
            String wi = stringArray[n2];
            try {
                ids.add(Integer.parseInt(wi));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return ids;
    }

    public static UUID parseUUID(String value) {
        try {
            return UUID.valueOf((String)value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static class Property {
        public String name;
        public String value;

        protected Property() {
        }
    }
}

