/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.buildablesubset.common.impl;

import com.ibm.team.enterprise.buildablesubset.common.IWorkItemBuildSubsetRule;
import com.ibm.team.enterprise.internal.buildablesubset.common.helper.Messages;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.List;

public class WorkItemBuildSubsetRule
implements IWorkItemBuildSubsetRule {
    private final List<IWorkItemHandle> workItemHandles = new ArrayList<IWorkItemHandle>();
    private final List<String> workItemSummaries = new ArrayList<String>();
    private boolean isIncludeChildren;
    private boolean isDynamic;
    private StringBuilder additionalSummaryText;

    @Override
    public List<IWorkItemHandle> getWorkItemHandles() {
        return this.workItemHandles;
    }

    @Override
    public void addWorkItem(IWorkItemHandle workItemHandle) {
        this.workItemHandles.add(workItemHandle);
    }

    @Override
    public void addWorkItemSummary(String workItemSummary) {
        this.workItemSummaries.add(workItemSummary);
    }

    @Override
    public void addAdditionalSummaryText(String text) {
        if (this.additionalSummaryText == null) {
            this.additionalSummaryText = new StringBuilder(text);
        } else {
            this.additionalSummaryText.append(text);
        }
    }

    @Override
    public boolean isValid() {
        return this.workItemHandles.size() > 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("_workItems=");
        for (IWorkItemHandle workItemHandle : this.workItemHandles) {
            buffer.append(workItemHandle.getItemId());
        }
        return buffer.toString();
    }

    @Override
    public String getCriteriaSummary() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Messages.getCommonString("WorkItemBuildSubsetRule_WORKITEMS")).append("\n");
        if (this.workItemSummaries.size() > 0) {
            for (String workItemSummary : this.workItemSummaries) {
                buffer.append("  ").append(workItemSummary).append("\n");
            }
        } else {
            for (IWorkItemHandle workItemHandle : this.workItemHandles) {
                buffer.append("   ").append(workItemHandle.getItemId().getUuidValue()).append("\n");
            }
        }
        if (this.additionalSummaryText != null) {
            buffer.append('\n');
            buffer.append((CharSequence)this.additionalSummaryText);
        }
        return buffer.toString();
    }

    @Override
    public void setIncludeChildren(boolean isIncludeChildren) {
        this.isIncludeChildren = isIncludeChildren;
    }

    @Override
    public boolean isIncludeChildren() {
        return this.isIncludeChildren;
    }

    @Override
    public boolean isDynamic() {
        return this.isDynamic;
    }

    @Override
    public void setDynamic(boolean isDynamic) {
        this.isDynamic = isDynamic;
    }
}

