/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.buildablesubset.common.impl;

import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetRuleParser;
import com.ibm.team.enterprise.buildablesubset.common.ISubsetBuildSubsetRule2;
import com.ibm.team.enterprise.buildablesubset.common.impl.SubsetBuildSubsetRule2;
import com.ibm.team.enterprise.buildablesubset.common.internal.model.impl.ModelFactoryImpl;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;

public class SubsetBuildSubsetRuleParser2
implements IBuildSubsetRuleParser {
    @Override
    public boolean canParseRule(IBuildSubsetRule rule) {
        return rule instanceof ISubsetBuildSubsetRule2;
    }

    @Override
    public boolean canParseRule(String ruleContent) {
        try {
            JSONObject jsonObj = JSONObject.parse((Reader)new StringReader(ruleContent));
            String id = (String)jsonObj.get((Object)"id");
            if (ISubsetBuildSubsetRule2.ID.equals(id)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public IBuildSubsetRule parseRule(String content) throws TeamRepositoryException {
        try {
            SubsetBuildSubsetRule2 rule = new SubsetBuildSubsetRule2();
            JSONObject jsonObj = JSONObject.parse((Reader)new StringReader(content));
            JSONArray jsonArray = (JSONArray)jsonObj.get((Object)"entries");
            if (jsonArray != null && !jsonArray.isEmpty()) {
                for (JSONObject nextObj : jsonArray) {
                    String label = (String)nextObj.get((Object)"label");
                    String itemUUID = (String)nextObj.get((Object)"itemUUID");
                    String stateUUID = (String)nextObj.get((Object)"stateUUID");
                    ISubsetHandle subsetHandle = (ISubsetHandle)ModelFactoryImpl.eINSTANCE.createSubsetHandle().getItemType().createItemHandle(UUID.valueOf((String)itemUUID), UUID.valueOf((String)stateUUID));
                    rule.addEntry(label, subsetHandle);
                }
            }
            String targetSubsetItemUUID = (String)jsonObj.get((Object)"targetSubsetItemUUID");
            String targetSubsetStateUUID = (String)jsonObj.get((Object)"targetSubsetStateUUID");
            ISubsetHandle subsetHandle = (ISubsetHandle)ModelFactoryImpl.eINSTANCE.createSubsetHandle().getItemType().createItemHandle(UUID.valueOf((String)targetSubsetItemUUID), targetSubsetStateUUID != null ? UUID.valueOf((String)targetSubsetStateUUID) : null);
            rule.setTargetSubset(subsetHandle);
            return rule;
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    @Override
    public String toJSON(IBuildSubsetRule rule) {
        JSONObject jsonObject = new JSONObject();
        if (rule instanceof ISubsetBuildSubsetRule2) {
            ISubsetBuildSubsetRule2 subsetRule = (ISubsetBuildSubsetRule2)rule;
            jsonObject.put((Object)"id", (Object)ISubsetBuildSubsetRule2.ID);
            if (subsetRule.getTargetSubset() != null) {
                ISubsetHandle subset = subsetRule.getTargetSubset();
                jsonObject.put((Object)"targetSubsetItemUUID", (Object)subset.getItemId().getUuidValue());
                jsonObject.put((Object)"targetSubsetStateUUID", subset.getStateId() != null ? subset.getStateId().getUuidValue() : null);
            }
            JSONArray jsonArray = new JSONArray();
            for (Map.Entry<String, ISubsetHandle> entry : subsetRule.getEntries().entrySet()) {
                JSONObject jsonEntry = new JSONObject();
                jsonEntry.put((Object)"label", (Object)entry.getKey());
                jsonEntry.put((Object)"itemUUID", (Object)entry.getValue().getItemId().getUuidValue());
                jsonEntry.put((Object)"stateUUID", (Object)entry.getValue().getStateId().getUuidValue());
                jsonArray.add((Object)jsonEntry);
            }
            jsonObject.put((Object)"entries", (Object)jsonArray);
        }
        return jsonObject.toString();
    }
}

