/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.buildablesubset.common.impl;

import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetRuleParser;
import com.ibm.team.enterprise.buildablesubset.common.ISubsetBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.impl.SubsetBuildSubsetRule;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;

public class SubsetBuildSubsetRuleParser
implements IBuildSubsetRuleParser {
    @Override
    public boolean canParseRule(IBuildSubsetRule rule) {
        return rule instanceof ISubsetBuildSubsetRule;
    }

    @Override
    public boolean canParseRule(String ruleContent) {
        try {
            JSONObject jsonObj = JSONObject.parse((Reader)new StringReader(ruleContent));
            String id = (String)jsonObj.get((Object)"id");
            if (ISubsetBuildSubsetRule.ID.equals(id)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public IBuildSubsetRule parseRule(String content) throws TeamRepositoryException {
        try {
            SubsetBuildSubsetRule rule = new SubsetBuildSubsetRule();
            JSONObject jsonObj = JSONObject.parse((Reader)new StringReader(content));
            JSONArray jsonArray = (JSONArray)jsonObj.get((Object)"entries");
            if (jsonArray != null && !jsonArray.isEmpty()) {
                for (JSONObject nextObj : jsonArray) {
                    String label = (String)nextObj.get((Object)"label");
                    String slug = (String)nextObj.get((Object)"slug");
                    rule.addEntry(label, slug);
                }
            }
            String targetSlug = (String)jsonObj.get((Object)"targetSlug");
            rule.setTargetSubsetSlug(targetSlug);
            return rule;
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    @Override
    public String toJSON(IBuildSubsetRule rule) {
        JSONObject jsonObject = new JSONObject();
        if (rule instanceof ISubsetBuildSubsetRule) {
            ISubsetBuildSubsetRule subsetRule = (ISubsetBuildSubsetRule)rule;
            jsonObject.put((Object)"id", (Object)ISubsetBuildSubsetRule.ID);
            if (subsetRule.getTargetSubsetSlug() != null && !subsetRule.getTargetSubsetSlug().isEmpty()) {
                jsonObject.put((Object)"targetSlug", (Object)subsetRule.getTargetSubsetSlug());
            }
            JSONArray jsonArray = new JSONArray();
            for (Map.Entry<String, String> entry : subsetRule.getEntries().entrySet()) {
                JSONObject jsonEntry = new JSONObject();
                jsonEntry.put((Object)"label", (Object)entry.getKey());
                jsonEntry.put((Object)"slug", (Object)entry.getValue());
                jsonArray.add((Object)jsonEntry);
            }
            jsonObject.put((Object)"entries", (Object)jsonArray);
        }
        return jsonObject.toString();
    }
}

