/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.buildablesubset.common.impl;

import com.ibm.team.enterprise.buildablesubset.common.ISubsetBuildSubsetRule2;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetHandle;
import com.ibm.team.enterprise.internal.buildablesubset.common.helper.Messages;
import java.util.HashMap;
import java.util.Map;

public class SubsetBuildSubsetRule2
implements ISubsetBuildSubsetRule2 {
    private Map<String, ISubsetHandle> entries = new HashMap<String, ISubsetHandle>();
    private ISubsetHandle targetSubset;

    @Override
    public void addEntry(String label, ISubsetHandle subset) {
        this.entries.put(label, subset);
    }

    @Override
    public Map<String, ISubsetHandle> getEntries() {
        return this.entries;
    }

    @Override
    public ISubsetHandle getTargetSubset() {
        return this.targetSubset;
    }

    @Override
    public void setTargetSubset(ISubsetHandle subset) {
        this.targetSubset = subset;
    }

    @Override
    public boolean isValid() {
        if (this.entries.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, ISubsetHandle> entry : this.entries.entrySet()) {
            String label = entry.getKey();
            if (label == null || label.isEmpty()) {
                return false;
            }
            ISubsetHandle subset = entry.getValue();
            if (subset != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getCriteriaSummary() {
        StringBuilder buffer = new StringBuilder(200);
        buffer.append(Messages.getCommonString("SubsetBuildSubsetRule_SUBSETS")).append('\n');
        for (Map.Entry<String, ISubsetHandle> entry : this.entries.entrySet()) {
            buffer.append("   ").append(entry.getKey()).append('\n');
        }
        return buffer.toString();
    }
}

