/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.buildablesubset.common.impl;

import com.ibm.team.enterprise.buildablesubset.common.ISubsetBuildSubsetRule;
import com.ibm.team.enterprise.internal.buildablesubset.common.helper.Messages;
import java.util.HashMap;
import java.util.Map;

public class SubsetBuildSubsetRule
implements ISubsetBuildSubsetRule {
    private Map<String, String> entries = new HashMap<String, String>();
    private String targetSubsetSlug;

    @Override
    public void addEntry(String label, String slug) {
        this.entries.put(label, slug);
    }

    @Override
    public Map<String, String> getEntries() {
        return this.entries;
    }

    @Override
    public String getTargetSubsetSlug() {
        return this.targetSubsetSlug;
    }

    @Override
    public void setTargetSubsetSlug(String slug) {
        this.targetSubsetSlug = slug;
    }

    @Override
    public boolean isValid() {
        if (this.entries.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.entries.entrySet()) {
            String label = entry.getKey();
            if (label == null || label.isEmpty()) {
                return false;
            }
            String slug = entry.getValue();
            if (slug != null && !slug.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getCriteriaSummary() {
        StringBuilder buffer = new StringBuilder(200);
        buffer.append(Messages.getCommonString("SubsetBuildSubsetRule_SUBSETS")).append('\n');
        for (Map.Entry<String, String> entry : this.entries.entrySet()) {
            buffer.append("   ").append(entry.getKey()).append('\n');
        }
        return buffer.toString();
    }
}

