/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.buildablesubset.common.impl;

import com.ibm.team.enterprise.buildablesubset.common.IBuildableFileDesc;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubset;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubsetCriteria;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractBuildableSubsetCriteria
implements IBuildableSubsetCriteria {
    protected UUID uuid;
    protected String uuidAsString;
    protected IBuildableSubset subset;
    protected boolean isDynamic;
    protected List<IBuildableFileDesc> buildableFiles;

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void setUUID(UUID uuid) {
        this.uuid = uuid;
        this.uuidAsString = this.uuid == null ? null : uuid.getUuidValue();
    }

    @Override
    public IBuildableSubset getSubset() {
        return this.subset;
    }

    @Override
    public void setSubset(IBuildableSubset subset) {
        this.subset = subset;
    }

    @Override
    public boolean isDynamic() {
        return this.isDynamic;
    }

    @Override
    public void setDynamic(boolean isDynamic) {
        this.isDynamic = isDynamic;
    }

    @Override
    public List<IBuildableFileDesc> getBuildableFileDescs() {
        if (this.buildableFiles == null) {
            this.buildableFiles = new ArrayList<IBuildableFileDesc>();
            if (this.subset != null && this.subset.getBuildableFileDescs() != null && !this.subset.getBuildableFileDescs().isEmpty()) {
                for (IBuildableFileDesc desc : this.subset.getBuildableFileDescs()) {
                    if (!this.isReferencedBy(desc)) continue;
                    this.buildableFiles.add(desc);
                }
            }
        }
        return this.buildableFiles;
    }

    @Override
    public boolean isReferencedBy(IBuildableFileDesc fileDesc) {
        if (this.uuidAsString == null || fileDesc == null) {
            return false;
        }
        for (String reference : fileDesc.getCriteriaReferences()) {
            if (!reference.contains(this.uuidAsString)) continue;
            return true;
        }
        return false;
    }
}

