/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.buildablesubset.common;

import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetRuleParser;
import com.ibm.team.enterprise.buildablesubset.common.impl.DefaultBuildSubsetRuleParser;
import com.ibm.team.enterprise.buildablesubset.common.impl.SubsetBuildSubsetRuleParser;
import com.ibm.team.enterprise.buildablesubset.common.impl.SubsetBuildSubsetRuleParser2;
import com.ibm.team.enterprise.buildablesubset.common.impl.WorkItemBuildSubsetRuleParser;
import java.util.ArrayList;
import java.util.List;

public class BuildSubsetRuleParserFactory {
    private static BuildSubsetRuleParserFactory instance;
    private List<IBuildSubsetRuleParser> parsers = new ArrayList<IBuildSubsetRuleParser>();

    private BuildSubsetRuleParserFactory() {
        this.parsers.add(new DefaultBuildSubsetRuleParser());
        this.parsers.add(new WorkItemBuildSubsetRuleParser());
        this.parsers.add(new SubsetBuildSubsetRuleParser());
        this.parsers.add(new SubsetBuildSubsetRuleParser2());
    }

    public static BuildSubsetRuleParserFactory getInstance() {
        if (instance == null) {
            instance = new BuildSubsetRuleParserFactory();
        }
        return instance;
    }

    public IBuildSubsetRuleParser getParser(IBuildSubsetRule rule) {
        for (IBuildSubsetRuleParser parser : this.parsers) {
            if (!parser.canParseRule(rule)) continue;
            return parser;
        }
        return null;
    }

    public IBuildSubsetRuleParser getParser(String ruleContent) {
        for (IBuildSubsetRuleParser parser : this.parsers) {
            if (!parser.canParseRule(ruleContent)) continue;
            return parser;
        }
        return null;
    }
}

