/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.build.ui.editors;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.enterprise.build.ui.editors.AbstractCompoundDependencyBuildConfigurationEditor;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.common.model.IPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosPlatformObject;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.LanguageDefinitionSelectionDialog;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ZosCompoundDependencyBuildConfigurationEditor
extends AbstractCompoundDependencyBuildConfigurationEditor
implements SelectionListener,
ModifyListener,
ISelectionChangedListener {
    protected Button buildMapsButton;
    protected Button reuseISPFButton;
    protected Text bpxwdynOptionsText;
    protected Button enableHFSButton;
    protected Label hfsOutputsDirLabel;
    protected Text hfsOutputsDirText;
    protected Text preBuildFileText;
    protected Text postBuildFileText;
    protected Button alwaysRunPostBuildButton;
    protected Spinner fnbProcessFreSpinner;

    public ZosCompoundDependencyBuildConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    protected void createAdvancedWidgets(Composite parent) {
        super.createAdvancedWidgets(parent);
        Composite advancedWidgetsComposite = this.getToolkit().createComposite(parent);
        advancedWidgetsComposite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.leftMargin = 0;
        layout.topMargin = 0;
        advancedWidgetsComposite.setLayout((Layout)layout);
        IBuildProperty buildProperty = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.reuseISPFSession");
        this.reuseISPFButton = this.getToolkit().createButton(advancedWidgetsComposite, Messages.EnterpriseConfigurationEditor_BUTTON_REUSEISPF, 32);
        TableWrapData buttonData = new TableWrapData(256);
        buttonData.colspan = 2;
        this.reuseISPFButton.setLayoutData((Object)buttonData);
        if (buildProperty != null) {
            boolean reuseISPFSession = Boolean.parseBoolean(buildProperty.getValue());
            this.reuseISPFButton.setSelection(reuseISPFSession);
        } else {
            this.reuseISPFButton.setSelection(false);
        }
        this.reuseISPFButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                ZosCompoundDependencyBuildConfigurationEditor.this.getWorkingCopy().setProperty("team.enterprise.build.ant.reuseISPFSession", Boolean.toString(ZosCompoundDependencyBuildConfigurationEditor.this.reuseISPFButton.getSelection()));
                ZosCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        buildProperty = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.hfsEnabled");
        boolean isHFSEnabled = buildProperty != null && Boolean.parseBoolean(buildProperty.getValue());
        this.enableHFSButton = this.getToolkit().createButton(advancedWidgetsComposite, Messages.EnterpriseConfigurationEditor_ENABLE_HFS_LABEL, 32);
        this.enableHFSButton.setToolTipText(Messages.EnterpriseConfigurationEditor_ENABLE_HFS_TOOLTIP);
        buttonData = new TableWrapData(256);
        buttonData.colspan = 2;
        this.enableHFSButton.setLayoutData((Object)buttonData);
        this.enableHFSButton.setSelection(isHFSEnabled);
        this.enableHFSButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZosCompoundDependencyBuildConfigurationEditor.this.validate();
                boolean selected = ZosCompoundDependencyBuildConfigurationEditor.this.enableHFSButton.getSelection();
                ZosCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.hfsEnabled", Boolean.toString(selected));
                ZosCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.hfsEnabled").setGenericEditAllowed(false);
                ZosCompoundDependencyBuildConfigurationEditor.this.hfsOutputsDirLabel.setEnabled(selected);
                ZosCompoundDependencyBuildConfigurationEditor.this.hfsOutputsDirText.setEnabled(selected);
                ZosCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        this.hfsOutputsDirLabel = this.getToolkit().createLabel(advancedWidgetsComposite, Messages.EnterpriseConfigurationEditor_HFS_OUTPUTS_DIR_LABEL);
        this.hfsOutputsDirLabel.setEnabled(isHFSEnabled);
        buttonData = new TableWrapData(2, 32);
        buttonData.indent = 15;
        this.hfsOutputsDirLabel.setLayoutData((Object)buttonData);
        buildProperty = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.hfs.outputdir");
        this.hfsOutputsDirText = this.getToolkit().createText(advancedWidgetsComposite, buildProperty != null ? buildProperty.getValue() : "");
        this.hfsOutputsDirText.setToolTipText(Messages.EnterpriseConfigurationEditor_HFS_OUTPUTS_DIR_TOOLTIP);
        this.hfsOutputsDirText.setLayoutData((Object)new TableWrapData(128));
        this.hfsOutputsDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ZosCompoundDependencyBuildConfigurationEditor.this.validate();
                ZosCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.hfs.outputdir", ZosCompoundDependencyBuildConfigurationEditor.this.hfsOutputsDirText.getText());
                ZosCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.hfs.outputdir").setGenericEditAllowed(false);
                ZosCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        this.hfsOutputsDirText.setEnabled(isHFSEnabled);
        this.createUpdateFrequnceConfiguration(advancedWidgetsComposite, 2);
        this.createSpacer(advancedWidgetsComposite, 5, 2);
        buildProperty = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.bpxwdyn.options");
        this.getToolkit().createLabel(advancedWidgetsComposite, Messages.EnterpriseConfigurationEditor_LABEL_BPXWDYNOPTIONS);
        this.bpxwdynOptionsText = this.getToolkit().createText(advancedWidgetsComposite, buildProperty != null ? buildProperty.getValue() : "");
        this.bpxwdynOptionsText.setLayoutData((Object)new TableWrapData(128));
        this.bpxwdynOptionsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ZosCompoundDependencyBuildConfigurationEditor.this.validate();
                IBuildProperty buildProperty = ZosCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.bpxwdyn.options");
                buildProperty.setValue(ZosCompoundDependencyBuildConfigurationEditor.this.bpxwdynOptionsText.getText().trim());
                ZosCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        this.createPrePostScriptWidgets(advancedWidgetsComposite);
    }

    private void createPrePostScriptWidgets(Composite parent) {
        IBuildProperty buildProperty = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.preBuildFile");
        this.getToolkit().createLabel(parent, Messages.EnterpriseConfigurationEditor_LABEL_PRE_BUILD_FILE);
        this.preBuildFileText = this.getToolkit().createText(parent, buildProperty != null ? buildProperty.getValue() : "");
        this.preBuildFileText.setLayoutData((Object)new TableWrapData(128));
        this.preBuildFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ZosCompoundDependencyBuildConfigurationEditor.this.validate();
                IBuildProperty buildProperty = ZosCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.preBuildFile");
                buildProperty.setValue(ZosCompoundDependencyBuildConfigurationEditor.this.preBuildFileText.getText().trim());
                ZosCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        buildProperty = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.postBuildFile");
        this.getToolkit().createLabel(parent, Messages.EnterpriseConfigurationEditor_LABEL_POST_BUILD_FILE);
        this.postBuildFileText = this.getToolkit().createText(parent, buildProperty != null ? buildProperty.getValue() : "");
        this.postBuildFileText.setLayoutData((Object)new TableWrapData(128));
        this.postBuildFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ZosCompoundDependencyBuildConfigurationEditor.this.validate();
                IBuildProperty buildProperty = ZosCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.postBuildFile");
                buildProperty.setValue(ZosCompoundDependencyBuildConfigurationEditor.this.postBuildFileText.getText().trim());
                ZosCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
                if (ZosCompoundDependencyBuildConfigurationEditor.this.alwaysRunPostBuildButton != null && !ZosCompoundDependencyBuildConfigurationEditor.this.alwaysRunPostBuildButton.isDisposed()) {
                    boolean enableState = !ZosCompoundDependencyBuildConfigurationEditor.this.postBuildFileText.getText().equalsIgnoreCase("");
                    ZosCompoundDependencyBuildConfigurationEditor.this.alwaysRunPostBuildButton.setEnabled(enableState);
                    if (!enableState) {
                        ZosCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.alwaysRunPostBuildFile").setValue(Boolean.toString(false));
                    } else if (enableState && ZosCompoundDependencyBuildConfigurationEditor.this.alwaysRunPostBuildButton.getSelection()) {
                        ZosCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.alwaysRunPostBuildFile").setValue(Boolean.toString(true));
                    }
                }
            }
        });
        buildProperty = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.alwaysRunPostBuildFile");
        this.alwaysRunPostBuildButton = this.getToolkit().createButton(parent, Messages.EnterpriseConfigurationEditor_LABEL_ALWAYS_RUN_POST_BUILD_FILE, 32);
        this.alwaysRunPostBuildButton.setLayoutData((Object)new TableWrapData(128));
        this.alwaysRunPostBuildButton.setSelection(Boolean.parseBoolean(buildProperty.getValue()));
        this.alwaysRunPostBuildButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ZosCompoundDependencyBuildConfigurationEditor.this.validate();
                IBuildProperty buildProperty = ZosCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.alwaysRunPostBuildFile");
                buildProperty.setValue(Boolean.toString(ZosCompoundDependencyBuildConfigurationEditor.this.alwaysRunPostBuildButton.getSelection()));
                ZosCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        if (this.postBuildFileText != null && !this.postBuildFileText.isDisposed()) {
            this.alwaysRunPostBuildButton.setEnabled(!this.postBuildFileText.getText().equalsIgnoreCase(""));
        }
        this.fBuildDefinitionWorkingCopy.setConfigurationProperty(this.getConfigurationId(), "team.enterprise.build.buildmaps.needMigrateComponent", "false");
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionzosdependency";
    }

    @Override
    protected String getConfigurationId() {
        return "com.ibm.team.enterprise.zos.build.common.IZosDependencyBuildConfigurationElement";
    }

    @Override
    protected LanguageDefinitionSelectionDialog getLanguageDefintionSelectionDialog(Shell parentShell, ITeamRepository teamRepository, IProjectArea projectArea, ViewerFilter filter, boolean allowMultipleSelection) {
        return new LanguageDefinitionSelectionDialog(parentShell, teamRepository, projectArea, filter, allowMultipleSelection, IZosLanguageDefinition.ITEM_TYPE, true);
    }

    @Override
    protected Section createAdvancedOptions(Composite parent, FormToolkit toolkit) {
        Section advancedSection = super.createAdvancedOptions(parent, toolkit);
        this.createSpacer((Composite)advancedSection.getClient(), 1, 1);
        this.conditionButton = this.fToolkit.createButton((Composite)advancedSection.getClient(), com.ibm.team.enterprise.build.common.Messages.EnterpriseRequestDialogOption_CONDITIONAL_BUILD, 32);
        this.conditionButton.setLayoutData((Object)new TableWrapData());
        this.conditionButton.setToolTipText(Messages.EnterpriseConfigurationEditorDependency_LABEL_CONDITIONAL);
        this.addControlDecorator((Control)this.conditionButton, Messages.EnterpriseConfigurationEditorDependency_LABEL_CONDITIONAL, 131072);
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.build.ant.conditionalBuild");
        if (property != null && !property.getValue().isEmpty()) {
            this.conditionButton.setSelection(Boolean.parseBoolean(property.getValue()));
        } else {
            this.conditionButton.setSelection(true);
        }
        this.conditionButton.addSelectionListener((SelectionListener)this);
        this.createNbProcessConfiguration((Composite)advancedSection.getClient(), 1);
        return advancedSection;
    }

    protected void createNbProcessConfiguration(Composite parent, int colspan) {
        Composite comp = new Composite(parent, 0);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        layout.leftMargin = 0;
        comp.setLayout((Layout)layout);
        TableWrapData data = new TableWrapData(256);
        data.colspan = colspan;
        comp.setLayoutData((Object)data);
        Label nameLabel = new Label(comp, 0);
        nameLabel.setText(Messages.EnterpriseConfigurationEditor_LABEL_NB_SUBPROCESS);
        nameLabel.setLayoutData((Object)new TableWrapData(2, 32));
        this.fnbProcessFreSpinner = new Spinner(comp, 2048);
        this.fnbProcessFreSpinner.setMinimum(1);
        this.fnbProcessFreSpinner.setMaximum(50);
        IBuildConfigurationElement element = this.getWorkingCopy().getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.build.dependency.ProcessCount");
        String valueStr = null;
        if (property != null) {
            valueStr = property.getValue();
        }
        int value = 0;
        if (valueStr != null && valueStr.length() > 0) {
            value = Integer.valueOf(valueStr);
        }
        if (value < 0) {
            value = 0;
        }
        this.fnbProcessFreSpinner.setSelection(value);
        this.fnbProcessFreSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                IBuildConfigurationElement element = ZosCompoundDependencyBuildConfigurationEditor.this.getWorkingCopy().getConfigurationElement(ZosCompoundDependencyBuildConfigurationEditor.this.getConfigurationId());
                IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.build.dependency.ProcessCount");
                String spinValue = String.valueOf(ZosCompoundDependencyBuildConfigurationEditor.this.fnbProcessFreSpinner.getSelection());
                if (property == null) {
                    property = BuildItemFactory.createConfigurationProperty();
                    property.setName("team.enterprise.build.dependency.ProcessCount");
                    element.getConfigurationProperties().add(property);
                }
                property.setValue(spinValue);
                ZosCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        this.fnbProcessFreSpinner.setLayoutData((Object)new TableWrapData());
    }

    @Override
    protected void createPlatformSpecificSections(Composite parent, FormToolkit toolkit) {
    }

    @Override
    protected boolean platformSpecificValidation() {
        this.removeMessage(this.hfsOutputsDirText, (Control)this.hfsOutputsDirText);
        if (this.enableHFSButton.getSelection() && this.hfsOutputsDirText.getText().trim().isEmpty()) {
            this.addErrorMessage(this.hfsOutputsDirText, Messages.EnterpriseConfigurationEditorDependency_ERROR_HFS_OUTPUTS, (Control)this.hfsOutputsDirText);
            return false;
        }
        return true;
    }

    @Override
    protected Class<? extends IPlatformObject> getPlatform() {
        return IZosPlatformObject.class;
    }
}

