/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.ui.utils;

import com.ibm.team.enterprise.build.ui.Activator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class MVSMemberHyperLinkUtils {
    public static String ENGINE_HOST_NAME = "buildEngineHostName";
    public static final String SLASH_SLASH = "://";
    public static final char SLASH = '/';
    public static final String MVS_SCHEME = "mvs";
    public static final String MVS_COMPACTED_SCHEME = "mvsc";
    private static String MVSMEMBER_HYPERLINK_NAME = "com.ibm.teamz.interop.ui.HyperlinkHandler";
    private static String MVSMEMBER_COMPACTED_HYPERLINK_NAME = "com.ibm.teamz.zide.ui.actions.OpenMVSCHyperlinkHandler";
    private static MVSMemberHyperLinkUtils _instance;
    private boolean isMVSMemberHyperLink = false;
    private boolean isMVSCMemberHyperLink = false;

    private MVSMemberHyperLinkUtils() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.team.foundation.rcp.core.hyperlinkHandler");
        IConfigurationElement[] members = extensionPoint.getConfigurationElements();
        int m = 0;
        while (m < members.length) {
            IConfigurationElement member = members[m];
            if (!this.isMVSMemberHyperLink) {
                try {
                    this.isMVSMemberHyperLink = this.foundMVSHyperLinkHandler(member);
                }
                catch (Exception e) {
                    Activator.getDefault().logError(e);
                }
            }
            if (!this.isMVSCMemberHyperLink) {
                try {
                    this.isMVSCMemberHyperLink = this.foundMVSCHyperLinkHandler(member);
                }
                catch (Exception e) {
                    Activator.getDefault().logError(e);
                }
            }
            if (this.isMVSMemberHyperLink && this.isMVSCMemberHyperLink) break;
            ++m;
        }
    }

    private boolean foundMVSHyperLinkHandler(IConfigurationElement element) throws ClassNotFoundException {
        boolean result = false;
        String mvsHyperName = element.getAttribute("name");
        if (mvsHyperName != null && mvsHyperName.equals(MVSMEMBER_HYPERLINK_NAME)) {
            result = true;
        }
        return result;
    }

    private boolean foundMVSCHyperLinkHandler(IConfigurationElement element) throws ClassNotFoundException {
        boolean result = false;
        String mvsHyperName = element.getAttribute("name");
        if (mvsHyperName != null && mvsHyperName.equals(MVSMEMBER_COMPACTED_HYPERLINK_NAME)) {
            result = true;
        }
        return result;
    }

    public static MVSMemberHyperLinkUtils getInstance() {
        if (_instance == null) {
            _instance = new MVSMemberHyperLinkUtils();
        }
        return _instance;
    }

    public boolean isMVSMemberHyperLink() {
        return this.isMVSMemberHyperLink;
    }

    public boolean isMVSCMemberHyperLink() {
        return this.isMVSCMemberHyperLink;
    }
}

