/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.ui.utils;

import java.util.ArrayList;

public class BuildableFilesNode {
    public static final int BUILDABLE_FILES_TREE_NODE = 0;
    public static final int BUILDABLE_FILES_LEAF_NODE = 1;
    public static final int BUILDABLE_FILES_ERROR_NODE = -1;
    private String fileItemId;
    private String componentId;
    private String label;
    private String scmPath;
    private ArrayList<BuildableFilesNode> children;
    private int type;

    private BuildableFilesNode(String label, int type, String fileItemId, String componentId) {
        this.label = label;
        this.type = type;
        this.fileItemId = fileItemId;
        this.componentId = componentId;
        if (type == 0) {
            this.children = new ArrayList();
        }
    }

    public static BuildableFilesNode createTreeNode(String label) {
        return new BuildableFilesNode(label, 0, null, null);
    }

    public static BuildableFilesNode createLeafNode(String label, String fileItemId, String componentId) {
        return new BuildableFilesNode(label, 1, fileItemId, componentId);
    }

    public static BuildableFilesNode createErrorNode(String label, String fileItemId, String componentId) {
        return new BuildableFilesNode(label, -1, fileItemId, componentId);
    }

    public String getFileItemId() {
        return this.fileItemId;
    }

    public String getLabel() {
        return this.label;
    }

    public String getScmPath() {
        return this.scmPath;
    }

    public void setScmPath(String newScmPath) {
        this.scmPath = newScmPath;
    }

    public ArrayList<BuildableFilesNode> getChildren() {
        return this.children;
    }

    public int getNodeType() {
        return this.type;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{\n");
        String nodeType = "TREE";
        if (this.type == 1) {
            nodeType = "LEAF";
        } else if (this.type == -1) {
            nodeType = "ERROR";
        }
        buf.append("\"type\":\"" + nodeType + "\",\n");
        String lbl = this.label != null ? this.label : "";
        buf.append("\"label\":\"" + lbl + "\",\n");
        if (this.type == 1 || this.type == -1) {
            buf.append("\"fileItemId\":\"" + this.fileItemId + "\",\n");
            buf.append("\"componentId\":\"" + this.componentId + "\",\n");
        } else {
            buf.append("\"children\":[\n");
            int i = 0;
            while (i < this.children.size()) {
                buf.append(this.children.get(i).toString());
                ++i;
            }
            buf.append("]\n");
        }
        buf.append("}\n");
        return buf.toString();
    }

    public String getComponentId() {
        return this.componentId;
    }

    public boolean hasErrors() {
        boolean hasErrors = false;
        if (this.type == 0) {
            for (BuildableFilesNode bfn : this.children) {
                if (bfn.getNodeType() == -1) {
                    hasErrors = true;
                    continue;
                }
                if (!bfn.hasErrors()) continue;
                hasErrors = true;
            }
        }
        if (hasErrors && this.label != null && !this.label.endsWith("*")) {
            this.label = String.valueOf(this.label) + "*";
        }
        return hasErrors;
    }
}

