/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.ui.utils;

import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildableFilesNode;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.internal.filesystem.ui.adapters.AbstractAdaptableRemoteResource;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.internal.CurrentFlows;
import com.ibm.team.scm.common.internal.Workspace;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class BuildUtils {
    private final String Z_SOURCE_DIR = "zOSsrc";

    public static IWorkspaceConnection getWorkspaceConnection(ITeamRepository repo, IWorkspaceHandle workspace, IProgressMonitor progress) throws TeamRepositoryException {
        return SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(workspace, progress);
    }

    public List<IComponentHandle> getAllComponentHandles(IWorkspaceConnection wksConn, IProgressMonitor progress) throws TeamRepositoryException {
        wksConn.refresh(progress);
        return wksConn.getComponents();
    }

    public BuildableFilesNode createBuildableFilesTree(ITeamRepository repo, IWorkspaceHandle workspaceHandle, IProgressMonitor progress) throws TeamRepositoryException {
        IWorkspace stream = this.getWorkspaceStream(workspaceHandle, repo);
        IWorkspace workspace = stream != null ? stream : workspaceHandle;
        IWorkspaceConnection connection = BuildUtils.getWorkspaceConnection(repo, (IWorkspaceHandle)workspace, progress);
        BuildableFilesNode tree = BuildableFilesNode.createTreeNode(null);
        List<IComponentHandle> componentHandles = this.getAllComponentHandles(connection, progress);
        for (IComponentHandle componentHandle : componentHandles) {
            IConfiguration config = connection.configuration(componentHandle);
            if (config == null) continue;
            IComponent currentComponent = (IComponent)config.teamRepository().itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, progress);
            BuildableFilesNode componentTree = BuildableFilesNode.createTreeNode(currentComponent.getName());
            tree.getChildren().add(componentTree);
            Map projectMap = config.childEntriesForRoot(progress);
            if (projectMap == null) continue;
            this.processProjects(componentTree, projectMap, config, progress, repo);
        }
        return tree;
    }

    public void processProjects(BuildableFilesNode componentTree, Map projectMap, IConfiguration config, IProgressMonitor progress, ITeamRepository repo) throws TeamRepositoryException {
        List projects = config.fetchCompleteItems(new ArrayList(projectMap.values()), progress);
        for (IVersionable project : projects) {
            if (!(project instanceof IFolderHandle)) continue;
            BuildableFilesNode projectTree = BuildableFilesNode.createTreeNode(project.getName());
            componentTree.getChildren().add(projectTree);
            this.processFolders(projectTree, (IFolderHandle)project, config, progress, repo);
        }
    }

    public void processFolders(BuildableFilesNode projectTree, IFolderHandle project, IConfiguration config, IProgressMonitor progress, ITeamRepository repo) throws TeamRepositoryException {
        List<IVersionable> folders = this.getProjectFolders(project, config, progress);
        for (IVersionable folder : folders) {
            BuildableFilesNode folderTree = BuildableFilesNode.createTreeNode(folder.getName());
            projectTree.getChildren().add(folderTree);
            this.processFiles(folderTree, (IFolderHandle)folder, config, progress, repo);
        }
    }

    public void processFiles(BuildableFilesNode folderTree, IFolderHandle folder, IConfiguration config, IProgressMonitor progress, ITeamRepository repo) throws TeamRepositoryException {
        ISystemDefinitionModelClient langDefClient = (ISystemDefinitionModelClient)repo.getClientLibrary(ISystemDefinitionModelClient.class);
        List<IVersionable> files = this.getFiles(folder, config, progress);
        for (IVersionable file : files) {
            if (!(file instanceof IFileItemHandle)) continue;
            try {
                if (!BuildUtils.isBuildableFile(file, langDefClient)) continue;
                ArrayList<IVersionable> singleFileList = new ArrayList<IVersionable>();
                singleFileList.add(file);
                List ancestorReports = config.locateAncestors(singleFileList, progress);
                Path filePath = null;
                for (IAncestorReport report : ancestorReports) {
                    List itemPairs = report.getNameItemPairs();
                    if (itemPairs.isEmpty()) continue;
                    for (INameItemPair pairItem : itemPairs) {
                        if (pairItem.getName() == null) {
                            filePath = new Path("\\");
                            continue;
                        }
                        if (filePath == null) continue;
                        filePath = filePath.append(pairItem.getName());
                    }
                }
                BuildableFilesNode leafNode = BuildableFilesNode.createLeafNode(file.getName(), file.getItemId().getUuidValue(), config.component().getItemId().getUuidValue());
                if (filePath != null) {
                    leafNode.setScmPath(this.convert2ScmPath((IPath)filePath));
                }
                folderTree.getChildren().add(leafNode);
            }
            catch (TeamRepositoryException tre) {
                String label = String.valueOf(file.getName()) + " - " + Messages.BuildUtils_ERROR_LANG_DEF_NOT_FOUND;
                folderTree.getChildren().add(BuildableFilesNode.createErrorNode(label, file.getItemId().getUuidValue(), config.component().getItemId().getUuidValue()));
            }
        }
    }

    private String convert2ScmPath(IPath path) {
        String temp = path.toString();
        while (temp.startsWith("\\") || temp.startsWith("/")) {
            temp = temp.substring(1);
        }
        return temp;
    }

    public List<IVersionable> getProjectFolders(IFolderHandle project, IConfiguration configuration, IProgressMonitor progress) throws TeamRepositoryException {
        ArrayList<IVersionable> folders = new ArrayList<IVersionable>();
        if (project instanceof IFolderHandle) {
            IFolderHandle srcDir = this.getChildFolderHandle("zOSsrc", project, configuration, progress);
            if (srcDir == null) {
                srcDir = project;
            }
            Map srcFolderMap = configuration.childEntries(srcDir, progress);
            List children = configuration.fetchCompleteItems(new ArrayList(srcFolderMap.values()), progress);
            for (IVersionable child : children) {
                if (!(child instanceof IFolderHandle)) continue;
                folders.add(child);
            }
        }
        return folders;
    }

    public IFolderHandle getChildFolderHandle(String child, IFolderHandle parentFolder, IConfiguration config, IProgressMonitor progress) throws TeamRepositoryException {
        Map entries = config.childEntries(parentFolder, progress);
        if (entries == null) {
            return null;
        }
        IVersionableHandle folder = (IVersionableHandle)entries.get(child);
        if (folder instanceof IFolderHandle) {
            return (IFolderHandle)folder;
        }
        return null;
    }

    public List<IVersionable> getFiles(IFolderHandle folder, IConfiguration configuration, IProgressMonitor progress) throws TeamRepositoryException {
        ArrayList<IVersionable> files = new ArrayList<IVersionable>();
        Map folderMap = configuration.childEntries(folder, progress);
        List children = configuration.fetchCompleteItems(new ArrayList(folderMap.values()), progress);
        for (IVersionable child : children) {
            if (!(child instanceof IFileItemHandle)) continue;
            files.add(child);
        }
        return files;
    }

    public String getLanguageDefinitionUUID(IVersionable file) {
        Map properties = file.getUserProperties();
        return (String)properties.get("team.enterprise.language.definition");
    }

    public IWorkspace getWorkspaceStream(IWorkspaceHandle workspaceHandle, ITeamRepository repo) throws TeamRepositoryException {
        IWorkspace flowTarget;
        IWorkspaceHandle flowTargetHandle;
        UUID defaultFlow;
        IWorkspace workspace = (IWorkspace)repo.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, null);
        if (workspace.isStream()) {
            return workspace;
        }
        IWorkspace stream = null;
        Workspace ws = (Workspace)workspace;
        CurrentFlows flows = ws.getCurrentFlows();
        if (flows != null && (defaultFlow = flows.getDefaultAcceptFlow()) != null && (flowTargetHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(defaultFlow, null)) != null && (flowTarget = (IWorkspace)repo.itemManager().fetchCompleteItem((IItemHandle)flowTargetHandle, 0, null)).isStream()) {
            stream = flowTarget;
        }
        return stream;
    }

    public static boolean isBuildableFile(IVersionable file, ISystemDefinitionModelClient langDefClient) throws TeamRepositoryException {
        ILanguageDefinition langdef = BuildUtils.getLanguageDefinition(file, langDefClient);
        if (langdef != null) {
            return langdef.getTranslators().size() > 0;
        }
        return false;
    }

    private static ILanguageDefinition getLanguageDefinition(IVersionable file, ISystemDefinitionModelClient langDefClient) throws TeamRepositoryException {
        ILanguageDefinition langdef = null;
        String langdefValue = (String)file.getUserProperties().get("team.enterprise.language.definition");
        if (BuildUtils.isValidUUID(langdefValue)) {
            langdef = (ILanguageDefinition)langDefClient.findSystemDefinitionComplete(langdefValue, null, ILanguageDefinition.ITEM_TYPE, (IProgressMonitor)new NullProgressMonitor());
        }
        if (langdef == null && file instanceof IFileItemHandle) {
            langdef = langDefClient.getDefaultLanguageDefinition(file.getName(), null);
        }
        return langdef;
    }

    private static boolean isValidUUID(String uuidValue) {
        if (uuidValue == null || uuidValue.equals("")) {
            return false;
        }
        try {
            UUID.valueOf((String)uuidValue);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static IShareable getShareable(IAdaptable adaptable) {
        if (adaptable != null) {
            IShareable shareable = (IShareable)adaptable.getAdapter(IShareable.class);
            if (shareable != null) {
                return shareable;
            }
            AbstractAdaptableRemoteResource aarr = (AbstractAdaptableRemoteResource)adaptable.getAdapter(AbstractAdaptableRemoteResource.class);
            if (aarr != null && (shareable = (IShareable)aarr.getAdapter(IShareable.class)) != null) {
                return shareable;
            }
            shareable = (IShareable)aarr.getAdapter(IShareable.class);
            if (shareable != null) {
                return shareable;
            }
        }
        return null;
    }

    public static InputStream getInputStreamFromBuildResults(ITeamRepository repository, IContent content) throws TeamRepositoryException {
        InputStream result = null;
        result = repository.contentManager().retrieveContentStream(content, null);
        return result;
    }
}

