/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.ui.utils;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.build.client.buildmap.IBuildMapClient;
import com.ibm.team.enterprise.build.common.BuildableFileBuildResult;
import com.ibm.team.enterprise.build.common.buildreport.BuildReportCache;
import com.ibm.team.enterprise.build.common.buildreport.CommonBuildReportUtil;
import com.ibm.team.enterprise.build.common.buildreport.IReportBuildFile;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.editors.buildmap.AbstractBuildMapComparator;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapInputsResolvedComparator;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapInputsUnresolvedComparator;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapOutputsComparator;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapParserOutputsComparator;
import com.ibm.team.enterprise.build.ui.editors.result.BuildReportContentFilter;
import com.ibm.team.enterprise.build.ui.editors.result.internal.BuildReportTreeLeafNode;
import com.ibm.team.enterprise.build.ui.editors.result.internal.BuildReportTreeNode;
import com.ibm.team.enterprise.build.ui.editors.result.internal.BuildReportTreeViewerComparator;
import com.ibm.team.enterprise.build.ui.editors.result.internal.IBuildReportNode;
import com.ibm.team.enterprise.build.ui.views.DependencySetComparator;
import com.ibm.team.enterprise.common.ui.util.Utils;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.actions.EditSystemDefinitionActionDelegate;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.MVSMemberHyperLinkUtils;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import com.ibm.team.enterprise.internal.buildmap.common.util.BuildMapConversionUtil;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosPlatformObject;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.foundation.rcp.core.internal.HyperlinkHandlerRegistry;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IVersionableIdentifier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.SAXException;

public class BuildReportUtil
extends CommonBuildReportUtil {
    public static Matcher getMatcher(String listStr, String pattern) {
        Pattern p = Pattern.compile(pattern, 34);
        Matcher m = p.matcher(listStr);
        return m;
    }

    public static void calculatePageCapacity(BuildReportCache fCache, int pageSize, Map<BuildableFileBuildResult, Map<Integer, Integer>> fPageBookMap, Map<BuildableFileBuildResult, AtomicInteger> fCurrentPageMap) {
        Map<Integer, Integer> pageBook;
        if (fCache == null || fPageBookMap == null || fCurrentPageMap == null) {
            return;
        }
        fPageBookMap.clear();
        if (fCache.getSuccessBuildFileSize() > 0) {
            pageBook = BuildReportUtil.calculatePageCapacityForBuildResult(fCache, pageSize, BuildableFileBuildResult.SUCCESS);
            fPageBookMap.put(BuildableFileBuildResult.SUCCESS, pageBook);
            fCurrentPageMap.put(BuildableFileBuildResult.SUCCESS, new AtomicInteger(1));
        }
        if (fCache.getFailedBuildFileSize() > 0) {
            pageBook = BuildReportUtil.calculatePageCapacityForBuildResult(fCache, pageSize, BuildableFileBuildResult.FAILED);
            fPageBookMap.put(BuildableFileBuildResult.FAILED, pageBook);
            fCurrentPageMap.put(BuildableFileBuildResult.FAILED, new AtomicInteger(1));
        }
        if (fCache.getUnBuiltBuildFileSize() > 0) {
            pageBook = BuildReportUtil.calculatePageCapacityForBuildResult(fCache, pageSize, BuildableFileBuildResult.UNBUILD);
            fPageBookMap.put(BuildableFileBuildResult.UNBUILD, pageBook);
            fCurrentPageMap.put(BuildableFileBuildResult.UNBUILD, new AtomicInteger(1));
        }
    }

    private static Map<Integer, Integer> calculatePageCapacityForBuildResult(BuildReportCache fCache, int pageSize, BuildableFileBuildResult buildResult) {
        HashMap<Integer, Integer> pageBook = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> projectMap = new HashMap<Integer, Integer>();
        int rowNum = 0;
        String previousKey = null;
        int rowNumByPage = 0;
        int buildFileSize = -1;
        if (BuildableFileBuildResult.SUCCESS.equals((Object)buildResult)) {
            buildFileSize = fCache.getSuccessBuildFileSize();
        } else if (BuildableFileBuildResult.FAILED.equals((Object)buildResult)) {
            buildFileSize = fCache.getFailedBuildFileSize();
        } else if (BuildableFileBuildResult.UNBUILD.equals((Object)buildResult)) {
            buildFileSize = fCache.getUnBuiltBuildFileSize();
        }
        int projectByRow = 0;
        while (rowNum < buildFileSize && pageSize < buildFileSize) {
            IReportBuildFile buildFile = null;
            if (BuildableFileBuildResult.SUCCESS.equals((Object)buildResult)) {
                buildFile = fCache.getSuccessReportBuildFile(rowNum);
            } else if (BuildableFileBuildResult.FAILED.equals((Object)buildResult)) {
                buildFile = fCache.getFailedReportBuildFile(rowNum);
            } else if (BuildableFileBuildResult.UNBUILD.equals((Object)buildResult)) {
                buildFile = fCache.getUnbuiltReportBuildFile(rowNum);
            }
            if (buildFile == null) continue;
            String projectName = buildFile.getProject();
            String componentName = buildFile.getComponent();
            String rootKey = String.valueOf(projectName) + "(" + componentName + ")";
            if (previousKey != null && !previousKey.equalsIgnoreCase(rootKey)) {
                projectMap.put(projectMap.size() + 1, projectByRow);
                projectByRow = 0;
            }
            ++projectByRow;
            if (rowNum + 1 == buildFileSize) {
                projectMap.put(projectMap.size() + 1, projectByRow);
            }
            ++rowNum;
            previousKey = rootKey;
        }
        int totalPage = 1;
        pageBook.put(1, 0);
        int i = 1;
        while (i <= projectMap.size()) {
            block22: {
                int remainingRows;
                int pageByProject;
                block20: {
                    int previousPageCut;
                    int projectRows;
                    block23: {
                        block21: {
                            projectRows = (Integer)projectMap.get(i);
                            pageByProject = projectRows / pageSize;
                            remainingRows = projectRows % pageSize;
                            if (remainingRows != 0 && projectRows > pageSize) {
                                ++pageByProject;
                                rowNumByPage += remainingRows;
                            }
                            if (projectRows >= pageSize) break block20;
                            previousPageCut = (Integer)pageBook.get(totalPage);
                            if (rowNumByPage + projectRows <= pageSize) break block21;
                            pageBook.put(++totalPage, previousPageCut + rowNumByPage);
                            rowNumByPage = projectRows;
                            break block22;
                        }
                        if (rowNumByPage + projectRows != pageSize) break block23;
                        if (previousPageCut + rowNumByPage + projectRows != buildFileSize) {
                            pageBook.put(++totalPage, previousPageCut + rowNumByPage + projectRows);
                            rowNumByPage = 0;
                        }
                        break block22;
                    }
                    if (i + 1 > projectMap.size()) break block22;
                    int nProjectRows = (Integer)projectMap.get(i + 1);
                    if (nProjectRows >= pageSize) {
                        pageBook.put(++totalPage, previousPageCut + rowNumByPage + projectRows);
                        rowNumByPage = 0;
                    } else {
                        rowNumByPage += projectRows;
                    }
                    break block22;
                }
                int j = 0;
                while (j < pageByProject) {
                    int previousPageCut = (Integer)pageBook.get(totalPage);
                    if (j == pageByProject - 1 && remainingRows != 0) break;
                    pageBook.put(++totalPage, previousPageCut + pageSize);
                    ++j;
                }
            }
            ++i;
        }
        int lastPageCut = (Integer)pageBook.get(pageBook.size());
        if (lastPageCut >= buildFileSize) {
            pageBook.remove(pageBook.size());
        }
        return pageBook;
    }

    private static int getStartingRowNum(int pageNum, Map<Integer, Integer> pageBook) {
        if (pageNum <= pageBook.size()) {
            return pageBook.get(pageNum);
        }
        return 0;
    }

    private static int getRowLimitNum(int pageNum, int rowSize, Map<Integer, Integer> pageBook) {
        if (pageNum + 1 <= pageBook.size()) {
            return pageBook.get(pageNum + 1);
        }
        return rowSize;
    }

    public static BuildReportTreeNode[] getCurrentRootNodes(BuildReportCache fCache, BuildReportContentFilter filter, int pageNum, Map<Integer, Integer> pageBook, BuildableFileBuildResult buildResult) {
        BuildReportTreeNode[] result = null;
        int pageSize = Utils.getCurrentBuildReportPageSize();
        if (fCache == null) {
            return new BuildReportTreeNode[0];
        }
        int rowNum = 0;
        int rowLimit = pageSize;
        if (pageBook != null) {
            rowNum = BuildReportUtil.getStartingRowNum(pageNum, pageBook);
            rowLimit = BuildReportUtil.getRowLimitNum(pageNum, fCache.getBuildFileSize(buildResult), pageBook);
        }
        LinkedHashMap<String, BuildReportTreeNode> treeNodeMpas = new LinkedHashMap<String, BuildReportTreeNode>();
        while (fCache.isEnded() && !fCache.isEmpty(buildResult) && rowNum < fCache.getBuildFileSize(buildResult) && rowNum < rowLimit || !fCache.isEnded() && rowNum < pageSize) {
            IReportBuildFile buildFile = fCache.getReportBuildFile(rowNum, buildResult);
            if (buildFile == null) continue;
            String projectName = buildFile.getProject();
            String componentName = buildFile.getComponent();
            String rootKey = String.valueOf(projectName) + "(" + componentName + ")";
            BuildReportTreeNode rootNode = (BuildReportTreeNode)treeNodeMpas.get(rootKey);
            if (rootNode == null) {
                rootNode = new BuildReportTreeNode(null, projectName, componentName, null);
                treeNodeMpas.put(rootKey, rootNode);
            }
            if (rootNode == null) continue;
            List<IBuildReportNode> children = rootNode.getChildren();
            if (children == null) {
                children = new ArrayList<IBuildReportNode>();
                rootNode.setChildren(children);
            }
            children.add(new BuildReportTreeLeafNode(rootNode, buildFile));
            ++rowNum;
        }
        if (treeNodeMpas.size() > 0) {
            Collection treeNodes = treeNodeMpas.values();
            result = treeNodes.toArray(new BuildReportTreeNode[treeNodes.size()]);
            if (filter != null) {
                result = filter.filter(result);
            }
        } else {
            result = new BuildReportTreeNode[]{};
        }
        return result;
    }

    public static com.ibm.team.enterprise.internal.buildmap.common.IBuildMap getBuildMap(ITeamRepository fTeamRepository, UUID buildDefinitionUUID, UUID buildFileUUID) throws TeamRepositoryException {
        IBuildMapClient buildMapClient = (IBuildMapClient)fTeamRepository.getClientLibrary(IBuildMapClient.class);
        IBuildMap newBuildMap = buildMapClient.getBuildMap(buildFileUUID, buildDefinitionUUID, null);
        return newBuildMap != null ? BuildMapConversionUtil.convert((IBuildMap)newBuildMap) : null;
    }

    public static com.ibm.team.enterprise.internal.buildmap.common.IBuildMap getBuildMap(ITeamRepository fTeamRepository, URI fBuildMapURI) throws TeamRepositoryException, SAXException, IOException, ParserConfigurationException {
        com.ibm.team.enterprise.internal.buildmap.common.IBuildMap result = null;
        IBuildMapClient buildMapClient = (IBuildMapClient)fTeamRepository.getClientLibrary(IBuildMapClient.class);
        if (fBuildMapURI != null) {
            IBuildMap newBuildMap = buildMapClient.getBuildMap(fBuildMapURI, null);
            result = newBuildMap != null ? BuildMapConversionUtil.convert((IBuildMap)newBuildMap) : null;
        }
        return result;
    }

    public static boolean isOldBuildMap(com.ibm.team.enterprise.internal.buildmap.common.IBuildMap currentBuildMap, URI fBuildMapURI, ITeamRepository fTeamRepository) throws TeamRepositoryException {
        IBuildMapClient fBuildMapClient;
        IBuildMap buildMap;
        boolean result = false;
        if (MVSMemberHyperLinkUtils.getInstance().isMVSMemberHyperLink() && fBuildMapURI != null && (buildMap = (fBuildMapClient = (IBuildMapClient)((TeamRepository)fTeamRepository).getClientLibrary(IBuildMapClient.class)).getBuildMap(fBuildMapURI, null)) != null) {
            String latestBuildLabel = buildMap.getBuildLabel();
            String currentBuildLabel = currentBuildMap.getBuild().getBuildLabel();
            if (latestBuildLabel != null && !latestBuildLabel.equals(currentBuildLabel)) {
                result = true;
            }
        }
        return result;
    }

    public static TableColumn createTableColumn(final TableViewer tableView, final Table table, TableColumnLayout tableColumnLayout, String columnName, int weight, int style, int index, String tooltip, final int sortType) {
        TableColumn tableColumn = new TableColumn(table, style);
        if (columnName != null) {
            tableColumn.setText(columnName);
        }
        tableColumn.setData((Object)index);
        tableColumn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                final TableColumn treeCol = (TableColumn)e.getSource();
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        int colIndex = (Integer)treeCol.getData();
                        int oldSortDir = treeCol == table.getSortColumn() ? table.getSortDirection() : 1024;
                        int newSortDir = 128;
                        switch (oldSortDir) {
                            case 128: {
                                newSortDir = 1024;
                                break;
                            }
                            case 1024: {
                                newSortDir = 128;
                            }
                        }
                        table.setSortColumn(treeCol);
                        table.setSortDirection(newSortDir);
                        tableView.setComparator((ViewerComparator)BuildReportUtil.getBuildMapSortComparator(colIndex, newSortDir, sortType));
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        tableColumn.setToolTipText(tooltip);
        tableColumnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(weight, 0));
        return tableColumn;
    }

    public static TreeColumn createTreeColumn(Tree tree, final TreeViewer fViewer, TreeColumnLayout treeColumnLayout, String columnName, int weight, int style, int index, String tooltip, final int type) {
        TreeColumn treeColumn = new TreeColumn(tree, style, index);
        treeColumn.setText(columnName);
        treeColumn.setData((Object)index);
        treeColumn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                final TreeColumn treeCol = (TreeColumn)e.getSource();
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        int colIndex = (Integer)treeCol.getData();
                        int oldSortDir = treeCol == fViewer.getTree().getSortColumn() ? fViewer.getTree().getSortDirection() : 1024;
                        int newSortDir = 128;
                        switch (oldSortDir) {
                            case 128: {
                                newSortDir = 1024;
                                break;
                            }
                            case 1024: {
                                newSortDir = 128;
                            }
                        }
                        fViewer.getTree().setSortColumn(treeCol);
                        fViewer.getTree().setSortDirection(newSortDir);
                        fViewer.setComparator((ViewerComparator)BuildReportUtil.getTreeSortComparator(colIndex, newSortDir, type));
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        treeColumn.setToolTipText(tooltip);
        treeColumnLayout.setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnWeightData(weight));
        return treeColumn;
    }

    public static AbstractBuildMapComparator getTreeSortComparator(int colIndex, int newSortDir, int type) {
        AbstractBuildMapComparator result = null;
        switch (type) {
            case 0: {
                result = new BuildReportTreeViewerComparator(colIndex, newSortDir);
                break;
            }
            case 1: {
                result = new BuildMapInputsResolvedComparator(colIndex, newSortDir);
            }
        }
        return result;
    }

    public static AbstractBuildMapComparator getBuildMapSortComparator(int colIndex, int newSortDir, int type) {
        AbstractBuildMapComparator result = null;
        switch (type) {
            case 0: {
                result = new BuildMapInputsUnresolvedComparator(colIndex, newSortDir);
                break;
            }
            case 1: {
                result = new BuildMapOutputsComparator(colIndex, newSortDir);
                break;
            }
            case 2: {
                result = new BuildMapParserOutputsComparator(colIndex, newSortDir);
                break;
            }
            case 3: {
                result = new DependencySetComparator(colIndex, newSortDir);
            }
        }
        return result;
    }

    public static String getPartLocation(String scmLocation, String project) {
        if (scmLocation == null || scmLocation.isEmpty() || project == null || project.isEmpty()) {
            return scmLocation;
        }
        String result = null;
        int index = scmLocation.indexOf(project);
        if (index > -1) {
            int start = index + project.length() + 1;
            if (start < scmLocation.length()) {
                result = scmLocation.substring(start);
            }
        } else {
            result = scmLocation;
        }
        return result;
    }

    public static List<IBuildFile> createDependencySetFromInputs(IWorkspaceManager fWorkspaceManager, ITeamRepository fTeamRepository, Map<String, String> fUuidStateIDVersionIDMap, Map<String, String> componentUUIDNameMap, List<IBuildFile> inputs, boolean ignoreResolved) {
        String uuid;
        ArrayList<IBuildFile> results = new ArrayList<IBuildFile>();
        if (fUuidStateIDVersionIDMap == null) {
            fUuidStateIDVersionIDMap = new HashMap<String, String>();
        }
        Map<String, String> uuidStateIDVersionIDMap = fUuidStateIDVersionIDMap;
        ArrayList<IVersionableHandle> fVersionableList = new ArrayList<IVersionableHandle>();
        for (IBuildFile inputFile : inputs) {
            uuid = inputFile.getFileUUID();
            if (uuid != null && uuid.length() > 0) {
                IVersionableHandle versionableHandle;
                int projectInde;
                String scmLocation;
                String projectName;
                results.add(inputFile);
                String name = inputFile.getComponentName();
                if (componentUUIDNameMap != null && (name == null || name.isEmpty())) {
                    try {
                        name = BuildReportUtil.getComponentName(fTeamRepository, componentUUIDNameMap, inputFile.getComponentUUID());
                    }
                    catch (Exception e) {
                        Activator.getDefault().logError(e);
                    }
                    inputFile.setComponentName(name);
                }
                if (((projectName = inputFile.getProjectName()) == null || projectName.isEmpty()) && (scmLocation = inputFile.getSCMLocation()) != null && (projectInde = scmLocation.indexOf(47)) > 0 && (projectName = scmLocation.substring(0, projectInde)) != null) {
                    inputFile.setProjectName(projectName);
                }
                inputFile.setSCMLocation(BuildReportUtil.getPartLocation(inputFile.getSCMLocation(), inputFile.getProjectName()));
                String stateID = inputFile.getFileStateUUID();
                String versionID = fUuidStateIDVersionIDMap.get(String.valueOf(uuid) + stateID);
                if (versionID != null && !versionID.isEmpty() || fVersionableList.contains(versionableHandle = (IVersionableHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), stateID == null ? null : UUID.valueOf((String)stateID)))) continue;
                fVersionableList.add(versionableHandle);
                continue;
            }
            if (ignoreResolved) continue;
            results.add(inputFile);
        }
        BuildReportUtil.retrieveVersionIDMap(fWorkspaceManager, fTeamRepository, uuidStateIDVersionIDMap, fVersionableList);
        for (IBuildFile inputBuildFile : results) {
            String versionID;
            uuid = inputBuildFile.getFileUUID();
            if (uuid == null || (versionID = inputBuildFile.getUserPropertyValue("versionID")) != null) continue;
            String stateID = inputBuildFile.getFileStateUUID() != null ? inputBuildFile.getFileStateUUID() : "";
            String key = String.valueOf(uuid) + stateID;
            versionID = fUuidStateIDVersionIDMap.get(key);
            inputBuildFile.getUserProperties().put("versionID", versionID);
        }
        return results;
    }

    private static void retrieveVersionIDMap(final IWorkspaceManager fWorkspaceManager, final ITeamRepository fTeamRepository, final Map<String, String> uuidStateIDVersionIDMap, final List<IVersionableHandle> fVersionableList) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                IWorkspaceManager workspaceManager = fWorkspaceManager;
                if (workspaceManager == null) {
                    workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)fTeamRepository);
                }
                IVersionableHandle[] versionableArray = fVersionableList.toArray(new IVersionableHandle[fVersionableList.size()]);
                IVersionableIdentifier[] versionableIdentifiers = null;
                try {
                    versionableIdentifiers = workspaceManager.getVersionableIdentifiers(versionableArray, null);
                }
                catch (Exception e) {
                    Activator.getDefault().logError(e);
                }
                if (versionableIdentifiers != null && versionableIdentifiers.length > 0) {
                    int i = 0;
                    while (i < versionableIdentifiers.length) {
                        IVersionableIdentifier versionableIdentifier = versionableIdentifiers[i];
                        if (versionableIdentifier != null) {
                            String versionID = versionableIdentifier.getShortVersionId();
                            IVersionableHandle versionHandle = (IVersionableHandle)fVersionableList.get(i);
                            String uuid = versionHandle.getItemId().getUuidValue();
                            String stateid = versionHandle.getStateId() != null ? versionHandle.getStateId().getUuidValue() : "";
                            uuidStateIDVersionIDMap.put(String.valueOf(uuid) + stateid, versionID);
                        }
                        ++i;
                    }
                }
            }
        };
        try {
            thread.start();
            thread.join();
        }
        catch (InterruptedException e) {
            Activator.getDefault().logError(e);
        }
    }

    private static String getComponentName(ITeamRepository fTeamRepository, Map<String, String> componentUUIDNameMap, String uuid) throws TeamRepositoryException {
        String result = null;
        if (fTeamRepository == null || uuid == null || uuid.isEmpty() || componentUUIDNameMap == null) {
            return result;
        }
        result = componentUUIDNameMap.get(uuid);
        if (result == null) {
            BuildReportUtil.setComponentNameToMap(fTeamRepository, componentUUIDNameMap, uuid);
            result = componentUUIDNameMap.get(uuid);
        }
        return result;
    }

    private static void setComponentNameToMap(final ITeamRepository fTeamRepository, final Map<String, String> componentUUIDNameMap, final String uuid) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                String componentName;
                IItemHandle comHandle = IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null);
                IComponent component = null;
                try {
                    component = (IComponent)fTeamRepository.itemManager().fetchCompleteItem(comHandle, 0, null);
                }
                catch (TeamRepositoryException e) {
                    Activator.getDefault().logError(e);
                }
                String string = componentName = component == null ? null : component.getName();
                if (componentName != null) {
                    componentUUIDNameMap.put(uuid, componentName);
                }
            }
        };
        try {
            thread.start();
            thread.join();
        }
        catch (InterruptedException e) {
            Activator.getDefault().logError(e);
        }
    }

    public static String getTooltipForSource(String project, String component) {
        String result = null;
        if (project == null || project.isEmpty()) {
            return result;
        }
        StringBuilder builder = new StringBuilder();
        if (project != null && project.length() > 0) {
            builder.append(project);
        }
        if (component != null && component.length() > 0) {
            builder.append(" ");
            builder.append("(");
            builder.append(component);
            builder.append(")");
        }
        result = builder.toString();
        return result;
    }

    public static StyledString getQualifierSourceString(String projectName, String componentName) {
        StyledString st = new StyledString();
        if (projectName == null || projectName.isEmpty()) {
            return st;
        }
        st.append(projectName);
        if (componentName != null && componentName.length() > 0) {
            st.append(" ");
            st.append("(", StyledString.QUALIFIER_STYLER);
            st.append(componentName, StyledString.QUALIFIER_STYLER);
            st.append(")", StyledString.QUALIFIER_STYLER);
        }
        return st;
    }

    public static ISystemDefinition getSystemDefinition(String fSysDefUUID, String fSysDefStateID, String fSysType, Map<String, ISystemDefinition> fSysDefCache, ITeamRepository fTeamRepository, IProgressMonitor fMonitor) throws TeamRepositoryException {
        String key;
        ISystemDefinition result = null;
        if (fSysDefUUID == null || fSysDefUUID.length() == 0) {
            return result;
        }
        String string = key = fSysDefStateID != null ? String.valueOf(fSysDefUUID) + fSysDefStateID : fSysDefUUID;
        if (fSysDefCache != null) {
            result = fSysDefCache.get(key);
        }
        if (result == null) {
            SystemDefThread sysThread = new SystemDefThread(fSysDefUUID, fSysDefStateID, fSysType, key, fSysDefCache, fTeamRepository, fMonitor);
            try {
                sysThread.start();
                sysThread.join();
                result = sysThread.getResult();
            }
            catch (InterruptedException e) {
                Activator.getDefault().logError(e);
            }
        }
        return result;
    }

    public static void openSystemDefinitionEditor(IProjectAreaHandle fProjectAreaHandle, ISystemDefinition sysDef, boolean isLatest, IWorkbenchPage fWorkbenchPage) {
        if (sysDef != null && fProjectAreaHandle != null) {
            IWorkbenchWindow window;
            IWorkbenchPage page = fWorkbenchPage;
            if (page == null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
                page = window.getActivePage();
            }
            if (page != null) {
                if (sysDef instanceof IZosPlatformObject) {
                    com.ibm.team.enterprise.zos.internal.systemdefinition.ui.domain.actions.EditSystemDefinitionActionDelegate.run((ISystemDefinition)sysDef, (IProjectAreaHandle)fProjectAreaHandle, (IWorkbenchPage)page, (boolean)isLatest, (boolean)true);
                } else if (sysDef instanceof IIBMiPlatformObject) {
                    EditSystemDefinitionActionDelegate.run((ISystemDefinition)sysDef, (IProjectAreaHandle)fProjectAreaHandle, (IWorkbenchPage)page, (boolean)isLatest, (boolean)true);
                }
            }
        }
    }

    public static boolean isOnZos(ISystemDefinition sysDef) {
        return sysDef == null || sysDef instanceof IZosPlatformObject;
    }

    public static void setTreeViewInput(BuildReportTreeNode[] fRootNodes, TreeViewer fSuccessViewer, TreeViewer fFailedViewer, TreeViewer fUnbuiltViewer, BuildableFileBuildResult fBuildResult) {
        if (fRootNodes == null) {
            return;
        }
        if (fBuildResult == null) {
            fBuildResult = BuildableFileBuildResult.SUCCESS;
        }
        TreeViewer treeViewer = null;
        if (BuildableFileBuildResult.SUCCESS.equals((Object)fBuildResult)) {
            treeViewer = fSuccessViewer;
        } else if (BuildableFileBuildResult.FAILED.equals((Object)fBuildResult)) {
            treeViewer = fFailedViewer;
        } else if (BuildableFileBuildResult.UNBUILD.equals((Object)fBuildResult)) {
            treeViewer = fUnbuiltViewer;
        }
        if (treeViewer != null && !treeViewer.getTree().isDisposed()) {
            treeViewer.setInput((Object)fRootNodes);
            if (fRootNodes.length > 0) {
                treeViewer.expandAll();
                treeViewer.setSelection((ISelection)new StructuredSelection((Object)fRootNodes[0]));
            }
        }
    }

    public static BuildableFileBuildResult getBuildResult(int fSuccessSize, int fFailedSize, int fUnbuildSize) {
        BuildableFileBuildResult result = null;
        result = fFailedSize > 0 ? BuildableFileBuildResult.FAILED : (fFailedSize == 0 && fSuccessSize == 0 && (-1 == fUnbuildSize || fUnbuildSize > 0) ? BuildableFileBuildResult.UNBUILD : BuildableFileBuildResult.SUCCESS);
        return result;
    }

    public static void setTabSelection(CTabFolder folder, BuildableFileBuildResult result) {
        if (folder != null && result != null) {
            CTabItem[] items = folder.getItems();
            CTabItem selectItem = null;
            CTabItem[] cTabItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                BuildableFileBuildResult tempResult;
                CTabItem item = cTabItemArray[n2];
                Object temp = item.getData();
                if (temp instanceof BuildableFileBuildResult && (tempResult = (BuildableFileBuildResult)temp).equals((Object)result)) {
                    selectItem = item;
                    break;
                }
                ++n2;
            }
            if (selectItem != null) {
                folder.setSelection(selectItem);
            }
        }
    }

    public static void disposeTab(CTabFolder folder, BuildableFileBuildResult buildResult) {
        if (folder != null && buildResult != null) {
            CTabItem[] items = folder.getItems();
            CTabItem disposedItem = null;
            CTabItem[] cTabItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                BuildableFileBuildResult tempResult;
                CTabItem item = cTabItemArray[n2];
                Object temp = item.getData();
                if (temp instanceof BuildableFileBuildResult && buildResult.equals((Object)(tempResult = (BuildableFileBuildResult)temp))) {
                    disposedItem = item;
                    break;
                }
                ++n2;
            }
            if (disposedItem != null) {
                disposedItem.dispose();
            }
        }
    }

    public static void setTabTooltipText(CTabFolder folder, BuildableFileBuildResult result, String message) {
        if (folder != null && result != null && message != null) {
            CTabItem[] items = folder.getItems();
            CTabItem selectItem = null;
            CTabItem[] cTabItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                BuildableFileBuildResult tempResult;
                CTabItem item = cTabItemArray[n2];
                Object temp = item.getData();
                if (temp instanceof BuildableFileBuildResult && (tempResult = (BuildableFileBuildResult)temp).equals((Object)result)) {
                    selectItem = item;
                    break;
                }
                ++n2;
            }
            if (selectItem != null) {
                selectItem.setToolTipText(message);
            }
        }
    }

    public static void handleOpenMVSMember(String hostName, String dataSet, String memberName, boolean isCompacted) {
        HyperlinkHandler handler;
        if (hostName == null || hostName.length() == 0 || dataSet == null || dataSet.length() == 0 || memberName == null || memberName.length() == 0) {
            return;
        }
        final URI memberURI = BuildReportUtil.toURI(hostName, dataSet, memberName, isCompacted);
        if (memberURI != null && (handler = HyperlinkHandlerRegistry.getDefault().getCustomOpenHandler(memberURI)) != null) {
            new FoundationJob(MessageFormat.format(Messages.BuildMapEditor_LOGS_INFO_JOB_OPEN_HYPERLINK, Messages.BuildMapEditor_LOGS_INFO_JOB_TITLE_MVS_MEMBER)){

                protected IStatus runProtected(IProgressMonitor monitor) {
                    return handler.open2(memberURI, null, monitor);
                }
            }.schedule();
        }
    }

    private static URI toURI(String hostName, String dsName, String memberName, boolean isCompacted) {
        StringBuilder fullPathBuilder = new StringBuilder();
        if (isCompacted) {
            fullPathBuilder.append("mvsc");
        } else {
            fullPathBuilder.append("mvs");
        }
        fullPathBuilder.append("://").append(hostName).append('/').append(dsName).append('/').append(memberName);
        String fullPathName = fullPathBuilder.toString();
        try {
            return new URI(fullPathName);
        }
        catch (URISyntaxException e) {
            Assert.isTrue((boolean)false);
            return null;
        }
    }

    public static Properties gatherPropertiesFromBuildResult(String buildResultUUID, ITeamRepository fTeamRepository, IProgressMonitor progressMonitor) throws TeamRepositoryException, IOException {
        ITeamBuildClient client = ClientFactory.getTeamBuildClient((ITeamRepository)fTeamRepository);
        IBuildResultHandle buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildResultUUID), null);
        IBuildResultContribution[] contributions = client.getBuildResultContributions(buildResultHandle, new String[]{IBuildResultContribution.ARTIFACT_EXTENDED_CONTRIBUTION_ID}, progressMonitor);
        if (contributions.length > 0) {
            IBuildResultContribution[] iBuildResultContributionArray = contributions;
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildResultContribution contribution = iBuildResultContributionArray[n2];
                String fileName = contribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_NAME);
                if ("build.properties".equals(fileName)) {
                    IContent content = contribution.getExtendedContributionData();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    fTeamRepository.contentManager().retrieveContent(content, (OutputStream)baos, null);
                    Properties properties = new Properties();
                    properties.load(new ByteArrayInputStream(baos.toByteArray()));
                    baos.close();
                    return properties;
                }
                ++n2;
            }
        }
        return new Properties();
    }

    private static class SystemDefThread
    extends Thread {
        private ISystemDefinition tempResult = null;
        private String fSysDefUUID = null;
        private String fSysDefStateID = null;
        private String fSysType = null;
        private String fKey = null;
        private Map<String, ISystemDefinition> fSysDefCache = null;
        private ITeamRepository fTeamRepository = null;
        private IProgressMonitor fMonitor = null;

        public SystemDefThread(String fSysDefUUID, String fSysDefStateID, String fSysType, String fKey, Map<String, ISystemDefinition> fSysDefCache, ITeamRepository fTeamRepository, IProgressMonitor fMonitor) {
            this.fSysDefUUID = fSysDefUUID;
            this.fSysDefStateID = fSysDefStateID;
            this.fSysDefCache = fSysDefCache;
            this.fSysType = fSysType;
            this.fTeamRepository = fTeamRepository;
            this.fMonitor = fMonitor;
            this.fKey = fKey;
        }

        @Override
        public void run() {
            ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)this.fTeamRepository.getClientLibrary(ISystemDefinitionModelClient.class);
            if (client != null) {
                try {
                    if ("languagedefinition".equals(this.fSysType)) {
                        this.tempResult = client.findSystemDefinitionComplete(this.fSysDefUUID, this.fSysDefStateID, ILanguageDefinition.ITEM_TYPE, this.fMonitor);
                    } else if ("resourcedefinition".equals(this.fSysType)) {
                        this.tempResult = client.findSystemDefinitionComplete(this.fSysDefUUID, this.fSysDefStateID, IResourceDefinition.ITEM_TYPE, this.fMonitor);
                    } else if ("searchpath".equals(this.fSysType)) {
                        this.tempResult = client.findSystemDefinitionComplete(this.fSysDefUUID, this.fSysDefStateID, ISearchPath.ITEM_TYPE, this.fMonitor);
                    } else if ("translator".equals(this.fSysType)) {
                        this.tempResult = client.findSystemDefinitionComplete(this.fSysDefUUID, this.fSysDefStateID, ITranslator.ITEM_TYPE, this.fMonitor);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.tempResult != null && this.fSysDefCache != null) {
                    this.fSysDefCache.put(this.fKey, this.tempResult);
                }
            }
        }

        public ISystemDefinition getResult() {
            return this.tempResult;
        }
    }
}

