/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.ui.query;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.build.buildmap.common.model.query.BaseBuildMapQueryModel;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.query.IBuildMapQuery;
import com.ibm.team.enterprise.build.ui.query.IBuildMapQueryItem;
import com.ibm.team.enterprise.build.ui.query.IBuildMapQueryResults;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.query.BuildMapQueryItem;
import com.ibm.team.enterprise.internal.build.ui.query.OutputsByNameBuildMapQueryResult;
import com.ibm.team.enterprise.metadata.query.common.Attribute;
import com.ibm.team.enterprise.metadata.query.common.AttributeColumn;
import com.ibm.team.enterprise.metadata.query.common.IAttribute;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.ISelectionElement;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.query.ast.IStringInputArg;
import com.ibm.team.repository.common.query.ast.IUUID;
import com.ibm.team.repository.common.query.ast.IUUIDInputArg;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class OutputsByNameBuildMapQuery
implements IBuildMapQuery {
    protected static final String SOURCE_TYPE = "SOURCE";
    private static final String QUERY_LABEL = Messages.OutputsByNameBuildMapQuery_QUERYLABEL;
    private static final String QUERY_NAME = Messages.OutputsByNameBuildMapQuery_QUERYNAME;
    public static final int PARSEROUTPUTSBYNAMEQUERY = 0;
    public static final int OUTPUTSBYNAMEQUERY = 1;
    private static IDataQuery[] outputFilesByName = null;
    private String name;
    private String label;
    protected HashMap<String, Object> fParameters = new HashMap();
    protected IBuildMapQueryResults fResult;

    public OutputsByNameBuildMapQuery() {
        this.name = QUERY_NAME;
        this.label = QUERY_LABEL;
    }

    @Override
    public void setQueryParameters(HashMap<String, Object> parameters) {
        this.fParameters = parameters;
    }

    @Override
    public HashMap<String, Object> getQueryParameters() {
        return this.fParameters;
    }

    @Override
    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
        progress.beginTask(Messages.OutputsByNameBuildMapQuery_TASKLABEL, -1);
        try {
            try {
                IBuildDefinition buildDefinition = (IBuildDefinition)this.fParameters.get("build.def");
                ITeamRepository repository = (ITeamRepository)buildDefinition.getOrigin();
                String fileName = (String)this.fParameters.get("file.name");
                String memberName = fileName.lastIndexOf(46) > -1 ? fileName.substring(0, fileName.lastIndexOf(46)).toUpperCase() : fileName.toUpperCase();
                IQueryService queryService = ((TeamRepository)repository).getQueryService();
                Object[] parameters = new Object[]{buildDefinition, memberName};
                ArrayList<IBuildMapQueryItem> resultsByScm = new ArrayList<IBuildMapQueryItem>();
                progress.worked(100);
                int totalReferences = 0;
                int i = 0;
                while (i < this.getBaseQueries().length) {
                    IDataQueryPage queryResults = queryService.queryData(this.getBaseQueries()[i], parameters, 512);
                    progress.worked(500);
                    while (true) {
                        int j = 0;
                        while (j < queryResults.getSize()) {
                            IBuildMapQueryItem item = this.computeItem(queryResults.getRow(j));
                            if (resultsByScm.contains(item)) {
                                IBuildMapQueryItem existingItem = (IBuildMapQueryItem)resultsByScm.get(resultsByScm.indexOf(item));
                                existingItem.addSubItems(item.getSubItems());
                            } else {
                                resultsByScm.add(item);
                            }
                            totalReferences += item.getSubItems().length;
                            progress.worked(1000);
                            ++j;
                        }
                        if (!queryResults.hasNext()) break;
                        queryResults = (IDataQueryPage)queryService.fetchPage(queryResults.getToken(), queryResults.getNextStartPosition(), 512);
                        progress.worked(500);
                    }
                    ++i;
                }
                this.getResult().setResults(resultsByScm, totalReferences);
            }
            catch (TeamRepositoryException exception) {
                Activator.getDefault().logError(exception);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public IBuildMapQueryResults getResult() {
        if (this.fResult == null) {
            this.fResult = new OutputsByNameBuildMapQueryResult(this);
        }
        return this.fResult;
    }

    @Override
    public List<AttributeColumn> getColumns() {
        ArrayList<AttributeColumn> columns = new ArrayList<AttributeColumn>();
        Attribute attribute = new Attribute(null, "SourceFile", Messages.OutputsByNameBuildMapQuery_SOURCEFILE_COLUMN);
        attribute.setValue((Object)150);
        AttributeColumn column = new AttributeColumn((IAttribute)attribute);
        columns.add(column);
        attribute = new Attribute(null, "scmLocation", Messages.OutputsByNameBuildMapQuery_SCM_COLUMN);
        attribute.setValue((Object)350);
        column = new AttributeColumn((IAttribute)attribute);
        columns.add(column);
        attribute = new Attribute(null, "outBuildPath", Messages.OutputsByNameBuildMapQuery_OUTPUT_COLUMN);
        attribute.setValue((Object)200);
        column = new AttributeColumn((IAttribute)attribute);
        columns.add(column);
        attribute = new Attribute(null, "refType", Messages.OutputsByNameBuildMapQuery_REFERENCE_COLUMN);
        attribute.setValue((Object)130);
        column = new AttributeColumn((IAttribute)attribute);
        columns.add(column);
        attribute = new Attribute(null, "timestamp", Messages.OutputsByNameBuildMapQuery_TIMESTAMP_COLUMN);
        attribute.setValue((Object)100);
        column = new AttributeColumn((IAttribute)attribute);
        columns.add(column);
        return columns;
    }

    @Override
    public IDataQuery[] getBaseQueries() {
        if (outputFilesByName == null) {
            outputFilesByName = new IDataQuery[2];
            BaseBuildMapQueryModel.BuildMapQueryModel model = BaseBuildMapQueryModel.BuildMapQueryModel.ROOT;
            IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
            IUUIDInputArg uuidArg = query.newUUIDArg();
            IStringInputArg stringArg = query.newStringArg();
            IPredicate filter = model.buildDefinition().itemId()._eq((IUUID)uuidArg)._and(model.temporary()._isFalse())._and(model.archived()._isFalse());
            filter = filter._and(model.parserOutputs().buildFile()._eq((IString)stringArg));
            query.filter(filter);
            query.select((ISelectionElement)model.buildableFile().itemId());
            query.select((ISelectionElement)model.buildDefinition().itemId());
            query.select((ISelectionElement)model.self().buildFile());
            query.select((ISelectionElement)model.self().file().itemId());
            query.select((ISelectionElement)model.self().fileStateUUID());
            query.select((ISelectionElement)model.self().SCMLocation());
            query.select((ISelectionElement)model.parserOutputs().buildPath());
            query.select((ISelectionElement)model.parserOutputs().type());
            query.select((ISelectionElement)model.parserOutputs().modified());
            query.distinct();
            OutputsByNameBuildMapQuery.outputFilesByName[0] = query;
            query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
            filter = model.buildDefinition().itemId()._eq((IUUID)uuidArg)._and(model.temporary()._isFalse())._and(model.archived()._isFalse());
            filter = filter._and(model.outputs().buildFile()._eq((IString)stringArg));
            query.filter(filter);
            query.select((ISelectionElement)model.buildableFile().itemId());
            query.select((ISelectionElement)model.buildDefinition().itemId());
            query.select((ISelectionElement)model.self().buildFile());
            query.select((ISelectionElement)model.self().file().itemId());
            query.select((ISelectionElement)model.self().fileStateUUID());
            query.select((ISelectionElement)model.self().SCMLocation());
            query.select((ISelectionElement)model.outputs().buildPath());
            query.select((ISelectionElement)model.outputs().type());
            query.select((ISelectionElement)model.outputs().modified());
            query.distinct();
            OutputsByNameBuildMapQuery.outputFilesByName[1] = query;
        }
        return outputFilesByName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private IBuildMapQueryItem computeItem(IDataRow dataRow) {
        String itemId = dataRow.getUUID(0).getUuidValue();
        String buildDefId = dataRow.getUUID(1).getUuidValue();
        String fileId = dataRow.getUUID(3).getUuidValue();
        String fileStateId = dataRow.getUUID(4).getUuidValue();
        String scmPath = dataRow.getString(5);
        BuildMapQueryItem item = new BuildMapQueryItem(itemId, buildDefId, "scmLocation", scmPath, this.getResult());
        item.setItemData("FileUUID", fileId);
        item.setItemData("FileStateUUID", fileStateId);
        item.setItemData("SourceFile", dataRow.getString(2));
        IBuildMapQueryItem subItem = item.newSubItem("outBuildPath", dataRow.getString(6));
        String ref_type = dataRow.getString(7).equals("") ? SOURCE_TYPE : dataRow.getString(7);
        subItem.setItemData("refType", ref_type);
        subItem.setItemData("timestamp", dataRow.getTimestamp(8).toString());
        return item;
    }
}

