/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.ui.query;

import com.ibm.team.enterprise.build.ui.query.IBuildMapQueryItem;
import com.ibm.team.enterprise.build.ui.query.IBuildMapQueryResults;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuildMapQueryItem
implements IBuildMapQueryItem {
    protected String fBuildableFileUuid;
    protected String fBuildDefUuid;
    protected String fIdentifierKey;
    protected Map<String, Object> fDataItems;
    protected List<IBuildMapQueryItem> fChildrenItems;
    protected IBuildMapQueryItem fParent;
    protected IBuildMapQueryResults fResult;

    public BuildMapQueryItem(String buildableFileUuid, String buildDefUuid, String identifierKey, Object identifier, IBuildMapQueryResults result) {
        this.fBuildableFileUuid = buildableFileUuid;
        this.fBuildDefUuid = buildDefUuid;
        this.fIdentifierKey = identifierKey;
        this.fResult = result;
        this.setItemData(identifierKey, identifier);
    }

    private BuildMapQueryItem(String identifierKey, Object identifier) {
        this.fIdentifierKey = identifierKey;
        this.setItemData(identifierKey, identifier);
    }

    @Override
    public String getBuildableFileUuidValue() {
        if (this.fParent != null) {
            return this.fParent.getBuildableFileUuidValue();
        }
        return this.fBuildableFileUuid;
    }

    @Override
    public String getBuildDefinitionUuidValue() {
        if (this.fParent != null) {
            return this.fParent.getBuildDefinitionUuidValue();
        }
        return this.fBuildDefUuid;
    }

    @Override
    public Object getIdentifier() {
        return this.getItemData(this.fIdentifierKey);
    }

    @Override
    public String getIdentifierKey() {
        return this.fIdentifierKey;
    }

    @Override
    public Object[] getItemData() {
        if (this.fDataItems == null) {
            return new Object[0];
        }
        return this.fDataItems.values().toArray(new Object[this.fDataItems.size()]);
    }

    @Override
    public IBuildMapQueryItem[] getSubItems() {
        if (this.hasSubItems()) {
            return this.fChildrenItems.toArray(new IBuildMapQueryItem[this.fChildrenItems.size()]);
        }
        return new IBuildMapQueryItem[0];
    }

    @Override
    public Object getItemData(String key) {
        Object data = this.fDataItems.get(key);
        if ((key.equals("FileUUID") || key.equals("FileStateUUID")) && data == null && this.fParent != null) {
            return this.fParent.getItemData(key);
        }
        return this.fDataItems.get(key);
    }

    @Override
    public void setItemData(String key, Object value) {
        if (this.fDataItems == null) {
            this.fDataItems = new HashMap<String, Object>();
        }
        this.fDataItems.put(key, value);
    }

    @Override
    public boolean hasSubItems() {
        return this.fChildrenItems != null && this.fChildrenItems.size() > 0;
    }

    @Override
    public IBuildMapQueryItem newSubItem(String key, Object identifier) {
        if (this.fChildrenItems == null) {
            this.fChildrenItems = new ArrayList<IBuildMapQueryItem>();
        }
        BuildMapQueryItem newItem = new BuildMapQueryItem(key, identifier);
        this.fChildrenItems.add(newItem);
        newItem.setParentItem(this);
        return newItem;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getIdentifier() == null ? 0 : this.getIdentifier().hashCode());
        result = 31 * result + (this.fChildrenItems == null ? 0 : this.fChildrenItems.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildMapQueryItem other = (BuildMapQueryItem)obj;
        return other.getBuildableFileUuidValue().equals(this.getBuildableFileUuidValue()) && other.getBuildDefinitionUuidValue().equals(this.getBuildDefinitionUuidValue()) && other.getIdentifier().equals(this.getIdentifier());
    }

    @Override
    public void addSubItem(IBuildMapQueryItem subItem) {
        if (this.fChildrenItems.contains(subItem)) {
            this.fChildrenItems.remove(subItem);
        }
        this.fChildrenItems.add(subItem);
    }

    @Override
    public void addSubItems(IBuildMapQueryItem[] subItems) {
        IBuildMapQueryItem[] iBuildMapQueryItemArray = subItems;
        int n = subItems.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildMapQueryItem subItem = iBuildMapQueryItemArray[n2];
            this.addSubItem(subItem);
            ++n2;
        }
    }

    @Override
    public IBuildMapQueryItem getParentItem() {
        return this.fParent;
    }

    @Override
    public void setParentItem(IBuildMapQueryItem item) {
        this.fParent = item;
    }

    @Override
    public IBuildMapQueryResults getOwningResult() {
        if (this.fParent != null) {
            return this.fParent.getOwningResult();
        }
        return this.fResult;
    }
}

