/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.ui.parserOutputs;

import java.util.ArrayList;
import java.util.List;

public class TreeNode {
    protected Object data = null;
    protected List<TreeNode> children = new ArrayList<TreeNode>();
    protected TreeNode parent = null;

    public TreeNode(Object data) {
        this.data = data;
    }

    public TreeNode(Object data, TreeNode parent) {
        this.data = data;
        this.parent = parent;
        this.parent.addChild(this);
    }

    public void addChild(TreeNode child) {
        child.setParent(this);
        this.children.add(child);
    }

    public void insertChild(int index, TreeNode child) {
        child.setParent(this);
        this.children.add(index, child);
    }

    public void addChildren(List<TreeNode> children) {
        for (TreeNode child : children) {
            child.setParent(this);
        }
        this.children.addAll(children);
    }

    public int removeChild(TreeNode child) {
        int index = this.children.indexOf(child);
        if (index > -1) {
            this.children.remove(index);
        }
        return index;
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public String toString() {
        return this.data == null ? "null" : this.data.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeNode other = (TreeNode)obj;
        return !(this.data == null ? other.getData() != null : !this.data.equals(other.getData()));
    }

    public int hashCode() {
        if (this.data == null) {
            return -1;
        }
        return this.data.hashCode();
    }
}

