/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.ui.parserOutputs;

import com.ibm.team.enterprise.internal.build.ui.parserOutputs.HolderNode;
import com.ibm.team.enterprise.internal.build.ui.parserOutputs.TreeNode;
import java.util.ArrayList;
import java.util.List;

public class Tree {
    private TreeNode root = new TreeNode("Root");

    public List<TreeNode> getHolderNodes() {
        ArrayList<TreeNode> holderNodes = new ArrayList<TreeNode>();
        this.retrieveHolderNodes(this.root, holderNodes);
        return holderNodes;
    }

    private void retrieveHolderNodes(TreeNode parentNode, List<TreeNode> holderNodes) {
        List<TreeNode> children = parentNode.getChildren();
        if (children.size() == 0) {
            return;
        }
        for (TreeNode child : children) {
            if (child instanceof HolderNode && !holderNodes.contains(child)) {
                holderNodes.add(child);
            }
            this.retrieveHolderNodes(child, holderNodes);
        }
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public void addToRoot(TreeNode child) {
        this.root.addChild(child);
        child.setParent(this.root);
    }

    public void replaceHolderNode(HolderNode node, TreeNode newNode) {
        this.replaceHolderNode(this.root, node, newNode);
    }

    private void replaceHolderNode(TreeNode parentNode, HolderNode node, TreeNode newNode) {
        int index = parentNode.removeChild(node);
        if (index > -1) {
            parentNode.insertChild(index, newNode);
        } else {
            for (TreeNode child : parentNode.getChildren()) {
                this.replaceHolderNode(child, node, newNode);
            }
        }
    }

    public List<TreeNode> getChildren() {
        return this.root.getChildren();
    }

    public boolean hasChildren() {
        return this.root.getChildren().size() > 0;
    }

    public void print() {
        String indent = "   ";
        this.internalPrint(this.root, indent);
    }

    private void internalPrint(TreeNode node, String indent) {
        System.out.println(String.valueOf(indent) + node);
        for (TreeNode child : node.getChildren()) {
            this.internalPrint(child, String.valueOf(indent) + indent);
        }
    }
}

