/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.ui.parserOutputs;

import com.ibm.team.enterprise.build.buildmap.common.model.BuildMap;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMapHandle;
import com.ibm.team.enterprise.build.buildmap.common.model.query.BaseBuildMapQueryModel;
import com.ibm.team.enterprise.build.client.buildmap.IBuildMapClient;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.common.client.util.URIUtilities;
import com.ibm.team.enterprise.internal.build.ui.parserOutputs.HolderNode;
import com.ibm.team.enterprise.internal.build.ui.parserOutputs.ParserOutputData;
import com.ibm.team.enterprise.internal.build.ui.parserOutputs.ParserOutputNode;
import com.ibm.team.enterprise.internal.build.ui.parserOutputs.ParserOutputSourceData;
import com.ibm.team.enterprise.internal.build.ui.parserOutputs.ParserOutputSourceNode;
import com.ibm.team.enterprise.internal.build.ui.parserOutputs.Tree;
import com.ibm.team.enterprise.internal.build.ui.parserOutputs.TreeNode;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import com.ibm.team.enterprise.internal.buildmap.common.impl.BuildFile;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.ISelectionElement;
import com.ibm.team.repository.common.query.ast.IUUID;
import com.ibm.team.repository.common.query.ast.IUUIDInputArg;
import com.ibm.team.repository.common.service.IQueryService;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ParserOutputsBuildMapQuery {
    private UUID buildDefinitionUuid;
    private IQueryService queryService;
    private IBuildMapClient buildMapClient;
    private String buildLabel;
    private Map<String, ParserOutputNode> path2ParserOutputNodeMap;
    private ITeamRepository fTeamRepository;
    private Map<String, String> buildMapId2StateMap;
    private Tree tree;

    public ParserOutputsBuildMapQuery(ITeamRepository repository) {
        this.queryService = ((TeamRepository)repository).getQueryService();
        this.buildMapClient = (IBuildMapClient)repository.getClientLibrary(IBuildMapClient.class);
        this.fTeamRepository = repository;
    }

    public void runQuery(UUID buildDefinitionUuid, List<IBuildFile> parserOutputs, String buildLabel) throws TeamRepositoryException {
        this.buildDefinitionUuid = buildDefinitionUuid;
        this.buildLabel = buildLabel;
        this.path2ParserOutputNodeMap = new HashMap<String, ParserOutputNode>();
        this.buildMapId2StateMap = new HashMap<String, String>();
        this.tree = new Tree();
        if (Activator.isDebug()) {
            System.out.println("Number of parser output to retrieve file details: " + parserOutputs.size());
        }
        for (IBuildFile buildFile : parserOutputs) {
            this.tree.addToRoot(new HolderNode(buildFile));
        }
        this.internalRun();
    }

    private void internalRun() throws TeamRepositoryException {
        List<TreeNode> holderNodes = this.tree.getHolderNodes();
        if (Activator.isDebug()) {
            System.out.println("Number of holder nodes: " + holderNodes.size());
            for (TreeNode holderNode : holderNodes) {
                System.out.println("   " + holderNode);
            }
        }
        Iterator<TreeNode> iterator = holderNodes.iterator();
        while (iterator.hasNext()) {
            HolderNode holderNode = (HolderNode)iterator.next();
            IBuildFile buildFile = holderNode.getData();
            String fullPath = BuildReportUtil.generateBuildFileFullPath((IBuildFile)buildFile);
            ParserOutputNode parserOutputNode = this.path2ParserOutputNodeMap.get(fullPath);
            if (parserOutputNode == null) continue;
            if (Activator.isDebug()) {
                System.out.println("Holder node " + holderNode + " is removing from the list to query.");
            }
            ParserOutputNode newNode = new ParserOutputNode(parserOutputNode.getData());
            this.tree.replaceHolderNode(holderNode, newNode);
            iterator.remove();
        }
        if (Activator.isDebug()) {
            System.out.println("***  Tree structure before query   ****");
            this.tree.print();
            System.out.println("************");
        }
        if (holderNodes.size() > 0) {
            boolean hasNextPage = false;
            Object[] parameters = new Object[]{this.buildDefinitionUuid};
            IDataQuery dataQuery = this.getParserOutputDataQuery(holderNodes);
            IDataQueryPage queryResults = this.queryService.queryData(dataQuery, parameters, 512);
            if (Activator.isDebug()) {
                System.out.println("Number of Results returned from the query: " + queryResults.getSize());
            }
            if (queryResults.getSize() > 0) {
                do {
                    int j = 0;
                    while (j < queryResults.getSize()) {
                        this.resolveHolderNode(queryResults.getRow(j), holderNodes);
                        ++j;
                    }
                    hasNextPage = queryResults.hasNext();
                    if (!hasNextPage) continue;
                    queryResults = (IDataQueryPage)this.queryService.fetchPage(queryResults.getToken(), queryResults.getNextStartPosition(), 512);
                } while (hasNextPage);
                this.internalRun();
            } else {
                for (TreeNode treeNode : holderNodes) {
                    HolderNode holderNode = (HolderNode)treeNode;
                    String fullPath = BuildReportUtil.generateBuildFileFullPath((IBuildFile)holderNode.getData());
                    ParserOutputData data = new ParserOutputData(fullPath, holderNode.getData().getType(), new Timestamp(holderNode.getData().getTimestamp()));
                    ParserOutputNode newNode = new ParserOutputNode(data);
                    this.tree.replaceHolderNode(holderNode, newNode);
                }
            }
        }
    }

    private void resolveHolderNode(IDataRow dataRow, List<TreeNode> holderNodes) throws TeamRepositoryException {
        String tempBuildMapState;
        TreeNode node;
        String buildMapItemId = dataRow.getUUID(0).getUuidValue();
        String buildMapStateId = dataRow.getUUID(1).getUuidValue();
        String sourceBuildFile = dataRow.getString(2);
        String sourceBuildPath = dataRow.getString(3);
        String sourceFileItemUuid = dataRow.getUUID(4).getUuidValue();
        String sourceFileStateUuid = dataRow.getUUID(5).getUuidValue();
        String scmLocation = dataRow.getString(6);
        String componentName = dataRow.getString(7);
        String outputBuildFile = dataRow.getString(8);
        String outputBuildPath = dataRow.getString(9);
        String outputType = dataRow.getString(10);
        boolean outputSeq = dataRow.getBoolean(11);
        Timestamp modifiedTime = dataRow.getTimestamp(12);
        String parserBuildFile = dataRow.getString(14);
        String parserBuildPath = dataRow.getString(15);
        String parserType = dataRow.getString(16);
        boolean parserSeq = dataRow.getBoolean(17);
        Timestamp parserModified = dataRow.getTimestamp(19);
        String type = dataRow.getString(18);
        String outputFullPath = BuildReportUtil.generateBuildFileFullPath((String)outputBuildPath, (String)outputBuildFile, (String)outputType, (String)Boolean.toString(outputSeq), (boolean)false);
        String sourceFullPath = BuildReportUtil.generateBuildFileFullPath((String)sourceBuildPath, (String)sourceBuildFile, null, (String)Boolean.toString(outputSeq), (boolean)false);
        if (Activator.isDebug()) {
            System.out.println("Resolve holder node for: " + outputFullPath);
            System.out.println("   SourceFullPath=" + sourceFullPath);
            System.out.println("   ParserBuildPath=" + (parserBuildPath == null ? "null" : BuildReportUtil.generateBuildFileFullPath((String)parserBuildPath, (String)parserBuildFile, (String)parserType, (String)Boolean.toString(parserSeq), (boolean)false)));
        }
        if ((node = this.findNode(outputFullPath, holderNodes)) instanceof HolderNode) {
            ParserOutputData data = new ParserOutputData(outputFullPath, ((HolderNode)node).getData().getType(), modifiedTime);
            ParserOutputNode newNode = new ParserOutputNode(data);
            this.tree.replaceHolderNode((HolderNode)node, newNode);
            int index = holderNodes.indexOf(node);
            holderNodes.remove(index);
            holderNodes.add(index, newNode);
            node = newNode;
            this.path2ParserOutputNodeMap.put(outputFullPath, newNode);
        }
        if ((tempBuildMapState = this.buildMapId2StateMap.get(buildMapItemId)) != null && tempBuildMapState.length() > 0) {
            buildMapStateId = tempBuildMapState;
        } else {
            buildMapStateId = this.retrieveBuildMapCorrectStateId(buildMapItemId, buildMapStateId);
            this.buildMapId2StateMap.put(buildMapItemId, buildMapStateId);
        }
        IItemHandle buildMapHandle = IBuildMap.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildMapItemId), UUID.valueOf((String)buildMapStateId));
        URI buildMapURI = URIUtilities.createItemURI((ITeamRepository)this.fTeamRepository, (IItemHandle)buildMapHandle);
        ParserOutputSourceData sourceData = new ParserOutputSourceData(sourceFullPath, buildMapURI, scmLocation, componentName, sourceFileItemUuid, sourceFileStateUuid);
        ParserOutputSourceNode sourceNode = new ParserOutputSourceNode(sourceData);
        node.addChild(sourceNode);
        BuildFile buildFile = null;
        if (parserBuildFile != null && parserBuildPath != null) {
            buildFile = new BuildFile();
            buildFile.setBuildFile(parserBuildFile);
            buildFile.setBuildPath(parserBuildPath);
            buildFile.setOutputType(parserType);
            buildFile.setSequential(Boolean.toString(parserSeq));
            buildFile.setTimestamp(parserModified.getTime());
            buildFile.setType(type);
            node.addChild(new HolderNode((IBuildFile)buildFile));
        }
        if (Activator.isDebug()) {
            System.out.println("***   Tree structure after resolving holder node   ***");
            this.tree.print();
            System.out.println("************");
        }
    }

    private TreeNode findNode(String fullPath, List<TreeNode> nodeList) {
        for (TreeNode node : nodeList) {
            ParserOutputData parserOutputData;
            IBuildFile buildFile;
            String buildFileFullPath;
            if (!(node instanceof HolderNode ? fullPath.equals(buildFileFullPath = BuildReportUtil.generateBuildFileFullPath((IBuildFile)(buildFile = ((HolderNode)node).getData()))) : node instanceof ParserOutputNode && (parserOutputData = ((ParserOutputNode)node).getData()).getFullPath().equals(fullPath))) continue;
            return node;
        }
        return null;
    }

    private IDataQuery getParserOutputDataQuery(Collection<TreeNode> holderNodes) {
        BaseBuildMapQueryModel.BuildMapQueryModel model = BaseBuildMapQueryModel.BuildMapQueryModel.ROOT;
        IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
        IUUIDInputArg uuidArg = query.newUUIDArg();
        IPredicate filter = model.buildDefinition().itemId()._eq((IUUID)uuidArg)._and(model.temporary()._isFalse())._and(model.archived()._isFalse());
        IPredicate outputFilter = this.getParserOutputsFilter(model, holderNodes);
        if (outputFilter != null) {
            filter = filter._and(outputFilter);
        }
        query.filter(filter);
        query.select((ISelectionElement)model.itemId());
        query.select((ISelectionElement)model.stateId());
        query.select((ISelectionElement)model.self().buildFile());
        query.select((ISelectionElement)model.self().buildPath());
        query.select((ISelectionElement)model.self().file().itemId());
        query.select((ISelectionElement)model.self().fileStateUUID());
        query.select((ISelectionElement)model.self().SCMLocation());
        query.select((ISelectionElement)model.self().component().name());
        query.select((ISelectionElement)model.outputs().buildFile());
        query.select((ISelectionElement)model.outputs().buildPath());
        query.select((ISelectionElement)model.outputs().outputType());
        query.select((ISelectionElement)model.outputs().sequential());
        query.select((ISelectionElement)model.outputs().timestamp());
        query.select((ISelectionElement)model.outputs().type());
        query.select((ISelectionElement)model.parserOutputs().buildFile());
        query.select((ISelectionElement)model.parserOutputs().buildPath());
        query.select((ISelectionElement)model.parserOutputs().outputType());
        query.select((ISelectionElement)model.parserOutputs().sequential());
        query.select((ISelectionElement)model.parserOutputs().type());
        query.select((ISelectionElement)model.parserOutputs().timestamp());
        query.distinct();
        return query;
    }

    private IPredicate getParserOutputsFilter(BaseBuildMapQueryModel.BuildMapQueryModel model, Collection<TreeNode> holderNodes) {
        IPredicate result = null;
        if (model == null || holderNodes == null || holderNodes.size() == 0) {
            return result;
        }
        for (TreeNode holderNode : holderNodes) {
            IBuildFile parserOutput = ((HolderNode)holderNode).getData();
            String parserBuildFile = parserOutput.getBuildFile();
            String parserBuildPath = parserOutput.getBuildPath();
            String outputType = parserOutput.getOutputType();
            String parserSeq = parserOutput.getSequential();
            IPredicate filter = model.outputs().buildFile()._eq(parserBuildFile)._and(model.outputs().buildPath()._eq(parserBuildPath))._and(model.outputs().sequential()._eq(Boolean.valueOf(parserSeq)));
            if (outputType != null && !outputType.isEmpty()) {
                filter = filter._and(model.outputs().outputType()._eq(parserOutput.getOutputType()));
            }
            IPredicate iPredicate = result = result == null ? filter : result._or(filter);
        }
        return result;
    }

    private String retrieveBuildMapCorrectStateId(String buildMapItemId, String buildMapStateId) throws TeamRepositoryException {
        IAuditableHandle predeBuildMapHandle;
        String bmBuildLabel;
        String result = null;
        IBuildMapHandle stateHandle = (IBuildMapHandle)BuildMap.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildMapItemId), UUID.valueOf((String)buildMapStateId));
        IBuildMap buildMap = this.buildMapClient.getBuildMapState(stateHandle, null);
        result = buildMap != null ? (this.buildLabel.compareTo(bmBuildLabel = buildMap.getBuildLabel()) > 0 ? ((predeBuildMapHandle = buildMap.getPredecessorState()) != null ? this.retrieveBuildMapCorrectStateId(predeBuildMapHandle.getItemId().getUuidValue(), predeBuildMapHandle.getStateId().getUuidValue()) : buildMap.getStateId().getUuidValue()) : buildMap.getStateId().getUuidValue()) : buildMapStateId;
        return result;
    }

    public Tree getTree() {
        return this.tree;
    }
}

