/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.ui.dialogs;

import com.ibm.team.enterprise.internal.build.ui.dialogs.BaseLibraryListControlListener;
import com.ibm.team.enterprise.internal.build.ui.dialogs.BaseLibraryListEntryDialog;
import com.ibm.team.enterprise.internal.build.ui.dialogs.BaseLibraryListTableContentProvider;
import com.ibm.team.enterprise.internal.build.ui.dialogs.BaseLibraryListTableLabelProvider;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class IBMiPersonalBuildReferencedLibrariesControl {
    private static final String COLUMN_LIBRARY = "library";
    protected TableViewer fTableViewer;
    protected List<String> baseLibraryListEntries;
    protected Button fAddButton;
    protected Button fEditButton;
    protected Button fRemoveButton;
    protected Button fMoveUpButton;
    protected Button fMoveDownButton;
    protected Shell fParentShell;
    protected ListenerList fListenerList = new ListenerList();

    public IBMiPersonalBuildReferencedLibrariesControl(Composite parent, String baseLibraryListProperty) {
        this.fParentShell = parent.getShell();
        Composite fComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)fComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(fComposite);
        Composite tableComposite = new Composite(fComposite, 0);
        Table table = new Table(tableComposite, 68354);
        GridDataFactory.fillDefaults().hint(450, table.getItemHeight() * 5).grab(true, true).span(1, 1).applyTo((Control)tableComposite);
        TableColumnLayout tableLayout = new TableColumnLayout();
        String[] columnProperties = new String[]{COLUMN_LIBRARY};
        String[] columnHeader = new String[]{Messages.LibraryListControl_LIBRARY};
        int[] columnWeight = new int[]{5};
        int i = 0;
        while (i < columnHeader.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnHeader[i]);
            tableLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(columnWeight[i]));
            ++i;
        }
        tableComposite.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setColumnProperties(columnProperties);
        BaseLibraryListTableContentProvider contentProvider = new BaseLibraryListTableContentProvider();
        BaseLibraryListTableLabelProvider labelProvider = new BaseLibraryListTableLabelProvider(this.fTableViewer);
        this.fTableViewer.setContentProvider((IContentProvider)contentProvider);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.baseLibraryListEntries = this.getBaseLibraryList(baseLibraryListProperty);
        this.fTableViewer.setInput(this.baseLibraryListEntries);
        this.fTableViewer.addSelectionChangedListener(this.getSelectionChangedListener());
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IBMiPersonalBuildReferencedLibrariesControl.this.handleDoubleClick(event);
            }
        });
        Composite buttonBar = new Composite(fComposite, 0);
        buttonBar.setLayoutData((Object)new GridData(131072, 4, false, true));
        buttonBar.setLayout((Layout)new GridLayout(1, false));
        this.fAddButton = new Button(buttonBar, 8);
        this.fAddButton.setText(Messages.EnterpriseBuildUI_BUTTON_ADD);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiPersonalBuildReferencedLibrariesControl.this.addEntry();
            }
        });
        this.fRemoveButton = new Button(buttonBar, 8);
        this.fRemoveButton.setText(Messages.EnterpriseBuildUI_BUTTON_REMOVE);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiPersonalBuildReferencedLibrariesControl.this.removeSelectedEntries();
            }
        });
        this.fEditButton = new Button(buttonBar, 8);
        this.fEditButton.setText(Messages.EnterpriseBuildUI_BUTTON_EDIT);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiPersonalBuildReferencedLibrariesControl.this.editEntry();
            }
        });
        this.fMoveUpButton = new Button(buttonBar, 8);
        this.fMoveUpButton.setText(Messages.EnterpriseBuildUI_BUTTON_UP);
        this.fMoveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiPersonalBuildReferencedLibrariesControl.this.moveEntries(true);
            }
        });
        this.fMoveDownButton = new Button(buttonBar, 8);
        this.fMoveDownButton.setText(Messages.EnterpriseBuildUI_BUTTON_DOWN);
        this.fMoveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiPersonalBuildReferencedLibrariesControl.this.moveEntries(false);
            }
        });
        this.setButtonLayoutData();
        this.updatePropertyButtonEnablement();
    }

    public void enable(boolean enable) {
        if (enable) {
            this.fTableViewer.getTable().setEnabled(true);
            this.fAddButton.setEnabled(true);
            this.updatePropertyButtonEnablement();
        } else {
            this.fTableViewer.getTable().setEnabled(false);
            this.fEditButton.setEnabled(false);
            this.fMoveDownButton.setEnabled(false);
            this.fMoveUpButton.setEnabled(false);
            this.fRemoveButton.setEnabled(false);
            this.fAddButton.setEnabled(false);
        }
    }

    protected List<String> getBaseLibraryList(String baseLibraryListProperty) {
        ArrayList<String> v = new ArrayList<String>();
        if (baseLibraryListProperty != null && baseLibraryListProperty.length() > 0) {
            StringTokenizer st = new StringTokenizer(baseLibraryListProperty, new String(new char[]{':'}));
            while (st.hasMoreTokens()) {
                String lib = st.nextToken();
                v.add(lib);
            }
        }
        return v;
    }

    public String getBaseLibraryListProperty() {
        String libraryList = "";
        int i = 0;
        while (i < this.baseLibraryListEntries.size()) {
            libraryList = libraryList.concat(this.baseLibraryListEntries.get(i));
            if (i < this.baseLibraryListEntries.size() - 1) {
                libraryList = libraryList.concat(new String(new char[]{':'}));
            }
            ++i;
        }
        return libraryList;
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IBMiPersonalBuildReferencedLibrariesControl.this.updatePropertyButtonEnablement();
            }
        };
    }

    protected void updatePropertyButtonEnablement() {
        IStructuredSelection selection = this.getCurrentPropertySelection();
        this.fEditButton.setEnabled(selection.size() == 1);
        this.fRemoveButton.setEnabled(!selection.isEmpty());
        if (!selection.isEmpty()) {
            int size = selection.size();
            String first = (String)selection.getFirstElement();
            if (this.baseLibraryListEntries.indexOf(first) == 0) {
                this.fMoveUpButton.setEnabled(false);
            } else {
                this.fMoveUpButton.setEnabled(true);
            }
            if (this.baseLibraryListEntries.indexOf(first) + size == this.baseLibraryListEntries.size()) {
                this.fMoveDownButton.setEnabled(false);
            } else {
                this.fMoveDownButton.setEnabled(true);
            }
        } else {
            this.fMoveDownButton.setEnabled(false);
            this.fMoveUpButton.setEnabled(false);
        }
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        this.editEntry();
    }

    private IStructuredSelection getCurrentPropertySelection() {
        return (IStructuredSelection)this.fTableViewer.getSelection();
    }

    protected void editEntry() {
        ISelection selection = this.fTableViewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        String entry = (String)((IStructuredSelection)selection).getFirstElement();
        BaseLibraryListEntryDialog dialog = new BaseLibraryListEntryDialog(this.fParentShell, Messages.BaseLibraryListControl_EDIT_TITLE, entry, this.baseLibraryListEntries, false);
        if (dialog.open() == 0) {
            int pos = this.baseLibraryListEntries.indexOf(entry);
            this.baseLibraryListEntries.remove(entry);
            this.baseLibraryListEntries.add(pos, dialog.getLibraryListEntry());
            this.fTableViewer.refresh();
            this.notifyBaseLibraryListTableModified();
        }
    }

    protected void notifyBaseLibraryListTableModified() {
        Object[] listeners = this.fListenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof BaseLibraryListControlListener) {
                BaseLibraryListControlListener listener = (BaseLibraryListControlListener)listeners[i];
                listener.baseLibraryListModified();
            }
            ++i;
        }
    }

    protected void addEntry() {
        BaseLibraryListEntryDialog dialog = this.getBuildPropertyDialog("");
        if (dialog.open() == 0) {
            this.baseLibraryListEntries.add(dialog.getLibraryListEntry());
            this.fTableViewer.refresh();
            this.notifyBaseLibraryListTableModified();
        }
    }

    protected void moveEntries(boolean up) {
        ISelection selection = this.fTableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (up) {
                for (String entry : structuredSelection) {
                    int orig = this.baseLibraryListEntries.indexOf(entry);
                    this.baseLibraryListEntries.remove(entry);
                    this.baseLibraryListEntries.add(orig - 1, entry);
                }
            } else {
                Vector<String> move = new Vector<String>();
                for (String entry : structuredSelection) {
                    move.add(0, entry);
                }
                int i = 0;
                while (i < move.size()) {
                    int orig = this.baseLibraryListEntries.indexOf(move.get(i));
                    this.baseLibraryListEntries.remove(move.get(i));
                    this.baseLibraryListEntries.add(orig + 1, (String)move.get(i));
                    ++i;
                }
            }
            this.fTableViewer.refresh();
            this.updatePropertyButtonEnablement();
            this.notifyBaseLibraryListTableModified();
        }
    }

    protected void removeSelectedEntries() {
        ISelection selection;
        boolean deleteConfirmed = MessageDialog.openQuestion((Shell)this.fParentShell, (String)Messages.BaseLibraryListControl_CONFIRM_TITLE, (String)Messages.BaseLibraryListControl_CONFIRM);
        if (deleteConfirmed && (selection = this.fTableViewer.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<String> entriesRemoved = new ArrayList<String>();
            for (String entry : structuredSelection) {
                this.fTableViewer.remove((Object)entry);
                this.baseLibraryListEntries.remove(entry);
                entriesRemoved.add(entry);
            }
            if (!entriesRemoved.isEmpty()) {
                this.fTableViewer.refresh();
                this.updatePropertyButtonEnablement();
                this.notifyBaseLibraryListTableModified();
            }
        }
    }

    private BaseLibraryListEntryDialog getBuildPropertyDialog(String entry) {
        return new BaseLibraryListEntryDialog(this.fParentShell, Messages.BaseLibraryListControl_ADD_TITLE, entry, this.baseLibraryListEntries, true);
    }

    public void addListener(BaseLibraryListControlListener baseLibraryListControlListener) {
        this.fListenerList.add((Object)baseLibraryListControlListener);
    }

    private void setButtonLayoutData() {
        GC gc = new GC((Drawable)this.fAddButton);
        gc.setFont(this.fAddButton.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int maxWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        Point minSize = this.fAddButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fRemoveButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fMoveUpButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fMoveDownButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fEditButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        GridData gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fAddButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fRemoveButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fMoveUpButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fMoveDownButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fEditButton.setLayoutData((Object)gridData);
    }
}

