/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.ui.dialogs;

import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.ui.dialogs.requestbuild.IRequestBuildSectionFactory;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSection;
import com.ibm.team.build.ui.dialogs.requestbuild.RequestBuildSectionSite;
import com.ibm.team.enterprise.build.client.buildablesubset.IBuildableSubsetClient;
import com.ibm.team.enterprise.build.common.EnterpriseRequestDialogOption;
import com.ibm.team.enterprise.build.common.IBuildUtility;
import com.ibm.team.enterprise.build.common.Messages;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.editors.IResourcePrefixValidator;
import com.ibm.team.enterprise.build.ui.editors.UtilFactory;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetEditorInput;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetNode;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetSelectionDialog;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetTextTooltipSupport;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetEditor;
import com.ibm.team.enterprise.buildablesubset.common.impl.BuildableSubsetHandle;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetHandle;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetUtil;
import com.ibm.team.enterprise.common.client.util.URIUtilities;
import com.ibm.team.enterprise.common.ui.EESharedImages;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.internal.client.ProcessClientService;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.rcp.ui.TeamArtifactsNavigator;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.progress.IProgressService;

public class EnterpriseRequestBuildSection
extends RequestBuildSection {
    private String configElementId;
    private boolean isPersonalBuild;
    private boolean fIsBuildChangedItems;
    private boolean fIsFullMinimumLoad;
    private boolean fIsBuildSubset;
    private boolean fIsMandatorySubset;
    private boolean fIsPreviewBuild;
    private boolean fShouldAppendLoadObjLibs;
    private String fSubsetResultLabel;
    private String fSubsetResultSlug;
    private String fMandatorySubsetResultSlug;
    private String prebuildScript;
    private String postbuildScript;
    private boolean isGeneratingBuildFile;
    private boolean hasPermission2RequestFullBuild;
    private boolean hasPermission2RequestSimulationBuild;
    private boolean hasPermission2UseAdvancedPropertiesTeam;
    private boolean hasPermission2UseAdvancedPropertiesPersonal;
    private ISubset fInitialSubset;
    private ISubsetHandle fInitialSubsetHandle;
    private boolean fSkipPreprocessing;
    private boolean fFailIfNotSkip;
    private boolean fHFSRequired;
    private String fLoadDirectory;
    private String fResourcePrefix;
    private String fHFSDir;
    private String subsetValidationMessage;
    private Composite fEnterpriseBuildOptionsComposite;
    private ScrolledComposite fScrolledComposite;
    private Group fPersonalBuildComposite;
    private Composite fArtifactLocationComposite;
    private Composite fPersonalBuildCheckboxComposite;
    private Composite fPreviewBuildCheckboxComposite;
    protected Button fPersonalBuildButton;
    private Button fPreviewBuildButton;
    private Label fPersonalBuildLabel;
    private Label fPreviewBuildLabel;
    protected Text fRepositoryWorkspaceText;
    private Label fRepositoryWorkspaceLabel;
    protected Button fBrowseWorkspaceButton;
    private IWorkspace fPersonalBuildWorkspace;
    private Button fSkipPreprocessingButton;
    private Button fFailIfSkipPreprocessingButton;
    private Text fResourcePrefixText;
    private Label fResourcePrefixLabel;
    private Text fLoadDirectoryText;
    private Label fLoadDirectoryLabel;
    private Text fHFSDirText;
    private Label fHFSDirLabel;
    private Button fBuildAllButton;
    private Button fBuildSubsetButton;
    private Text fSubsetText;
    private Button browseSubsetButton;
    private Composite fMandatorySubsetComposite;
    private Button fMandatorySubsetButton;
    private Text fMandatorySubsetText;
    private Button browseMandatorySubsetButton;
    private Button fBuildChangesOnlyButton;
    private Button fFullMinimumLoadButton;
    private Button fAppendLoadObjLibs;
    private Composite fSimulationBuildCheckboxComposite;
    private Button fSimulationBuildButton;
    private boolean fIsSimulationBuild;
    private Label fSimulationBuildLabel;
    private Button fSimulationBuildBinaryCheckButton;
    private Label fSimulationBuildBinaryCheckLabel;
    private boolean fIsSimulationBuildBinaryCheck;
    private Composite fSimulationBuildBinaryCheckboxComposite;
    private Section fAdvancedSection;
    private ScrolledComposite fScrolledAdvancedComposite;
    private Composite fAdvancedComposite;
    private Button prebuildScriptButton;
    private Button postbuildScriptButton;
    private Button alwaysRunPostbuildScriptButton;
    private Map<String, EnterpriseRequestDialogOption> fDialogOptions;
    private List<Control> hideableControls;
    private List<Control> hiddenControls;
    private Set<Control> userModifiedControls;
    private Map<Control, EnterpriseRequestDialogOption> advancedPropertyControls;
    private List<Button> negatedCheckboxes;
    private Map<String, String> advancedPropertyValues;
    private static final String PREFERENCE_WORKSPACE_PREFIX = "personalBuildWorkspace";
    private static final String PERSONAL_BUILD_SUBSET_LABEL_KEY = "team.enterprise.build.ui.buildSubsetMap";
    private static final String PERSONAL_BUILD_SUBSET_SLUG_KEY = "team.enterprise.build.ui.buildSubsetSlugMap";
    private static final String PERSONAL_BUILD_MANDATORY_SUBSET_SLUG_KEY = "team.enterprise.build.ui.mandatorySubsetSlugMap";
    private static final String PERSONAL_BUILD_FULL_MINIMUM_LOAD_KEY = "team.enterprise.build.ui.performFullLoadMap";
    private static final String PERSONAL_BUILD_LOAD_DIR_KEY = "team.enterprise.build.ui.loadDir";
    private static final String PERSONAL_BUILD_RESOURCE_PREFIX_KEY = "team.enterprise.build.ui.dsPrefix";
    private static final String PERSONAL_BUILD_APPEND_OBJECTS_KEY = "team.enterprise.build.ui.appendObjectsMap";
    private static final String PERSONAL_BUILD_HFS_DIR_KEY = "team.enterprise.build.ui.hfsDir";

    public EnterpriseRequestBuildSection(RequestBuildSectionSite site) {
        super(site);
        IWorkbenchPart part;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart iWorkbenchPart = part = page != null ? page.getActivePart() : null;
        if (part != null) {
            TeamArtifactsNavigator navigator;
            ISelection selection;
            if (part instanceof BuildableSubsetEditor) {
                BuildableSubsetEditor editor = (BuildableSubsetEditor)part;
                BuildSubsetEditorInput editorInput = (BuildSubsetEditorInput)editor.getEditorInput();
                this.fInitialSubset = editorInput.getSubset();
            } else if (part instanceof TeamArtifactsNavigator && (selection = (navigator = (TeamArtifactsNavigator)part).getOriginalSelection()) instanceof TreeSelection) {
                Object selectionObject = ((TreeSelection)selection).getFirstElement();
                if (selectionObject instanceof BuildSubsetNode) {
                    this.fInitialSubset = ((BuildSubsetNode)((Object)selectionObject)).getBuildableSubset();
                } else if (selectionObject instanceof URIFavorite) {
                    URI uri = ((URIFavorite)selectionObject).uri();
                    ISubsetHandle subsetHandle = (ISubsetHandle)URIUtilities.getItemHandle((URI)uri);
                    ITeamRepository repository = URIUtilities.findTeamRepository((URI)uri);
                    IBuildableSubsetClient client = (IBuildableSubsetClient)repository.getClientLibrary(IBuildableSubsetClient.class);
                    try {
                        this.fInitialSubset = client.getSubsetItem(subsetHandle, repository);
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected String getSectionName() {
        return com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_OPTIONS;
    }

    public void createContent(Composite parent) {
        super.createContent(parent);
        ((GridData)this.getSection().getLayoutData()).exclude = true;
        this.getSection().setVisible(false);
    }

    protected void createSectionContent(Section section) {
        ArrayList tabList = new ArrayList();
        this.hideableControls = new ArrayList<Control>();
        this.hiddenControls = new ArrayList<Control>();
        this.advancedPropertyControls = new LinkedHashMap<Control, EnterpriseRequestDialogOption>();
        this.negatedCheckboxes = new ArrayList<Button>();
        this.advancedPropertyValues = new HashMap<String, String>();
        this.userModifiedControls = new HashSet<Control>();
        boolean isIBMiBuild = IBuildUtility.isIBMiDependencyBuild((IBuildDefinition)this.getSite().getBuildDefinition());
        boolean isOldDependencyBuild = IBuildUtility.isOldDependencyBuild((IBuildDefinition)this.getSite().getBuildDefinition());
        this.configElementId = isIBMiBuild ? "com.ibm.team.enterprise.ibmi.build.common.IIBMiDependencyBuildConfigurationElement" : "com.ibm.team.enterprise.zos.build.common.IZosDependencyBuildConfigurationElement";
        this.fDialogOptions = new LinkedHashMap<String, EnterpriseRequestDialogOption>();
        List options = EnterpriseRequestDialogOption.parseOptions((String)this.getSite().getBuildDefinition().getConfigurationPropertyValue(this.configElementId, "team.enterprise.build.ui.requestOptionVisibility", null), (!isIBMiBuild ? 1 : 0) != 0);
        for (EnterpriseRequestDialogOption option : options) {
            this.fDialogOptions.put(option.getId(), option);
        }
        if (this.fEnterpriseBuildOptionsComposite != null && !this.fEnterpriseBuildOptionsComposite.isDisposed()) {
            this.fEnterpriseBuildOptionsComposite.dispose();
        }
        this.fScrolledComposite = new ScrolledComposite((Composite)section, 768);
        this.fEnterpriseBuildOptionsComposite = new Composite((Composite)this.fScrolledComposite, 0);
        this.fEnterpriseBuildOptionsComposite.setLayoutData((Object)new GridData());
        GridLayout layout = new GridLayout(4, false);
        layout.marginLeft = 10;
        layout.verticalSpacing = 0;
        this.fEnterpriseBuildOptionsComposite.setLayout((Layout)layout);
        section.setClient((Control)this.fScrolledComposite);
        IBuildConfigurationElement element = this.getBuildConfigurationElement();
        boolean bl = this.isPersonalBuild = this.getSite().isPersonalBuild() || this.usePersonalBuildForSubset();
        if (element != null) {
            ((GridData)this.getSection().getLayoutData()).exclude = false;
            this.getSection().setVisible(true);
            if (this.getSite().isRebuild()) {
                ((GridLayout)this.fEnterpriseBuildOptionsComposite.getLayout()).verticalSpacing = 15;
                if (!this.isPersonalBuild) {
                    Group preprocessingGroup = new Group(this.fEnterpriseBuildOptionsComposite, 0);
                    preprocessingGroup.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildSection_PREPROCESSING_GROUP_LABEL);
                    GridDataFactory.fillDefaults().grab(true, false).indent(-1, 5).applyTo((Control)preprocessingGroup);
                    GridLayoutFactory.fillDefaults().numColumns(1).applyTo((Composite)preprocessingGroup);
                    Composite groupComposite = new Composite((Composite)preprocessingGroup, 0);
                    GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)groupComposite);
                    GridLayoutFactory.fillDefaults().numColumns(1).margins(10, 5).applyTo(groupComposite);
                    this.fSkipPreprocessingButton = new Button(groupComposite, 32);
                    this.fSkipPreprocessingButton.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildSection_PREPROCESSING_REUSE_LABEL);
                    this.fSkipPreprocessingButton.addSelectionListener(this.getRebuildPreprocessingButtonListener());
                    GridDataFactory.swtDefaults().applyTo((Control)this.fSkipPreprocessingButton);
                    this.fSkipPreprocessingButton.setEnabled(true);
                    this.fSkipPreprocessingButton.setSelection(true);
                    this.fSkipPreprocessing = true;
                    this.fSkipPreprocessingButton.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildSection_PREPROCESSING_REUSE_TOOLTIP);
                    this.fFailIfSkipPreprocessingButton = new Button(groupComposite, 32);
                    this.fFailIfSkipPreprocessingButton.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildSection_PREPROCESSING_FAIL_BUILD_LABEL);
                    this.fFailIfSkipPreprocessingButton.addSelectionListener(this.getRebuildPreprocessingButtonListener());
                    GridDataFactory.swtDefaults().indent(15, 0).applyTo((Control)this.fFailIfSkipPreprocessingButton);
                    this.fFailIfSkipPreprocessingButton.setEnabled(true);
                    this.fFailIfSkipPreprocessingButton.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildSection_PREPROCESSING_FAIL_BUILD_TOOLTIP);
                }
                Label rebuildDescriptionLabel = new Label(this.fEnterpriseBuildOptionsComposite, 16448);
                rebuildDescriptionLabel.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestReBuildDialog_SIMPLE_DESCRIPTION);
                GridDataFactory.fillDefaults().span(4, 1).grab(true, false).applyTo((Control)rebuildDescriptionLabel);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)rebuildDescriptionLabel, ".dialog_buildrequest");
                section.setExpanded(!this.isPersonalBuild);
            } else {
                this.getSite().setProperty("personalBuild", (Object)this.isPersonalBuild);
                this.createBuildScopeOptions(this.fEnterpriseBuildOptionsComposite, tabList);
                this.createPersonalBuildOptions(this.fEnterpriseBuildOptionsComposite, tabList, isIBMiBuild);
                this.fPreviewBuildCheckboxComposite = new Composite(this.fEnterpriseBuildOptionsComposite, 0);
                this.fPreviewBuildCheckboxComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).spacing(0, 0).margins(0, 0).create());
                this.fPreviewBuildCheckboxComposite.setLayoutData((Object)GridDataFactory.fillDefaults().span(4, 0).indent(-1, 5).create());
                this.fPreviewBuildCheckboxComposite.setData((Object)this.fDialogOptions.get("previewBuild"));
                this.hideableControls.add((Control)this.fPreviewBuildCheckboxComposite);
                this.fPreviewBuildButton = new Button(this.fPreviewBuildCheckboxComposite, 32);
                this.fPreviewBuildButton.setText(Messages.EnterpriseRequestDialogOption_PREVIEW_BUILD);
                this.fPreviewBuildButton.setLayoutData((Object)new GridData());
                this.fPreviewBuildButton.addSelectionListener(this.getPreviewBuildButtonListener());
                this.fPreviewBuildLabel = new Label(this.fPreviewBuildCheckboxComposite, 0);
                this.fPreviewBuildLabel.setImage(EESharedImages.getInstance().getImage("IMG_INFO"));
                this.fPreviewBuildLabel.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_PREVIEW_BUILD_DESCRIPTION);
                GridDataFactory.swtDefaults().applyTo((Control)this.fPreviewBuildLabel);
                if (this.hasPermission2RequestSimulationBuild && !isOldDependencyBuild) {
                    this.fSimulationBuildCheckboxComposite = new Composite(this.fEnterpriseBuildOptionsComposite, 0);
                    this.fSimulationBuildCheckboxComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).spacing(0, 0).margins(0, 0).create());
                    this.fSimulationBuildCheckboxComposite.setLayoutData((Object)GridDataFactory.fillDefaults().span(4, 0).indent(-1, 5).create());
                    this.fSimulationBuildCheckboxComposite.setData((Object)this.fDialogOptions.get("simulationBuild"));
                    this.hideableControls.add((Control)this.fSimulationBuildCheckboxComposite);
                    this.fSimulationBuildButton = new Button(this.fSimulationBuildCheckboxComposite, 32);
                    this.fSimulationBuildButton.setText(Messages.EnterpriseRequestDialogOption_SIMULATION_BUILD);
                    this.fSimulationBuildButton.setLayoutData((Object)new GridData());
                    this.fSimulationBuildButton.addSelectionListener(this.getSimulationBuildButtonListener());
                    this.fSimulationBuildLabel = new Label(this.fSimulationBuildCheckboxComposite, 0);
                    this.fSimulationBuildLabel.setImage(EESharedImages.getInstance().getImage("IMG_INFO"));
                    this.fSimulationBuildLabel.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_SIMULATION_BUILD_DESCRIPTION);
                    GridDataFactory.swtDefaults().applyTo((Control)this.fSimulationBuildLabel);
                    this.fSimulationBuildBinaryCheckboxComposite = new Composite(this.fSimulationBuildCheckboxComposite, 0);
                    this.fSimulationBuildBinaryCheckboxComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).spacing(0, 0).margins(0, 0).create());
                    this.fSimulationBuildBinaryCheckboxComposite.setLayoutData((Object)GridDataFactory.fillDefaults().span(4, 0).indent(-1, 5).create());
                    this.fSimulationBuildBinaryCheckboxComposite.setData((Object)this.fDialogOptions.get("verifyBuildOutputs"));
                    this.hideableControls.add((Control)this.fSimulationBuildBinaryCheckboxComposite);
                    this.fSimulationBuildBinaryCheckButton = new Button(this.fSimulationBuildBinaryCheckboxComposite, 32);
                    this.fSimulationBuildBinaryCheckButton.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_SIMULATION_BUILD_BINARY_CHECK_BUTTON);
                    this.fSimulationBuildBinaryCheckButton.setLayoutData((Object)new GridData());
                    this.fSimulationBuildBinaryCheckButton.addSelectionListener(this.getSimulationBuildBinaryCheckButtonListener());
                    this.fSimulationBuildBinaryCheckButton.setEnabled(false);
                    GridDataFactory.swtDefaults().indent(15, 0).applyTo((Control)this.fSimulationBuildBinaryCheckButton);
                    this.fSimulationBuildBinaryCheckLabel = new Label(this.fSimulationBuildBinaryCheckboxComposite, 0);
                    this.fSimulationBuildBinaryCheckLabel.setImage(EESharedImages.getInstance().getImage("IMG_INFO"));
                    this.fSimulationBuildBinaryCheckLabel.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_SIMULATION_BUILD_BINARY_CHECK_DESCRIPTION);
                }
                this.createAdvancedPropertiesSection(this.fEnterpriseBuildOptionsComposite, this.configElementId);
                this.updateComboState();
                this.updateControlVisibility();
                this.updateWidgetValues(true);
            }
        } else {
            Label noOptionsLabel = new Label(this.fEnterpriseBuildOptionsComposite, 64);
            noOptionsLabel.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_NO_OPTIONS);
        }
        this.fScrolledComposite.setContent((Control)this.fEnterpriseBuildOptionsComposite);
        this.fScrolledComposite.setExpandVertical(true);
        this.fScrolledComposite.setExpandHorizontal(true);
        this.fScrolledComposite.setMinSize(this.fEnterpriseBuildOptionsComposite.computeSize(-1, -1));
        if (this.fInitialSubset != null || this.fInitialSubsetHandle != null) {
            this.getSection().setExpanded(true);
        }
    }

    private void createBuildScopeOptions(Composite parent, List tabList) {
        this.fBuildAllButton = new Button(parent, 16);
        this.fBuildAllButton.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_BUTTON_BUILD_WORKSPACE);
        this.fBuildAllButton.addSelectionListener(this.getBuildButtonListener());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.fBuildAllButton.setLayoutData((Object)gridData);
        tabList.add(this.fBuildAllButton);
        this.fBuildSubsetButton = new Button(parent, 16);
        this.fBuildSubsetButton.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_BUTTON_BUILD_SUBSET);
        this.fBuildSubsetButton.addSelectionListener(this.getBuildButtonListener());
        this.fBuildSubsetButton.setLayoutData((Object)new GridData());
        tabList.add(this.fBuildSubsetButton);
        this.fSubsetText = new Text(parent, 2056);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).indent(10, 0).applyTo((Control)this.fSubsetText);
        tabList.add(this.fSubsetText);
        new BuildSubsetTextTooltipSupport(this.fSubsetText);
        this.browseSubsetButton = new Button(parent, 8);
        this.browseSubsetButton.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseBuildUI_BUTTON_BROWSE);
        this.browseSubsetButton.addSelectionListener(this.getSubsetButtonListener());
        GridDataFactory.swtDefaults().applyTo((Control)this.browseSubsetButton);
        tabList.add(this.browseSubsetButton);
        this.fMandatorySubsetComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().span(4, 1).grab(true, false).applyTo((Control)this.fMandatorySubsetComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.fMandatorySubsetComposite);
        this.fMandatorySubsetComposite.setData((Object)this.fDialogOptions.get("mandatorySubset"));
        this.hideableControls.add((Control)this.fMandatorySubsetComposite);
        this.fMandatorySubsetButton = new Button(this.fMandatorySubsetComposite, 32);
        this.fMandatorySubsetButton.setText(Messages.EnterpriseRequestDialogOption_MANDATORY_SUBSET);
        this.fMandatorySubsetButton.setLayoutData((Object)new GridData());
        this.fMandatorySubsetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterpriseRequestBuildSection.this.fIsMandatorySubset = EnterpriseRequestBuildSection.this.fMandatorySubsetButton.getSelection();
                EnterpriseRequestBuildSection.this.userModifiedControls.add(EnterpriseRequestBuildSection.this.fMandatorySubsetButton);
                EnterpriseRequestBuildSection.this.updateComboState();
                EnterpriseRequestBuildSection.this.getSite().revalidate();
            }
        });
        tabList.add(this.fMandatorySubsetButton);
        this.fMandatorySubsetText = new Text(this.fMandatorySubsetComposite, 2056);
        GridDataFactory.fillDefaults().grab(true, false).indent(10, 0).applyTo((Control)this.fMandatorySubsetText);
        tabList.add(this.fMandatorySubsetText);
        new BuildSubsetTextTooltipSupport(this.fMandatorySubsetText);
        this.browseMandatorySubsetButton = new Button(this.fMandatorySubsetComposite, 8);
        this.browseMandatorySubsetButton.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseBuildUI_BUTTON_BROWSE);
        this.browseMandatorySubsetButton.addSelectionListener(this.getSubsetButtonListener());
        GridDataFactory.swtDefaults().applyTo((Control)this.browseMandatorySubsetButton);
        tabList.add(this.browseMandatorySubsetButton);
        this.fBuildChangesOnlyButton = new Button(parent, 32);
        this.fBuildChangesOnlyButton.setText(Messages.EnterpriseRequestDialogOption_BUILD_CHANGED_ITEMS_ONLY);
        this.fBuildChangesOnlyButton.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_LABEL_BUILDCHANGED);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.verticalIndent = 5;
        this.fBuildChangesOnlyButton.setLayoutData((Object)gridData);
        this.fBuildChangesOnlyButton.addSelectionListener(this.getBuildChangesButtonListener());
        this.fBuildChangesOnlyButton.setData((Object)this.fDialogOptions.get("changedItemsOnly"));
        this.hideableControls.add((Control)this.fBuildChangesOnlyButton);
    }

    private void createPersonalBuildOptions(Composite parent, List tabList, boolean isIBMiBuild) {
        this.fPersonalBuildCheckboxComposite = new Composite(parent, 0);
        this.fPersonalBuildCheckboxComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).spacing(0, 0).margins(0, 0).create());
        this.fPersonalBuildCheckboxComposite.setLayoutData((Object)GridDataFactory.fillDefaults().span(4, 0).indent(-1, 5).create());
        this.fPersonalBuildButton = new Button(this.fPersonalBuildCheckboxComposite, 32);
        this.fPersonalBuildButton.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_PERSONAL_BUILD_BUTTON);
        this.fPersonalBuildButton.setLayoutData((Object)new GridData());
        this.fPersonalBuildButton.addSelectionListener(this.getPersonalBuildButtonListener());
        this.fPersonalBuildButton.setSelection(this.isPersonalBuild);
        tabList.add(this.fPersonalBuildButton);
        this.fPersonalBuildLabel = new Label(this.fPersonalBuildCheckboxComposite, 0);
        this.fPersonalBuildLabel.setImage(EESharedImages.getInstance().getImage("IMG_INFO"));
        this.fPersonalBuildLabel.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_PERSONAL_BUILD_DESCRIPTION);
        GridDataFactory.swtDefaults().applyTo((Control)this.fPersonalBuildLabel);
        this.fPersonalBuildComposite = new Group(parent, 0);
        this.fPersonalBuildComposite.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_PERSONAL_BUILD_OPTIONS);
        GridDataFactory.fillDefaults().span(4, 1).grab(true, false).indent(-1, 5).applyTo((Control)this.fPersonalBuildComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo((Composite)this.fPersonalBuildComposite);
        this.fPersonalBuildComposite.setData((Object)new EnterpriseRequestDialogOption("", "", "", "", null, false, false, true, false, false));
        this.hideableControls.add((Control)this.fPersonalBuildComposite);
        this.fArtifactLocationComposite = new Composite((Composite)this.fPersonalBuildComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fArtifactLocationComposite);
        GridLayoutFactory.fillDefaults().numColumns(4).margins(10, 5).applyTo(this.fArtifactLocationComposite);
        this.fRepositoryWorkspaceLabel = new Label(this.fArtifactLocationComposite, 0);
        this.fRepositoryWorkspaceLabel.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_REPOSITORY_WORKSPACE);
        GridDataFactory.swtDefaults().grab(false, false).applyTo((Control)this.fRepositoryWorkspaceLabel);
        tabList.add(this.fRepositoryWorkspaceLabel);
        this.fRepositoryWorkspaceText = new Text(this.fArtifactLocationComposite, 2056);
        GridDataFactory.fillDefaults().grab(true, false).indent(10, 0).span(2, 1).applyTo((Control)this.fRepositoryWorkspaceText);
        tabList.add(this.fRepositoryWorkspaceText);
        this.fBrowseWorkspaceButton = new Button(this.fArtifactLocationComposite, 8);
        this.fBrowseWorkspaceButton.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseBuildUI_BUTTON_BROWSE);
        this.fBrowseWorkspaceButton.addSelectionListener(this.getBrowseWorkspaceButtonListener());
        GridDataFactory.swtDefaults().applyTo((Control)this.fBrowseWorkspaceButton);
        tabList.add(this.fBrowseWorkspaceButton);
        this.fLoadDirectoryLabel = new Label(this.fArtifactLocationComposite, 0);
        this.fLoadDirectoryLabel.setText(String.valueOf(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_LABEL_LOAD) + ":*");
        GridDataFactory.swtDefaults().grab(false, false).applyTo((Control)this.fLoadDirectoryLabel);
        this.fLoadDirectoryText = new Text(this.fArtifactLocationComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).indent(10, 0).span(3, 1).applyTo((Control)this.fLoadDirectoryText);
        this.fLoadDirectoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EnterpriseRequestBuildSection.this.updateSubmitState();
                EnterpriseRequestBuildSection.this.fLoadDirectory = EnterpriseRequestBuildSection.this.fLoadDirectoryText.getText().trim();
                EnterpriseRequestBuildSection.this.userModifiedControls.add(EnterpriseRequestBuildSection.this.fLoadDirectoryText);
            }
        });
        this.fResourcePrefixLabel = new Label(this.fArtifactLocationComposite, 0);
        this.fResourcePrefixLabel.setText(String.valueOf(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_LABEL_PREFIX) + ":*");
        GridDataFactory.swtDefaults().grab(false, false).applyTo((Control)this.fResourcePrefixLabel);
        this.fResourcePrefixText = new Text(this.fArtifactLocationComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).indent(10, 0).span(3, 1).applyTo((Control)this.fResourcePrefixText);
        this.fResourcePrefixText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EnterpriseRequestBuildSection.this.updateSubmitState();
                EnterpriseRequestBuildSection.this.fResourcePrefix = EnterpriseRequestBuildSection.this.fResourcePrefixText.getText();
                EnterpriseRequestBuildSection.this.userModifiedControls.add(EnterpriseRequestBuildSection.this.fResourcePrefixText);
            }
        });
        if (!isIBMiBuild) {
            this.fHFSDirLabel = new Label(this.fArtifactLocationComposite, 0);
            if (this.fHFSRequired) {
                this.fHFSDirLabel.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditor_HFS_OUTPUTS_DIR_LABEL);
            } else {
                this.fHFSDirLabel.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditor_HFS_OUTPUTS_DIR_LABEL_NOT_REQUIRED);
            }
            GridDataFactory.swtDefaults().grab(false, false).applyTo((Control)this.fHFSDirLabel);
            this.fHFSDirText = new Text(this.fArtifactLocationComposite, 2048);
            GridDataFactory.fillDefaults().grab(true, false).indent(10, 0).span(3, 1).applyTo((Control)this.fHFSDirText);
            this.fHFSDirText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    EnterpriseRequestBuildSection.this.updateSubmitState();
                    EnterpriseRequestBuildSection.this.fHFSDir = EnterpriseRequestBuildSection.this.fHFSDirText.getText();
                    EnterpriseRequestBuildSection.this.userModifiedControls.add(EnterpriseRequestBuildSection.this.fHFSDirText);
                }
            });
            this.fHFSDirText.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditor_HFS_OUTPUTS_DIR_TOOLTIP);
            this.fHFSDirLabel.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditor_HFS_OUTPUTS_DIR_TOOLTIP);
        }
        this.fFullMinimumLoadButton = new Button(this.fArtifactLocationComposite, 32);
        this.fFullMinimumLoadButton.setText(Messages.EnterpriseRequestDialogOption_MINIMUM_LOAD);
        if (isIBMiBuild) {
            this.fFullMinimumLoadButton.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildSection_FullMinimumLoadTooltipIBMi);
        } else {
            this.fFullMinimumLoadButton.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildSection_FullMinimumLoadTooltipZOS);
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.fFullMinimumLoadButton.setLayoutData((Object)gridData);
        this.fFullMinimumLoadButton.addSelectionListener(this.getMinimumLoadButtonListener());
        this.fFullMinimumLoadButton.setData((Object)this.fDialogOptions.get("fullMinLoad"));
        this.hideableControls.add((Control)this.fFullMinimumLoadButton);
        if (isIBMiBuild) {
            this.fAppendLoadObjLibs = new Button(this.fArtifactLocationComposite, 32);
            this.fAppendLoadObjLibs.setText(Messages.EnterpriseRequestDialogOption_APPEND_LOAD_OBJECT_LIBRARIES);
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            gridData.verticalIndent = 5;
            this.fAppendLoadObjLibs.setLayoutData((Object)gridData);
            this.fAppendLoadObjLibs.addSelectionListener(this.getAppendLoadObjLibsButtonListener());
            this.hideableControls.add((Control)this.fAppendLoadObjLibs);
        }
    }

    private void createAdvancedPropertiesSection(final Composite parent, String configElementId) {
        this.fAdvancedSection = new Section(parent, 34);
        this.fAdvancedSection.setExpanded(false);
        this.fAdvancedSection.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildSection_ADVANCED_PROPERTIES);
        GridDataFactory.fillDefaults().grab(true, false).indent(-1, 5).span(4, 1).applyTo((Control)this.fAdvancedSection);
        this.fAdvancedSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ((GridData)((EnterpriseRequestBuildSection)EnterpriseRequestBuildSection.this).fScrolledAdvancedComposite.getLayoutData()).exclude = !e.getState();
                EnterpriseRequestBuildSection.this.fScrolledAdvancedComposite.setVisible(e.getState());
                EnterpriseRequestBuildSection.this.fScrolledComposite.setMinSize(parent.computeSize(-1, -1));
                EnterpriseRequestBuildSection.this.fScrolledComposite.getShell().pack();
            }
        });
        this.fScrolledAdvancedComposite = new ScrolledComposite(parent, 2560);
        this.fScrolledAdvancedComposite.setExpandVertical(false);
        this.fScrolledAdvancedComposite.setExpandHorizontal(true);
        this.fScrolledAdvancedComposite.setAlwaysShowScrollBars(false);
        GridDataFactory.fillDefaults().grab(true, false).indent(5, 0).span(4, 1).exclude(true).applyTo((Control)this.fScrolledAdvancedComposite);
        this.fAdvancedComposite = new Composite((Composite)this.fScrolledAdvancedComposite, 0);
        this.fAdvancedComposite.setLayout((Layout)new GridLayout(1, false));
        this.fScrolledAdvancedComposite.setContent((Control)this.fAdvancedComposite);
        this.createAdvancedPropertyCheckbox(this.fAdvancedComposite, this.fDialogOptions.get("trustOutputs"), false);
        this.createAdvancedPropertyCheckbox(this.fAdvancedComposite, this.fDialogOptions.get("conditionalBuild"), false);
        this.createAdvancedPropertyCheckbox(this.fAdvancedComposite, this.fDialogOptions.get("impactsInRepo"), true);
        this.createAdvancedPropertyCheckbox(this.fAdvancedComposite, this.fDialogOptions.get("impactsNotRepo"), true);
        this.createAdvancedPropertyCheckbox(this.fAdvancedComposite, this.fDialogOptions.get("impactsAlwaysBuild"), true);
        this.createAdvancedPropertyCheckbox(this.fAdvancedComposite, this.fDialogOptions.get("deleteDirectory"), false);
        this.prebuildScriptButton = this.createAdvancedPropertyCheckbox(this.fAdvancedComposite, this.fDialogOptions.get("prebuildScript"), false);
        this.postbuildScriptButton = this.createAdvancedPropertyCheckbox(this.fAdvancedComposite, this.fDialogOptions.get("postbuildScript"), false);
        this.alwaysRunPostbuildScriptButton = this.createAdvancedPropertyCheckbox(this.fAdvancedComposite, this.fDialogOptions.get("alwaysRunPostbuild"), false);
        this.createAdvancedTextField(this.fAdvancedComposite, this.fDialogOptions.get("antArgs"));
        this.createAdvancedTextField(this.fAdvancedComposite, this.fDialogOptions.get("customBuildFile"));
        this.createAdvancedTextField(this.fAdvancedComposite, this.fDialogOptions.get("customBuildTargets"));
        this.createAdvancedSpinnerField(this.fAdvancedComposite, this.fDialogOptions.get("processCount"), 1, 50);
        this.prebuildScript = this.getSite().getBuildDefinition().getPropertyValue("team.enterprise.build.ant.preBuildFile", "").trim();
        this.postbuildScript = this.getSite().getBuildDefinition().getPropertyValue("team.enterprise.build.ant.postBuildFile", "").trim();
        this.isGeneratingBuildFile = Boolean.valueOf(this.getSite().getBuildDefinition().getConfigurationPropertyValue(configElementId, "team.enterprise.build.ant.useGeneratedBuildFile", null));
    }

    private Button createAdvancedPropertyCheckbox(Composite parent, final EnterpriseRequestDialogOption option, final boolean isNegatedValue) {
        if (option != null) {
            final Button button = new Button(parent, 32);
            button.setText(option.getLabel());
            button.setData((Object)option);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)button);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean value = isNegatedValue ? !button.getSelection() : button.getSelection();
                    EnterpriseRequestBuildSection.this.advancedPropertyValues.put(option.getId(), Boolean.toString(value));
                    EnterpriseRequestBuildSection.this.userModifiedControls.add(button);
                    if (e.widget == EnterpriseRequestBuildSection.this.postbuildScriptButton && EnterpriseRequestBuildSection.this.alwaysRunPostbuildScriptButton != null) {
                        EnterpriseRequestBuildSection.this.alwaysRunPostbuildScriptButton.setEnabled(EnterpriseRequestBuildSection.this.postbuildScriptButton.getSelection());
                    }
                }
            });
            if (isNegatedValue) {
                this.negatedCheckboxes.add(button);
            }
            this.hideableControls.add((Control)button);
            this.advancedPropertyControls.put((Control)button, option);
            return button;
        }
        return null;
    }

    private Text createAdvancedTextField(Composite parent, final EnterpriseRequestDialogOption option) {
        if (option != null) {
            final Composite composite = new Composite(parent, 0);
            composite.setData((Object)option);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
            Label label = new Label(composite, 0);
            label.setText(NLS.bind((String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildSection_TEXT_FIELD_LABEL, (Object)option.getLabel()));
            GridDataFactory.fillDefaults().grab(false, false).align(1, 0x1000000).applyTo((Control)label);
            final Text text = new Text(composite, 2052);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)text);
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    EnterpriseRequestBuildSection.this.advancedPropertyValues.put(option.getId(), text.getText());
                    EnterpriseRequestBuildSection.this.userModifiedControls.add(composite);
                }
            });
            this.hideableControls.add((Control)composite);
            this.advancedPropertyControls.put((Control)composite, option);
            return text;
        }
        return null;
    }

    private Spinner createAdvancedSpinnerField(Composite parent, final EnterpriseRequestDialogOption option, int mini, int max) {
        if (option != null) {
            final Composite composite = new Composite(parent, 0);
            composite.setData((Object)option);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
            Label label = new Label(composite, 0);
            label.setText(NLS.bind((String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildSection_TEXT_FIELD_LABEL, (Object)option.getLabel()));
            GridDataFactory.fillDefaults().grab(false, false).align(1, 0x1000000).applyTo((Control)label);
            final Spinner spin = new Spinner(composite, 2048);
            spin.setMinimum(mini);
            spin.setMaximum(max);
            GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)spin);
            spin.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    EnterpriseRequestBuildSection.this.advancedPropertyValues.put(option.getId(), spin.getText());
                    EnterpriseRequestBuildSection.this.userModifiedControls.add(composite);
                }
            });
            this.hideableControls.add((Control)composite);
            this.advancedPropertyControls.put((Control)composite, option);
            return spin;
        }
        return null;
    }

    private void updateControlVisibility() {
        this.hiddenControls.clear();
        for (Control control : this.hideableControls) {
            boolean visible;
            Object data = control.getData();
            if (!(data instanceof EnterpriseRequestDialogOption)) continue;
            EnterpriseRequestDialogOption option = (EnterpriseRequestDialogOption)data;
            boolean bl = visible = this.isPersonalBuild ? option.getPersonalVisibility() : option.getTeamVisibility();
            if (control == this.prebuildScriptButton && (this.prebuildScript == null || this.prebuildScript.isEmpty())) {
                visible = false;
            } else if (!(control != this.postbuildScriptButton && control != this.alwaysRunPostbuildScriptButton || this.postbuildScript != null && !this.postbuildScript.isEmpty())) {
                visible = false;
            } else if (this.isGeneratingBuildFile && ("customBuildFile".equals(option.getId()) || "customBuildTargets".equals(option.getId()))) {
                visible = false;
            }
            ((GridData)control.getLayoutData()).exclude = !visible;
            control.setVisible(visible);
            if (visible) continue;
            this.hiddenControls.add(control);
        }
        int numShown = 0;
        if (this.isPersonalBuild && this.hasPermission2UseAdvancedPropertiesPersonal || !this.isPersonalBuild && this.hasPermission2UseAdvancedPropertiesTeam) {
            for (Control control : this.advancedPropertyControls.keySet()) {
                if (this.hiddenControls.contains(control)) continue;
                ++numShown;
            }
        }
        if (this.fAdvancedSection != null && !this.fAdvancedSection.isDisposed()) {
            this.fAdvancedSection.setVisible(numShown > 0);
            ((GridData)this.fAdvancedSection.getLayoutData()).exclude = numShown == 0;
            this.fScrolledAdvancedComposite.setVisible(numShown > 0 && this.fAdvancedSection.isExpanded());
            ((GridData)this.fScrolledAdvancedComposite.getLayoutData()).exclude = numShown == 0 || !this.fAdvancedSection.isExpanded();
            ((GridData)this.fScrolledAdvancedComposite.getLayoutData()).heightHint = Math.min(140, 10 + 30 * numShown);
            this.fAdvancedComposite.setSize(this.fAdvancedComposite.computeSize(-1, -1));
        }
    }

    private boolean usePersonalBuildForSubset() {
        if (this.fInitialSubset != null || this.fInitialSubsetHandle != null) {
            try {
                ITeamRepository repository = (ITeamRepository)this.getSite().getBuildDefinition().getOrigin();
                IProcessAreaHandle processAreaHandle = this.getSite().getBuildDefinition().getProcessArea();
                IProcessArea processArea = (IProcessArea)repository.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, null);
                IProcessClientService processService = (IProcessClientService)repository.getClientLibrary(IProcessClientService.class);
                final IClientProcess clientProcess = processService.getClientProcess(processArea, null);
                final IProcessConfigurationData[] data = new IProcessConfigurationData[1];
                Job job = new Job(""){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            data[0] = clientProcess.getProjectConfigurationData("com.ibm.team.enterprise.process.configuration.build.subsets", null);
                        }
                        catch (TeamRepositoryException e) {
                            Activator.getDefault().logError(e);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
                try {
                    job.join();
                }
                catch (InterruptedException e) {
                    Activator.getDefault().logError(e);
                }
                if (data[0] != null) {
                    IProcessConfigurationElement[] elements = data[0].getElements();
                    int i = 0;
                    while (i < elements.length) {
                        IProcessConfigurationElement element = elements[i];
                        if ("requestBuildType".equals(element.getName())) {
                            return !Boolean.parseBoolean(element.getAttribute("teamBuild"));
                        }
                        ++i;
                    }
                }
            }
            catch (TeamRepositoryException e) {
                Activator.getDefault().logError(e);
            }
            return true;
        }
        return false;
    }

    public void initialize(IProgressMonitor monitor) {
        IBuildDefinition buildDefinition = this.getSite().getBuildDefinition();
        if (!IBuildUtility.isDependencyBuild((IBuildDefinition)buildDefinition)) {
            return;
        }
        boolean isJazzAdmin = this.isUserJazzAdmin(monitor);
        this.hasPermission2RequestFullBuild = this.hasPermission2RequestFullBuild();
        this.hasPermission2RequestSimulationBuild = isJazzAdmin || this.hasPermission2RequestSimulationBuild();
        this.hasPermission2UseAdvancedPropertiesTeam = isJazzAdmin || this.hasPermission2UseAdvancedPropertiesInTeamBuild();
        this.hasPermission2UseAdvancedPropertiesPersonal = isJazzAdmin || this.hasPermission2UseAdvancedPropertiesInPersonalBuild();
        this.fHFSRequired = Boolean.parseBoolean(buildDefinition.getPropertyValue("team.enterprise.build.hfsEnabled", null));
    }

    private void updateWidgetValues(boolean isInitialization) {
        String textLabel;
        String preferenceValue;
        IBuildProperty changesOnlyProperty;
        String buildDefUUID = this.getSite().getBuildDefinition().getItemId().getUuidValue();
        boolean isIBMiBuild = IBuildUtility.isIBMiDependencyBuild((IBuildDefinition)this.getSite().getBuildDefinition());
        if ((isInitialization || !this.isPersonalBuild && !this.hasPermission2RequestFullBuild || !this.isPersonalBuild && !this.userModifiedControls.contains(this.fBuildChangesOnlyButton)) && (changesOnlyProperty = this.getSite().getBuildDefinition().getProperty("team.enterprise.build.ant.buildChangesOnly")) != null) {
            this.fIsBuildChangedItems = Boolean.parseBoolean(changesOnlyProperty.getValue());
        }
        if (!this.hiddenControls.contains(this.fBuildChangesOnlyButton)) {
            this.fBuildChangesOnlyButton.setEnabled(this.isPersonalBuild || this.hasPermission2RequestFullBuild);
            this.fBuildChangesOnlyButton.setSelection(this.fIsBuildChangedItems);
        }
        if (isInitialization) {
            this.getPersistedWorkspaceInBackground(this.getSite().getBuildDefinition());
        }
        if (isInitialization && (preferenceValue = this.fetchPersonalPropertyValue(PERSONAL_BUILD_LOAD_DIR_KEY, buildDefUUID)) != null && !preferenceValue.isEmpty()) {
            this.fLoadDirectory = preferenceValue.trim();
            this.fLoadDirectoryText.setText(this.fLoadDirectory);
        }
        if (isInitialization && (preferenceValue = this.fetchPersonalPropertyValue(PERSONAL_BUILD_RESOURCE_PREFIX_KEY, buildDefUUID)) != null && !preferenceValue.isEmpty()) {
            this.fResourcePrefix = preferenceValue;
            this.fResourcePrefixText.setText(this.fResourcePrefix);
        }
        if (isInitialization && !isIBMiBuild && (preferenceValue = this.fetchPersonalPropertyValue(PERSONAL_BUILD_HFS_DIR_KEY, buildDefUUID)) != null && !preferenceValue.isEmpty()) {
            this.fHFSDir = preferenceValue;
            this.fHFSDirText.setText(this.fHFSDir);
        }
        if (isInitialization) {
            String fullLoadValue = this.fetchPersonalPropertyValue(PERSONAL_BUILD_FULL_MINIMUM_LOAD_KEY, buildDefUUID);
            if (fullLoadValue == null) {
                fullLoadValue = this.getSite().getBuildDefinition().getPropertyValue("team.enterprise.build.ant.fullMinimumLoad", null);
            }
            this.fIsFullMinimumLoad = Boolean.parseBoolean(fullLoadValue);
            this.fFullMinimumLoadButton.setSelection(this.fIsFullMinimumLoad);
        }
        if (isInitialization && isIBMiBuild) {
            String appendValue = this.fetchPersonalPropertyValue(PERSONAL_BUILD_APPEND_OBJECTS_KEY, buildDefUUID);
            if (appendValue == null) {
                appendValue = this.getSite().getBuildDefinition().getPropertyValue("com.ibm.team.enterprise.ibmi.build.AppendLoadObjLibraries", Boolean.TRUE.toString());
            }
            this.fShouldAppendLoadObjLibs = Boolean.parseBoolean(appendValue);
            this.fAppendLoadObjLibs.setSelection(this.fShouldAppendLoadObjLibs);
        }
        if (isInitialization && this.fSimulationBuildBinaryCheckButton != null) {
            this.fIsSimulationBuildBinaryCheck = Boolean.parseBoolean(this.getSite().getBuildDefinition().getPropertyValue("team.enterprise.build.ant.simulationModeBinaryCheck", null));
            this.fSimulationBuildBinaryCheckButton.setSelection(this.fIsSimulationBuildBinaryCheck);
        }
        if (!this.userModifiedControls.contains(this.fBuildSubsetButton) && !this.userModifiedControls.contains(this.fSubsetText)) {
            textLabel = null;
            if (this.fInitialSubset != null || this.fInitialSubsetHandle != null) {
                this.fIsBuildSubset = true;
                this.fSubsetResultLabel = this.fInitialSubset != null ? this.fInitialSubset.getLabel() : null;
                this.fSubsetResultSlug = this.fInitialSubset != null ? BuildableSubsetUtil.getSlug((String)this.fInitialSubset.getLabel(), (String)this.fInitialSubset.getBuildDefinition().getItemId().getUuidValue()) : null;
            } else {
                String label = null;
                String slug = null;
                if (this.isPersonalBuild) {
                    label = this.fetchPersonalPropertyValue(PERSONAL_BUILD_SUBSET_LABEL_KEY, buildDefUUID);
                    slug = this.fetchPersonalPropertyValue(PERSONAL_BUILD_SUBSET_SLUG_KEY, buildDefUUID);
                    if (label != null) {
                        label = label.trim();
                    }
                    if (slug != null) {
                        slug = slug.trim();
                    }
                }
                if (label == null) {
                    label = this.getSite().getBuildDefinition().getPropertyValue("team.enterprise.build.ant.buildableSubset", null);
                }
                if (label != null && !label.isEmpty() && (slug == null || slug.isEmpty())) {
                    slug = BuildableSubsetUtil.getSlug((String)label, (String)buildDefUUID);
                }
                if (!(slug == null || slug.isEmpty() || slug.equals(this.fSubsetResultSlug) || this.subsetExists(slug))) {
                    slug = null;
                    textLabel = com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_BUILD_SUBSET_DELETED;
                }
                if (slug != null && !slug.isEmpty()) {
                    this.fIsBuildSubset = true;
                    this.fSubsetResultLabel = label;
                    this.fSubsetResultSlug = slug;
                } else {
                    this.fIsBuildSubset = com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_BUILD_SUBSET_DELETED.equals(textLabel);
                    this.fSubsetResultLabel = "";
                    this.fSubsetResultSlug = "";
                }
            }
            if (textLabel == null) {
                textLabel = this.fSubsetResultLabel;
            }
            this.fBuildAllButton.setSelection(!this.fIsBuildSubset);
            this.fBuildSubsetButton.setSelection(this.fIsBuildSubset);
            this.fSubsetText.setText(textLabel);
            this.fSubsetText.setData("subset_handle", (Object)new BuildableSubsetHandle(textLabel, this.getSite().getBuildDefinition().getItemId(), this.getSite().getBuildDefinition().getOrigin()));
            this.browseSubsetButton.setEnabled(this.fIsBuildSubset);
        }
        if (!this.hiddenControls.contains(this.fMandatorySubsetComposite)) {
            if (!this.userModifiedControls.contains(this.fMandatorySubsetButton) && !this.userModifiedControls.contains(this.fMandatorySubsetText)) {
                textLabel = null;
                String slug = null;
                if (this.isPersonalBuild) {
                    slug = this.fetchPersonalPropertyValue(PERSONAL_BUILD_MANDATORY_SUBSET_SLUG_KEY, buildDefUUID);
                    if (slug != null) {
                        slug = slug.trim();
                    }
                    if (slug == null && Boolean.parseBoolean(this.getSite().getBuildDefinition().getPropertyValue("team.enterprise.build.ant.mandatorySubset.useInPersonal", null))) {
                        slug = this.getSite().getBuildDefinition().getPropertyValue("team.enterprise.build.ant.mandatorySubset", null);
                    }
                } else {
                    slug = this.getSite().getBuildDefinition().getPropertyValue("team.enterprise.build.ant.mandatorySubset", null);
                }
                if (!(slug == null || slug.isEmpty() || slug.equals(this.fMandatorySubsetResultSlug) || this.subsetExists(slug))) {
                    slug = null;
                    textLabel = com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_BUILD_SUBSET_DELETED;
                }
                if (slug != null && !slug.isEmpty()) {
                    this.fIsMandatorySubset = true;
                    this.fMandatorySubsetResultSlug = slug;
                } else {
                    this.fIsMandatorySubset = com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_BUILD_SUBSET_DELETED.equals(textLabel);
                    this.fMandatorySubsetResultSlug = "";
                }
                if (textLabel == null) {
                    textLabel = BuildableSubsetUtil.getLabelFromSlug((String)this.fMandatorySubsetResultSlug);
                }
                this.fMandatorySubsetButton.setSelection(this.fIsMandatorySubset);
                this.fMandatorySubsetText.setText(textLabel);
                this.fMandatorySubsetText.setData("subset_handle", (Object)new BuildableSubsetHandle(textLabel, this.getSite().getBuildDefinition().getItemId(), this.getSite().getBuildDefinition().getOrigin()));
            }
            this.fMandatorySubsetButton.setEnabled(this.fIsBuildChangedItems || this.fIsBuildSubset);
            this.browseMandatorySubsetButton.setEnabled(this.fIsMandatorySubset && (this.fIsBuildChangedItems || this.fIsBuildSubset));
        }
        block0: for (Map.Entry<Control, EnterpriseRequestDialogOption> entry : this.advancedPropertyControls.entrySet()) {
            if (this.hiddenControls.contains(entry.getKey()) || this.userModifiedControls.contains(entry.getKey())) continue;
            String setting = null;
            if (this.isPersonalBuild) {
                setting = this.fetchPersonalPropertyValue(String.valueOf(entry.getValue().getId()) + "PersonalBuildMap", buildDefUUID);
            }
            if (entry.getKey() == this.prebuildScriptButton) {
                boolean selection;
                if (setting == null) {
                    selection = true;
                    setting = Boolean.toString(selection);
                } else {
                    selection = Boolean.parseBoolean(setting);
                }
                this.advancedPropertyValues.put(entry.getValue().getId(), setting);
                this.prebuildScriptButton.setSelection(selection);
                continue;
            }
            if (entry.getKey() == this.postbuildScriptButton) {
                boolean selection;
                if (setting == null) {
                    selection = true;
                    setting = Boolean.toString(selection);
                } else {
                    selection = Boolean.parseBoolean(setting);
                }
                this.advancedPropertyValues.put(entry.getValue().getId(), setting);
                this.postbuildScriptButton.setSelection(selection);
                if (this.alwaysRunPostbuildScriptButton == null) continue;
                this.alwaysRunPostbuildScriptButton.setEnabled(selection);
                continue;
            }
            if (setting == null) {
                IConfigurationProperty property;
                setting = entry.getValue().isConfigurationProperty() ? ((property = this.getSite().getBuildDefinition().getConfigurationElement(this.configElementId).getConfigurationProperty(entry.getValue().getBuildPropertyName())) == null || property.getValue().isEmpty() ? ("conditionalBuild".equals(entry.getValue().getId()) ? "true" : "") : property.getValue()) : this.getSite().getBuildDefinition().getPropertyValue(entry.getValue().getBuildPropertyName(), "");
            }
            this.advancedPropertyValues.put(entry.getValue().getId(), setting);
            if (entry.getKey() instanceof Button) {
                boolean value = Boolean.parseBoolean(setting);
                if (this.negatedCheckboxes.contains(entry.getKey())) {
                    value = !value;
                }
                ((Button)entry.getKey()).setSelection(value);
                continue;
            }
            if (!(entry.getKey() instanceof Composite)) continue;
            Control[] controlArray = ((Composite)entry.getKey()).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof Text) {
                    ((Text)child).setText(setting);
                    continue block0;
                }
                if (child instanceof Spinner) {
                    int value = 0;
                    if (setting != null && setting.length() > 0) {
                        value = Integer.valueOf(setting);
                    }
                    ((Spinner)child).setSelection(value);
                    continue block0;
                }
                ++n2;
            }
        }
    }

    private boolean subsetExists(final String slug) {
        if (slug == null || slug.isEmpty()) {
            return false;
        }
        IProgressService ps = PlatformUI.getWorkbench().getProgressService();
        IBuildDefinition buildDef = this.getSite().getBuildDefinition();
        ITeamRepository fRepository = (ITeamRepository)buildDef.getOrigin();
        final IBuildableSubsetClient client = (IBuildableSubsetClient)fRepository.getClientLibrary(IBuildableSubsetClient.class);
        final boolean[] result = new boolean[1];
        try {
            ps.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        result[0] = client.exists(slug);
                    }
                    catch (TeamRepositoryException e) {
                        Activator.getDefault().logError(e);
                    }
                }
            });
        }
        catch (Exception e) {
            Activator.getDefault().logError(e);
        }
        return result[0];
    }

    protected void getPersistedWorkspaceInBackground(final IBuildDefinition buildDefinition) {
        new UIUpdaterJob(""){

            public IStatus runInBackground(IProgressMonitor monitor) {
                String workspaceUuid = Activator.getDefault().getPreferenceStore().getString(EnterpriseRequestBuildSection.PREFERENCE_WORKSPACE_PREFIX + buildDefinition.getId());
                ITeamRepository teamRepository = (ITeamRepository)buildDefinition.getOrigin();
                EnterpriseRequestBuildSection.this.fPersonalBuildWorkspace = EnterpriseRequestBuildSection.this.getWorkspace(workspaceUuid, teamRepository, monitor);
                return Status.OK_STATUS;
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                if (EnterpriseRequestBuildSection.this.fPersonalBuildWorkspace != null && EnterpriseRequestBuildSection.this.fRepositoryWorkspaceText != null && !EnterpriseRequestBuildSection.this.fRepositoryWorkspaceText.isDisposed()) {
                    EnterpriseRequestBuildSection.this.fRepositoryWorkspaceText.setText(EnterpriseRequestBuildSection.this.fPersonalBuildWorkspace.getName());
                    EnterpriseRequestBuildSection.this.getSite().revalidate();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected IWorkspace getWorkspace(String workspaceUuid, ITeamRepository teamRepository, IProgressMonitor monitor) {
        try {
            if (workspaceUuid != null && workspaceUuid.length() > 0) {
                IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceUuid), null);
                return (IWorkspace)teamRepository.itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, monitor);
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        return null;
    }

    private SelectionListener getBuildChangesButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterpriseRequestBuildSection.this.fIsBuildChangedItems = EnterpriseRequestBuildSection.this.fBuildChangesOnlyButton.getSelection();
                EnterpriseRequestBuildSection.this.userModifiedControls.add(EnterpriseRequestBuildSection.this.fBuildChangesOnlyButton);
                EnterpriseRequestBuildSection.this.updateComboState();
            }
        };
    }

    private SelectionListener getRebuildPreprocessingButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EnterpriseRequestBuildSection.this.fSkipPreprocessingButton.getSelection()) {
                    EnterpriseRequestBuildSection.this.fSkipPreprocessing = true;
                    EnterpriseRequestBuildSection.this.fFailIfSkipPreprocessingButton.setEnabled(true);
                    EnterpriseRequestBuildSection.this.fFailIfNotSkip = EnterpriseRequestBuildSection.this.fFailIfSkipPreprocessingButton.getSelection();
                } else {
                    EnterpriseRequestBuildSection.this.fSkipPreprocessing = false;
                    EnterpriseRequestBuildSection.this.fFailIfNotSkip = false;
                    EnterpriseRequestBuildSection.this.fFailIfSkipPreprocessingButton.setEnabled(false);
                    EnterpriseRequestBuildSection.this.fFailIfSkipPreprocessingButton.setSelection(false);
                }
            }
        };
    }

    private SelectionListener getAppendLoadObjLibsButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterpriseRequestBuildSection.this.fShouldAppendLoadObjLibs = EnterpriseRequestBuildSection.this.fAppendLoadObjLibs.getSelection();
                EnterpriseRequestBuildSection.this.userModifiedControls.add(EnterpriseRequestBuildSection.this.fAppendLoadObjLibs);
            }
        };
    }

    private SelectionListener getMinimumLoadButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterpriseRequestBuildSection.this.fIsFullMinimumLoad = EnterpriseRequestBuildSection.this.fFullMinimumLoadButton.getSelection();
                EnterpriseRequestBuildSection.this.userModifiedControls.add(EnterpriseRequestBuildSection.this.fFullMinimumLoadButton);
            }
        };
    }

    protected SelectionListener getPersonalBuildButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterpriseRequestBuildSection.this.isPersonalBuild = EnterpriseRequestBuildSection.this.fPersonalBuildButton.getSelection();
                EnterpriseRequestBuildSection.this.getSite().setProperty("personalBuild", (Object)EnterpriseRequestBuildSection.this.isPersonalBuild);
                EnterpriseRequestBuildSection.this.updateComboState();
                EnterpriseRequestBuildSection.this.updateControlVisibility();
                EnterpriseRequestBuildSection.this.updateWidgetValues(false);
                EnterpriseRequestBuildSection.this.getSite().revalidate();
                EnterpriseRequestBuildSection.this.fScrolledComposite.setMinSize(EnterpriseRequestBuildSection.this.fEnterpriseBuildOptionsComposite.computeSize(-1, -1));
                EnterpriseRequestBuildSection.this.fPersonalBuildCheckboxComposite.getShell().pack();
            }
        };
    }

    protected SelectionListener getBrowseWorkspaceButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITeamRepository teamRepository = (ITeamRepository)EnterpriseRequestBuildSection.this.getSite().getBuildDefinition().getOrigin();
                IWorkspace workspace = EnterpriseRequestBuildSection.this.openWorkspaceChooserDialog(EnterpriseRequestBuildSection.this.fBrowseWorkspaceButton.getShell(), teamRepository);
                if (workspace != null) {
                    EnterpriseRequestBuildSection.this.fPersonalBuildWorkspace = workspace;
                    EnterpriseRequestBuildSection.this.fRepositoryWorkspaceText.setText(workspace.getName());
                    EnterpriseRequestBuildSection.this.userModifiedControls.add(EnterpriseRequestBuildSection.this.fRepositoryWorkspaceText);
                    EnterpriseRequestBuildSection.this.updateComboState();
                    EnterpriseRequestBuildSection.this.getSite().revalidate();
                    Activator.getDefault().getPreferenceStore().setValue(EnterpriseRequestBuildSection.PREFERENCE_WORKSPACE_PREFIX + EnterpriseRequestBuildSection.this.getSite().getBuildDefinition().getId(), workspace.getItemId().getUuidValue());
                    Activator.getDefault().savePluginPreferences();
                }
            }
        };
    }

    private SelectionListener getPreviewBuildButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterpriseRequestBuildSection.this.fIsPreviewBuild = EnterpriseRequestBuildSection.this.fPreviewBuildButton.getSelection();
                EnterpriseRequestBuildSection.this.updateComboState();
            }
        };
    }

    private SelectionListener getSimulationBuildButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterpriseRequestBuildSection.this.fIsSimulationBuild = EnterpriseRequestBuildSection.this.fSimulationBuildButton.getSelection();
                EnterpriseRequestBuildSection.this.fSimulationBuildBinaryCheckButton.setEnabled(EnterpriseRequestBuildSection.this.fIsSimulationBuild);
                EnterpriseRequestBuildSection.this.userModifiedControls.add(EnterpriseRequestBuildSection.this.fSimulationBuildButton);
                EnterpriseRequestBuildSection.this.updateComboState();
                if (EnterpriseRequestBuildSection.this.fIsSimulationBuild) {
                    EnterpriseRequestBuildSection.this.getSite().addWarningMessage((Object)EnterpriseRequestBuildSection.this.fSimulationBuildButton, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_SIMULATION_WARNING_MESSAGE);
                } else {
                    EnterpriseRequestBuildSection.this.getSite().removeWarningMessage((Object)EnterpriseRequestBuildSection.this.fSimulationBuildButton);
                }
            }
        };
    }

    private SelectionListener getSimulationBuildBinaryCheckButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterpriseRequestBuildSection.this.fIsSimulationBuildBinaryCheck = EnterpriseRequestBuildSection.this.fSimulationBuildBinaryCheckButton.getSelection();
                EnterpriseRequestBuildSection.this.userModifiedControls.add(EnterpriseRequestBuildSection.this.fSimulationBuildBinaryCheckButton);
            }
        };
    }

    private SelectionListener getBuildButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterpriseRequestBuildSection.this.fIsBuildSubset = EnterpriseRequestBuildSection.this.fBuildSubsetButton.getSelection();
                if (e.widget instanceof Control) {
                    EnterpriseRequestBuildSection.this.userModifiedControls.add((Control)e.widget);
                }
                EnterpriseRequestBuildSection.this.updateComboState();
                EnterpriseRequestBuildSection.this.validateSubset();
                EnterpriseRequestBuildSection.this.getSite().revalidate();
            }
        };
    }

    private SelectionListener getSubsetButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == EnterpriseRequestBuildSection.this.browseSubsetButton || e.getSource() == EnterpriseRequestBuildSection.this.browseMandatorySubsetButton) {
                    try {
                        Shell parentShell = EnterpriseRequestBuildSection.this.browseSubsetButton.getShell();
                        ITeamRepository fRepository = (ITeamRepository)EnterpriseRequestBuildSection.this.getSite().getBuildDefinition().getOrigin();
                        BuildSubsetSelectionDialog dialog = new BuildSubsetSelectionDialog(parentShell, fRepository, EnterpriseRequestBuildSection.this.getSite().getBuildDefinition(), true, false);
                        if (dialog.open() == 0) {
                            ISubset subset = dialog.getSelectedSubset();
                            String newSlug = BuildableSubsetUtil.getSlug((String)subset.getLabel(), (String)subset.getBuildDefinition().getItemId().getUuidValue());
                            if (e.getSource() == EnterpriseRequestBuildSection.this.browseSubsetButton) {
                                EnterpriseRequestBuildSection.this.fSubsetResultLabel = subset.getLabel();
                                EnterpriseRequestBuildSection.this.fSubsetResultSlug = newSlug;
                                EnterpriseRequestBuildSection.this.fSubsetText.setText(EnterpriseRequestBuildSection.this.fSubsetResultLabel);
                                EnterpriseRequestBuildSection.this.fSubsetText.setData("subset_handle", (Object)new BuildableSubsetHandle(EnterpriseRequestBuildSection.this.fSubsetResultLabel, EnterpriseRequestBuildSection.this.getSite().getBuildDefinition().getItemId(), EnterpriseRequestBuildSection.this.getSite().getBuildDefinition().getOrigin()));
                                EnterpriseRequestBuildSection.this.userModifiedControls.add(EnterpriseRequestBuildSection.this.fSubsetText);
                            } else {
                                EnterpriseRequestBuildSection.this.fMandatorySubsetResultSlug = newSlug;
                                EnterpriseRequestBuildSection.this.fMandatorySubsetText.setText(subset.getLabel());
                                EnterpriseRequestBuildSection.this.fMandatorySubsetText.setData("subset_handle", (Object)new BuildableSubsetHandle(subset.getLabel(), EnterpriseRequestBuildSection.this.getSite().getBuildDefinition().getItemId(), EnterpriseRequestBuildSection.this.getSite().getBuildDefinition().getOrigin()));
                                EnterpriseRequestBuildSection.this.userModifiedControls.add(EnterpriseRequestBuildSection.this.fMandatorySubsetText);
                            }
                        } else {
                            return;
                        }
                        EnterpriseRequestBuildSection.this.validateSubset();
                        EnterpriseRequestBuildSection.this.getSite().revalidate();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
    }

    private void updateComboState() {
        boolean isBuildAllSelected = this.fBuildAllButton.getSelection();
        boolean isPersonalBuild = this.getSite().isPersonalBuild();
        this.browseSubsetButton.setEnabled(!isBuildAllSelected);
        this.fMandatorySubsetButton.setEnabled(this.fIsBuildChangedItems || this.fIsBuildSubset);
        this.browseMandatorySubsetButton.setEnabled(this.fIsMandatorySubset && (this.fIsBuildChangedItems || this.fIsBuildSubset));
        if (this.fPreviewBuildButton != null && this.fPersonalBuildButton != null && !this.fPreviewBuildButton.isDisposed() && !this.fPersonalBuildButton.isDisposed()) {
            boolean simulationEnabled;
            boolean isPreviewBuild = this.fPreviewBuildButton.getSelection();
            boolean isSimulationBuild = this.fSimulationBuildButton != null && !this.fSimulationBuildButton.isDisposed() && this.fSimulationBuildButton.getSelection();
            this.fPreviewBuildButton.setEnabled(!isPersonalBuild && !isSimulationBuild);
            this.fPersonalBuildButton.setEnabled(!isPreviewBuild && !isSimulationBuild);
            boolean bl = simulationEnabled = !isPersonalBuild && !isPreviewBuild;
            if (this.fSimulationBuildButton != null && !this.fSimulationBuildButton.isDisposed()) {
                this.fSimulationBuildButton.setEnabled(simulationEnabled);
            }
            if (this.fSimulationBuildBinaryCheckButton != null && !this.fSimulationBuildBinaryCheckButton.isDisposed()) {
                this.fSimulationBuildBinaryCheckButton.setEnabled(simulationEnabled && isSimulationBuild);
            }
        }
    }

    private void updateSubmitState() {
        this.getSite().revalidate();
    }

    protected IWorkspace openWorkspaceChooserDialog(Shell shell, ITeamRepository teamRepository) {
        AbstractPlaceWrapper wrapper = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream((Shell)shell, (ITeamRepository)teamRepository, null, (WORKSPACES_OR_STREAMS)WORKSPACES_OR_STREAMS.WORKSPACES, null);
        if (wrapper != null) {
            return wrapper.getWorkspace();
        }
        return null;
    }

    private String fetchPersonalPropertyValue(String propertyMapPreferenceKey, String buildDefinitionUUID) {
        String propertyString;
        IPreferenceStore eeSectionStore = Activator.getDefault().getPreferenceStore();
        String propertyMapString = eeSectionStore.getString(propertyMapPreferenceKey);
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        if (propertyMapString != null && propertyMapString.length() > 0) {
            StringTokenizer mapTokenizer = new StringTokenizer(propertyMapString, " ", false);
            while (mapTokenizer.hasMoreElements()) {
                String buildDefToken = mapTokenizer.nextToken();
                if (mapTokenizer.hasMoreTokens()) {
                    String propertyToken = mapTokenizer.nextToken();
                    propertyMap.put(buildDefToken, propertyToken);
                    continue;
                }
                eeSectionStore.setToDefault(propertyMapPreferenceKey);
                return null;
            }
        }
        if ((propertyString = (String)propertyMap.get(buildDefinitionUUID)) != null && propertyString.length() > 0) {
            propertyString = propertyString.replaceAll("%20", " ").replaceAll("%25", "%");
        }
        return propertyString;
    }

    public String validate() {
        if (this.getSite().isRebuild() && Boolean.parseBoolean(this.getSite().getBuildDefinition().getPropertyValue("team.enterprise.build.ant.simulationMode", "false"))) {
            return com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_SIMULATION_ERROR_MESSAGE_NO_REBUILDS;
        }
        if (this.fPersonalBuildButton != null && !this.fPersonalBuildButton.isDisposed() && this.fPersonalBuildButton.getSelection()) {
            IStatus status;
            if (this.fResourcePrefixText.getText().isEmpty()) {
                return com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_ERROR_NORESOURCEPREFIX;
            }
            String resourcePrefixValue = this.fResourcePrefixText.getText();
            IResourcePrefixValidator resourcePrefixValidator = UtilFactory.getInstance().getResourcePrefixValidator(this.getSite().getBuildDefinition());
            if (resourcePrefixValidator != null && (status = resourcePrefixValidator.validate(resourcePrefixValue)) != null && !status.isOK()) {
                return status.getMessage();
            }
            if (this.fRepositoryWorkspaceText.getText().isEmpty()) {
                return com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_ERROR_NOWORKSPACE;
            }
            if (this.fLoadDirectoryText.getText().isEmpty()) {
                return com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_ERROR_NOLOADDIR;
            }
            if (this.fHFSRequired && this.fHFSDirText.getText().trim().isEmpty()) {
                return com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_ERROR_HFS_OUTPUTS;
            }
            this.validateSubset();
            return this.getSubsetValidationMessage();
        }
        this.validateSubset();
        return this.getSubsetValidationMessage();
    }

    private void validateSubset() {
        if (this.fBuildSubsetButton != null && !this.fBuildSubsetButton.isDisposed() && this.fBuildSubsetButton.getSelection() && (this.fSubsetText.getText().isEmpty() || this.fSubsetText.getText().equals(com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_BUILD_SUBSET_DELETED))) {
            this.setSubsetValidationMessage(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_ERROR_SUBSET_NONE);
        } else if (this.fMandatorySubsetButton != null && !this.fMandatorySubsetButton.isDisposed() && this.fMandatorySubsetButton.getSelection() && (this.fMandatorySubsetText.getText().isEmpty() || this.fMandatorySubsetText.getText().equals(com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_BUILD_SUBSET_DELETED))) {
            this.setSubsetValidationMessage(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_ERROR_MANDATORY_SUBSET_NONE);
        } else {
            this.setSubsetValidationMessage(null);
        }
    }

    private String getSubsetValidationMessage() {
        return this.subsetValidationMessage;
    }

    private void setSubsetValidationMessage(String subsetValidationMessage) {
        this.subsetValidationMessage = subsetValidationMessage;
    }

    private IBuildConfigurationElement getBuildConfigurationElement() {
        IBuildDefinition buildDef = this.getSite().getBuildDefinition();
        if (IBuildUtility.isIBMiDependencyBuild((IBuildDefinition)buildDef)) {
            return buildDef.getConfigurationElement("com.ibm.team.enterprise.ibmi.build.common.IIBMiDependencyBuildConfigurationElement");
        }
        if (IBuildUtility.isZOSDependencyBuild((IBuildDefinition)this.getSite().getBuildDefinition())) {
            return buildDef.getConfigurationElement("com.ibm.team.enterprise.zos.build.common.IZosDependencyBuildConfigurationElement");
        }
        return null;
    }

    public void applyProperties(IBuildDefinition buildDefinition) {
        IBuildConfigurationElement element = this.getBuildConfigurationElement();
        if (element != null) {
            if (this.getSite().isRebuild()) {
                this.applyRebuildProperties();
            } else {
                String subsetLabel;
                IBuildProperty buildLabelPrefix;
                String buildDefUUID = this.getSite().getBuildDefinition().getItemId().getUuidValue();
                this.setBuildProperty(buildDefinition, "team.enterprise.build.dependency.previewBuild", Boolean.toString(this.fIsPreviewBuild), this.fIsPreviewBuild ? Boolean.valueOf(true) : null);
                if (this.fIsSimulationBuild && !this.hiddenControls.contains(this.fSimulationBuildCheckboxComposite)) {
                    this.setBuildProperty(buildDefinition, "team.enterprise.build.ant.simulationMode", Boolean.toString(this.fIsSimulationBuild), null);
                    if (this.fIsSimulationBuildBinaryCheck && !this.hiddenControls.contains(this.fSimulationBuildBinaryCheckboxComposite)) {
                        this.setBuildProperty(buildDefinition, "team.enterprise.build.ant.simulationModeBinaryCheck", Boolean.toString(this.fIsSimulationBuildBinaryCheck), null);
                    }
                }
                if ((this.fIsPreviewBuild || this.fIsSimulationBuild) && (buildLabelPrefix = buildDefinition.getProperty("buildLabelPrefix")) == null) {
                    String prefixLabel = this.fIsPreviewBuild ? com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_PREVIEW_BUILD_LABEL_PREFIX : com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_SIMULATION_BUILD_LABEL_PREFIX;
                    this.setBuildProperty(buildDefinition, "buildLabelPrefix", prefixLabel, null);
                }
                if (!this.hiddenControls.contains(this.fBuildChangesOnlyButton)) {
                    this.setBuildProperty(buildDefinition, "team.enterprise.build.ant.buildChangesOnly", Boolean.toString(this.fIsBuildChangedItems), this.isPersonalBuild);
                }
                String string = this.fIsBuildSubset ? (this.fSubsetResultLabel == null ? "" : this.fSubsetResultLabel) : (subsetLabel = "");
                String subsetSlug = this.fIsBuildSubset ? (this.fSubsetResultSlug == null ? "" : this.fSubsetResultSlug) : "";
                this.setBuildProperty(buildDefinition, "team.enterprise.build.ant.buildableSubset", subsetLabel, this.isPersonalBuild);
                this.setBuildProperty(buildDefinition, "team.enterprise.build.ant.buildableSubsetSlug", subsetSlug, this.isPersonalBuild);
                if (this.isPersonalBuild) {
                    this.storePersonalPropertyValue(PERSONAL_BUILD_SUBSET_LABEL_KEY, buildDefUUID, subsetLabel.isEmpty() ? " " : subsetLabel);
                    this.storePersonalPropertyValue(PERSONAL_BUILD_SUBSET_SLUG_KEY, buildDefUUID, subsetSlug.isEmpty() ? " " : subsetSlug);
                }
                if ((this.fIsBuildChangedItems || this.fIsBuildSubset) && !this.hiddenControls.contains(this.fMandatorySubsetComposite)) {
                    String mandatorySlug = this.fIsMandatorySubset ? (this.fMandatorySubsetResultSlug == null ? "" : this.fMandatorySubsetResultSlug) : "";
                    this.setBuildProperty(buildDefinition, "team.enterprise.build.ant.mandatorySubset", mandatorySlug, this.isPersonalBuild);
                    if (this.isPersonalBuild) {
                        this.storePersonalPropertyValue(PERSONAL_BUILD_MANDATORY_SUBSET_SLUG_KEY, buildDefUUID, mandatorySlug.isEmpty() ? " " : mandatorySlug);
                        this.setBuildProperty(buildDefinition, "team.enterprise.build.ant.mandatorySubset.useInPersonal", Boolean.toString(true), this.isPersonalBuild);
                    }
                }
                for (Map.Entry<Control, EnterpriseRequestDialogOption> entry : this.advancedPropertyControls.entrySet()) {
                    String value;
                    if (this.hiddenControls.contains(entry.getKey()) || (value = this.advancedPropertyValues.get(entry.getValue().getId())) == null) continue;
                    if (entry.getKey() == this.prebuildScriptButton || entry.getKey() == this.postbuildScriptButton) {
                        if (!Boolean.parseBoolean(value)) {
                            this.setBuildProperty(buildDefinition, entry.getValue().getBuildPropertyName(), "", this.isPersonalBuild);
                        }
                    } else {
                        this.setBuildProperty(buildDefinition, entry.getValue().getBuildPropertyName(), value, this.isPersonalBuild);
                    }
                    if (!this.isPersonalBuild) continue;
                    this.storePersonalPropertyValue(String.valueOf(entry.getValue().getId()) + "PersonalBuildMap", buildDefUUID, value);
                }
                if (this.isPersonalBuild) {
                    this.applyPersonalBuildProperties();
                }
            }
        }
    }

    protected void applyRebuildProperties() {
        this.getSite().getBuildDefinition().setProperty("team.enterprise.build.dependency.rebuild.resultUuid", this.getSite().getBuildResult().getItemId().getUuidValue());
        this.getSite().getBuildDefinition().setProperty("team.enterprise.build.dependency.rebuild.reuse", Boolean.toString(this.fSkipPreprocessing));
        this.getSite().getBuildDefinition().setProperty("team.enterprise.build.dependency.rebuild.reuse.fail", Boolean.toString(this.fFailIfNotSkip));
    }

    private void setBuildProperty(IBuildDefinition buildDefinition, String key, String value, Boolean newGenericEditSetting) {
        buildDefinition.setProperty(key, value);
        if (newGenericEditSetting != null) {
            buildDefinition.getProperty(key).setGenericEditAllowed(newGenericEditSetting.booleanValue());
        }
    }

    private void applyPersonalBuildProperties() {
        IBuildProperty originalResourcePrefix;
        String originalResourcePrefixValue;
        String workspaceUUID;
        IBuildDefinition buildDefinition = this.getSite().getBuildDefinition();
        String buildDefUUID = buildDefinition.getItemId().getUuidValue();
        boolean isIBMiBuild = IBuildUtility.isIBMiDependencyBuild((IBuildDefinition)buildDefinition);
        String string = workspaceUUID = this.fPersonalBuildWorkspace != null ? this.fPersonalBuildWorkspace.getItemId().getUuidValue() : null;
        if (workspaceUUID != null) {
            IBuildProperty prop = buildDefinition.getProperty("team.enterprise.scm.workspaceUUID");
            this.setBuildProperty(buildDefinition, "team.enterprise.scm.teamWorkspaceUUID", prop.getValue(), true);
            this.setBuildProperty(buildDefinition, "team.enterprise.scm.workspaceUUID", workspaceUUID, true);
        }
        if (!this.hiddenControls.contains(this.fFullMinimumLoadButton)) {
            this.setBuildProperty(buildDefinition, "team.enterprise.build.ant.fullMinimumLoad", Boolean.toString(this.fIsFullMinimumLoad), true);
            this.storePersonalPropertyValue(PERSONAL_BUILD_FULL_MINIMUM_LOAD_KEY, buildDefUUID, Boolean.toString(this.fIsFullMinimumLoad));
        }
        if (isIBMiBuild && !this.hiddenControls.contains(this.fAppendLoadObjLibs)) {
            this.setBuildProperty(buildDefinition, "com.ibm.team.enterprise.ibmi.build.AppendLoadObjLibraries", Boolean.toString(this.fShouldAppendLoadObjLibs), true);
            this.storePersonalPropertyValue(PERSONAL_BUILD_APPEND_OBJECTS_KEY, buildDefUUID, Boolean.toString(this.fShouldAppendLoadObjLibs));
        }
        if ((originalResourcePrefixValue = (originalResourcePrefix = buildDefinition.getProperty("team.enterprise.scm.resourcePrefix")).getValue()) != null && !originalResourcePrefixValue.isEmpty()) {
            this.setBuildProperty(buildDefinition, "team.enterprise.scm.resourceTeamPrefix", originalResourcePrefixValue, true);
        }
        if (this.fResourcePrefix != null && !this.fResourcePrefix.isEmpty()) {
            if (IBuildUtility.isIBMiDependencyBuild((IBuildDefinition)this.getSite().getBuildDefinition()) && this.fResourcePrefix.indexOf(34) < 0) {
                this.fResourcePrefix = this.fResourcePrefix.toUpperCase();
            }
            this.setBuildProperty(buildDefinition, "team.enterprise.scm.resourcePrefix", this.fResourcePrefix, true);
            this.storePersonalPropertyValue(PERSONAL_BUILD_RESOURCE_PREFIX_KEY, buildDefUUID, this.fResourcePrefix);
        }
        if (this.fLoadDirectory != null && !this.fLoadDirectory.isEmpty()) {
            this.setBuildProperty(buildDefinition, "team.enterprise.scm.fetchDestination", this.fLoadDirectory, true);
            this.storePersonalPropertyValue(PERSONAL_BUILD_LOAD_DIR_KEY, buildDefUUID, this.fLoadDirectory);
        }
        if (!isIBMiBuild) {
            if (this.fHFSDir == null) {
                this.fHFSDir = "";
            }
            this.setBuildProperty(buildDefinition, "team.enterprise.build.personal.hfs.outputdir", this.fHFSDir, true);
            this.storePersonalPropertyValue(PERSONAL_BUILD_HFS_DIR_KEY, buildDefUUID, this.fHFSDir);
        }
    }

    private void storePersonalPropertyValue(String propertyMapPreferenceKey, String buildDefUUID, String value) {
        if (value != null) {
            IPreferenceStore eeSectionStore = Activator.getDefault().getPreferenceStore();
            String finalValueString = new String();
            HashMap<String, String> valueMap = new HashMap<String, String>();
            if (eeSectionStore.contains(propertyMapPreferenceKey)) {
                String valueString = eeSectionStore.getString(propertyMapPreferenceKey);
                StringTokenizer mapTokenizer = new StringTokenizer(valueString, " ", false);
                while (mapTokenizer.hasMoreElements()) {
                    String buildDefToken = mapTokenizer.nextToken();
                    if (!mapTokenizer.hasMoreElements()) continue;
                    String valueToken = mapTokenizer.nextToken();
                    valueMap.put(buildDefToken, valueToken);
                }
            }
            value = value.replace("%", "%25").replace(" ", "%20");
            valueMap.put(buildDefUUID, value);
            for (String mapkey : valueMap.keySet()) {
                finalValueString = finalValueString.concat(String.valueOf(mapkey) + " " + (String)valueMap.get(mapkey) + " ");
            }
            if (eeSectionStore.contains(propertyMapPreferenceKey)) {
                eeSectionStore.setValue(propertyMapPreferenceKey, finalValueString);
            } else {
                eeSectionStore.putValue(propertyMapPreferenceKey, finalValueString);
            }
        }
    }

    public void handlePropertyChanged(String propertyName) {
        if ("buildDefinition".equals(propertyName)) {
            this.getSite().setProperty("personalBuild", (Object)false);
            this.fPersonalBuildWorkspace = null;
            this.fHFSRequired = Boolean.parseBoolean(this.getSite().getBuildDefinition().getPropertyValue("team.enterprise.build.hfsEnabled", null));
        }
    }

    protected boolean grabVertical() {
        return true;
    }

    private boolean hasPermission2RequestFullBuild() {
        try {
            ITeamRepository repository = (ITeamRepository)this.getSite().getBuildDefinition().getOrigin();
            IProcessAreaHandle processAreaHandle = this.getSite().getBuildDefinition().getProcessArea();
            IProcessArea processArea = (IProcessArea)repository.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, null);
            IProcessClientService processService = (IProcessClientService)repository.getClientLibrary(IProcessClientService.class);
            IClientProcess clientProcess = processService.getClientProcess(processArea, null);
            boolean[] permitted = clientProcess.getPermittedActions(processArea, "com.ibm.team.enterprise.build.ui.requestFullBuildOperation", new String[]{"requestFullBuildAction"}, null);
            return permitted[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean hasPermission2RequestSimulationBuild() {
        try {
            ITeamRepository repository = (ITeamRepository)this.getSite().getBuildDefinition().getOrigin();
            IProcessAreaHandle processAreaHandle = this.getSite().getBuildDefinition().getProcessArea();
            IProcessArea processArea = (IProcessArea)repository.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, null);
            IProcessClientService processService = (IProcessClientService)repository.getClientLibrary(IProcessClientService.class);
            IClientProcess clientProcess = processService.getClientProcess(processArea, null);
            boolean[] permitted = clientProcess.getPermittedActions(processArea, "com.ibm.team.enterprise.build.ui.requestSimulationBuildOperation", new String[]{"requestSimulationBuildAction"}, null);
            return permitted[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean hasPermission2UseAdvancedPropertiesInTeamBuild() {
        try {
            ITeamRepository repository = (ITeamRepository)this.getSite().getBuildDefinition().getOrigin();
            IProcessAreaHandle processAreaHandle = this.getSite().getBuildDefinition().getProcessArea();
            IProcessArea processArea = (IProcessArea)repository.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, null);
            IProcessClientService processService = (IProcessClientService)repository.getClientLibrary(IProcessClientService.class);
            IClientProcess clientProcess = processService.getClientProcess(processArea, null);
            boolean[] permitted = clientProcess.getPermittedActions(processArea, "com.ibm.team.enterprise.build.ui.overrideAdvancedPropertiesOperation", new String[]{"overrideAdvancedPropertiesTeamAction"}, null);
            return permitted[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean hasPermission2UseAdvancedPropertiesInPersonalBuild() {
        try {
            ITeamRepository repository = (ITeamRepository)this.getSite().getBuildDefinition().getOrigin();
            IProcessAreaHandle processAreaHandle = this.getSite().getBuildDefinition().getProcessArea();
            IProcessArea processArea = (IProcessArea)repository.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, null);
            IProcessClientService processService = (IProcessClientService)repository.getClientLibrary(IProcessClientService.class);
            IClientProcess clientProcess = processService.getClientProcess(processArea, null);
            boolean[] permitted = clientProcess.getPermittedActions(processArea, "com.ibm.team.enterprise.build.ui.overrideAdvancedPropertiesOperation", new String[]{"overrideAdvancedPropertiesPersonalAction"}, null);
            return permitted[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isUserJazzAdmin(IProgressMonitor monitor) {
        boolean result = false;
        try {
            ITeamRepository repository = (ITeamRepository)this.getSite().getBuildDefinition().getOrigin();
            ProcessClientService processClient = (ProcessClientService)repository.getClientLibrary(IProcessItemService.class);
            result = processClient.assertPermission("JazzAdmins", monitor);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public static class Factory
    implements IRequestBuildSectionFactory {
        public RequestBuildSection createRequestBuildSection(RequestBuildSectionSite site) {
            return new EnterpriseRequestBuildSection(site);
        }
    }
}

