/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.ui.dialogs;

import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildableFilesNode;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class BuildableSubsetContentProvider
implements ITreeContentProvider,
IDeferredWorkbenchAdapter {
    private boolean fFetchInProgress;
    private AbstractTreeViewer fViewer;
    private ITeamRepository fRepo;
    private DeferredTreeContentManager fDeferredTreeManager;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final TreePath[] EMPTY_TREEPATH_ARRAY = new TreePath[0];

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TreePath) {
            return this.getChildren((TreePath)parentElement);
        }
        if (parentElement instanceof BuildableFilesNode) {
            ArrayList<BuildableFilesNode> childrenList = ((BuildableFilesNode)parentElement).getChildren();
            this.pruneEmptyTreeNodes(childrenList);
            return childrenList != null ? childrenList.toArray() : null;
        }
        return new String[]{Messages.BuildableSubsetSelectionDialog_PENDING};
    }

    public Object[] getChildren(TreePath parentPath) {
        Object parentElement = parentPath.getLastSegment();
        if (parentElement instanceof BuildableFilesNode) {
            return this.fDeferredTreeManager.getChildren((Object)parentPath);
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof BuildableFilesNode) {
            return ((BuildableFilesNode)element).getNodeType() != 1;
        }
        return false;
    }

    public boolean hasChildren(TreePath path) {
        Object object = path.getLastSegment();
        if (object instanceof BuildableFilesNode) {
            return this.hasChildren((BuildableFilesNode)object);
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.fDeferredTreeManager = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (AbstractTreeViewer)viewer;
        if (this.fDeferredTreeManager == null) {
            this.fDeferredTreeManager = new DeferredTreeContentManager((AbstractTreeViewer)viewer){

                protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                    if (BuildableSubsetContentProvider.this.hasChildren(element)) {
                        return BuildableSubsetContentProvider.this;
                    }
                    return super.getAdapter(element);
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        TreePath parentPath = (TreePath)object;
        Object parent = parentPath.getLastSegment();
        BuildableSubsetContentProvider buildableSubsetContentProvider = this;
        synchronized (buildableSubsetContentProvider) {
            if (this.fFetchInProgress) {
                return;
            }
            this.fFetchInProgress = true;
        }
        try {
            monitor.beginTask("", -1);
            if (parent instanceof BuildableFilesNode) {
                this.getChildrenOfBuildableFilesNode((BuildableFilesNode)parent, collector, monitor);
            }
        }
        finally {
            this.fFetchInProgress = false;
            collector.done();
            monitor.done();
        }
    }

    private void getChildrenOfBuildableFilesNode(BuildableFilesNode parent, IElementCollector collector, IProgressMonitor monitor) {
        ArrayList<BuildableFilesNode> childList = parent.getChildren();
        this.pruneEmptyTreeNodes(childList);
        collector.add(childList.toArray(), monitor);
    }

    private void pruneEmptyTreeNodes(List<BuildableFilesNode> parentList) {
        if (parentList != null) {
            int childIndex = parentList.size() - 1;
            while (childIndex >= 0) {
                BuildableFilesNode currNode = parentList.get(childIndex);
                if (currNode.getNodeType() == 0 && this.getChildren(currNode).length == 0) {
                    parentList.remove(currNode);
                }
                --childIndex;
            }
        }
    }

    public ISchedulingRule getRule(Object arg0) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public ImageDescriptor getImageDescriptor(Object arg0) {
        return null;
    }

    public String getLabel(Object object) {
        if (object instanceof TreePath) {
            TreePath path = (TreePath)object;
            Object lastSegement = path.getLastSegment();
            return object.toString();
        }
        if (object instanceof BuildableFilesNode) {
            return ((BuildableFilesNode)object).getLabel();
        }
        return object.toString();
    }
}

