/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.ui.browser;

import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.editors.EnterpriseBrowserEditorInput;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapEditorInput;
import com.ibm.team.enterprise.internal.build.ui.browser.IOpenLocalFileInBrowserHandler;
import com.ibm.team.enterprise.internal.build.ui.browser.OpenLocalFileInBrowserHandlerFactory;
import com.ibm.team.foundation.client.internal.util.ClientURIUtils;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.internal.browser.WebBrowserPreference;

public class OpenHtmlLinkHandler
extends HyperlinkHandler {
    private static final String BUILD_REPORT = "buildReport";
    private boolean isInternalBrowser = false;

    public boolean handles(URI uri) {
        if (uri != null) {
            if (uri.toString().contains(BUILD_REPORT) || this.isBuildMapSlug(uri.toString())) {
                return true;
            }
            return this.getSupportHandler(uri) != null && this.isInternalBrowser();
        }
        return false;
    }

    private boolean isInternalBrowser() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                OpenHtmlLinkHandler.this.isInternalBrowser = WebBrowserPreference.getBrowserChoice() == 0;
            }
        });
        return this.isInternalBrowser;
    }

    public IStatus open2(URI uri, ContextProvider context, IProgressMonitor monitor) {
        IOpenLocalFileInBrowserHandler handler = this.getSupportHandler(uri);
        if (handler != null) {
            try {
                final ITeamRepository repository = this.getTeamRepository(uri);
                if (uri.toString().contains(BUILD_REPORT)) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                IWorkbenchPage wbPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                FormEditor editor = (FormEditor)wbPage.getActiveEditor();
                                IFormPage page = editor.setActivePage("com.ibm.team.enterprise.build.ui.editors.result.BuildReportPage");
                                page.setActive(true);
                            }
                            catch (Exception e) {
                                Activator.getDefault().logError(e);
                            }
                        }
                    });
                } else if (this.isBuildMapSlug(uri.toString())) {
                    final BuildMapEditorInput editorInput = new BuildMapEditorInput(uri, null, null, null, null, repository);
                    UIUpdaterJob job = new UIUpdaterJob(""){

                        public IStatus runInUI(IProgressMonitor monitor) {
                            try {
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, "com.ibm.team.enterprise.build.ui.editors.buildMapEditor");
                            }
                            catch (PartInitException ex) {
                                Activator.getDefault().logError(ex);
                            }
                            return super.runInUI(monitor);
                        }
                    };
                    job.schedule();
                } else {
                    final File file = handler.getLocalFile(uri);
                    if (file != null) {
                        if (handler.alwaysOverwrite() || !file.exists()) {
                            handler.generateLocalContent(uri, file, repository);
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    IWorkbenchPage wbPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                    EnterpriseBrowserEditorInput input = new EnterpriseBrowserEditorInput(file.toURI(), repository);
                                    wbPage.openEditor((IEditorInput)input, "com.ibm.team.enterprise.build.ui.editors.EnterpriseBrowserEditor");
                                }
                                catch (Exception e) {
                                    Activator.getDefault().logError(e);
                                }
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                return new Status(4, "com.ibm.team.enterprise.build.ui", e.getMessage(), (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    private IOpenLocalFileInBrowserHandler getSupportHandler(URI uri) {
        for (IOpenLocalFileInBrowserHandler handler : OpenLocalFileInBrowserHandlerFactory.getInstance().getAllHandlers()) {
            if (!handler.canOpen(uri)) continue;
            return handler;
        }
        return null;
    }

    private ITeamRepository getTeamRepository(URI uri) {
        return ClientURIUtils.guessTeamRepository((URI)uri);
    }

    private boolean isBuildMapSlug(String string) {
        if (string.contains("enterprise_buildmap") || string.contains("teamz_buildmap")) {
            return true;
        }
        if (string.contains("itemOid")) {
            String t = string.substring(string.indexOf("itemOid"));
            try {
                Location l = Location.location((URI)new URI(t));
                if (l.isItem() && l.getItemType().equals(IBuildMap.ITEM_TYPE)) {
                    return true;
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return false;
    }
}

