/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.ui.browser;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.internal.build.ui.browser.AbstractOpenLocalFileInBrowserFromBuildResultHandler;
import com.ibm.team.enterprise.internal.build.ui.browser.IOpenLocalFileInBrowserHandler;
import com.ibm.team.enterprise.internal.buildmap.common.util.BuildReportCssNlsHelper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;

public class OpenBuildReportInBrowserHandler
extends AbstractOpenLocalFileInBrowserFromBuildResultHandler
implements IOpenLocalFileInBrowserHandler {
    private static final String ENTERPRISE_RESOURCES_BUILD_COMPONENT = "buildComponent";
    private static final String ENTERPRISE_RESOURCES_BUILD_REPORT = "buildReport";
    private static final String FILE_EXTENSION_HTM = ".htm";
    private static final String DEFAULT_TEMP_FOLDER = "java.io.tmpdir";
    private static final String IMAGE_NAME_EXTERNAL_LINK = "externalLink.gif";
    private static final String IMAGE_PATH_EXTERNAL_LINK = "/icons/misc/externalLink.gif";

    @Override
    public boolean canOpen(URI uri) {
        return uri != null && this.isEnterpriseResource(uri.toString());
    }

    @Override
    public File getLocalFile(URI uri) {
        String fileName = null;
        IBuildResultHandle buildResultHandle = this.getBuildResultHandle(uri);
        if (buildResultHandle != null) {
            if (uri.toString().contains(ENTERPRISE_RESOURCES_BUILD_COMPONENT)) {
                fileName = ENTERPRISE_RESOURCES_BUILD_COMPONENT + buildResultHandle.getItemId().getUuidValue() + FILE_EXTENSION_HTM;
            } else if (uri.toString().contains(ENTERPRISE_RESOURCES_BUILD_REPORT)) {
                fileName = ENTERPRISE_RESOURCES_BUILD_REPORT + buildResultHandle.getItemId().getUuidValue() + FILE_EXTENSION_HTM;
            }
        }
        File file = new File(System.getProperty(DEFAULT_TEMP_FOLDER), fileName);
        file.deleteOnExit();
        return file;
    }

    @Override
    public final boolean alwaysOverwrite() {
        return true;
    }

    private boolean isCurrentClicked(String clickedUri, String fileNameExtension) {
        if (clickedUri.contains(ENTERPRISE_RESOURCES_BUILD_REPORT) && fileNameExtension.contains(ENTERPRISE_RESOURCES_BUILD_REPORT)) {
            return true;
        }
        return clickedUri.contains(ENTERPRISE_RESOURCES_BUILD_COMPONENT) && fileNameExtension.contains(ENTERPRISE_RESOURCES_BUILD_COMPONENT);
    }

    @Override
    public void generateLocalContent(URI uri, File file, ITeamRepository repository) throws Exception {
        IBuildResultHandle buildResultHandle = this.getBuildResultHandle(uri);
        IBuildResult buildResult = (IBuildResult)repository.itemManager().fetchCompleteItem((IItemHandle)buildResultHandle, 0, null);
        ITeamBuildClient buildClient = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        IBuildResultContribution[] contributions = buildClient.getBuildResultContributions((IBuildResultHandle)buildResult, IBuildResultContribution.ARTIFACT_EXTENDED_CONTRIBUTION_ID, null);
        if (contributions.length > 0) {
            IBuildResultContribution[] iBuildResultContributionArray = contributions;
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildResultContribution contribution = iBuildResultContributionArray[n2];
                String fileName = contribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_NAME);
                if (this.isCurrentClicked(uri.toString(), fileName)) {
                    try (ByteArrayOutputStream baos = null;){
                        IContent content = contribution.getExtendedContributionData();
                        int BUFFER_SIZE = 8192;
                        baos = new ByteArrayOutputStream(8192);
                        repository.contentManager().retrieveContent(content, (OutputStream)baos, null);
                        String encoding = content.getCharacterEncoding();
                        if (encoding == null) {
                            encoding = "UTF-8";
                        }
                        this.transformXml2Html(new ByteArrayInputStream(baos.toByteArray()), new BuildReportCssNlsHelper().getTranslatedContent(fileName), file);
                        Map<File, ImageDescriptor> imageMap = this.getImages();
                        for (File imageFile : imageMap.keySet()) {
                            this.writeImageDataToFile(imageMap.get(imageFile), imageFile);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private Map<File, ImageDescriptor> getImages() {
        HashMap<File, ImageDescriptor> imageMap = new HashMap<File, ImageDescriptor>();
        imageMap.put(new File(this.getTempDirPath(), IMAGE_NAME_EXTERNAL_LINK), Activator.getImageDescriptor(IMAGE_PATH_EXTERNAL_LINK));
        imageMap.put(new File(this.getTempDirPath(), "chevron_dn.gif"), Activator.getImageDescriptor("/icons/misc/chevron_dn.gif"));
        imageMap.put(new File(this.getTempDirPath(), "chevron_up.gif"), Activator.getImageDescriptor("/icons/misc/chevron_up.gif"));
        return imageMap;
    }

    private boolean isEnterpriseResource(String uri) {
        return uri.contains(ENTERPRISE_RESOURCES_BUILD_COMPONENT) || uri.contains(ENTERPRISE_RESOURCES_BUILD_REPORT);
    }
}

