/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.ui.browser;

import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.build.client.buildmap.IBuildMapClient;
import com.ibm.team.enterprise.internal.build.ui.browser.AbstractOpenLocalFileInBrowserFromBuildResultHandler;
import com.ibm.team.enterprise.internal.build.ui.browser.IOpenLocalFileInBrowserHandler;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.buildmap.common.util.BuildMapCssNlsHelper;
import com.ibm.team.enterprise.internal.buildmap.common.util.BuildMapUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.util.NLS;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URI;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class OpenBuildMapInBrowserHandler
extends AbstractOpenLocalFileInBrowserFromBuildResultHandler
implements IOpenLocalFileInBrowserHandler {
    private static final String ENTERPRISE_RESOURCES_ENTERPRISE_BUILDMAP = "enterprise_buildmap";
    private static final String FILE_EXTENSION_HTM = ".htm";

    @Override
    public boolean canOpen(URI uri) {
        return uri != null && this.isEnterpriseResource(uri.toString());
    }

    @Override
    public File getLocalFile(URI uri) {
        String slug = this.getBuildMapSlug(uri);
        File file = new File(this.getTempDirPath(), "buildMap_" + this.generateUniqueName(slug) + FILE_EXTENSION_HTM);
        file.deleteOnExit();
        return file;
    }

    @Override
    public boolean alwaysOverwrite() {
        return true;
    }

    @Override
    public void generateLocalContent(URI uri, File file, ITeamRepository repository) throws Exception {
        IBuildMapClient buildMapClient = (IBuildMapClient)repository.getClientLibrary(IBuildMapClient.class);
        if (uri == null) {
            throw new NullPointerException(NLS.bind((String)Messages.OpenBuildMapInBrowserHandler_NO_BUILD_MAP, (Object)uri, (Object[])new Object[0]));
        }
        IBuildMap buildMap = buildMapClient.getBuildMap(uri, null);
        if (buildMap == null) {
            throw new NullPointerException(NLS.bind((String)Messages.OpenBuildMapInBrowserHandler_NO_BUILD_MAP, (Object)uri, (Object[])new Object[0]));
        }
        String content = BuildMapUtil.getBuildXmlString((IBuildMap)buildMap);
        StreamSource xmlSource = new StreamSource(new ByteArrayInputStream(content.getBytes("UTF-8")));
        StreamSource xslSource = new StreamSource(new BuildMapCssNlsHelper().getTranslatedContent());
        Transformer transformer = TransformerFactory.newInstance().newTransformer(xslSource);
        transformer.transform(xmlSource, new StreamResult(file));
    }

    private boolean isEnterpriseResource(String uri) {
        return uri.contains(ENTERPRISE_RESOURCES_ENTERPRISE_BUILDMAP);
    }

    protected String getBuildMapSlug(URI uri) {
        String uriValue = uri.toString();
        int slugIndex = uri.toString().indexOf(ENTERPRISE_RESOURCES_ENTERPRISE_BUILDMAP);
        if (slugIndex == -1) {
            return null;
        }
        return uriValue.substring(slugIndex + ENTERPRISE_RESOURCES_ENTERPRISE_BUILDMAP.length() + 1);
    }

    public String generateUniqueName(String buildMapSlug) {
        String name = buildMapSlug.replace("_buildableFileUUID=", "");
        name = name.replace("_buildDefinitionUUID=_", "");
        name = name.replace("?revision=", "");
        name = name.replace("&revision_inputs=", "");
        name = name.replace("&revision_outputs=", "");
        name = name.replace("&revision_parserOutputs=", "");
        return name;
    }
}

