/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.ui.browser;

import com.ibm.team.enterprise.internal.build.ui.browser.IBrowserAction;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class BrowserActionFactory {
    public static BrowserActionFactory _instance;
    private List<IBrowserAction> actions;

    private BrowserActionFactory() {
        this.initActions();
    }

    public static BrowserActionFactory getInstance() {
        if (_instance == null) {
            _instance = new BrowserActionFactory();
        }
        return _instance;
    }

    public List<IBrowserAction> getActions() {
        return this.actions;
    }

    private void initActions() {
        this.actions = new ArrayList<IBrowserAction>(5);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.ibm.team.enterprise.build.ui.browserAction");
        if (extensionPoint != null) {
            IConfigurationElement[] members;
            IConfigurationElement[] iConfigurationElementArray = members = extensionPoint.getConfigurationElements();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement member = iConfigurationElementArray[n2];
                IBrowserAction action = this.createAction(member);
                if (action != null) {
                    this.actions.add(action);
                }
                ++n2;
            }
        }
    }

    private IBrowserAction createAction(IConfigurationElement element) {
        try {
            Object obj = element.createExecutableExtension("class");
            if (obj instanceof IBrowserAction) {
                IBrowserAction action = (IBrowserAction)obj;
                String id = element.getAttribute("id");
                action.setId(id);
                return action;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

