/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.ui.browser;

import com.ibm.team.enterprise.internal.build.ui.browser.AbstractOpenLocalFileInBrowserHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public abstract class AbstractOpenLocalXmlFileInBrowserHandler
extends AbstractOpenLocalFileInBrowserHandler {
    protected void transformXml2Html(InputStream xmlStreamContent, InputStream xslStreamContent, File file) throws TransformerFactoryConfigurationError, TransformerException {
        StreamSource xmlSource = new StreamSource(xmlStreamContent);
        StreamSource xslSource = new StreamSource(xslStreamContent);
        Transformer transformer = TransformerFactory.newInstance().newTransformer(xslSource);
        transformer.transform(xmlSource, new StreamResult(file));
    }

    protected void writeImageDataToFile(ImageDescriptor imageDesc, File file) throws IOException {
        this.writeImageDataToFile(imageDesc, file, false);
    }

    protected void writeImageDataToFile(ImageDescriptor imageDesc, File file, boolean overwrite) throws IOException {
        if (file.exists() && !overwrite) {
            return;
        }
        try (FileOutputStream fos = null;){
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{imageDesc.getImageData()};
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            imageLoader.save((OutputStream)baos, 2);
            fos = new FileOutputStream(file);
            fos.write(baos.toByteArray());
            fos.flush();
        }
    }
}

