/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.ui.browser;

import com.ibm.team.enterprise.build.ui.editors.EnterpriseBrowserEditor;
import com.ibm.team.enterprise.internal.build.ui.browser.AbstractBrowserAction;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public abstract class AbstractOpenEditorAction
extends AbstractBrowserAction {
    private static final String[] SCHEMA_NAMES = new String[]{"open", "file"};
    private static final String EDITOR_ID = "com.ibm.team.enterprise.build.ui.editors.EnterpriseBrowserEditor";

    protected abstract IEditorInput getEditorInput(String var1, String var2, ITeamRepository var3) throws Exception;

    protected abstract boolean canSupportFile(String var1);

    @Override
    public final String[] getSchema() {
        return SCHEMA_NAMES;
    }

    @Override
    public final boolean canSupport(URI uri) {
        if (!super.canSupport(uri)) {
            return false;
        }
        String[] temp = this.parseURI(uri);
        String filePath = temp[1];
        return this.canSupportFile(filePath);
    }

    @Override
    public void run(URI uri, EnterpriseBrowserEditor browser, IProgressMonitor monitor, final ITeamRepository repository) {
        ExecutorService executor = null;
        try {
            String anEditorId;
            String[] temp = this.parseURI(uri);
            final String editorId = anEditorId = EDITOR_ID;
            final String filePath = temp[1];
            executor = Executors.newSingleThreadExecutor();
            Future<IEditorInput> future = executor.submit(new Callable<IEditorInput>(){

                @Override
                public IEditorInput call() throws Exception {
                    return AbstractOpenEditorAction.this.getEditorInput(editorId, filePath, repository);
                }
            });
            IEditorInput editorInput = future.get();
            this.openEditor(editorInput, editorId, browser, monitor);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)browser.getSite().getShell(), (String)Messages.DIALOG_TITLE_ERROR, (String)(String.valueOf(Messages.DIALOG_MSG_ERROR_PREFIX) + e.getLocalizedMessage()));
            e.printStackTrace();
        }
    }

    protected void openEditor(IEditorInput editorInput, String editorId, EnterpriseBrowserEditor browser, IProgressMonitor monitor) throws PartInitException {
        try {
            IDE.openEditor((IWorkbenchPage)browser.getEditorSite().getWorkbenchWindow().getActivePage(), (IEditorInput)editorInput, (String)editorId);
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)browser.getSite().getShell(), (String)Messages.DIALOG_TITLE_ERROR, (String)(String.valueOf(Messages.DIALOG_MSG_ERROR_PREFIX) + e.getLocalizedMessage()));
            e.printStackTrace();
        }
    }

    protected String[] parseURI(URI uri) {
        String editorId = null;
        String uriValue = uri.toString();
        int index = uriValue.indexOf("://");
        if (index > -1 && index + 3 < uriValue.length()) {
            String[] segments = uriValue.substring(index + 3).split(":");
            if (segments.length > 1) {
                editorId = segments[0];
                uriValue = segments[1];
            } else if (segments.length > 0) {
                uriValue = segments[0];
            }
        }
        return new String[]{editorId, uriValue};
    }

    protected String getTempDirPath() {
        return System.getProperty("java.io.tmpdir");
    }
}

