/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.ui.actions;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapEditorInput;
import com.ibm.team.enterprise.build.ui.query.IBuildMapQueryItem;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildMap;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.SAXException;

public class ViewBuildMapFromQueryResultAction
extends Action
implements IObjectActionDelegate {
    private IStructuredSelection selection;
    private UIUpdaterJob fOpenEditorJob;

    public ViewBuildMapFromQueryResultAction() {
        super(Messages.ViewBuildMapFromQueryResultAction_OPENBUILDMAP);
    }

    public void run() {
        Object obj = this.selection.getFirstElement();
        if (obj instanceof IBuildMapQueryItem) {
            IBuildMapQueryItem item = (IBuildMapQueryItem)obj;
            IBuildDefinition buildDef = (IBuildDefinition)item.getOwningResult().getQuery().getQueryParameters().get("build.def");
            ITeamRepository repo = (ITeamRepository)buildDef.getOrigin();
            final BuildMapEditorInput editorInput = new BuildMapEditorInput(UUID.valueOf((String)item.getBuildableFileUuidValue()), UUID.valueOf((String)item.getBuildDefinitionUuidValue()), repo);
            if (this.fOpenEditorJob != null) {
                this.fOpenEditorJob.cancel();
            }
            this.fOpenEditorJob = new UIUpdaterJob(Messages.ViewBuildMapFromQueryResultAction_OPENBUILDMAPJOB){
                IBuildMap buildMap;
                {
                    super($anonymous0);
                    this.buildMap = null;
                }

                public IStatus runInBackground(IProgressMonitor monitor) {
                    this.buildMap = null;
                    try {
                        this.buildMap = editorInput.fetchBuildMap(null);
                    }
                    catch (TeamRepositoryException e) {
                        Activator.getDefault().logError(e);
                    }
                    catch (SAXException e) {
                        Activator.getDefault().logError(e);
                    }
                    catch (IOException e) {
                        Activator.getDefault().logError(e);
                    }
                    catch (ParserConfigurationException e) {
                        Activator.getDefault().logError(e);
                    }
                    return super.runInBackground(monitor);
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    if (this.buildMap != null) {
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, "com.ibm.team.enterprise.build.ui.editors.buildMapEditor");
                        }
                        catch (PartInitException ex) {
                            Activator.getDefault().logError(ex);
                        }
                    } else {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ViewBuildMapDialog_TITLE, (String)Messages.ViewBuildMapAction_ERROR_INVALID_SELECTION);
                    }
                    return super.runInUI(monitor);
                }
            };
            this.fOpenEditorJob.schedule();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = (IStructuredSelection)selection;
        this.setEnabled(this.selection != null && this.selection.size() == 1 && this.selection.getFirstElement() instanceof IBuildMapQueryItem);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        this.run();
    }
}

