/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.ui.actions;

import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.query.IBuildMapQueryItem;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.ui.changes.actions.OpenLocalFileAction;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class OpenLocalFileFromBuildMapQueryAction
extends Action
implements IObjectActionDelegate {
    private IWorkbenchPartSite fPartSite;
    private IStructuredSelection selection;
    private UIUpdaterJob fOpenEditorJob;
    private String fileUUID;

    public OpenLocalFileFromBuildMapQueryAction(IWorkbenchPartSite partSite) {
        super(Messages.OpenLocalFileFromBuildMapQueryAction_ACTIONTITLE);
        this.fPartSite = partSite;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        Object obj = this.selection.getFirstElement();
        if (obj instanceof IBuildMapQueryItem) {
            final IVersionableHandle vHandle = (IVersionableHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.fileUUID), null);
            if (this.fOpenEditorJob != null) {
                this.fOpenEditorJob.cancel();
            }
            this.fOpenEditorJob = new UIUpdaterJob(Messages.OpenLocalFileFromBuildMapQueryAction_JOBLABEL){
                IShareable shareable;
                {
                    super($anonymous0);
                    this.shareable = null;
                }

                public IStatus runInBackground(IProgressMonitor monitor) {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    subMonitor.beginTask(Messages.OpenLocalFileFromBuildMapQueryAction_JOBLABEL, 100);
                    try {
                        Collection shareables = SharingManager.getInstance().findShareables(vHandle, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 90));
                        if (!shareables.isEmpty()) {
                            this.shareable = (IShareable)shareables.iterator().next();
                        }
                    }
                    catch (FileSystemException e) {
                        Activator.getDefault().logError(e);
                    }
                    return super.runInBackground(monitor);
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    if (this.shareable != null) {
                        OpenLocalFileAction.openLocalFile((Shell)OpenLocalFileFromBuildMapQueryAction.this.fPartSite.getShell(), (IWorkbenchPage)OpenLocalFileFromBuildMapQueryAction.this.fPartSite.getPage(), (IShareable)this.shareable);
                    } else {
                        Activator.getDefault().logError(new TeamRepositoryException("Unexpected null shareable when trying to open local file"));
                    }
                    return super.runInUI(monitor);
                }
            };
            this.fOpenEditorJob.schedule();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = (IStructuredSelection)selection;
        if (this.selection != null && this.selection.size() == 1 && this.selection.getFirstElement() instanceof IBuildMapQueryItem) {
            IBuildMapQueryItem item = (IBuildMapQueryItem)this.selection.getFirstElement();
            this.fileUUID = (String)item.getItemData("FileUUID");
            if (this.fileUUID != null && !this.fileUUID.equals("")) {
                this.setEnabled(true);
                return;
            }
        }
        this.setEnabled(false);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

