/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.ibmi.build.ui.editors;

import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.enterprise.build.ui.editors.AbstractCompoundDependencyBuildConfigurationEditor;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.IPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.LanguageDefinitionSelectionDialog;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.SearchPathSelectionDialog;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class IBMiCompoundDependencyBuildConfigurationEditor
extends AbstractCompoundDependencyBuildConfigurationEditor
implements SelectionListener,
ModifyListener,
ISelectionChangedListener {
    private Button fFailOnErrorButton;
    private Button fFailOnErrorCommandButton;
    protected Combo fFailOnErrorCommandLevelCombo;
    protected Combo fFailOnErrorLevelCombo;
    private Text ibmiPreCommandText;
    private Text ibmiPostCommandText;
    private Button fSearchPathBrowseButton;
    private Button fSearchPathClearButton;
    private Text fSearchPathText;
    protected Text preBuildFileText;
    protected Text postBuildFileText;
    protected Button alwaysRunPostBuildButton;

    public IBMiCompoundDependencyBuildConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitionibmidependency";
    }

    @Override
    protected String getConfigurationId() {
        return "com.ibm.team.enterprise.ibmi.build.common.IIBMiDependencyBuildConfigurationElement";
    }

    @Override
    protected LanguageDefinitionSelectionDialog getLanguageDefintionSelectionDialog(Shell parentShell, ITeamRepository teamRepository, IProjectArea projectArea, ViewerFilter filter, boolean allowMultipleSelection) {
        return new LanguageDefinitionSelectionDialog(parentShell, teamRepository, projectArea, filter, allowMultipleSelection, IIBMiLanguageDefinition.ITEM_TYPE, true);
    }

    @Override
    protected void createAdvancedWidgets(Composite parent) {
        super.createAdvancedWidgets(parent);
        this.createUpdateFrequnceConfiguration(parent, 1);
        Composite composite = this.fToolkit.createComposite(parent);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.fToolkit.createLabel(composite, Messages.EnterpriseConfigurationEditor_LABEL_PRE_BUILD_FILE);
        String property = this.fBuildDefinitionWorkingCopy.getPropertyValue("team.enterprise.build.ant.preBuildFile", "");
        this.preBuildFileText = this.fToolkit.createText(composite, property, 0);
        TableWrapData layoutData = new TableWrapData(256, 32);
        this.preBuildFileText.setLayoutData((Object)layoutData);
        this.preBuildFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBMiCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.ant.preBuildFile", IBMiCompoundDependencyBuildConfigurationEditor.this.preBuildFileText.getText().trim());
                IBMiCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        this.fToolkit.createLabel(composite, Messages.EnterpriseConfigurationEditor_LABEL_POST_BUILD_FILE);
        property = this.fBuildDefinitionWorkingCopy.getPropertyValue("team.enterprise.build.ant.postBuildFile", "");
        this.postBuildFileText = this.fToolkit.createText(composite, property, 0);
        layoutData = new TableWrapData(256, 32);
        this.postBuildFileText.setLayoutData((Object)layoutData);
        this.postBuildFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBMiCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.ant.postBuildFile", IBMiCompoundDependencyBuildConfigurationEditor.this.postBuildFileText.getText().trim());
                IBMiCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
                if (IBMiCompoundDependencyBuildConfigurationEditor.this.alwaysRunPostBuildButton != null && !IBMiCompoundDependencyBuildConfigurationEditor.this.alwaysRunPostBuildButton.isDisposed()) {
                    boolean enableState = !IBMiCompoundDependencyBuildConfigurationEditor.this.postBuildFileText.getText().equalsIgnoreCase("");
                    IBMiCompoundDependencyBuildConfigurationEditor.this.alwaysRunPostBuildButton.setEnabled(enableState);
                    if (!enableState) {
                        IBMiCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.alwaysRunPostBuildFile").setValue(Boolean.toString(false));
                    } else if (enableState && IBMiCompoundDependencyBuildConfigurationEditor.this.alwaysRunPostBuildButton.getSelection()) {
                        IBMiCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.alwaysRunPostBuildFile").setValue(Boolean.toString(true));
                    }
                }
            }
        });
        property = this.fBuildDefinitionWorkingCopy.getPropertyValue("team.enterprise.build.ant.alwaysRunPostBuildFile", "");
        this.alwaysRunPostBuildButton = this.getToolkit().createButton(parent, Messages.EnterpriseConfigurationEditor_LABEL_ALWAYS_RUN_POST_BUILD_FILE, 32);
        this.alwaysRunPostBuildButton.setLayoutData((Object)new TableWrapData(128));
        this.alwaysRunPostBuildButton.setSelection(Boolean.parseBoolean(property));
        this.alwaysRunPostBuildButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IBMiCompoundDependencyBuildConfigurationEditor.this.validate();
                IBMiCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.ant.alwaysRunPostBuildFile", Boolean.toString(IBMiCompoundDependencyBuildConfigurationEditor.this.alwaysRunPostBuildButton.getSelection()));
                IBMiCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        if (this.postBuildFileText != null && !this.postBuildFileText.isDisposed()) {
            this.alwaysRunPostBuildButton.setEnabled(!this.postBuildFileText.getText().equalsIgnoreCase(""));
        }
    }

    @Override
    protected void createPlatformSpecificSections(Composite parent, FormToolkit toolkit) {
        this.createSearchPathSection(parent);
        this.createCommandSection(parent);
        this.createFailOnErrorSection(parent);
    }

    private void createFailOnErrorSection(Composite parent) {
        this.createSpacer(parent, 10, 1);
        Section fConfigurationSection = this.fToolkit.createSection(parent, 384);
        fConfigurationSection.setLayoutData((Object)new TableWrapData(256, 256));
        fConfigurationSection.setLayout((Layout)new TableWrapLayout());
        fConfigurationSection.setText(Messages.IBMiCompoundDependencyBuildConfigurationEditor_SECTION_TEXT_FAIL_ON_ERROR);
        fConfigurationSection.setDescription(Messages.IBMiCompoundDependencyBuildConfigurationEditor_SECTION_DESC_FAIL_ON_ERROR);
        Composite composite = this.fToolkit.createComposite((Composite)fConfigurationSection);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createFailOnErrorWidgets(composite);
        fConfigurationSection.setClient((Control)composite);
        this.initializeFailOnErrorWidgets();
        this.createSpacer(parent, 10, 1);
    }

    private void createFailOnErrorWidgets(Composite parent) {
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.team.enterprise.ibmi.build.ant.icmd.failOnError");
        boolean failOnErrorFromCommand = true;
        if (property != null) {
            failOnErrorFromCommand = Boolean.valueOf(property.getValue());
        }
        this.fFailOnErrorCommandButton = this.fToolkit.createButton(parent, Messages.IBMiCompoundDependencyBuildConfigurationEditor_ANT_PROPERTY_FAIL_ON_ERROR_COMMAND_LABEL, 32);
        TableWrapData layoutData = new TableWrapData();
        this.fFailOnErrorCommandButton.setLayoutData((Object)layoutData);
        this.fFailOnErrorCommandButton.addSelectionListener(this.getFailOnErrorCommandSelectionListener());
        this.fFailOnErrorCommandButton.setSelection(failOnErrorFromCommand);
        this.createSpacer(parent, 20, 1);
        property = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.team.enterprise.ibmi.build.ant.icmd.failOnError.level");
        int failOnErrorCommandLevel = 40;
        if (property != null) {
            failOnErrorCommandLevel = Integer.valueOf(property.getValue());
        }
        this.fFailOnErrorCommandLevelCombo = new Combo(parent, 8);
        this.fFailOnErrorCommandLevelCombo.setItems(new String[]{"00", "10", "20", "30", "40", "50"});
        this.fFailOnErrorCommandLevelCombo.select(failOnErrorCommandLevel / 10);
        layoutData = new TableWrapData(2, 32);
        this.fFailOnErrorCommandLevelCombo.setLayoutData((Object)layoutData);
        this.fFailOnErrorCommandLevelCombo.addSelectionListener(this.getFailOnErrorCommandLevelSelectionListener());
        property = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.team.enterprise.ibmi.build.ant.failOnError");
        this.fFailOnErrorButton = this.fToolkit.createButton(parent, Messages.IBMiCompoundDependencyBuildConfigurationEditor_ANT_PROPERTY_FAIL_ON_ERROR_LABEL, 32);
        layoutData = new TableWrapData();
        layoutData.colspan = 2;
        this.fFailOnErrorButton.setLayoutData((Object)layoutData);
        this.fFailOnErrorButton.addSelectionListener(this.getFailOnErrorSelectionListener());
        if (property != null) {
            this.fFailOnErrorButton.setSelection(Boolean.valueOf(property.getValue()).booleanValue());
        }
        property = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.team.enterprise.ibmi.build.ant.failOnError.level");
        this.fFailOnErrorLevelCombo = new Combo(parent, 8);
        this.fFailOnErrorLevelCombo.setItems(new String[]{"00", "10", "20", "30", "40", "50"});
        if (property != null) {
            this.fFailOnErrorLevelCombo.select(Integer.valueOf(property.getValue()) / 10);
        }
        layoutData = new TableWrapData(2, 32);
        this.fFailOnErrorLevelCombo.setLayoutData((Object)layoutData);
        this.fFailOnErrorLevelCombo.addSelectionListener(this.getFailOnErrorLevelSelectionListener());
    }

    private void initializeFailOnErrorWidgets() {
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.team.enterprise.ibmi.build.ant.failOnError.level");
        int level = 3;
        if (property != null && property.getValue() != null) {
            level = Integer.parseInt(property.getValue()) / 10;
        }
        this.fFailOnErrorLevelCombo.select(level);
        property = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.team.enterprise.ibmi.build.ant.failOnError");
        if (property != null && Boolean.valueOf(property.getValue()).booleanValue()) {
            this.fFailOnErrorLevelCombo.setEnabled(true);
        } else {
            this.fFailOnErrorLevelCombo.setEnabled(false);
        }
        property = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.team.enterprise.ibmi.build.ant.icmd.failOnError.level");
        level = 3;
        if (property != null && property.getValue() != null) {
            level = Integer.parseInt(property.getValue()) / 10;
        }
        this.fFailOnErrorCommandLevelCombo.select(level);
        property = this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.team.enterprise.ibmi.build.ant.icmd.failOnError");
        if (property != null && Boolean.valueOf(property.getValue()).booleanValue()) {
            this.fFailOnErrorCommandLevelCombo.setEnabled(true);
        } else {
            this.fFailOnErrorCommandLevelCombo.setEnabled(false);
        }
        this.fBuildDefinitionWorkingCopy.setConfigurationProperty(this.getConfigurationId(), "team.enterprise.build.buildmaps.needMigrateComponent", "false");
    }

    protected SelectionListener getFailOnErrorLevelSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiCompoundDependencyBuildConfigurationEditor.this.validate();
                IBuildProperty property = IBMiCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.team.enterprise.ibmi.build.ant.failOnError.level");
                property.setValue(IBMiCompoundDependencyBuildConfigurationEditor.this.fFailOnErrorLevelCombo.getItem(IBMiCompoundDependencyBuildConfigurationEditor.this.fFailOnErrorLevelCombo.getSelectionIndex()));
                IBMiCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getFailOnErrorCommandLevelSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiCompoundDependencyBuildConfigurationEditor.this.validate();
                IBMiCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("com.ibm.team.enterprise.ibmi.build.ant.icmd.failOnError.level", IBMiCompoundDependencyBuildConfigurationEditor.this.fFailOnErrorCommandLevelCombo.getItem(IBMiCompoundDependencyBuildConfigurationEditor.this.fFailOnErrorCommandLevelCombo.getSelectionIndex()));
                IBMiCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getFailOnErrorSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiCompoundDependencyBuildConfigurationEditor.this.validate();
                IBuildProperty property = IBMiCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("com.ibm.team.enterprise.ibmi.build.ant.failOnError");
                property.setValue(Boolean.toString(IBMiCompoundDependencyBuildConfigurationEditor.this.fFailOnErrorButton.getSelection()));
                if (IBMiCompoundDependencyBuildConfigurationEditor.this.fFailOnErrorButton.getSelection()) {
                    IBMiCompoundDependencyBuildConfigurationEditor.this.fFailOnErrorLevelCombo.setEnabled(true);
                } else {
                    IBMiCompoundDependencyBuildConfigurationEditor.this.fFailOnErrorLevelCombo.setEnabled(false);
                }
                IBMiCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getFailOnErrorCommandSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiCompoundDependencyBuildConfigurationEditor.this.validate();
                IBMiCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("com.ibm.team.enterprise.ibmi.build.ant.icmd.failOnError", Boolean.toString(IBMiCompoundDependencyBuildConfigurationEditor.this.fFailOnErrorCommandButton.getSelection()));
                if (IBMiCompoundDependencyBuildConfigurationEditor.this.fFailOnErrorCommandButton.getSelection()) {
                    IBMiCompoundDependencyBuildConfigurationEditor.this.fFailOnErrorCommandLevelCombo.setEnabled(true);
                } else {
                    IBMiCompoundDependencyBuildConfigurationEditor.this.fFailOnErrorCommandLevelCombo.setEnabled(false);
                }
                IBMiCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private void createCommandSection(Composite parent) {
        Section section = this.fToolkit.createSection(parent, 384);
        section.setLayoutData((Object)new TableWrapData(256, 256));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(Messages.IBMiCompoundDependencyBuildConfigurationEditor_COMMANDS_SECTION_TITLE);
        section.setDescription(Messages.IBMiCompoundDependencyBuildConfigurationEditor_SECTION_DESC_COMMAND);
        Composite composite = this.fToolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        this.createSpacer(composite, 5, 2);
        this.fToolkit.createLabel(composite, Messages.IBMiCompoundDependencyBuildConfigurationEditor_IBMI_PRE_COMMAND_LABEL);
        String property = this.fBuildDefinitionWorkingCopy.getPropertyValue("team.enterprise.build.ibmi.preCommand", "");
        this.ibmiPreCommandText = this.fToolkit.createText(composite, property, 0);
        TableWrapData layoutData = new TableWrapData(256, 32);
        this.ibmiPreCommandText.setLayoutData((Object)layoutData);
        this.ibmiPreCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBMiCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.ibmi.preCommand", IBMiCompoundDependencyBuildConfigurationEditor.this.ibmiPreCommandText.getText().trim());
                IBMiCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        this.createSpacer(composite, -1, 1);
        Label descriptionLabel = this.fToolkit.createLabel(composite, Messages.IBMiCompoundDependencyBuildConfigurationEditor_PRE_BUILD_COMMAND_DESC, 64);
        layoutData = new TableWrapData(256);
        layoutData.colspan = 1;
        descriptionLabel.setLayoutData((Object)layoutData);
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        this.createSpacer(composite, 5, 2);
        this.fToolkit.createLabel(composite, Messages.IBMiCompoundDependencyBuildConfigurationEditor_IBMI_POST_COMMAND_LABEL);
        property = this.fBuildDefinitionWorkingCopy.getPropertyValue("team.enterprise.build.ibmi.postCommand", "");
        this.ibmiPostCommandText = this.fToolkit.createText(composite, property, 0);
        layoutData = new TableWrapData(256, 32);
        this.ibmiPostCommandText.setLayoutData((Object)layoutData);
        this.ibmiPostCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBMiCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.ibmi.postCommand", IBMiCompoundDependencyBuildConfigurationEditor.this.ibmiPostCommandText.getText().trim());
                IBMiCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        this.createSpacer(composite, -1, 1);
        descriptionLabel = this.fToolkit.createLabel(composite, Messages.IBMiCompoundDependencyBuildConfigurationEditor_POST_BUILD_COMMAND_DESC, 64);
        layoutData = new TableWrapData(256);
        layoutData.colspan = 1;
        descriptionLabel.setLayoutData((Object)layoutData);
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        this.createSpacer(parent, 10, 1);
    }

    private void createSearchPathSection(Composite parent) {
        Section section = this.fToolkit.createSection(parent, 384);
        section.setLayoutData((Object)new TableWrapData(256, 256));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(Messages.IBMiCompoundDependencyBuildConfigurationEditor_SearchPathSectionTitle);
        section.setDescription(Messages.IBMiCompoundDependencyBuildConfigurationEditor_SearchPathSectionDescription);
        Composite composite = this.fToolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 5;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        this.fToolkit.createLabel(composite, Messages.IBMiCompoundDependencyBuildConfigurationEditor_SearchPathLabel);
        String searchPathProperty = this.fBuildDefinitionWorkingCopy.getPropertyValue("com.ibm.team.enterprise.ibmi.build.searchPath", "");
        String textContents = "";
        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.getTeamRepository());
        if (!searchPathProperty.isEmpty()) {
            try {
                ISearchPath searchPath = (ISearchPath)client.findSystemDefinition(searchPathProperty, null, ISearchPath.ITEM_TYPE, null);
                if (searchPath != null) {
                    textContents = searchPath.getName();
                    if (searchPath.isArchived()) {
                        textContents = String.valueOf(textContents) + Messages.SystemDefinition_ARCHIVED_SUFFIX;
                    }
                } else {
                    textContents = Messages.IBMiCompoundDependencyBuildConfigurationEditor_MissingSearchPath;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.fSearchPathText = this.fToolkit.createText(composite, textContents, 0);
        TableWrapData layoutData = new TableWrapData(256, 32);
        this.fSearchPathText.setLayoutData((Object)layoutData);
        this.fSearchPathText.setEditable(false);
        String searchPathHover = NLS.bind((String)Messages.FileAgentJazzScmConfigurationEditor_BUILD_PROPERTY_DESC, (Object)"com.ibm.team.enterprise.ibmi.build.searchPath");
        this.fSearchPathText.setToolTipText(searchPathHover);
        this.addControlDecorator((Control)this.fSearchPathText, searchPathHover, 131072);
        this.fSearchPathBrowseButton = this.fToolkit.createButton(composite, Messages.EnterpriseBuildUI_BUTTON_BROWSE, 8);
        this.fSearchPathBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    SearchPathSelectionDialog dialog = new SearchPathSelectionDialog(IBMiCompoundDependencyBuildConfigurationEditor.this.getSite().getShell(), IBMiCompoundDependencyBuildConfigurationEditor.this.getTeamRepository(), null);
                    if (dialog.open() == 0) {
                        ISystemDefinition searchPath = dialog.getSelectedSystemDefinition();
                        String searchPathName = searchPath.getName();
                        IBMiCompoundDependencyBuildConfigurationEditor.this.fSearchPathText.setText(searchPathName);
                        IBMiCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("com.ibm.team.enterprise.ibmi.build.searchPath", searchPath.getItemId().getUuidValue());
                        IBMiCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
                    }
                    IBMiCompoundDependencyBuildConfigurationEditor.this.updateSearchPathButtonEnablement();
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
            }
        });
        this.fSearchPathClearButton = this.fToolkit.createButton(composite, Messages.BUILD_CLEAR_BUTTON_LABEL, 8);
        this.fSearchPathClearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IBMiCompoundDependencyBuildConfigurationEditor.this.fSearchPathText.setText("");
                IBMiCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("com.ibm.team.enterprise.ibmi.build.searchPath", "");
                IBMiCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
                IBMiCompoundDependencyBuildConfigurationEditor.this.updateSearchPathButtonEnablement();
            }
        });
        this.updateSearchPathButtonEnablement();
    }

    private void updateSearchPathButtonEnablement() {
        this.fSearchPathClearButton.setEnabled(!this.fSearchPathText.getText().isEmpty());
    }

    @Override
    protected Section createPersonalBuildDefaultsSection(Composite parent, FormToolkit toolkit) {
        Section section = super.createPersonalBuildDefaultsSection(parent, toolkit);
        final Button appendLibraries = this.fToolkit.createButton((Composite)section.getClient(), com.ibm.team.enterprise.build.common.Messages.EnterpriseRequestDialogOption_APPEND_LOAD_OBJECT_LIBRARIES, 32);
        appendLibraries.setLayoutData((Object)new TableWrapData());
        appendLibraries.setSelection(Boolean.parseBoolean(this.fBuildDefinitionWorkingCopy.getPropertyValue("com.ibm.team.enterprise.ibmi.build.AppendLoadObjLibraries", Boolean.TRUE.toString())));
        appendLibraries.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBMiCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("com.ibm.team.enterprise.ibmi.build.AppendLoadObjLibraries", Boolean.toString(appendLibraries.getSelection()));
                IBMiCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        return section;
    }

    @Override
    protected Class<? extends IPlatformObject> getPlatform() {
        return IIBMiPlatformObject.class;
    }
}

