/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.views;

import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.build.client.buildmap.IBuildMapClient;
import com.ibm.team.enterprise.build.common.buildreport.IReportBuildFile;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.actions.OpenLocalFileInBuildAction;
import com.ibm.team.enterprise.build.ui.actions.OpenRemoteFileAction;
import com.ibm.team.enterprise.build.ui.views.ProjectAreaConnectionControl;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildMap;
import com.ibm.team.enterprise.internal.buildmap.common.IInput;
import com.ibm.team.enterprise.internal.buildmap.common.util.BuildMapConversionUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.common.IVersionableHandle;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class DependencySetView
extends ViewPart
implements IConnectedProjectAreaRegistryListener {
    public static final String VIEW_ID = "com.ibm.team.enterprise.build.ui.views.DependencySetView";
    private IBuildMap fBuildMap = null;
    private IReportBuildFile fReportBuildFile = null;
    private boolean fIsZos = true;
    private boolean fPersonal = false;
    private List<IBuildFile> fDependencyList = null;
    private TableViewer fTableViewer;
    private Map<URI, IBuildMap> fBuildmapMap = null;
    private Map<IBuildMap, List<IBuildFile>> fDependencySetMap = null;
    private Map<String, String> fUuidStateIDVersionIDMap = null;
    private Map<String, String> fComponentUUIDNameMap = null;
    private ITeamRepository fTeamRepository = null;
    protected Table fDependencyTable;
    private boolean fNeedInputs = false;
    private String fResourcePrefix = null;
    private final IWorkspaceManager fWorkspaceManager = null;
    protected Composite fParentComposite;
    protected Composite fContentComposite;
    protected Composite fGuideComposite;
    private List<IProjectAreaHandle> fConnectedProjectAreas = Collections.emptyList();
    protected ProjectAreaConnectionControl fProjectAreaConnectionControl;
    private boolean fNeedRemovePrefix = false;

    public void createPartControl(Composite parent) {
        this.fParentComposite = parent;
        this.initConnectedProjectAreas();
        this.setContentDescription(Messages.DependencyView_NO_CONTENT);
        ConnectedProjectAreaRegistry.getDefault().addListener((IConnectedProjectAreaRegistryListener)this);
        if (this.fConnectedProjectAreas.size() == 0) {
            this.showProjectAreaConnectionControl();
        } else if (this.fTeamRepository == null) {
            this.createGuidePage(parent);
        }
    }

    private void createGuidePage(Composite parent) {
        if (this.fProjectAreaConnectionControl != null) {
            this.fProjectAreaConnectionControl.dispose();
        }
        if (this.fContentComposite != null && !this.fContentComposite.isDisposed()) {
            this.fContentComposite.dispose();
        }
        this.fProjectAreaConnectionControl = null;
        this.fContentComposite = null;
        if (this.fGuideComposite != null) {
            return;
        }
        this.setContentDescription(Messages.DependencyView_NO_CONTENT);
        this.fGuideComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.fGuideComposite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fGuideComposite);
        this.fGuideComposite.setBackground(this.fGuideComposite.getDisplay().getSystemColor(25));
        Label label = new Label(this.fGuideComposite, 16576);
        label.setText(Messages.DependencyView_GUIDE);
        label.setBackground(this.fGuideComposite.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        this.fParentComposite.layout();
    }

    protected void showProjectAreaConnectionControl() {
        if (this.fContentComposite != null && !this.fContentComposite.isDisposed()) {
            this.fContentComposite.dispose();
        }
        if (this.fGuideComposite != null && !this.fGuideComposite.isDisposed()) {
            this.fGuideComposite.dispose();
        }
        this.fContentComposite = null;
        this.fGuideComposite = null;
        if (this.fProjectAreaConnectionControl != null) {
            return;
        }
        this.setContentDescription(Messages.DependencyView_NO_CONTENT);
        this.fProjectAreaConnectionControl = new ProjectAreaConnectionControl();
        this.fProjectAreaConnectionControl.create(this.fParentComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fProjectAreaConnectionControl.getContentContainer());
        this.fParentComposite.layout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnectedProjectAreas() {
        List projectAreas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(null);
        DependencySetView dependencySetView = this;
        synchronized (dependencySetView) {
            this.fConnectedProjectAreas = Collections.unmodifiableList(new ArrayList(projectAreas));
        }
    }

    public static void displayDependencySetView(IReportBuildFile reportBuildFile, Map<URI, IBuildMap> fBuildmapMap2, Map<String, String> fUuidStateIDVersionIDMap, Map<String, String> fComponentUUIDNameMap, ITeamRepository fTeamRepository, boolean fNeedInputs, String fResourcePrefix, boolean fIsZos, boolean fPersonal) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        DependencySetView view = (DependencySetView)activePage.findView(VIEW_ID);
        if (view == null) {
            try {
                view = (DependencySetView)activePage.showView(VIEW_ID);
                view.setInitiaData(reportBuildFile, fBuildmapMap2, fUuidStateIDVersionIDMap, fComponentUUIDNameMap, fTeamRepository, fNeedInputs, fResourcePrefix, fIsZos, fPersonal);
            }
            catch (PartInitException exception) {
                Activator.getDefault().logError(exception);
            }
        } else {
            activePage.bringToTop((IWorkbenchPart)view);
            view.setInitiaData(reportBuildFile, fBuildmapMap2, fUuidStateIDVersionIDMap, fComponentUUIDNameMap, fTeamRepository, fNeedInputs, fResourcePrefix, fIsZos, fPersonal);
        }
    }

    private void createDependencyTableViewer(Composite parent) {
        if (this.fProjectAreaConnectionControl != null) {
            this.fProjectAreaConnectionControl.dispose();
        }
        if (this.fGuideComposite != null && !this.fGuideComposite.isDisposed()) {
            this.fGuideComposite.dispose();
        }
        this.fProjectAreaConnectionControl = null;
        this.fGuideComposite = null;
        if (this.fContentComposite != null) {
            return;
        }
        this.fContentComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 150).applyTo((Control)this.fContentComposite);
        this.fDependencyTable = new Table(this.fContentComposite, 67586);
        this.fDependencyTable.setLinesVisible(true);
        this.fDependencyTable.setHeaderVisible(true);
        TableColumnLayout columnLayout = new TableColumnLayout();
        this.fContentComposite.setLayout((Layout)columnLayout);
        this.fTableViewer = new TableViewer(this.fDependencyTable);
        BuildReportUtil.createTableColumn(this.fTableViewer, this.fDependencyTable, columnLayout, Messages.BuildMapEditor_INPUTS_DEPENDENCY_RESOURCE_TABLE_COLUMN, 20, 16384, 0, Messages.BuildMapEditor_INPUTS_DEPENDENCY_RESOURCE_TABLE_COLUMN, 3);
        BuildReportUtil.createTableColumn(this.fTableViewer, this.fDependencyTable, columnLayout, Messages.BuildMapEditor_INPUTS_COMPONENT_TABLE_COLUMN, 15, 16384, 1, Messages.BuildMapEditor_INPUTS_COMPONENT_TABLE_COLUMN, 3);
        BuildReportUtil.createTableColumn(this.fTableViewer, this.fDependencyTable, columnLayout, Messages.BuildMapEditor_INPUTS_PROJECT_TABLE_COLUMN, 15, 16384, 2, Messages.BuildMapEditor_INPUTS_PROJECT_TABLE_COLUMN, 3);
        BuildReportUtil.createTableColumn(this.fTableViewer, this.fDependencyTable, columnLayout, Messages.BuildMapEditor_INPUTS_PATH_TABLE_COLUMN, 20, 16384, 3, Messages.BuildMapEditor_INPUTS_PATH_TABLE_COLUMN, 3);
        BuildReportUtil.createTableColumn(this.fTableViewer, this.fDependencyTable, columnLayout, Messages.BuildMapEditor_INPUTS_TYPE_TABLE_COLUMN, 6, 16384, 4, Messages.BuildMapEditor_INPUTS_TYPE_TABLE_COLUMN, 3);
        BuildReportUtil.createTableColumn(this.fTableViewer, this.fDependencyTable, columnLayout, Messages.DependencyView_TABLE_COLUMN_CHANGE, 6, 16384, 5, Messages.DependencyView_TABLE_COLUMN_CHANGE, 3);
        BuildReportUtil.createTableColumn(this.fTableViewer, this.fDependencyTable, columnLayout, Messages.BuildReportPage_TABLE_COLUMN_VERSION_ID, 6, 16384, 6, Messages.BuildReportPage_TABLE_COLUMN_VERSION_ID, 3);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new DependencyTableLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){
            IShareable shareable = null;

            public void menuAboutToShow(IMenuManager manager) {
                Object selected;
                this.shareable = null;
                ISelection selection = DependencySetView.this.fTableViewer.getSelection();
                if (selection instanceof IStructuredSelection && (selected = ((IStructuredSelection)selection).getFirstElement()) instanceof IBuildFile) {
                    IBuildFile file = (IBuildFile)selected;
                    UUID fileStatusid = UUID.valueOf((String)file.getFileStateUUID());
                    UUID fileUUID = UUID.valueOf((String)file.getFileUUID());
                    String scmLocation = file.getSCMLocation();
                    final IVersionableHandle fileHandle = (IVersionableHandle)IFileItem.ITEM_TYPE.createItemHandle(fileUUID, null);
                    Display.getCurrent().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Collection shareables = null;
                            try {
                                shareables = SharingManager.getInstance().findShareables(fileHandle, null);
                            }
                            catch (FileSystemException e) {
                                Activator.getDefault().logError(e);
                            }
                            if (shareables != null && !shareables.isEmpty()) {
                                shareable = (IShareable)shareables.iterator().next();
                            }
                        }
                    });
                    if (this.shareable != null) {
                        manager.add((IAction)new OpenLocalFileInBuildAction(this.shareable, DependencySetView.this.getSite()));
                    }
                    manager.add((IAction)new OpenRemoteFileAction(DependencySetView.this.fTeamRepository, fileUUID, fileStatusid, DependencySetView.this.getSite().getPart(), scmLocation));
                }
            }
        });
        Menu openFileMenu = menuMgr.createContextMenu(this.fTableViewer.getControl());
        this.fTableViewer.getControl().setMenu(openFileMenu);
        this.fContentComposite.layout();
        this.fTableViewer.addDragSupport(23, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(DependencySetView.this.fTableViewer.getSelection());
            }

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }

            public void dragSetData(DragSourceEvent event) {
                if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                    event.data = LocalSelectionTransfer.getTransfer().getSelection();
                }
            }
        });
    }

    public void setFocus() {
    }

    protected void setContentDescription(String description) {
        super.setContentDescription(description);
    }

    private List<IBuildFile> createDependencySetFromBuildMap(IBuildMap buildMap) {
        Set inputs;
        List<IBuildFile> results = null;
        if (buildMap != null && (inputs = buildMap.getInputs()) != null && inputs.size() > 0) {
            ArrayList<IBuildFile> inputFiles = new ArrayList<IBuildFile>();
            for (IInput input : inputs) {
                IBuildFile inputFile = (IBuildFile)input.getArtifact();
                inputFiles.add(inputFile.clone());
            }
            results = BuildReportUtil.createDependencySetFromInputs(this.fWorkspaceManager, this.fTeamRepository, this.fUuidStateIDVersionIDMap, this.fComponentUUIDNameMap, inputFiles, true);
        }
        return results;
    }

    private void initializeDependencySet() {
        if (this.fBuildmapMap == null) {
            return;
        }
        if (this.fDependencySetMap == null) {
            this.fDependencySetMap = new HashMap<IBuildMap, List<IBuildFile>>();
        }
        this.createDependencyTableViewer(this.fParentComposite);
        TeamBuildJob job = new TeamBuildJob(Messages.DependencyView_JOB_LABEL, true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                URI buildMapURI = DependencySetView.this.fReportBuildFile.getBuildMapURL();
                if (buildMapURI != null) {
                    DependencySetView.this.fBuildMap = (IBuildMap)DependencySetView.this.fBuildmapMap.get(buildMapURI);
                    if (DependencySetView.this.fBuildMap == null) {
                        IBuildMap buildMap;
                        IBuildMapClient buildMapClient = (IBuildMapClient)DependencySetView.this.fTeamRepository.getClientLibrary(IBuildMapClient.class);
                        com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap newBuildMap = buildMapClient.getBuildMap(buildMapURI, monitor);
                        IBuildMap iBuildMap = buildMap = newBuildMap != null ? BuildMapConversionUtil.convert((com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap)newBuildMap) : null;
                        if (buildMap != null) {
                            DependencySetView.this.fBuildMap = buildMap;
                            DependencySetView.this.fBuildmapMap.put(DependencySetView.this.fReportBuildFile.getBuildMapURL(), DependencySetView.this.fBuildMap);
                            DependencySetView.this.fDependencyList = DependencySetView.this.createDependencySetFromBuildMap(DependencySetView.this.fBuildMap);
                            DependencySetView.this.fDependencySetMap.put(DependencySetView.this.fBuildMap, DependencySetView.this.fDependencyList);
                        }
                    } else {
                        DependencySetView.this.fDependencyList = (List)DependencySetView.this.fDependencySetMap.get(DependencySetView.this.fBuildMap);
                        if (DependencySetView.this.fDependencyList == null) {
                            DependencySetView.this.fDependencyList = DependencySetView.this.createDependencySetFromBuildMap(DependencySetView.this.fBuildMap);
                            DependencySetView.this.fDependencySetMap.put(DependencySetView.this.fBuildMap, DependencySetView.this.fDependencyList);
                        }
                    }
                } else if (DependencySetView.this.fNeedInputs) {
                    DependencySetView.this.fDependencyList = BuildReportUtil.createDependencySetFromInputs(DependencySetView.this.fWorkspaceManager, DependencySetView.this.fTeamRepository, DependencySetView.this.fUuidStateIDVersionIDMap, DependencySetView.this.fComponentUUIDNameMap, DependencySetView.this.fReportBuildFile.getInputs(), true);
                }
                if (DependencySetView.this.fIsZos) {
                    DependencySetView.this.fNeedRemovePrefix = true;
                    if (!DependencySetView.this.fReportBuildFile.isHFS() && DependencySetView.this.fPersonal && DependencySetView.this.fResourcePrefix != null) {
                        for (IBuildFile file : DependencySetView.this.fDependencyList) {
                            String buildPath = file.getBuildPath();
                            if (buildPath == null || buildPath.startsWith(DependencySetView.this.fResourcePrefix)) continue;
                            DependencySetView.this.fNeedRemovePrefix = false;
                            break;
                        }
                    }
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (DependencySetView.this.fResourcePrefix != null) {
                            DependencySetView.this.setContentDescription(" " + Messages.BuildMapEditor_GENERAL_RESOURCE_PREFIX_LABEL + " " + DependencySetView.this.fResourcePrefix);
                        }
                        DependencySetView.this.fTableViewer.setInput((Object)DependencySetView.this.fDependencyList);
                        (this).DependencySetView.this.fParentComposite.layout();
                    }
                });
                return null;
            }

            protected void jobFinished(IStatus status) {
            }
        };
        job.schedule();
    }

    public void setTeamRepository(ITeamRepository fTeamRepository) {
        this.fTeamRepository = fTeamRepository;
    }

    public void setInitiaData(IReportBuildFile reportBuildFile, Map<URI, IBuildMap> fBuildmapMap2, Map<String, String> fUuidStateIDVersionIDMap, Map<String, String> fComponentUUIDNameMap, ITeamRepository teamRepository, boolean fNeedInputs, String fResourcePrefix, boolean fIsZos, boolean fPersonal) {
        this.fReportBuildFile = reportBuildFile;
        this.fBuildmapMap = fBuildmapMap2;
        this.fUuidStateIDVersionIDMap = fUuidStateIDVersionIDMap;
        this.fComponentUUIDNameMap = fComponentUUIDNameMap;
        this.fTeamRepository = teamRepository;
        this.fNeedInputs = fNeedInputs;
        this.fResourcePrefix = fResourcePrefix;
        this.fIsZos = fIsZos;
        this.fPersonal = fPersonal;
        if (this.fConnectedProjectAreas.size() > 0 && this.fTeamRepository != null) {
            if (!this.fTeamRepository.loggedIn()) {
                try {
                    this.fTeamRepository.login(null);
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
            }
            this.initializeDependencySet();
        }
    }

    public void connectedProjectAreaRegistryChanged(IConnectedProjectAreaRegistryChangeEvent changeEvent) {
        this.initConnectedProjectAreas();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DependencySetView.this.handleProjectAreasChanged();
            }
        });
    }

    protected void handleProjectAreasChanged() {
        if (this.fParentComposite != null && !this.fParentComposite.isDisposed()) {
            if (this.fConnectedProjectAreas.size() == 0) {
                this.showProjectAreaConnectionControl();
            } else if (this.fConnectedProjectAreas.size() != 0 && this.fProjectAreaConnectionControl != null) {
                this.createGuidePage(this.fParentComposite);
            }
        }
    }

    public void dispose() {
        ConnectedProjectAreaRegistry.getDefault().removeListener((IConnectedProjectAreaRegistryListener)this);
        super.dispose();
    }

    class DependencyTableLabelProvider
    implements ITableLabelProvider {
        DependencyTableLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element instanceof IBuildFile) {
                IBuildFile buildFile = (IBuildFile)element;
                switch (columnIndex) {
                    case 0: {
                        result = DependencySetView.this.fNeedRemovePrefix ? BuildReportUtil.generateFullPathWithoutPrefix((String)buildFile.getBuildPath(), (String)buildFile.getBuildFile(), (String)buildFile.getOutputType(), (String)buildFile.getSequential(), (String)DependencySetView.this.fResourcePrefix, (boolean)buildFile.isHFS()) : BuildReportUtil.generateBuildFileFullPath((String)buildFile.getBuildPath(), (String)buildFile.getBuildFile(), (String)buildFile.getOutputType(), (String)buildFile.getSequential(), (boolean)buildFile.isHFS());
                        break;
                    }
                    case 1: {
                        result = buildFile.getComponentName();
                        break;
                    }
                    case 2: {
                        result = buildFile.getProjectName();
                        break;
                    }
                    case 3: {
                        result = buildFile.getSCMLocation();
                        break;
                    }
                    case 4: {
                        result = buildFile.getType();
                        break;
                    }
                    case 5: {
                        result = buildFile.getUserPropertyValue("changed");
                        if (result != null) break;
                        result = Messages.DependencyView_FILE_CHANGE_NO;
                        break;
                    }
                    case 6: {
                        String versionID = buildFile.getUserPropertyValue("versionID");
                        result = versionID != null ? versionID : "N/A";
                    }
                }
            }
            if (result == null) {
                result = "";
            }
            return result;
        }
    }
}

