/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.views;

import com.ibm.team.enterprise.build.ui.editors.buildmap.AbstractBuildMapComparator;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import org.eclipse.jface.viewers.Viewer;

public class DependencySetComparator
extends AbstractBuildMapComparator {
    public DependencySetComparator(int colIndex, int sortDirection) {
        super(colIndex, sortDirection);
    }

    @Override
    public int compare(Viewer viewer, Object sourceCol, Object targetCol) {
        int result = 0;
        if (sourceCol != null && targetCol != null && sourceCol instanceof IBuildFile && targetCol instanceof IBuildFile) {
            IBuildFile sourceFile = (IBuildFile)sourceCol;
            IBuildFile targetFile = (IBuildFile)targetCol;
            switch (this.fColIndex) {
                case 0: {
                    String sourceFullPath = BuildReportUtil.generateBuildFileFullPath((String)sourceFile.getBuildPath(), (String)sourceFile.getBuildFile(), (String)sourceFile.getOutputType(), (String)sourceFile.getSequential(), (boolean)sourceFile.isHFS());
                    String targetFullPath = BuildReportUtil.generateBuildFileFullPath((String)targetFile.getBuildPath(), (String)targetFile.getBuildFile(), (String)targetFile.getOutputType(), (String)targetFile.getSequential(), (boolean)targetFile.isHFS());
                    result = this.compareString(sourceFullPath, targetFullPath);
                    break;
                }
                case 1: {
                    result = this.compareString(sourceFile.getComponentName(), targetFile.getComponentName());
                    break;
                }
                case 2: {
                    result = this.compareString(sourceFile.getProjectName(), targetFile.getProjectName());
                    break;
                }
                case 3: {
                    result = this.compareString(sourceFile.getSCMLocation(), targetFile.getSCMLocation());
                    break;
                }
                case 4: {
                    result = this.compareString(sourceFile.getType(), targetFile.getType());
                    break;
                }
                case 5: {
                    result = this.compareString(sourceFile.getUserPropertyValue("changed"), targetFile.getUserPropertyValue("changed"));
                    break;
                }
                case 6: {
                    result = this.compareString(sourceFile.getUserPropertyValue("versionID"), targetFile.getUserPropertyValue("versionID"));
                }
            }
        }
        result = this.fSortDirection == 128 ? result : result * -1;
        return result;
    }
}

