/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.views;

import com.ibm.team.enterprise.build.ui.query.IBuildMapQueryItem;
import com.ibm.team.enterprise.build.ui.views.BuildMapsQueryView;
import com.ibm.team.enterprise.metadata.query.common.AttributeColumn;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class BuildsMapsQueryViewLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS ", Locale.US);
    private ResourceManager resources = null;
    private BuildMapsQueryView treeview = null;

    public BuildsMapsQueryViewLabelProvider(BuildMapsQueryView treeview) {
        this.treeview = treeview;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof IBuildMapQueryItem) {
            IBuildMapQueryItem item = (IBuildMapQueryItem)element;
            switch (columnIndex) {
                case 0: {
                    break;
                }
                default: {
                    Object columnData = this.treeview.getTree().getColumn(columnIndex).getData();
                    if (columnData == null || !(columnData instanceof AttributeColumn)) break;
                    String bindingName = ((AttributeColumn)columnData).getAttribute().getNamespace();
                    String string = text = item.getItemData(bindingName) != null ? item.getItemData(bindingName).toString() : "";
                    if (!bindingName.equals("timestamp") || text.isEmpty()) break;
                    try {
                        String formatText = DateFormat.getDateTimeInstance().format(DATE_FORMAT.parse(text));
                        return formatText;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        }
        return text;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    protected final ResourceManager getResources() {
        if (this.resources == null) {
            this.resources = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resources;
    }

    protected final Image getImage(ImageDescriptor descriptor) {
        Object o = this.getResources().find((DeviceResourceDescriptor)descriptor);
        if (o instanceof Image) {
            return (Image)o;
        }
        return this.getResources().createImageWithDefault(descriptor);
    }

    public void dispose() {
        super.dispose();
        if (this.resources != null) {
            this.resources.dispose();
        }
    }
}

