/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.views;

import com.ibm.team.enterprise.metadata.query.common.AttributeColumn;
import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class BuildMapsQueryViewer
extends Composite {
    private TreeViewer treeViewer;
    private Composite parent;
    private Composite treeComposite;

    public BuildMapsQueryViewer(Composite parent) {
        super(parent, 0);
        this.parent = parent;
        this.init();
    }

    private void init() {
        this.createTree(this.parent);
    }

    private void createTree(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.treeComposite = new Composite((Composite)this, 0);
        GridLayout treeCompositeLayout = new GridLayout();
        treeCompositeLayout.marginHeight = 0;
        treeCompositeLayout.marginWidth = 0;
        this.treeComposite.setLayout((Layout)treeCompositeLayout);
        GridData data = new GridData(4, 4, true, true);
        this.treeComposite.setLayoutData((Object)data);
        this.treeViewer = new TreeViewer(this.treeComposite);
        data = new GridData(4, 4, true, true);
        this.treeViewer.getControl().setLayoutData((Object)data);
    }

    public void setColumns(List<AttributeColumn> columns) {
        TreeColumn[] treeColumns = this.treeViewer.getTree().getColumns();
        if (treeColumns.length == 0) {
            TreeColumn treeColumn = new TreeColumn(this.treeViewer.getTree(), 0x1000000);
            treeColumn.setWidth(30);
        } else {
            int i = 1;
            while (i < treeColumns.length) {
                treeColumns[i].dispose();
                ++i;
            }
        }
        if (columns != null) {
            TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
            int j = 0;
            while (j < columns.size()) {
                AttributeColumn column = columns.get(j);
                BuildMapsQueryViewer.createTreeColumn(this.treeViewer.getTree(), this.treeViewer, treeColumnLayout, column, 20, 16384, j, 0);
                ++j;
            }
        }
        this.treeViewer.refresh();
    }

    public void setInput(Object input) {
        this.treeViewer.setInput(input);
        this.treeViewer.refresh(true);
    }

    public void dispose() {
        if (this.treeViewer != null) {
            this.treeViewer = null;
        }
    }

    public void refresh() {
        this.treeViewer.refresh(true);
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.treeViewer.getSelection();
    }

    public void installContextMenu(MenuManager menuManager) {
        Menu menu = menuManager.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
    }

    public void clearSorting() {
        if (this.treeViewer != null) {
            this.treeViewer.setComparator(null);
        }
    }

    public ISelectionProvider getSelectionProvider() {
        return this.treeViewer;
    }

    private static TreeColumn createTreeColumn(Tree tree, final TreeViewer fViewer, TreeColumnLayout treeColumnLayout, AttributeColumn column, int weight, int style, int index, int type) {
        TreeColumn treeColumn = new TreeColumn(tree, style, index);
        treeColumn.setText(column.getAttribute().getFullDisplayName());
        treeColumn.setData((Object)column);
        treeColumn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                final TreeColumn treeCol = (TreeColumn)e.getSource();
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        int oldSortDir = treeCol == fViewer.getTree().getSortColumn() ? fViewer.getTree().getSortDirection() : 1024;
                        int newSortDir = 128;
                        switch (oldSortDir) {
                            case 128: {
                                newSortDir = 1024;
                                break;
                            }
                            case 1024: {
                                newSortDir = 128;
                            }
                        }
                        fViewer.getTree().setSortColumn(treeCol);
                        fViewer.getTree().setSortDirection(newSortDir);
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        treeColumn.setToolTipText(column.getAttribute().getFullDisplayName());
        treeColumnLayout.setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnWeightData(weight));
        return treeColumn;
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }
}

