/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.views;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.actions.OpenRemoteFileAction;
import com.ibm.team.enterprise.build.ui.query.IBuildMapQueryItem;
import com.ibm.team.enterprise.build.ui.views.BuildMapsQueryContentProvider;
import com.ibm.team.enterprise.build.ui.views.BuildMapsQueryViewer;
import com.ibm.team.enterprise.build.ui.views.BuildsMapsQueryViewLabelProvider;
import com.ibm.team.enterprise.internal.build.ui.actions.OpenLocalFileFromBuildMapQueryAction;
import com.ibm.team.enterprise.internal.build.ui.actions.ViewBuildMapFromQueryResultAction;
import com.ibm.team.enterprise.metadata.query.common.AttributeColumn;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class BuildMapsQueryView
extends ViewPart {
    public static final String VIEW_ID = "com.ibm.team.enterprise.build.ui.views.BuildMapQueryView";
    private Label statusLabel;
    private BuildMapsQueryViewer fViewer;
    private Tree fTree;
    private List<IBuildMapQueryItem> elements = new ArrayList<IBuildMapQueryItem>(0);

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.statusLabel = new Label(composite, 16384);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.statusLabel);
        this.fViewer = new BuildMapsQueryViewer(composite);
        this.fViewer.setBackground(parent.getDisplay().getSystemColor(25));
        this.fViewer.setLayoutData(new GridData(1808));
        this.fTree = this.fViewer.getViewer().getTree();
        this.fTree.setLinesVisible(true);
        this.fTree.setHeaderVisible(true);
        this.fViewer.getViewer().setContentProvider((IContentProvider)new BuildMapsQueryContentProvider(this));
        this.fViewer.getViewer().setLabelProvider((IBaseLabelProvider)new BuildsMapsQueryViewLabelProvider(this));
        this.fViewer.getViewer().setInput((Object)this);
        this.installContextMenu();
    }

    public void setInput(Object object, String message) {
        if (this.fViewer != null) {
            if (object instanceof List) {
                this.elements.clear();
                this.elements.addAll((List)object);
                this.refresh();
                this.setStatus(message);
            } else if (object instanceof IStatus) {
                this.setStatus(message);
            }
            this.refresh();
        }
    }

    public void setColumns(List<AttributeColumn> columns) {
        TreeColumn[] treeColumns = this.fTree.getColumns();
        if (treeColumns.length == 0) {
            TreeColumn treeColumn = new TreeColumn(this.fTree, 0x1000000);
            treeColumn.setWidth(30);
        } else {
            int i = 1;
            while (i < treeColumns.length) {
                treeColumns[i].dispose();
                ++i;
            }
        }
        if (columns != null) {
            int i = 1;
            for (AttributeColumn column : columns) {
                TreeColumn tableColumn = new TreeColumn(this.fTree, 16384, i++);
                tableColumn.setData((Object)column);
                tableColumn.setText(column.getAttribute().getFullDisplayName());
                if (column.getAttribute().getValue() != null && column.getAttribute().getValue() instanceof Number) {
                    tableColumn.setWidth(Integer.valueOf(column.getAttribute().getValue().toString()).intValue());
                    continue;
                }
                tableColumn.setWidth(150);
            }
        }
        this.fTree.setHeaderVisible(true);
        this.asyncRefresh(true);
    }

    public void setFocus() {
        if (this.fViewer != null) {
            this.fViewer.setFocus();
        }
    }

    public void refresh() {
        if (this.fViewer != null) {
            this.asyncRefresh(true);
        }
    }

    public void setStatus(String status) {
        this.statusLabel.setText(status);
    }

    private void installContextMenu() {
        MenuManager contextMenuMgr = new MenuManager("#PopupMenu");
        contextMenuMgr.setRemoveAllWhenShown(true);
        contextMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = BuildMapsQueryView.this.fViewer.getSelection();
                if (selection.getFirstElement() instanceof IBuildMapQueryItem) {
                    IBuildMapQueryItem parentItem;
                    IBuildMapQueryItem item = (IBuildMapQueryItem)selection.getFirstElement();
                    IBuildDefinition buildDef = (IBuildDefinition)item.getOwningResult().getQuery().getQueryParameters().get("build.def");
                    UUID fileUUID = UUID.valueOf((String)((String)item.getItemData("FileUUID")));
                    UUID fileStatusid = UUID.valueOf((String)((String)item.getItemData("FileStateUUID")));
                    String scmLocation = (String)item.getItemData("scmLocation");
                    if (scmLocation == null && (parentItem = item.getParentItem()) != null) {
                        scmLocation = (String)parentItem.getItemData("scmLocation");
                    }
                    ViewBuildMapFromQueryResultAction action = new ViewBuildMapFromQueryResultAction();
                    action.selectionChanged(null, (ISelection)selection);
                    manager.add((IAction)action);
                    OpenLocalFileFromBuildMapQueryAction openLocal = new OpenLocalFileFromBuildMapQueryAction(BuildMapsQueryView.this.getSite());
                    openLocal.selectionChanged(null, (ISelection)selection);
                    manager.add((IAction)openLocal);
                    manager.add((IAction)new OpenRemoteFileAction((ITeamRepository)buildDef.getOrigin(), fileUUID, fileStatusid, (IWorkbenchPart)BuildMapsQueryView.this, scmLocation));
                }
            }
        });
        contextMenuMgr.createContextMenu(this.fViewer.getViewer().getControl());
        this.fViewer.installContextMenu(contextMenuMgr);
        this.getSite().registerContextMenu(contextMenuMgr, (ISelectionProvider)this.fViewer.getViewer());
    }

    public void dispose() {
        this.fTree.dispose();
        super.dispose();
    }

    public Tree getTree() {
        return this.fTree;
    }

    public IBuildMapQueryItem[] getElements() {
        return this.elements.toArray(new IBuildMapQueryItem[this.elements.size()]);
    }

    private void asyncRefresh(final boolean activate) {
        if (this.fTree.isDisposed()) {
            return;
        }
        Display display = this.fTree.getDisplay();
        final BuildMapsQueryView view = this;
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!BuildMapsQueryView.this.fTree.isDisposed()) {
                        IWorkbenchPage page;
                        TreeViewer viewer = BuildMapsQueryView.this.fViewer.getViewer();
                        viewer.refresh();
                        if (activate && (page = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
                            page.bringToTop((IWorkbenchPart)view);
                        }
                    }
                }
            });
        }
    }
}

