/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset.views;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.build.client.buildablesubset.ClientFactory;
import com.ibm.team.enterprise.build.client.buildablesubset.IBuildableSubsetClient;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetEditorInput;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetNode;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetsNode;
import com.ibm.team.enterprise.build.ui.subset.EditSubsetActionDelegate;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetUtil;
import com.ibm.team.enterprise.common.ui.IEnterpriseExtensionsNode;
import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainContentProvider;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class BuildSubsetView
extends ViewPart
implements IConnectedProjectAreaRegistryListener {
    public static final String VIEW_ID = "com.ibm.team.enterprise.build.ui.subset.views.BuildSubsetView";
    public final int COLUMN_NAME = 1;
    public final int COLUMN_BUILD_DEF = 0;
    public final int COLUMN_OWNER = 2;
    public final int COLUMN_VISIBILITY = 3;
    private ITeamRepository fTeamRepository;
    private IProjectArea fProjectArea;
    private TableViewer fSubsetTableViewer;
    private AbstractEnterpriseExtensionsNode fSelectedNode;
    private Composite fTableComposite;
    private List<ISubset> fSubsetHandles;
    private Map<String, IContributor> contributorMap = new HashMap<String, IContributor>();
    private Map<String, IBuildDefinition> buildDefinitionMap = new HashMap<String, IBuildDefinition>();
    private OpenSubsetAction openSubsetAction = new OpenSubsetAction();
    private DeleteSubsetAction deleteSubsetAction = new DeleteSubsetAction();
    private ITableLabelProvider labelProvider;

    public void connectedProjectAreaRegistryChanged(IConnectedProjectAreaRegistryChangeEvent changeEvent) {
    }

    private IContributor getContributor(String ownerId) {
        if (this.contributorMap.containsKey(ownerId)) {
            return this.contributorMap.get(ownerId);
        }
        IContributorHandle ownerHandle = (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle(UUID.valueOf((String)ownerId), null);
        IContributor owner = null;
        try {
            owner = (IContributor)this.fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)ownerHandle, 0, null);
        }
        catch (TeamRepositoryException e) {
            Activator.getDefault().logError(e);
        }
        this.contributorMap.put(ownerId, owner);
        return owner;
    }

    private IBuildDefinition getBuildDefinition(String buildDefID) {
        if (this.buildDefinitionMap.containsKey(buildDefID)) {
            return this.buildDefinitionMap.get(buildDefID);
        }
        IBuildDefinitionHandle buildDefHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildDefID), null);
        IBuildDefinition buildDefinition = null;
        try {
            buildDefinition = (IBuildDefinition)this.fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)buildDefHandle, 0, null);
        }
        catch (TeamRepositoryException e) {
            Activator.getDefault().logError(e);
        }
        this.buildDefinitionMap.put(buildDefID, buildDefinition);
        return buildDefinition;
    }

    private void createTableViewer(Composite parent) {
        this.fTableComposite = new Composite(parent, 0);
        this.fSubsetTableViewer = new TableViewer(this.fTableComposite, 68354);
        this.fSubsetTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return BuildSubsetView.this.fSubsetHandles.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.labelProvider = new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                ISubset subset = (ISubset)element;
                switch (columnIndex) {
                    case 0: {
                        IBuildDefinition buildDefinition = BuildSubsetView.this.getBuildDefinition(subset.getBuildDefinition().getItemId().getUuidValue());
                        return buildDefinition.getId();
                    }
                    case 2: {
                        IContributor contributor = BuildSubsetView.this.getContributor(subset.getOwner().getItemId().getUuidValue());
                        return contributor.getName();
                    }
                    case 1: {
                        return subset.getLabel();
                    }
                    case 3: {
                        return subset.getVisibility().getName();
                    }
                }
                return null;
            }
        };
        this.fSubsetTableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        TableColumnLayout columnLayout = new TableColumnLayout();
        this.fTableComposite.setLayout((Layout)columnLayout);
        TableColumn defaultSortColumn = this.createTableColumn(Messages.BuildSubsetView_BUILD_DEF_COLUMN_LABEL, null, 16384, 0, 15, columnLayout);
        this.createTableColumn(Messages.BuildSubsetView_NAME_COLUMN_LABEL, null, 16384, 1, 50, columnLayout);
        this.createTableColumn(Messages.BuildSubsetView_OWNER_COLUMN_LABEL, null, 16384, 2, 15, columnLayout);
        this.createTableColumn(Messages.BuildSubsetView_VISIBILITY_COLUMN_LABEL, null, 16384, 3, 15, columnLayout);
        this.fSubsetTableViewer.getTable().setHeaderVisible(true);
        this.fSubsetTableViewer.getTable().setLinesVisible(true);
        this.fSubsetTableViewer.getTable().setSortColumn(defaultSortColumn);
        this.fSubsetTableViewer.getTable().setSortDirection(128);
        this.fSubsetTableViewer.setComparator((ViewerComparator)new BuildSubsetComparator(0, 128));
        if (this.getSite() != null) {
            MenuManager menuManager = new MenuManager("#PopupMenu");
            menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    int selectionSize = ((IStructuredSelection)BuildSubsetView.this.fSubsetTableViewer.getSelection()).size();
                    BuildSubsetView.this.openSubsetAction.setEnabled(selectionSize > 0);
                    BuildSubsetView.this.deleteSubsetAction.setEnabled(selectionSize > 0);
                }
            });
            menuManager.add((IAction)this.openSubsetAction);
            menuManager.add((IAction)this.deleteSubsetAction);
            this.getSite().registerContextMenu(this.getSite().getId(), menuManager, (ISelectionProvider)this.fSubsetTableViewer);
            Menu menu = menuManager.createContextMenu((Control)this.fSubsetTableViewer.getTable());
            this.fSubsetTableViewer.getTable().setMenu(menu);
            this.fSubsetTableViewer.addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    BuildSubsetView.this.openSubsetAction.run();
                }
            });
            this.fSubsetTableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 127) {
                        BuildSubsetView.this.deleteSubsetAction.run();
                    }
                }
            });
        }
        this.fSubsetTableViewer.addDragSupport(23, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(BuildSubsetView.this.fSubsetTableViewer.getSelection());
            }

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }

            public void dragSetData(DragSourceEvent event) {
                if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                    event.data = LocalSelectionTransfer.getTransfer().getSelection();
                }
            }
        });
    }

    private TableColumn createTableColumn(String name, String tooltip, int flags, final int id, int weight, TableColumnLayout layout) {
        TableColumn column = new TableColumn(this.fSubsetTableViewer.getTable(), 16384, id);
        column.setText(name);
        column.setToolTipText(tooltip);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final TableColumn tableCol = (TableColumn)e.getSource();
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        int oldSortDir = tableCol == BuildSubsetView.this.fSubsetTableViewer.getTable().getSortColumn() ? BuildSubsetView.this.fSubsetTableViewer.getTable().getSortDirection() : 1024;
                        int newSortDir = 128;
                        switch (oldSortDir) {
                            case 128: {
                                newSortDir = 1024;
                                break;
                            }
                            case 1024: {
                                newSortDir = 128;
                            }
                        }
                        BuildSubsetView.this.fSubsetTableViewer.getTable().setSortColumn(tableCol);
                        BuildSubsetView.this.fSubsetTableViewer.getTable().setSortDirection(newSortDir);
                        ((BuildSubsetComparator)BuildSubsetView.this.fSubsetTableViewer.getComparator()).update(id, newSortDir);
                        BuildSubsetView.this.fSubsetTableViewer.refresh();
                    }
                });
            }
        });
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight));
        return column;
    }

    public void createPartControl(Composite parent) {
        this.createTableViewer(parent);
    }

    public void setFocus() {
    }

    public static void displayBuildSubsetView(List<ISubset> subsetHandles, ITeamRepository teamRepository, IProjectArea projectArea, AbstractEnterpriseExtensionsNode selectedNode) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        BuildSubsetView view = (BuildSubsetView)activePage.findView(VIEW_ID);
        if (view == null) {
            try {
                view = (BuildSubsetView)activePage.showView(VIEW_ID);
                view.setInitialData(subsetHandles, teamRepository, projectArea, selectedNode);
            }
            catch (PartInitException exception) {
                Activator.getDefault().logError(exception);
            }
        } else {
            activePage.bringToTop((IWorkbenchPart)view);
            view.setInitialData(subsetHandles, teamRepository, projectArea, selectedNode);
        }
    }

    public static boolean deleteNodesFromBuildSubsetView(List<IEnterpriseExtensionsNode> fDeletedNodes) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        BuildSubsetView view = (BuildSubsetView)activePage.findView(VIEW_ID);
        if (view != null) {
            view.removeSubsets(fDeletedNodes);
            return true;
        }
        return false;
    }

    public void setInitialData(List<ISubset> subsetHandles, ITeamRepository teamRepository, IProjectArea projectArea, AbstractEnterpriseExtensionsNode selectedNode) {
        this.fTeamRepository = teamRepository;
        this.fSubsetHandles = subsetHandles == null ? new ArrayList() : subsetHandles;
        this.fProjectArea = projectArea;
        this.fSelectedNode = selectedNode;
        this.fSubsetTableViewer.setInput(this.fSubsetHandles);
        this.fSubsetTableViewer.refresh();
    }

    public void removeSubsets(List<IEnterpriseExtensionsNode> deletedNodes) {
        ArrayList<ISubset> deletedSubsetHandles = new ArrayList<ISubset>();
        int i = 0;
        while (i < deletedNodes.size()) {
            BuildSubsetNode deletingSubsetNode = (BuildSubsetNode)deletedNodes.get(i);
            int j = 0;
            while (j < this.fSubsetHandles.size()) {
                ISubset viewSubsetHandle = this.fSubsetHandles.get(j);
                if (viewSubsetHandle.getBuildDefinition().equals((Object)deletingSubsetNode.getBuildableSubset().getBuildDefinition()) && viewSubsetHandle.getLabel().equals(deletingSubsetNode.getBuildableSubset().getLabel())) {
                    deletedSubsetHandles.add(viewSubsetHandle);
                }
                ++j;
            }
            ++i;
        }
        this.fSubsetHandles.removeAll(deletedSubsetHandles);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BuildSubsetView.this.fSubsetTableViewer.setInput((Object)BuildSubsetView.this.fSubsetHandles);
            }
        });
    }

    private class BuildSubsetComparator
    extends ViewerComparator {
        private int colIndex;
        private int sortDir;

        public BuildSubsetComparator(int colIndex, int sortDir) {
            this.update(colIndex, sortDir);
        }

        public void update(int colIndex, int sortDir) {
            this.colIndex = colIndex;
            this.sortDir = sortDir;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (BuildSubsetView.this.labelProvider == null) {
                return super.compare(viewer, e1, e2);
            }
            try {
                int result = BuildSubsetView.this.labelProvider.getColumnText(e1, this.colIndex).compareTo(BuildSubsetView.this.labelProvider.getColumnText(e2, this.colIndex));
                if (result != 0) {
                    result = this.sortDir == 128 ? result : result * -1;
                }
                return result;
            }
            catch (Exception e) {
                e.printStackTrace();
                return super.compare(viewer, e1, e2);
            }
        }
    }

    private class DeleteSubsetAction
    extends Action {
        public DeleteSubsetAction() {
            super(Messages.BuildSubsetView_DELETE_ACTION);
        }

        public void run() {
            try {
                MessageDialog dialog = new MessageDialog(null, Messages.BuildSubsetView_CONFIRM_ACTION, null, Messages.BuildSubsetNode_LABEL_DELETEDIALOG_MESSAGE, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 0) {
                    final IStructuredSelection selection = (IStructuredSelection)BuildSubsetView.this.fSubsetTableViewer.getSelection();
                    final ArrayList deletedSubsets = new ArrayList();
                    new TeamBuildJob(Messages.BuildSubsetView_LOAD_CONFIGURATIONS_JOB, true, BuildSubsetView.this.fTeamRepository){

                        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                            IBuildableSubsetClient client = ClientFactory.getBuildableSubsetClient((ITeamRepository)BuildSubsetView.this.fTeamRepository);
                            for (ISubset subset : selection) {
                                boolean deleted = false;
                                try {
                                    if (client.exists(BuildableSubsetUtil.getSlug((String)subset.getLabel(), (String)subset.getBuildDefinition().getItemId().getUuidValue()))) {
                                        client.deleteBuildableSubset(subset);
                                    }
                                    deleted = true;
                                }
                                catch (ItemNotFoundException infException) {
                                    deleted = true;
                                }
                                catch (TeamRepositoryException tException) {
                                    Activator.getDefault().logError(tException);
                                    deleted = false;
                                }
                                if (!deleted) continue;
                                deletedSubsets.add(subset);
                            }
                            return null;
                        }

                        protected void jobFinished(IStatus status) {
                            if (!deletedSubsets.isEmpty()) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        BuildSubsetView.this.fSubsetTableViewer.remove(deletedSubsets.toArray());
                                        if (BuildSubsetView.this.fSelectedNode != null) {
                                            AbstractEnterpriseExtensionsNode nodeToRefresh = (AbstractEnterpriseExtensionsNode)BuildSubsetView.this.fSelectedNode.getParent();
                                            if (nodeToRefresh == null && BuildSubsetView.this.fSelectedNode instanceof BuildSubsetsNode) {
                                                nodeToRefresh = BuildSubsetView.this.fSelectedNode;
                                            }
                                            if (nodeToRefresh != null) {
                                                ((EnterpriseExtensionsDomainContentProvider)BuildSubsetView.this.fSelectedNode.getDomain().getContentProvider()).updateTreeViewer(nodeToRefresh);
                                            }
                                        }
                                    }
                                });
                            }
                        }
                    }.schedule();
                }
            }
            catch (Exception e) {
                Activator.getDefault().logError(e);
            }
        }

        public ImageDescriptor getImageDescriptor() {
            return Activator.getImageDescriptor("icons/elcl16/delete.gif");
        }
    }

    private class OpenSubsetAction
    extends Action {
        public OpenSubsetAction() {
            super(Messages.BuildSubsetView_OPEN_ACTION);
        }

        public void run() {
            try {
                IWorkbenchPage page = BuildSubsetView.this.getSite().getPage();
                StructuredSelection selection = (StructuredSelection)BuildSubsetView.this.fSubsetTableViewer.getSelection();
                for (ISubset buidableSubsetHandle : selection) {
                    BuildSubsetEditorInput editorInput = new BuildSubsetEditorInput(buidableSubsetHandle, BuildSubsetView.this.fTeamRepository, (IProjectAreaHandle)BuildSubsetView.this.fProjectArea);
                    EditSubsetActionDelegate.run(editorInput, page);
                }
            }
            catch (Exception e) {
                Activator.getDefault().logError(e);
            }
        }
    }
}

