/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset.views;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.build.client.buildablesubset.ClientFactory;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.data.export.IQueryResultExportSupplier;
import com.ibm.team.enterprise.build.ui.data.export.TableData;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildableFilesViewer;
import com.ibm.team.enterprise.build.ui.subset.views.ProjectAreaConnectionControl;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetCriteria;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetUtil;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class BuildSubsetFilesView
extends ViewPart
implements IConnectedProjectAreaRegistryListener,
IQueryResultExportSupplier {
    public static final String VIEW_ID = "com.ibm.team.enterprise.build.ui.subset.views.BuildSubsetFilesView";
    private ITeamRepository fTeamRepository;
    private ISubset fSubset;
    private ISubset fSubsetHandle;
    private boolean fNeedToResolveDynamicCriteria;
    private boolean fContainsUnsavedChanges;
    private String fSubsetLabelOverride;
    protected Composite fParentComposite;
    protected Composite fContentComposite;
    protected Composite fGuideComposite;
    private BuildableFilesViewer fFilesViewer;
    private IAction fRefreshAction;
    private List<IProjectAreaHandle> fConnectedProjectAreas = Collections.emptyList();
    protected ProjectAreaConnectionControl fProjectAreaConnectionControl;

    public BuildSubsetFilesView() {
        this.fFilesViewer = new BuildableFilesViewer(null, null, this.getSite(), true, true);
    }

    protected void setSite(IWorkbenchPartSite site) {
        super.setSite(site);
        this.fFilesViewer.setSite(site);
    }

    public void createPartControl(Composite parent) {
        this.fParentComposite = parent;
        this.initConnectedProjectAreas();
        this.setContentDescription(Messages.BuildSubsetFilesView_NO_CONTENT);
        ConnectedProjectAreaRegistry.getDefault().addListener((IConnectedProjectAreaRegistryListener)this);
        this.initToolbarActions();
        if (this.fConnectedProjectAreas.size() == 0) {
            this.showProjectAreaConnectionControl();
        } else if (this.fTeamRepository == null) {
            this.createGuidePage(parent);
        }
    }

    private void createGuidePage(Composite parent) {
        if (this.fProjectAreaConnectionControl != null) {
            this.fProjectAreaConnectionControl.dispose();
        }
        if (this.fContentComposite != null && !this.fContentComposite.isDisposed()) {
            this.fContentComposite.dispose();
        }
        this.fProjectAreaConnectionControl = null;
        this.fContentComposite = null;
        if (this.fGuideComposite != null) {
            return;
        }
        this.setContentDescription(Messages.BuildSubsetFilesView_NO_CONTENT);
        this.fGuideComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.fGuideComposite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fGuideComposite);
        this.fGuideComposite.setBackground(this.fGuideComposite.getDisplay().getSystemColor(25));
        Label label = new Label(this.fGuideComposite, 16576);
        label.setText(Messages.BuildSubsetFilesView_GUIDE);
        label.setBackground(this.fGuideComposite.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        this.fParentComposite.layout();
    }

    protected void showProjectAreaConnectionControl() {
        if (this.fContentComposite != null && !this.fContentComposite.isDisposed()) {
            this.fContentComposite.dispose();
        }
        if (this.fGuideComposite != null && !this.fGuideComposite.isDisposed()) {
            this.fGuideComposite.dispose();
        }
        this.fRefreshAction.setEnabled(false);
        this.fContentComposite = null;
        this.fGuideComposite = null;
        if (this.fProjectAreaConnectionControl != null) {
            return;
        }
        this.setContentDescription(Messages.BuildSubsetFilesView_NO_CONTENT);
        this.fProjectAreaConnectionControl = new ProjectAreaConnectionControl();
        this.fProjectAreaConnectionControl.create(this.fParentComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fProjectAreaConnectionControl.getContentContainer());
        this.fParentComposite.layout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnectedProjectAreas() {
        List projectAreas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(null);
        BuildSubsetFilesView buildSubsetFilesView = this;
        synchronized (buildSubsetFilesView) {
            this.fConnectedProjectAreas = Collections.unmodifiableList(new ArrayList(projectAreas));
        }
    }

    public static void displayBuildSubsetFilesView(ISubset tempSubset, ITeamRepository teamRepository, boolean needToResolveDynamicCriteria, boolean containsUnsavedChanges, String subsetLabelOverride) {
        BuildSubsetFilesView.displayBuildSubsetFilesView(tempSubset, null, teamRepository, needToResolveDynamicCriteria, containsUnsavedChanges, subsetLabelOverride);
    }

    public static void displayBuildSubsetFilesView(ISubset iSubset, ITeamRepository teamRepository) {
        BuildSubsetFilesView.displayBuildSubsetFilesView(null, iSubset, teamRepository, false, false, null);
    }

    private static void displayBuildSubsetFilesView(ISubset subset, ISubset iSubset, ITeamRepository teamRepository, boolean needToResolveDynamicCriteria, boolean containsUnsavedChanges, String subsetLabelOverride) {
        if (subset == null && iSubset == null) {
            throw new IllegalArgumentException();
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        BuildSubsetFilesView view = (BuildSubsetFilesView)activePage.findView(VIEW_ID);
        if (view == null) {
            try {
                view = (BuildSubsetFilesView)activePage.showView(VIEW_ID);
                view.setInitialData(subset, iSubset, teamRepository, needToResolveDynamicCriteria, containsUnsavedChanges, subsetLabelOverride);
            }
            catch (PartInitException exception) {
                Activator.getDefault().logError(exception);
            }
        } else {
            activePage.bringToTop((IWorkbenchPart)view);
            view.setInitialData(subset, iSubset, teamRepository, needToResolveDynamicCriteria, containsUnsavedChanges, subsetLabelOverride);
        }
    }

    private void createTableViewer(Composite parent) {
        if (this.fProjectAreaConnectionControl != null) {
            this.fProjectAreaConnectionControl.dispose();
        }
        if (this.fGuideComposite != null && !this.fGuideComposite.isDisposed()) {
            this.fGuideComposite.dispose();
        }
        this.fProjectAreaConnectionControl = null;
        this.fGuideComposite = null;
        if (this.fContentComposite != null) {
            return;
        }
        this.fContentComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 150).applyTo((Control)this.fContentComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.fContentComposite);
        this.fFilesViewer.createContents(this.fContentComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fFilesViewer.getMainComposite());
        this.fContentComposite.layout();
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        ConnectedProjectAreaRegistry.getDefault().removeListener((IConnectedProjectAreaRegistryListener)this);
        this.fFilesViewer.dispose();
    }

    private void initializeSubsetFiles() {
        this.createTableViewer(this.fParentComposite);
        TeamBuildJob job = new TeamBuildJob(Messages.BuildSubsetFilesView_JOB_LABEL, true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                IItem buildDef;
                IBuildDefinitionHandle handle;
                BuildSubsetFilesView.this.fFilesViewer.getBuildableFiles().clear();
                Object object = BuildSubsetFilesView.this.fSubset != null ? BuildSubsetFilesView.this.fSubset.getBuildDefinition() : (handle = BuildSubsetFilesView.this.fSubsetHandle != null ? BuildSubsetFilesView.this.fSubsetHandle.getBuildDefinition() : null);
                if (handle != null && (buildDef = BuildSubsetFilesView.this.fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)handle, 0, null)) instanceof IBuildDefinition) {
                    BuildSubsetFilesView.this.fFilesViewer.setBuildDefinition((IBuildDefinition)buildDef);
                }
                ISubset resolvedSubset = null;
                try {
                    if (BuildSubsetFilesView.this.fSubset != null || BuildSubsetFilesView.this.fSubsetHandle != null) {
                        ISubset iSubset = resolvedSubset = BuildSubsetFilesView.this.fSubset == null ? BuildSubsetFilesView.this.fSubsetHandle : BuildSubsetFilesView.this.fSubset;
                        if (BuildSubsetFilesView.this.fNeedToResolveDynamicCriteria) {
                            boolean hasDynamic = false;
                            for (ISubsetCriteria criterion : resolvedSubset.getCriteria().getReferences()) {
                                if (!BuildableSubsetUtil.isDynamic((ISubsetCriteria)criterion)) continue;
                                hasDynamic = true;
                                break;
                            }
                            if (hasDynamic) {
                                resolvedSubset = ClientFactory.getBuildableSubsetClient((ITeamRepository)BuildSubsetFilesView.this.fTeamRepository).evaluateSubset(resolvedSubset);
                            }
                        }
                    } else {
                        String slug = BuildableSubsetUtil.getSlug((String)BuildSubsetFilesView.this.fSubsetHandle.getLabel(), (String)BuildSubsetFilesView.this.fSubsetHandle.getBuildDefinition().getItemId().getUuidValue());
                        resolvedSubset = ClientFactory.getBuildableSubsetClient((ITeamRepository)BuildSubsetFilesView.this.fTeamRepository).getSubsetItem(slug);
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().logError(e);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ErrorDialog.openError((Shell)BuildSubsetFilesView.this.getSite().getShell(), (String)Messages.AbstractSubsetFromArtifactAction_ERROR_TITLE, (String)Messages.BuildSubsetFilesView_ERROR_RESOLVING_MSG, (IStatus)new Status(4, "com.ibm.team.enterprise.build.ui", e.getMessage(), (Throwable)e));
                        }
                    });
                    return Status.OK_STATUS;
                }
                if (resolvedSubset != null && resolvedSubset.getFileDescs() != null && !resolvedSubset.getFileDescs().isEmpty()) {
                    BuildSubsetFilesView.this.fFilesViewer.setCriteria(resolvedSubset.getCriteria().getReferences());
                    BuildSubsetFilesView.this.fFilesViewer.getBuildableFiles().addAll(resolvedSubset.getFileDescs());
                    BuildSubsetFilesView.this.fFilesViewer.resolvePaths(BuildSubsetFilesView.this.fFilesViewer.getBuildableFiles());
                }
                final ISubset finalSubset = resolvedSubset;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (finalSubset == null) {
                            String label = BuildSubsetFilesView.this.fSubset == null ? BuildSubsetFilesView.this.fSubsetHandle.getLabel() : BuildSubsetFilesView.this.fSubset.getLabel();
                            MessageDialog.openError((Shell)BuildSubsetFilesView.this.getSite().getShell(), (String)Messages.BuildSubsetDialog_ERROR_TITLE, (String)NLS.bind((String)Messages.BuildableSubsetEditor_NOT_EXIST, (Object)label));
                        } else {
                            String subsetLabel = BuildSubsetFilesView.this.fSubsetLabelOverride;
                            if ((subsetLabel == null || subsetLabel.trim().isEmpty()) && ((subsetLabel = finalSubset.getLabel()) == null || subsetLabel.trim().isEmpty())) {
                                subsetLabel = Messages.BuildSubsetFilesView_NO_SUBSET_LABEL;
                            }
                            String mainLabel = BuildSubsetFilesView.this.fContainsUnsavedChanges ? Messages.BuildSubsetFilesView_FILES_LABEL_UNSAVED : Messages.BuildSubsetFilesView_FILES_LABEL;
                            BuildSubsetFilesView.this.setContentDescription(NLS.bind((String)mainLabel, (Object)subsetLabel, (Object)BuildSubsetFilesView.this.fFilesViewer.getBuildableFiles().size()));
                        }
                        BuildSubsetFilesView.this.fFilesViewer.getFilterText().setText("");
                        BuildSubsetFilesView.this.fFilesViewer.getTableViewer().getTable().setFocus();
                        BuildSubsetFilesView.this.fFilesViewer.getTableViewer().setInput(BuildSubsetFilesView.this.fFilesViewer.getBuildableFiles());
                        (this).BuildSubsetFilesView.this.fParentComposite.layout();
                    }
                });
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
            }
        };
        job.schedule();
    }

    public void setTeamRepository(ITeamRepository fTeamRepository) {
        this.fTeamRepository = fTeamRepository;
    }

    public void setInitialData(ISubset subset, ISubset iSubset, ITeamRepository teamRepository, boolean needToResolveDynamicCriteria, boolean containsUnsavedChanges, String subsetLabelOverride) {
        this.fSubset = subset;
        this.fSubsetHandle = iSubset;
        this.fNeedToResolveDynamicCriteria = needToResolveDynamicCriteria;
        this.fContainsUnsavedChanges = containsUnsavedChanges;
        this.fSubsetLabelOverride = subsetLabelOverride;
        this.fTeamRepository = teamRepository;
        this.fFilesViewer.setTeamRepository(teamRepository);
        this.fRefreshAction.setEnabled(true);
        this.loginAndDisplaySubsetFiles();
    }

    private void loginAndDisplaySubsetFiles() {
        if (this.fConnectedProjectAreas.size() > 0 && this.fTeamRepository != null) {
            if (!this.fTeamRepository.loggedIn()) {
                try {
                    this.fTeamRepository.login(null);
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
            }
            this.initializeSubsetFiles();
        }
    }

    public void connectedProjectAreaRegistryChanged(IConnectedProjectAreaRegistryChangeEvent changeEvent) {
        this.initConnectedProjectAreas();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BuildSubsetFilesView.this.handleProjectAreasChanged();
            }
        });
    }

    protected void handleProjectAreasChanged() {
        if (this.fParentComposite != null && !this.fParentComposite.isDisposed()) {
            if (this.fConnectedProjectAreas.size() == 0) {
                this.showProjectAreaConnectionControl();
            } else if (this.fConnectedProjectAreas.size() != 0 && this.fProjectAreaConnectionControl != null) {
                this.createGuidePage(this.fParentComposite);
            }
        }
    }

    private void initToolbarActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.removeAll();
        this.fRefreshAction = this.createRefreshAction();
        this.fRefreshAction.setEnabled(false);
        this.fRefreshAction.setToolTipText(Messages.BuildableSubsetEditor_ACTION_REFRESH_TOOLTIP);
        toolBarManager.add(this.fRefreshAction);
        this.getViewSite().getActionBars().updateActionBars();
    }

    private IAction createRefreshAction() {
        return new Action(Messages.BuildableSubsetEditor_ACTION_REFRESH){

            public void run() {
                BuildSubsetFilesView.this.loginAndDisplaySubsetFiles();
            }

            public ImageDescriptor getImageDescriptor() {
                return Activator.getImageDescriptor("icons/elcl16/refresh.gif");
            }
        };
    }

    @Override
    public TableData gatherExportData(IProgressMonitor monitor) {
        return this.fFilesViewer.getTableData(monitor);
    }

    public Object getAdapter(Class adapter) {
        if (BuildableFilesViewer.class.equals((Object)adapter)) {
            return this.fFilesViewer;
        }
        if (ITeamRepository.class.equals((Object)adapter)) {
            return this.fTeamRepository;
        }
        if (IBuildDefinition.class.equals((Object)adapter)) {
            return this.fFilesViewer.getBuildDefinition();
        }
        return super.getAdapter(adapter);
    }
}

