/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.dialogs.RequestBuildDialog;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetEditor;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RequestBuildAction
extends Action {
    private final BuildableSubsetEditor fEditor;
    private IBuildDefinition fBuildDefinition;
    private Button fRequestButton;

    public RequestBuildAction(BuildableSubsetEditor editor, IBuildDefinition buildDefinition) {
        super(Messages.BuildableSubsetEditor_ACTION_REQUEST, 1);
        this.fEditor = editor;
        this.fBuildDefinition = buildDefinition;
        this.setToolTipText(Messages.BuildableSubsetEditor_ACTION_REQUEST_TOOLTIP);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/elcl16/rquebuild.gif"));
    }

    public void runWithEvent(Event event) {
        RequestBuildDialog dialog = new RequestBuildDialog(this.getEditor().getEditorSite().getShell(), (IBuildDefinitionHandle)this.getBuildDefinition());
        dialog.open();
    }

    protected BuildableSubsetEditor getEditor() {
        return this.fEditor;
    }

    protected Button getRequestButton() {
        return this.fRequestButton;
    }

    protected FormToolkit getToolkit() {
        return this.fEditor.getToolkit();
    }

    protected IManagedForm getHeaderForm() {
        return this.fEditor.getActivePageInstance().getManagedForm();
    }

    public IBuildDefinition getBuildDefinition() {
        return this.fBuildDefinition;
    }

    public void updateEnabledState() {
        boolean isEnabled = !this.fEditor.isDirty() && !this.fEditor.isNewSubset();
        this.setEnabled(isEnabled);
    }

    public void setBuildDefinition(IBuildDefinition newBuildDefinition) {
        this.fBuildDefinition = newBuildDefinition;
    }
}

