/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset.editors;

import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJobHelper;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetEditorInput;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetEditor;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.repository.common.ItemNotFoundException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;

public class RefreshBuildSubsetJob
extends TeamBuildJob {
    private BuildableSubsetEditor editor;

    public RefreshBuildSubsetJob(BuildableSubsetEditor editor) {
        super(NLS.bind((String)Messages.BuildSubsetNode_JOB_REFRESH, ((BuildSubsetEditorInput)editor.getEditorInput()).getSubset() == null ? null : ((BuildSubsetEditorInput)editor.getEditorInput()).getSubset().getLabel()), true, editor.getTeamRepository());
        this.editor = editor;
    }

    protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!RefreshBuildSubsetJob.this.editor.isDisposed()) {
                    RefreshBuildSubsetJob.this.editor.setBusy(true);
                }
            }
        });
        this.editor.refreshSubset(monitor);
        return Status.OK_STATUS;
    }

    protected String getHeaderMessageTitle(IStatus status) {
        return NLS.bind((String)com.ibm.team.build.internal.ui.editors.Messages.BuildItemEditorJob_JOB_FAILED, (Object)this.getShortName());
    }

    protected void setHeaderMessage(IStatus status) {
        String title = this.getHeaderMessageTitle(status);
        int messageType = status.getSeverity() == 2 ? 2 : 3;
        this.editor.getHeaderForm().getMessageManager().addMessage((Object)title, title, (Object)status, messageType);
    }

    protected void jobFinished(final IStatus status) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!RefreshBuildSubsetJob.this.editor.isDisposed()) {
                    try {
                        if (RefreshBuildSubsetJob.this.isUserInitiated() && (status.getSeverity() == 4 || status.getSeverity() == 2)) {
                            IStatus headerStatus = status;
                            if (RefreshBuildSubsetJob.this.isExpectedStatus(status) && !(status.getException() instanceof ItemNotFoundException)) {
                                headerStatus = TeamBuildJobHelper.convertToWarningStatus((IStatus)status);
                            }
                            headerStatus = TeamBuildJobHelper.createDisplayableStatus((IStatus)headerStatus);
                            RefreshBuildSubsetJob.this.setHeaderMessage(headerStatus);
                        }
                        RefreshBuildSubsetJob.this.editor.handleRefreshComplete();
                    }
                    finally {
                        RefreshBuildSubsetJob.this.editor.setBusy(false);
                    }
                }
            }
        });
    }
}

