/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset.editors;

import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetEditor;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class RefreshAction
extends Action {
    private final BuildableSubsetEditor fEditor;
    private final Shell fEditorShell;

    public RefreshAction(BuildableSubsetEditor editor, Shell editorShell) {
        this.fEditor = editor;
        this.fEditorShell = editorShell;
        this.setImageDescriptor(Activator.getImageDescriptor("icons/elcl16/refresh.gif"));
        this.setToolTipText(Messages.BuildableSubsetEditor_ACTION_REFRESH_TOOLTIP);
    }

    public void run() {
        if (this.fEditor.isDirty() && !this.confirmRefresh()) {
            return;
        }
        this.fEditor.refreshSubset(true);
    }

    protected boolean confirmRefresh() {
        String message = Messages.BuildableSubsetEditor_ACTION_REFRESH_CONFIRM_DESCRIPTION;
        return MessageDialog.openConfirm((Shell)this.fEditorShell, (String)Messages.BuildableSubsetEditor_ACTION_REFRESH_CONFIRM_TITLE, (String)message);
    }

    public void updateEnabledState() {
        boolean isEnabled = !this.fEditor.isNewSubset() && !this.fEditor.isBusy();
        this.setEnabled(isEnabled);
    }
}

