/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.TeamAreaHierarchyException;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class OwnerTreeContentProvider
implements ITreePathContentProvider,
ITreeContentProvider,
IDeferredWorkbenchAdapter {
    private Object fInitialSelection;
    private IBuildDefinition fInitialBuildDef;
    private TreeViewer fTreeViewer;
    private DeferredTreeContentManager fContentManager;
    private StandardLabelProvider fLabelProvider = new StandardLabelProvider(null, (IElementRemovedNotifier)new ElementRemovedNotifierImpl());
    private boolean fIncludeArchived = false;
    private boolean fIncludeTeamsWithNoDevelopmentLine = true;
    private List fAllChildrenFilteredItems = new ArrayList();
    private static final Object[] EMPTY = new Object[0];

    public OwnerTreeContentProvider() {
        this(null, null);
    }

    public OwnerTreeContentProvider(IBuildDefinition buildDef, Object initialElementSelection) {
        this.fInitialSelection = initialElementSelection;
        this.fInitialBuildDef = buildDef;
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        monitor.beginTask("", 1000);
        try {
            collector.add(this.computeChildren(object, (IProgressMonitor)new SubProgressMonitor(monitor, 500)), (IProgressMonitor)new SubProgressMonitor(monitor, 500));
        }
        finally {
            monitor.done();
        }
    }

    private Object[] computeChildren(Object element, IProgressMonitor monitor) {
        Object[] children;
        block7: {
            children = EMPTY;
            try {
                if (element instanceof IProcessArea) {
                    return this.computeProcessAreaChildren((IProcessArea)element, monitor);
                }
                if (element instanceof ITeamAreaHandle || element instanceof IProjectAreaHandle) {
                    ITeamRepository teamRepository = (ITeamRepository)((IItemHandle)element).getOrigin();
                    IItemManager manager = teamRepository.itemManager();
                    IItem area = manager.fetchCompleteItem((IItemHandle)element, 0, monitor);
                    return this.computeChildren(area, monitor);
                }
                if (element instanceof ITeamRepository) {
                    ITeamRepository teamRepository = (ITeamRepository)element;
                    if (!teamRepository.loggedIn() || teamRepository.getErrorState() != 0 || this.fInitialBuildDef == null) break block7;
                    IProcessArea processArea = null;
                    IProcessAreaHandle owningProcessArea = this.fInitialBuildDef.getProcessArea();
                    try {
                        processArea = (IProcessArea)teamRepository.itemManager().fetchPartialItem((IItemHandle)owningProcessArea, 0, Arrays.asList("projectArea"), null);
                    }
                    catch (TeamRepositoryException e) {
                        children = ConnectedProjectAreaRegistry.getDefault().fetchConnectedProjectAreas(teamRepository, true, true, monitor);
                    }
                    children = new Object[]{processArea};
                    break block7;
                }
                children = this.computeConnectedProjectAreas(monitor);
            }
            catch (TeamRepositoryException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.team.enterprise.build.ui", Messages.OwnerTreeContentProvider_ERROR_FETCH, (Throwable)e));
                return new Object[0];
            }
        }
        return children;
    }

    private Object[] computeConnectedProjectAreas(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fInitialBuildDef != null) {
            IProcessArea processArea = null;
            IProcessAreaHandle owningProcessArea = this.fInitialBuildDef.getProcessArea();
            try {
                ITeamRepository repo = (ITeamRepository)this.fInitialBuildDef.getOrigin();
                processArea = (IProcessArea)repo.itemManager().fetchPartialItem((IItemHandle)owningProcessArea, 0, Arrays.asList("projectArea"), null);
                return new Object[]{processArea};
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
            }
        }
        ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        ArrayList<IProjectAreaHandle> repoChildren = new ArrayList<IProjectAreaHandle>();
        int i = 0;
        while (i < repos.length) {
            ITeamRepository teamRepository = repos[i];
            repoChildren.addAll(Arrays.asList(ConnectedProjectAreaRegistry.getDefault().fetchConnectedProjectAreas(teamRepository, true, this.fIncludeArchived, monitor)));
            ++i;
        }
        return repoChildren.toArray();
    }

    private Object[] computeProcessAreaChildren(IProcessArea area, IProgressMonitor monitor) throws TeamRepositoryException {
        List childAreas;
        ITeamRepository teamRepository = (ITeamRepository)area.getOrigin();
        IItemManager manager = teamRepository.itemManager();
        IProjectArea projectArea = null;
        if (area instanceof IProjectArea) {
            projectArea = (IProjectArea)area;
            ArrayList<IContributorHandle> children = new ArrayList<IContributorHandle>(projectArea.getTeamAreaHierarchy().getRoots());
            children.addAll(Arrays.asList(projectArea.getMembers()));
            childAreas = this.shareItems(children, manager, monitor);
        } else {
            ITeamArea teamArea = (ITeamArea)area;
            projectArea = (IProjectArea)manager.fetchCompleteItem((IItemHandle)teamArea.getProjectArea(), 0, monitor);
            ArrayList<IContributorHandle> children = new ArrayList<IContributorHandle>(projectArea.getTeamAreaHierarchy().getChildren((ITeamAreaHandle)teamArea));
            children.addAll(Arrays.asList(teamArea.getMembers()));
            childAreas = this.shareItems(children, manager, monitor);
        }
        if (!(childAreas.size() <= 0 || this.fIncludeTeamsWithNoDevelopmentLine && this.fIncludeArchived)) {
            ListIterator iter = childAreas.listIterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof IContributor) continue;
                ITeamArea child = (ITeamArea)obj;
                IDevelopmentLineHandle developmentLine = projectArea.getTeamAreaHierarchy().getDevelopmentLine((ITeamAreaHandle)child);
                if (developmentLine == null && !this.fIncludeTeamsWithNoDevelopmentLine) {
                    iter.remove();
                    continue;
                }
                if (!child.isArchived() || this.fIncludeArchived) continue;
                iter.remove();
            }
            if (childAreas.size() == 0) {
                this.fAllChildrenFilteredItems.add(area);
            }
        }
        return childAreas.toArray();
    }

    private List shareItems(List itemSet, IItemManager manager, IProgressMonitor monitor) throws TeamRepositoryException {
        List shared = manager.fetchCompleteItems(itemSet, 1, monitor);
        Iterator iter = shared.iterator();
        while (iter.hasNext()) {
            if (iter.next() != null) continue;
            iter.remove();
        }
        return shared;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        Image image = this.fLabelProvider.getImage(element);
        if (image != null) {
            return ImageDescriptor.createFromImage((Image)image);
        }
        return null;
    }

    public String getLabel(Object element) {
        String label = this.fLabelProvider.getText(element);
        if (label == null) {
            label = "";
        }
        return label;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement != null) {
            return this.getChildren(inputElement);
        }
        return EMPTY;
    }

    public void dispose() {
        this.fTreeViewer = null;
        this.fContentManager = null;
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
            this.fLabelProvider = null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fTreeViewer = (TreeViewer)viewer;
    }

    public Object[] getChildren(Object parentElement) {
        DeferredTreeContentManager contentManager = this.getContentManager();
        if (contentManager != null) {
            Object[] children = contentManager.getChildren(parentElement);
            if (children == null) {
                return EMPTY;
            }
            return children;
        }
        if (parentElement instanceof IProjectArea) {
            return ((IProjectArea)parentElement).getTeamAreas().toArray();
        }
        if (parentElement instanceof ITeamArea) {
            return ((ITeamArea)parentElement).getMembers();
        }
        if (parentElement == ConnectedProjectAreaRegistry.getDefault()) {
            ArrayList connectedProjectAreas = new ArrayList();
            ITeamRepository[] teamRepositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            int i = 0;
            while (i < teamRepositories.length) {
                connectedProjectAreas.addAll(ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(teamRepositories[i]));
                ++i;
            }
            return connectedProjectAreas.toArray();
        }
        if (parentElement instanceof ITeamRepository) {
            return ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas((ITeamRepository)parentElement).toArray();
        }
        return new Object[]{""};
    }

    private DeferredTreeContentManager getContentManager() {
        if (this.fContentManager == null && this.fTreeViewer != null) {
            this.fContentManager = new DeferredTreeContentManager((AbstractTreeViewer)this.fTreeViewer){

                protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                    if (OwnerTreeContentProvider.this.hasChildren(element)) {
                        return OwnerTreeContentProvider.this;
                    }
                    return super.getAdapter(element);
                }

                protected PendingUpdateAdapter createPendingUpdateAdapter() {
                    return new PendingUpdateAdapter(){

                        protected void setRemoved(boolean removedValue) {
                            super.setRemoved(removedValue);
                            TreeItem[] allUsers = OwnerTreeContentProvider.this.fTreeViewer.getTree().getItems();
                            int i = 0;
                            while (i < allUsers.length) {
                                String userID;
                                if (allUsers[i] instanceof IContributorHandle && (userID = ((IContributorHandle)allUsers[i].getData()).getItemId().getUuidValue()).equals((String)OwnerTreeContentProvider.this.fInitialSelection)) {
                                    OwnerTreeContentProvider.this.fTreeViewer.getTree().select(allUsers[i]);
                                    break;
                                }
                                ++i;
                            }
                        }
                    };
                }
            };
        }
        return this.fContentManager;
    }

    public Object getParent(Object element) {
        IProjectAreaHandle projectAreaHandle;
        ITeamArea teamArea;
        IItemManager manager;
        IProjectArea projectArea;
        if (element instanceof IProjectArea) {
            return null;
        }
        if (element instanceof ITeamArea && (projectArea = (IProjectArea)(manager = ((ITeamRepository)(teamArea = (ITeamArea)element).getOrigin()).itemManager()).getSharedItemIfKnown((IItemHandle)(projectAreaHandle = teamArea.getProjectArea()))) != null) {
            try {
                ITeamAreaHandle parent = projectArea.getTeamAreaHierarchy().getParent((ITeamAreaHandle)teamArea);
                if (parent != null) {
                    return manager.getSharedItemIfKnown((IItemHandle)parent);
                }
                return projectArea;
            }
            catch (TeamAreaHierarchyException e) {
                return null;
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof PendingUpdateAdapter) {
            return false;
        }
        if (this.fAllChildrenFilteredItems.contains(element)) {
            return false;
        }
        if (element instanceof IItemHandle && !this.repositoryLoggedIn((ITeamRepository)((IItemHandle)element).getOrigin())) {
            return false;
        }
        if (element instanceof ITeamArea) {
            IProjectArea projectArea = this.getProjectArea((ITeamArea)element);
            return projectArea != null && !projectArea.getTeamAreaHierarchy().getChildren((ITeamAreaHandle)element).isEmpty() || ((ITeamArea)element).getMembers().length > 0;
        }
        if (element instanceof IProjectArea) {
            IProjectArea projectArea = (IProjectArea)element;
            return !projectArea.getTeamAreaHierarchy().getRoots().isEmpty() || projectArea.getMembers().length > 0;
        }
        if (element instanceof IProcessAreaHandle || element instanceof ConnectedProjectAreaRegistry) {
            return true;
        }
        if (element instanceof ITeamRepository) {
            return this.repositoryLoggedIn((ITeamRepository)element);
        }
        return false;
    }

    private boolean repositoryLoggedIn(ITeamRepository repository) {
        return repository.getState() == 1 && repository.getErrorState() == 0;
    }

    /*
     * Unable to fully structure code
     */
    private IProjectArea getProjectArea(ITeamArea teamArea) {
        block1: {
            parentInViewer = this.getParent(teamArea);
            if (!(parentInViewer instanceof IProjectArea)) ** GOTO lbl6
            targetProjectArea = (IProjectArea)parentInViewer;
            break block1;
lbl-1000:
            // 1 sources

            {
                parentInViewer = this.getParent(parentInViewer);
lbl6:
                // 2 sources

                ** while (parentInViewer != null && !(parentInViewer instanceof IProjectArea))
            }
lbl7:
            // 1 sources

            targetProjectArea = (IProjectArea)parentInViewer;
        }
        return targetProjectArea;
    }

    public Object[] getChildren(TreePath parentPath) {
        return this.getChildren(parentPath.getLastSegment());
    }

    public TreePath[] getParents(Object element) {
        return new TreePath[0];
    }

    public boolean hasChildren(TreePath path) {
        return this.hasChildren(path.getLastSegment());
    }

    public void setFilters(boolean includeArchived, boolean includeTeamsWithNoDevelopmentLine) {
        this.fIncludeArchived = includeArchived;
        this.fIncludeTeamsWithNoDevelopmentLine = includeTeamsWithNoDevelopmentLine;
        this.fAllChildrenFilteredItems.clear();
        if (this.fTreeViewer != null) {
            this.fTreeViewer.refresh();
        }
    }
}

