/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetEditorInput;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildSubsetOwnerPicker;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildSubsetPermissionDialog;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetEditor;
import com.ibm.team.enterprise.build.ui.subset.editors.IBuildableSubsetEditorPage;
import com.ibm.team.enterprise.buildablesubset.common.internal.model.Visibility;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.ui.editor.TeamFormPage;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class BuildableSubsetOverviewPage
extends TeamFormPage
implements IBuildableSubsetEditorPage {
    private boolean isDirty = false;
    private boolean isInitializing = false;
    private Composite pageComposite;
    private ScrolledForm mainForm;
    private Section detailsSection;
    private Section contentsSection;
    private Label ownerValue;
    private Label visibilityValue;
    Label totalCountLabel;
    private Button ownerBrowse;
    private Button visibilityChange;
    private Text descriptionText;

    public void finishAdd(SelectionStatusDialog dialog) {
    }

    public BuildableSubsetOverviewPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.mainForm = managedForm.getForm();
        Composite body = this.mainForm.getBody();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)body);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(body);
        this.pageComposite = toolkit.createComposite(body);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.pageComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.pageComposite);
        this.createDetailsSection(this.pageComposite, toolkit);
        this.createContentsSection(this.pageComposite, toolkit);
        managedForm.setInput((Object)this.getEditorInput());
    }

    private void createDetailsSection(Composite parent, FormToolkit toolkit) {
        this.detailsSection = toolkit.createSection(parent, 256);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.detailsSection);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.detailsSection);
        this.detailsSection.setText(Messages.BuildableSubsetOverviewPage_SECTION_DETAILS);
        Composite detailsComposite = toolkit.createComposite((Composite)this.detailsSection);
        detailsComposite.setLayoutData((Object)new GridData(768));
        detailsComposite.setLayout((Layout)new GridLayout(3, false));
        this.createDetailsComponents(detailsComposite, toolkit);
        this.detailsSection.setClient((Control)detailsComposite);
    }

    private void createContentsSection(Composite parent, FormToolkit toolkit) {
        this.contentsSection = toolkit.createSection(parent, 384);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.contentsSection);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.contentsSection);
        this.contentsSection.setText(Messages.BuildableSubsetOverviewPage_SECTION_SUMMARY);
        this.contentsSection.setDescription(Messages.BuildableSubsetOverviewPage_SECTION_SUMMARY_EXPLANATION);
        Composite contentsComposite = toolkit.createComposite((Composite)this.contentsSection);
        contentsComposite.setLayoutData((Object)new GridData(768));
        contentsComposite.setLayout((Layout)new GridLayout(2, false));
        this.createContentsComponents(contentsComposite, toolkit);
        this.contentsSection.setClient((Control)contentsComposite);
    }

    private void createDetailsComponents(Composite parent, FormToolkit toolkit) {
        toolkit.createLabel(parent, Messages.BuildableSubsetOverviewPage_LABEL_OWNER);
        this.ownerValue = toolkit.createLabel(parent, Messages.BuildableSubsetOverviewPage_PENDING);
        GridDataFactory.fillDefaults().grab(true, false).indent(5, 5).applyTo((Control)this.ownerValue);
        this.ownerValue.setEnabled(false);
        this.ownerValue.setData(null);
        this.ownerBrowse = toolkit.createButton(parent, Messages.BuildableSubsetOverviewPage_BUTTON_BROWSE, 8);
        this.ownerBrowse.setEnabled(false);
        this.ownerBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String currentOwner = (String)BuildableSubsetOverviewPage.this.ownerValue.getData();
                ITeamRepository repo = ((BuildSubsetEditorInput)BuildableSubsetOverviewPage.this.getEditorInput()).getTeamRepository();
                IBuildDefinition buildDef = ((BuildableSubsetEditor)BuildableSubsetOverviewPage.this.getEditor()).getBuildDefinition();
                BuildSubsetOwnerPicker dialog = new BuildSubsetOwnerPicker(BuildableSubsetOverviewPage.this.getSite().getShell(), repo, buildDef, null, BuildableSubsetOverviewPage.this.ownerValue.getData(), (Visibility)BuildableSubsetOverviewPage.this.visibilityValue.getData());
                if (dialog.open() == 0) {
                    String newOwner = null;
                    IAuditable owner = dialog.getOwner();
                    if (owner != null) {
                        newOwner = owner.getItemId().getUuidValue();
                    }
                    if (newOwner == null || !newOwner.equals(currentOwner)) {
                        if (newOwner == null) {
                            BuildableSubsetOverviewPage.this.ownerValue.setText(Messages.BuildableSubsetOverviewPage_OWNER_DEFAULT);
                        } else {
                            BuildableSubsetOverviewPage.this.ownerValue.setText(((IContributor)owner).getName());
                        }
                        BuildableSubsetOverviewPage.this.ownerValue.setData((Object)newOwner);
                        BuildableSubsetOverviewPage.this.setDirty(true);
                    }
                }
            }
        });
        toolkit.createLabel(parent, Messages.BuildableSubsetOverviewPage_LABEL_VISIBILITY);
        this.visibilityValue = toolkit.createLabel(parent, Messages.BuildableSubsetOverviewPage_PENDING);
        GridDataFactory.fillDefaults().grab(true, false).indent(5, 5).applyTo((Control)this.visibilityValue);
        this.visibilityValue.setEnabled(false);
        this.visibilityValue.setData(null);
        this.visibilityChange = toolkit.createButton(parent, Messages.BuildableSubsetOverviewPage_BUTTON_CHANGE, 8);
        this.visibilityChange.setEnabled(false);
        this.visibilityChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Visibility newVisibility;
                Visibility currentVisibility = (Visibility)BuildableSubsetOverviewPage.this.visibilityValue.getData();
                BuildSubsetPermissionDialog dialog = new BuildSubsetPermissionDialog(BuildableSubsetOverviewPage.this.getSite().getShell(), currentVisibility, BuildableSubsetOverviewPage.this.ownerValue.getData());
                if (dialog.open() == 0 && !(newVisibility = dialog.getVisibility()).equals(currentVisibility)) {
                    BuildableSubsetOverviewPage.this.visibilityValue.setText(newVisibility.equals(Visibility.PRIVATE_LITERAL) ? Messages.BuildableSubsetOverviewPage_LABEL_VISIBILITY_PRIVATE : Messages.BuildableSubsetOverviewPage_LABEL_VISIBILITY_PUBLIC);
                    BuildableSubsetOverviewPage.this.visibilityValue.setData((Object)newVisibility);
                    BuildableSubsetOverviewPage.this.setDirty(true);
                }
            }
        });
        toolkit.createLabel(parent, Messages.BuildableSubsetOverviewPage_LABEL_DESCRIPTION);
        this.descriptionText = toolkit.createText(parent, "", 2626);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 8).indent(5, 5).applyTo((Control)this.descriptionText);
        this.descriptionText.setEnabled(false);
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!BuildableSubsetOverviewPage.this.isInitializing) {
                    BuildableSubsetOverviewPage.this.setDirty(true);
                }
            }
        });
    }

    private Visibility getDefaultVisibility() {
        block5: {
            try {
                IProjectAreaHandle projectAreaHandle;
                BuildSubsetEditorInput input = (BuildSubsetEditorInput)this.getEditorInput();
                ITeamRepository repository = input.getTeamRepository();
                if (repository == null || (projectAreaHandle = input.getProjectAreaHandle()) == null) break block5;
                IProcessArea processArea = (IProcessArea)repository.itemManager().fetchCompleteItem((IItemHandle)projectAreaHandle, 0, null);
                IProcessClientService processService = (IProcessClientService)repository.getClientLibrary(IProcessClientService.class);
                IClientProcess clientProcess = processService.getClientProcess(processArea, null);
                IProcessConfigurationData data = clientProcess.getProjectConfigurationData("com.ibm.team.enterprise.process.configuration.build.subsets", null);
                if (data == null) break block5;
                IProcessConfigurationElement[] elements = data.getElements();
                int i = 0;
                while (i < elements.length) {
                    IProcessConfigurationElement element = elements[i];
                    if ("newSubsets".equals(element.getName())) {
                        String visibility = element.getAttribute("visibility");
                        if ("private".equals(visibility)) {
                            return Visibility.PRIVATE_LITERAL;
                        }
                        break;
                    }
                    ++i;
                }
            }
            catch (TeamRepositoryException e) {
                Activator.getDefault().logError(e);
            }
        }
        return Visibility.PUBLIC_LITERAL;
    }

    private void createContentsComponents(Composite parent, FormToolkit toolkit) {
        Composite overviewComposite = toolkit.createComposite(parent);
        overviewComposite.setLayout((Layout)new GridLayout(2, false));
        List<IBuildableSubsetEditorPage> editorPages = ((BuildableSubsetEditor)this.getEditor()).getEditorPages();
        for (IBuildableSubsetEditorPage editorPage : editorPages) {
            if (editorPage instanceof BuildableSubsetOverviewPage) continue;
            editorPage.populateOverview(overviewComposite, toolkit);
        }
    }

    @Override
    public void editorInitFinished() {
        BuildableSubsetEditor owningEditor = (BuildableSubsetEditor)this.getEditor();
        BuildSubsetEditorInput owningInput = (BuildSubsetEditorInput)owningEditor.getEditorInput();
        ISubset subset = owningInput.getSubset();
        this.initializationJob(owningInput.getTeamRepository(), subset).schedule();
    }

    @Override
    public void updateEnablement() {
        this.updateDetailsEnablement();
    }

    private void updateDetailsEnablement() {
        boolean subsetJobEnableState = !((BuildableSubsetEditor)this.getEditor()).isInitBuildSubsetJobsRunning();
        this.ownerValue.setEnabled(subsetJobEnableState);
        this.ownerBrowse.setEnabled(subsetJobEnableState && ((BuildableSubsetEditor)this.getEditor()).getBuildDefinition() != null);
        this.visibilityValue.setEnabled(subsetJobEnableState);
        this.visibilityChange.setEnabled(subsetJobEnableState);
        this.descriptionText.setEnabled(subsetJobEnableState);
    }

    private Job initializationJob(final ITeamRepository fTeamRepository, final ISubset subset) {
        TeamBuildJob fetchContributorJob = new TeamBuildJob(Messages.BuildableSubsetOverviewPage_JOB_OWNER_TITLE, false, fTeamRepository){
            private IContributor owner;
            private IContributorHandle ownerHandle;
            private Visibility visibility;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.owner = null;
                this.ownerHandle = null;
            }

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                if (subset != null && subset.getOwner() != null) {
                    this.ownerHandle = subset.getOwner();
                    this.owner = (IContributor)fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)this.ownerHandle, 0, monitor);
                } else if (((BuildableSubsetEditor)BuildableSubsetOverviewPage.this.getEditor()).isNewSubset()) {
                    this.owner = fTeamRepository.loggedInContributor();
                }
                this.visibility = ((BuildableSubsetEditor)BuildableSubsetOverviewPage.this.getEditor()).isNewSubset() ? BuildableSubsetOverviewPage.this.getDefaultVisibility() : subset.getVisibility();
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BuildableSubsetOverviewPage.this.isInitializing = true;
                        if (owner == null) {
                            BuildableSubsetOverviewPage.this.ownerValue.setText(Messages.BuildableSubsetOverviewPage_OWNER_DEFAULT);
                        } else {
                            BuildableSubsetOverviewPage.this.ownerValue.setText(owner.getName());
                            BuildableSubsetOverviewPage.this.ownerValue.setData((Object)owner.getItemId().getUuidValue());
                        }
                        BuildableSubsetOverviewPage.this.visibilityValue.setText(visibility.equals(Visibility.PRIVATE_LITERAL) ? Messages.BuildableSubsetOverviewPage_LABEL_VISIBILITY_PRIVATE : Messages.BuildableSubsetOverviewPage_LABEL_VISIBILITY_PUBLIC);
                        BuildableSubsetOverviewPage.this.visibilityValue.setData((Object)visibility);
                        if (subset != null) {
                            BuildableSubsetOverviewPage.this.descriptionText.setText(subset.getDescription() == null ? "" : subset.getDescription());
                        }
                        BuildableSubsetOverviewPage.this.updateDetailsEnablement();
                        BuildableSubsetOverviewPage.this.isInitializing = false;
                    }
                });
            }
        };
        return fetchContributorJob;
    }

    public boolean isDirty() {
        return !this.isDirty ? super.isDirty() : this.isDirty;
    }

    @Override
    public void setDirty(boolean state) {
        this.isDirty = state;
        ((BuildableSubsetEditor)this.getEditor()).fireDirtyPropertyChangeEvent();
    }

    @Override
    public void doSave(ISubset workingSubset, IProgressMonitor monitor) {
        super.doSave(monitor);
        IContributorHandle contributor = this.ownerValue.getData() != null ? (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle(UUID.valueOf((String)((String)this.ownerValue.getData())), null) : null;
        workingSubset.setOwner(contributor);
        workingSubset.setVisibility((Visibility)this.visibilityValue.getData());
        workingSubset.setDescription(this.descriptionText.getText());
    }

    @Override
    public void populateForPreview(ISubset workingSubset) {
    }

    @Override
    public boolean validate(ISubset workingSubset) {
        boolean isWorking = true;
        if (workingSubset.getOwner() == null && workingSubset.getVisibility().equals(Visibility.PRIVATE_LITERAL)) {
            ((BuildableSubsetEditor)this.getEditor()).getHeaderForm().getMessageManager().addMessage((Object)"com.ibm.team.enterprise.build.ui.subset.editors.ERROR_OWNERVISIBILITY_COLLISION", Messages.BuildableSubsetEditor_ERROR_VISIBILITY_TEAMSUBSETS, null, 3, (Control)this.visibilityValue);
            isWorking = false;
            return false;
        }
        return isWorking;
    }

    public IBuildDefinition getDefinitionFromHandle(IBuildDefinitionHandle handle) {
        IBuildDefinition buildDefinition = null;
        try {
            buildDefinition = (IBuildDefinition)((BuildSubsetEditorInput)this.getEditorInput()).getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)handle, 0, null);
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        return buildDefinition;
    }

    @Override
    public void refresh() {
        BuildableSubsetEditor owningEditor = (BuildableSubsetEditor)this.getEditor();
        BuildSubsetEditorInput owningInput = (BuildSubsetEditorInput)owningEditor.getEditorInput();
        ISubset subset = owningInput.getSubset();
        this.ownerValue.setText(Messages.BuildableSubsetOverviewPage_PENDING);
        this.ownerBrowse.setEnabled(false);
        this.initializationJob(owningInput.getTeamRepository(), subset).schedule();
        this.updateEnablement();
        this.setDirty(false);
    }

    @Override
    public void populateOverview(Composite parent, FormToolkit toolkit) {
    }

    @Override
    public void appendInput(BuildSubsetEditorInput input) {
    }

    @Override
    public void buildDefinitionChanged(IBuildDefinition buildDef) {
    }

    public void setFocus() {
        ((BuildableSubsetEditor)this.getEditor()).setFocusInHeader();
    }
}

