/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.build.client.buildablesubset.ClientFactory;
import com.ibm.team.enterprise.build.client.buildablesubset.IBuildableSubsetClient;
import com.ibm.team.enterprise.build.ui.data.export.IQueryResultExportSupplier;
import com.ibm.team.enterprise.build.ui.data.export.TableData;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetDefinitionSelectionDialog;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetEditorInput;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetNode;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetsNode;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildableFilesViewer;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetContentsPage;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetCriteriaPage;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetOverviewPage;
import com.ibm.team.enterprise.build.ui.subset.editors.IBuildableSubsetEditorPage;
import com.ibm.team.enterprise.build.ui.subset.editors.PreviewAction;
import com.ibm.team.enterprise.build.ui.subset.editors.RefreshAction;
import com.ibm.team.enterprise.build.ui.subset.editors.RefreshBuildSubsetJob;
import com.ibm.team.enterprise.build.ui.subset.editors.RequestBuildAction;
import com.ibm.team.enterprise.build.ui.subset.editors.SaveEditorAction;
import com.ibm.team.enterprise.buildablesubset.common.internal.model.Subset;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetCriteria;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetFileDesc;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetHandle;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetUtil;
import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainContentProvider;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.rcp.ui.ProcessAreaSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.ui.editor.TeamFormEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BuildableSubsetEditor
extends TeamFormEditor
implements IQueryResultExportSupplier {
    private static final String WARNING_SPECIFY_FIELDS = "com.ibm.team.enterprise.build.ui.subset.editors.WARNING_SPECIFY_FIELDS";
    private static final String WARNING_EMPTYSUBSET = "com.ibm.team.enterprise.build.ui.subset.editors.WARNING_EMPTYSUBSET";
    private Form fForm;
    public static final String ID = "com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetEditor";
    public static final String ID_PAGE_CONTENTS = "com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetEditor.CONTENTS";
    public static final String ID_PAGE_CRITERIA = "com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetEditor.CRITERIA";
    private boolean isNewSubset = false;
    private boolean initBuildableSubset = true;
    protected BuildableSubsetOverviewPage overviewPage;
    protected BuildableSubsetContentsPage contentsPage;
    protected BuildableSubsetCriteriaPage criteriaPage;
    private ITeamRepository fTeamRepository;
    private IBuildDefinition fBuildDefinition;
    private IBuildDefinitionHandle fBuildDefHandle;
    private BuildSubsetEditorInput editorInput;
    private String fOriginalSubsetID;
    private String fOriginalSubsetBuildDefID;
    private Job createSubsetJob;
    private RefreshBuildSubsetJob refreshSubsetJob;
    private Text idText;
    private Text buildDefinitionText;
    private SaveEditorAction fSaveAction;
    private RequestBuildAction fRequestBuildAction;
    private RefreshAction fRefreshAction;
    private PreviewAction fPreviewAction;
    private List<IBuildableSubsetEditorPage> pages = new ArrayList<IBuildableSubsetEditorPage>();
    private IProjectAreaHandle projectArea;
    private AbstractEnterpriseExtensionsNode fSubsetNode;
    protected int fBusyCount;
    protected boolean fIsDisposed;

    protected void addPages() {
        this.overviewPage = new BuildableSubsetOverviewPage((FormEditor)this, ID, Messages.BuildableSubsetEditor_PAGE_TITLE_OVERVIEW);
        this.pages.add(this.overviewPage);
        this.contentsPage = new BuildableSubsetContentsPage((FormEditor)this, ID_PAGE_CONTENTS, Messages.BuildableSubsetEditor_PAGE_TITLE_CONTENTS);
        this.pages.add(this.contentsPage);
        this.criteriaPage = new BuildableSubsetCriteriaPage((FormEditor)this, ID_PAGE_CRITERIA, Messages.BuildableSubsetEditor_PAGE_TITLE_CRITERIA);
        this.pages.add(this.criteriaPage);
        try {
            for (IBuildableSubsetEditorPage fp : this.pages) {
                this.addPage(fp);
            }
        }
        catch (PartInitException e) {
            StatusUtil.log((Object)this, (Throwable)e);
        }
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        this.createFirstRow(headerForm);
        this.createHeaderSecondRow(headerForm);
        this.validateSubsetWarning();
    }

    protected void createFirstRow(IManagedForm headerForm) {
        this.fForm = headerForm.getForm().getForm();
        FormToolkit toolkit = headerForm.getToolkit();
        toolkit.decorateFormHeading(this.fForm);
        headerForm.getForm().setText(Messages.BuildableSubsetEditor_TITLE);
        IToolBarManager toolbarManager = headerForm.getForm().getToolBarManager();
        this.fRequestBuildAction = new RequestBuildAction(this, this.fBuildDefinition);
        this.fRequestBuildAction.setEnabled(!this.isNewSubset());
        toolbarManager.add((IAction)this.fRequestBuildAction);
        this.fPreviewAction = new PreviewAction(this, this.fForm.getShell());
        this.fPreviewAction.setEnabled(false);
        toolbarManager.add((IAction)this.fPreviewAction);
        this.fRefreshAction = new RefreshAction(this, this.fForm.getShell());
        this.fRefreshAction.setEnabled(!this.isNewSubset());
        toolbarManager.add((IAction)this.fRefreshAction);
        this.fSaveAction = new SaveEditorAction(this);
        toolbarManager.add((IContributionItem)this.fSaveAction);
        toolbarManager.update(false);
        this.addPropertyListener(new DirtyPropertyListener());
    }

    protected void createHeaderSecondRow(IManagedForm headerForm) {
        FormToolkit toolkit = headerForm.getToolkit();
        Composite head = headerForm.getForm().getForm().getHead();
        Composite headerBody = new Composite(head, 0);
        GridLayout layout = new GridLayout(6, false);
        layout.horizontalSpacing = 7;
        headerBody.setLayout((Layout)layout);
        GridData gridData = new GridData();
        headerBody.setLayoutData((Object)gridData);
        Label label = toolkit.createLabel(headerBody, Messages.BuildableSubsetEditor_LABEL_ID);
        label.setBackground(null);
        this.idText = toolkit.createText(headerBody, "");
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 100;
        this.idText.setLayoutData((Object)layoutData);
        this.idText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildableSubsetEditor.this.validateSubsetWarning();
            }
        });
        label = toolkit.createLabel(headerBody, "");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setBackground(null);
        label = this.getToolkit().createLabel(headerBody, Messages.BuildableSubsetEditor_LABEL_BUILDDEFINITION);
        label.setBackground(null);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.buildDefinitionText = this.getToolkit().createText(headerBody, "");
        this.buildDefinitionText.setLayoutData((Object)new GridData(768));
        this.buildDefinitionText.setEditable(false);
        this.buildDefinitionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildableSubsetEditor.this.validateSubsetWarning();
            }
        });
        Button changeDefinitionButton = toolkit.createButton(headerBody, Messages.BuildableSubsetEditor_BUTTON_BROWSE_DEFINITION, 0);
        changeDefinitionButton.addSelectionListener(this.changeDefinitionListener());
        headerForm.getForm().setHeadClient((Control)headerBody);
    }

    private void validateSubsetWarning() {
        if (this.idText.getText().trim().length() == 0 || this.getBuildDefinition() == null) {
            this.getHeaderForm().getMessageManager().addMessage((Object)WARNING_SPECIFY_FIELDS, Messages.BuildableSubsetEditor_WARNING_SPECIFY_FIELDS, null, 2);
        } else {
            this.getHeaderForm().getMessageManager().removeMessage((Object)WARNING_SPECIFY_FIELDS);
        }
    }

    protected SelectionListener changeDefinitionListener() {
        SelectionListener buttonListener = null;
        if (buttonListener == null) {
            buttonListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    BuildSubsetDefinitionSelectionDialog dialog = new BuildSubsetDefinitionSelectionDialog(BuildableSubsetEditor.this.projectArea, BuildableSubsetEditor.this.getSite().getShell());
                    if (dialog.open() == 0) {
                        IBuildDefinition definition = dialog.getFirstSelectedBuildDefinition();
                        BuildableSubsetEditor.this.setBuildDefinition(definition);
                        IBuildableSubsetEditorPage page = (IBuildableSubsetEditorPage)BuildableSubsetEditor.this.getActivePageInstance();
                        if (page != null) {
                            page.setDirty(true);
                        }
                        page.updateEnablement();
                    }
                }
            };
        }
        return buttonListener;
    }

    protected ProcessAreaSelectionDialog getProcessAreaSelectionDialog() {
        ProcessAreaSelectionDialog dialog = new ProcessAreaSelectionDialog(this.getSite().getShell(), false);
        dialog.setAllowArchivedAreas(true);
        return dialog;
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.editorInput = (BuildSubsetEditorInput)input;
        if (this.fTeamRepository == null) {
            this.fTeamRepository = this.editorInput.getTeamRepository();
        }
        if (this.fBuildDefHandle == null) {
            this.fBuildDefHandle = this.editorInput.getBuildDefinitionHandle();
        }
        if (this.fSubsetNode == null) {
            this.fSubsetNode = this.editorInput.getSubsetNode();
        }
        this.projectArea = this.fSubsetNode != null && this.fSubsetNode.getProjectAreaHandle() != null ? this.fSubsetNode.getProjectAreaHandle() : this.editorInput.getProjectAreaHandle();
        if (this.editorInput.getSubset() == null) {
            this.isNewSubset = true;
        }
        this.createSubsetJob = this.createSubsetJob();
        this.createSubsetJob.schedule();
    }

    private Job createSubsetJob() {
        TeamBuildJob fetchSubsetJob = new TeamBuildJob(Messages.EnterpriseRequestBuildSection_JOBNAME_FETCHSUBSETS, false, this.fTeamRepository){
            private ISubset subset;
            private IBuildDefinition buildDefinition;

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                if (BuildableSubsetEditor.this.fBuildDefHandle != null) {
                    this.buildDefinition = (IBuildDefinition)BuildableSubsetEditor.this.fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)BuildableSubsetEditor.this.fBuildDefHandle, 0, monitor);
                }
                if (BuildableSubsetEditor.this.isNewSubset) {
                    IBuildableSubsetClient client = ClientFactory.getBuildableSubsetClient((ITeamRepository)BuildableSubsetEditor.this.fTeamRepository);
                    this.subset = client.createNewSubset();
                    if (this.subset == null) {
                        return new Status(4, "com.ibm.team.enterprise.build.ui", NLS.bind((String)Messages.BuildableSubsetEditor_NOT_EXIST, (Object)BuildableSubsetEditor.this.editorInput.getName()));
                    }
                } else {
                    this.subset = BuildableSubsetEditor.this.editorInput.getSubset();
                }
                return Status.OK_STATUS;
            }

            protected void jobFinished(final IStatus status) {
                BuildableSubsetEditor.this.initBuildableSubset = false;
                BuildableSubsetEditor.this.editorInput.setSubset(this.subset);
                if (!status.isOK()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)BuildableSubsetEditor.this.getEditorSite().getShell(), (String)Messages.BuildSubsetDialog_ERROR_TITLE, (String)status.getMessage());
                            BuildableSubsetEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)BuildableSubsetEditor.this.getEditorSite().getPart(), false);
                        }
                    });
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            String subsetID;
                            String string = subsetID = BuildableSubsetEditor.this.isNewSubset ? "" : subset.getLabel();
                            if (buildDefinition != null) {
                                BuildableSubsetEditor.this.fOriginalSubsetBuildDefID = buildDefinition.getItemId().getUuidValue();
                                BuildableSubsetEditor.this.setBuildDefinition(buildDefinition);
                            }
                            BuildableSubsetEditor.this.fOriginalSubsetID = subsetID;
                            BuildableSubsetEditor.this.idText.setText(subsetID);
                            BuildableSubsetEditor.this.idText.addModifyListener(new ModifyListener(){

                                public void modifyText(ModifyEvent e) {
                                    IBuildableSubsetEditorPage page = (IBuildableSubsetEditorPage)BuildableSubsetEditor.this.getActivePageInstance();
                                    if (page != null) {
                                        page.setDirty(true);
                                    }
                                }
                            });
                            for (IBuildableSubsetEditorPage page : BuildableSubsetEditor.this.getEditorPages()) {
                                page.editorInitFinished();
                            }
                            if (!subsetID.isEmpty()) {
                                BuildableSubsetEditor.this.setPartName(subsetID);
                            }
                            BuildableSubsetEditor.this.firePropertyChange(1);
                            BuildableSubsetEditor.this.fPreviewAction.updateEnabledState();
                        }
                    });
                }
            }
        };
        return fetchSubsetJob;
    }

    protected void createPages() {
        super.createPages();
        if (this.getPageCount() == 1 && this.getContainer() instanceof CTabFolder) {
            ((CTabFolder)this.getContainer()).setTabHeight(0);
        }
        this.setActivePage(this.editorInput.getInitialPageId());
    }

    public void doSave(IProgressMonitor monitor) {
        Subset workingSubset = (Subset)this.editorInput.getSubset().getWorkingCopy();
        workingSubset.setLabel(this.idText.getText());
        IBuildDefinitionHandle handle = this.buildDefinitionText.getData() == null ? null : (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)((String)this.buildDefinitionText.getData())), null);
        workingSubset.setBuildDefinition(handle);
        for (IBuildableSubsetEditorPage page : this.pages) {
            page.doSave((ISubset)workingSubset, monitor);
        }
        if (!this.validate((ISubset)workingSubset)) {
            return;
        }
        Job update = this.createUpdateJob((ISubset)workingSubset);
        update.addJobChangeListener(new IJobChangeListener(){

            public void aboutToRun(IJobChangeEvent event) {
            }

            public void awake(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                BuildableSubsetEditor.this.refreshSubset(false);
            }

            public void running(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void sleeping(IJobChangeEvent event) {
            }
        });
        update.schedule();
    }

    public ISubset createSubsetForPreview() {
        Subset workingSubset = (Subset)this.editorInput.getSubset().getWorkingCopy();
        workingSubset.setLabel(this.idText.getText());
        IBuildDefinitionHandle handle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)((String)this.buildDefinitionText.getData())), null);
        workingSubset.setBuildDefinition(handle);
        for (IBuildableSubsetEditorPage page : this.pages) {
            page.populateForPreview((ISubset)workingSubset);
        }
        return workingSubset;
    }

    private Job createUpdateJob(final ISubset workingSubset) {
        TeamBuildJob updateSubsetJob = new TeamBuildJob(Messages.EnterpriseRequestBuildSection_JOBNAME_GENERALSUBSETS, false, this.fTeamRepository){
            private String errorMessage;
            private String jobTimestamp;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.errorMessage = null;
                this.jobTimestamp = null;
            }

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                IBuildableSubsetClient client = (IBuildableSubsetClient)BuildableSubsetEditor.this.fTeamRepository.getClientLibrary(IBuildableSubsetClient.class);
                try {
                    this.jobTimestamp = client.saveSubset(workingSubset, BuildableSubsetEditor.this.editorInput.getPreviousSubset());
                }
                catch (TeamRepositoryException e) {
                    this.errorMessage = NLS.bind((String)Messages.BuildableSubsetEditor_ERROR_SAVE_GENERIC, (Object)e.getLocalizedMessage());
                }
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (errorMessage != null) {
                            BuildableSubsetEditor.this.getHeaderForm().getMessageManager().addMessage((Object)"com.ibm.team.enterprise.build.ui.subset.editors.ERROR_SAVE_GENERIC", errorMessage, null, 3);
                        } else {
                            for (IBuildableSubsetEditorPage page : BuildableSubsetEditor.this.pages) {
                                page.setDirty(false);
                                if (BuildableSubsetEditor.this.isNewSubset) {
                                    BuildableSubsetEditor.this.isNewSubset = false;
                                }
                                BuildableSubsetEditor.this.fOriginalSubsetID = workingSubset.getLabel();
                                BuildableSubsetEditor.this.fOriginalSubsetBuildDefID = workingSubset.getBuildDefinition().getItemId().getUuidValue();
                            }
                            BuildableSubsetEditor.this.setPartName(workingSubset.getLabel());
                            BuildableSubsetEditor.this.editorInput.setBuildDefinition(BuildableSubsetEditor.this.fBuildDefinition);
                            BuildableSubsetEditor.this.editorInput.setSubset(workingSubset);
                            BuildableSubsetEditor.this.editorInput.setBuildDefinitionHandle(BuildableSubsetEditor.this.fBuildDefHandle);
                        }
                        if (BuildableSubsetEditor.this.fSubsetNode != null) {
                            AbstractEnterpriseExtensionsNode nodeToRefresh;
                            if (BuildableSubsetEditor.this.fSubsetNode instanceof BuildSubsetNode) {
                                ((BuildSubsetNode)BuildableSubsetEditor.this.fSubsetNode).setBuildableSubset(workingSubset);
                            }
                            if ((nodeToRefresh = (AbstractEnterpriseExtensionsNode)BuildableSubsetEditor.this.fSubsetNode.getParent()) == null && BuildableSubsetEditor.this.fSubsetNode instanceof BuildSubsetsNode) {
                                nodeToRefresh = BuildableSubsetEditor.this.fSubsetNode;
                            }
                            if (nodeToRefresh != null) {
                                ((EnterpriseExtensionsDomainContentProvider)BuildableSubsetEditor.this.fSubsetNode.getDomain().getContentProvider()).updateTreeViewer(nodeToRefresh);
                            }
                        }
                        BuildableSubsetEditor.this.fireDirtyPropertyChangeEvent();
                    }
                });
            }
        };
        return updateSubsetJob;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isInitBuildSubsetJobsRunning() {
        return this.initBuildableSubset;
    }

    public List<IBuildableSubsetEditorPage> getEditorPages() {
        return this.pages;
    }

    public boolean isDirty() {
        return super.isDirty() || this.isNewSubset;
    }

    public void fireDirtyPropertyChangeEvent() {
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
    }

    public void refreshSubset(boolean removeMessages) {
        if (removeMessages) {
            this.getHeaderForm().getMessageManager().removeAllMessages();
        }
        this.refreshSubsetJob = new RefreshBuildSubsetJob(this);
        this.refreshSubsetJob.schedule();
    }

    public void refreshSubset(IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.isNewSubset) {
            IBuildableSubsetClient client = ClientFactory.getBuildableSubsetClient((ITeamRepository)this.fTeamRepository);
            ISubset subset = client.getSubsetItem((ISubsetHandle)this.editorInput.getSubset(), this.fTeamRepository);
            if (subset == null) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.BuildableSubsetEditor_NOT_EXIST, (Object)this.fOriginalSubsetID));
            }
            this.editorInput.setSubset(subset);
            this.fBuildDefinition = (IBuildDefinition)this.fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)subset.getBuildDefinition(), 0, monitor);
        }
    }

    public void handleRefreshComplete() {
        this.fOriginalSubsetID = this.editorInput.getSubset().getLabel();
        this.idText.setText(this.editorInput.getSubset().getLabel());
        this.fOriginalSubsetBuildDefID = this.fBuildDefinition.getItemId().getUuidValue();
        this.setBuildDefinition(this.fBuildDefinition);
        if (this.pages != null) {
            for (IBuildableSubsetEditorPage currPage : this.pages) {
                currPage.refresh();
            }
            this.fireDirtyPropertyChangeEvent();
        }
    }

    public void setBusy(boolean isBusy) {
        if (!this.isDisposed()) {
            if (this.fBusyCount == 0 && isBusy) {
                this.getHeaderForm().getForm().setBusy(true);
            } else if (this.fBusyCount == 1 && !isBusy) {
                this.getHeaderForm().getForm().setBusy(false);
            }
            if (isBusy) {
                ++this.fBusyCount;
            } else if (this.fBusyCount > 0) {
                --this.fBusyCount;
            }
        }
        this.fSaveAction.updateEnabledState();
        this.fRefreshAction.updateEnabledState();
        this.fPreviewAction.updateEnabledState();
        this.fRequestBuildAction.updateEnabledState();
    }

    public boolean isBusy() {
        return this.fBusyCount > 0;
    }

    private boolean validate(ISubset workingSubset) {
        this.getHeaderForm().getMessageManager().removeAllMessages();
        boolean isWorking = true;
        if (this.idText.getText().trim().length() == 0) {
            this.getHeaderForm().getMessageManager().addMessage((Object)"com.ibm.team.enterprise.build.ui.subset.editors.ERROR_INVALID_ID", Messages.BuildableSubsetEditor_ERROR_ID_MISSING, null, 3, (Control)this.idText);
            isWorking = false;
        }
        if (this.getBuildDefinition() == null) {
            this.getHeaderForm().getMessageManager().addMessage((Object)"com.ibm.team.enterprise.build.ui.subset.editors.ERROR_NO_BUILD_DEF", Messages.BuildSubsetDialog_ERROR_NOBUILDDEF, null, 3, (Control)this.buildDefinitionText);
            isWorking = false;
        }
        for (IBuildableSubsetEditorPage p : this.pages) {
            boolean bl = isWorking = p.validate(workingSubset) && isWorking;
        }
        int contentCount = this.contentsPage.getFileCount();
        int criteriaCount = this.criteriaPage.getCriteriaCount(true);
        if (contentCount == 0 && criteriaCount == 0) {
            this.getHeaderForm().getMessageManager().addMessage((Object)WARNING_EMPTYSUBSET, Messages.BuildSubsetDialog_WARNING_EMPTYSUBSET, null, 2, this.overviewPage.getPartControl());
        }
        return isWorking;
    }

    public boolean isNewSubset() {
        return this.isNewSubset;
    }

    private boolean subsetExists() {
        return this.editorInput.getSubset() != null;
    }

    public IBuildDefinition getBuildDefinition() {
        return this.fBuildDefinition;
    }

    String getCurrentLabel() {
        return this.idText.getText();
    }

    String getCurrentBuildDefinitionUUID() {
        return (String)this.buildDefinitionText.getData();
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    protected void processAdditions(ISubset subset) {
        List<ISubsetCriteria> criteria;
        List<ISubsetFileDesc> files = this.contentsPage.getBuildableFileList();
        BuildableSubsetUtil.SubsetMergeResults2 mergeResults = BuildableSubsetUtil.merge3(files, criteria = this.criteriaPage.getCurrentCriteria(), (ISubset)(subset.isWorkingCopy() ? subset : (ISubset)subset.getWorkingCopy()));
        if (mergeResults != null) {
            this.criteriaPage.processAdditions(mergeResults.addedCriteria, false);
            this.contentsPage.processAdditions(mergeResults.addedAndMergedFiles, false);
        }
    }

    public void appendInput(BuildSubsetEditorInput input) {
        if (input != null) {
            for (IBuildableSubsetEditorPage p : this.pages) {
                p.appendInput(input);
            }
        }
    }

    private void setBuildDefinition(IBuildDefinition buildDef) {
        this.fBuildDefinition = buildDef;
        this.fBuildDefHandle = (IBuildDefinitionHandle)buildDef.getItemHandle();
        this.editorInput.setBuildDefinition(this.fBuildDefinition);
        this.editorInput.setBuildDefinitionHandle(this.fBuildDefHandle);
        this.buildDefinitionText.setData((Object)this.fBuildDefinition.getItemId().getUuidValue());
        this.buildDefinitionText.setText(this.fBuildDefinition.getId());
        this.fRequestBuildAction.setBuildDefinition(this.fBuildDefinition);
        for (IBuildableSubsetEditorPage p : this.pages) {
            p.buildDefinitionChanged(buildDef);
        }
    }

    public void setFocus() {
        int pageIndex = this.getActivePage();
        if (pageIndex != -1) {
            IFormPage page = this.pages.get(pageIndex);
            page.setFocus();
        } else {
            super.setFocus();
        }
    }

    public void setFocusInHeader() {
        if (this.idText != null) {
            this.idText.setFocus();
        }
    }

    public boolean isDisposed() {
        return this.fIsDisposed;
    }

    public void dispose() {
        this.fIsDisposed = true;
        if (this.createSubsetJob != null) {
            this.createSubsetJob.cancel();
        }
        if (this.refreshSubsetJob != null) {
            this.refreshSubsetJob.cancel();
        }
        super.dispose();
    }

    @Override
    public TableData gatherExportData(IProgressMonitor monitor) {
        BuildableFilesViewer viewer = (BuildableFilesViewer)this.contentsPage.getAdapter(BuildableFilesViewer.class);
        if (viewer != null) {
            return viewer.getTableData(monitor);
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (IBuildDefinition.class.equals((Object)adapter)) {
            return this.fBuildDefinition;
        }
        if (ITeamRepository.class.equals((Object)adapter)) {
            return this.fTeamRepository;
        }
        for (IBuildableSubsetEditorPage page : this.pages) {
            Object adapted = page.getAdapter(adapter);
            if (adapted == null) continue;
            return adapted;
        }
        return super.getAdapter(adapter);
    }

    protected class DirtyPropertyListener
    implements IPropertyListener {
        protected DirtyPropertyListener() {
        }

        public void propertyChanged(Object source, int propertyId) {
            if (source instanceof IEditorPart && propertyId == 257) {
                BuildableSubsetEditor.this.fSaveAction.updateEnabledState();
                BuildableSubsetEditor.this.fRefreshAction.updateEnabledState();
                BuildableSubsetEditor.this.fRequestBuildAction.updateEnabledState();
                BuildableSubsetEditor.this.fPreviewAction.updateEnabledState();
                BuildableSubsetEditor.this.fForm.updateToolBar();
            }
        }
    }
}

