/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.build.ui.dialogs.AddFileToSubsetSummaryDialog;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetEditorInput;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetWorkItemSelectionDialog;
import com.ibm.team.enterprise.build.ui.subset.dnd.BuildSubsetCriteriaDragSourceAdapter;
import com.ibm.team.enterprise.build.ui.subset.dnd.BuildSubsetCriteriaDropTargetAdapter;
import com.ibm.team.enterprise.build.ui.subset.dnd.BuildSubsetFilesDropTargetAdapter;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetEditor;
import com.ibm.team.enterprise.build.ui.subset.editors.IBuildableSubsetEditorPage;
import com.ibm.team.enterprise.build.ui.subset.views.BuildSubsetFilesView;
import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.model.ICriteriaSubset;
import com.ibm.team.enterprise.buildablesubset.common.model.ICriteriaWorkItem;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetCriteria;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetFileDesc;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetUtil;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.ide.ui.EditorUtilities;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPage;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.explorer.Utils;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ItemComparer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class BuildableSubsetCriteriaPage
extends TeamFormPage
implements IBuildableSubsetEditorPage,
BuildSubsetFilesDropTargetAdapter.IBuildSubsetDropTargetContext {
    private static final String EMPTY_STRING = "";
    private static final int COLUMN_ID = 0;
    private static final int COLUMN_SUMMARY = 1;
    private static final int COLUMN_OWNER = 2;
    private static final int COLUMN_CREATOR = 3;
    private static final int COLUMN_IMPACTED = 4;
    private static final int COLUMN_CHILDREN = 5;
    private boolean isDirty = false;
    private Composite pageComposite;
    private ScrolledForm mainForm;
    private Section criteriaSection;
    private TreeViewer criteriaViewer;
    private Composite criteriaActionComposite;
    private Button addButton;
    private Button removeButton;
    private Button previewButton;
    Link totalCountLabel;
    private Set<Criteria> fCriteria;
    private Map<UUID, IContributor> fContributors = new HashMap<UUID, IContributor>();
    private BuildSubsetWorkItemSelectionDialog dialog;
    private Tree fCriteriaTree;
    private Composite criteriaViewComposite;
    private Link overviewWICriteriaSummary;
    private Label overviewWILabel;
    private TreeColumn fDefaultSort;
    private Link overviewWIFileSummary;
    private Job currentCriteriaJob;
    private final Object jobSync = new Object();
    private Control msgPermission2SaveDynamicCriteria;
    private static final String CELL_EDITING_ENABLED = "cellEditingEnabled";
    private static final String DROP_SUPPORT_ADAPTER = "dropSupportAdapter";
    private static final int MAX_SIZE_OF_WORKITEMS_TO_HANDLES_MAP = 50;
    public static final String CONTRIBUTOR_MAP = "BuildableSubsetCriteriaPage.CONTRIBUTOR_MAP";
    private static WorkItemIDMap mapWorkItemsToHandles_ = new WorkItemIDMap();
    private ControlDecoration msgPermission2SaveDynamicCriteriaDecorator;

    private Integer criteriaComparator(Viewer viewer, Object e1, Object e2, int colIndex, int sortDir) {
        try {
            Criteria c1 = (Criteria)e1;
            Criteria c2 = (Criteria)e2;
            int result = 0;
            switch (colIndex) {
                case 0: {
                    result = Integer.valueOf(this.getWINumber(e1)).compareTo((int)this.getWINumber(e2));
                    return sortDir == 128 ? result : result * -1;
                }
                case 1: {
                    result = c1.workItem.getHTMLSummary().getPlainText().compareTo(c2.workItem.getHTMLSummary().getPlainText());
                    return sortDir == 128 ? result : result * -1;
                }
                case 4: {
                    boolean b1 = ((ICriteriaWorkItem)c1.criteria).isIncludeImpacted();
                    boolean b2 = ((ICriteriaWorkItem)c2.criteria).isIncludeImpacted();
                    result = Boolean.valueOf(b1).compareTo(b2);
                    return sortDir == 128 ? result : result * -1;
                }
                case 5: {
                    boolean b1 = ((ICriteriaWorkItem)c1.criteria).isIncludeChildren();
                    boolean b2 = ((ICriteriaWorkItem)c2.criteria).isIncludeChildren();
                    result = Boolean.valueOf(b1).compareTo(b2);
                    return sortDir == 128 ? result : result * -1;
                }
                case 3: {
                    Map fContributors = (Map)viewer.getData(CONTRIBUTOR_MAP);
                    String name1 = ((IContributor)fContributors.get(c1.workItem.getOwner().getItemId())).getName();
                    String name2 = ((IContributor)fContributors.get(c2.workItem.getOwner().getItemId())).getName();
                    result = name1.compareTo(name2);
                    return sortDir == 128 ? result : result * -1;
                }
                case 2: {
                    Map fContributors = (Map)viewer.getData(CONTRIBUTOR_MAP);
                    String name1 = ((IContributor)fContributors.get(c1.workItem.getOwner().getItemId())).getName();
                    String name2 = ((IContributor)fContributors.get(c2.workItem.getOwner().getItemId())).getName();
                    result = name1.compareTo(name2);
                    return sortDir == 128 ? result : result * -1;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void finishAdd(ISubset addResultsTempSubset) {
        ((BuildableSubsetEditor)this.getEditor()).processAdditions(addResultsTempSubset);
    }

    public void processAdditions(List<ISubsetCriteria> addedCriteria, boolean isRefresh) {
        if (this.fCriteria == null || isRefresh) {
            this.fCriteria = new HashSet<Criteria>(addedCriteria.size());
        }
        if (addedCriteria != null && !addedCriteria.isEmpty()) {
            this.fCriteria.addAll(BuildableSubsetCriteriaPage.initCriteria(addedCriteria));
            this.resolveCriteriaJob(addedCriteria).schedule();
            if (!isRefresh) {
                this.setDirty(true);
            }
        }
        if (this.criteriaViewer != null && !this.criteriaViewer.getTree().isDisposed()) {
            if (isRefresh) {
                this.criteriaViewer.getTree().removeAll();
            }
            this.criteriaViewer.setInput(this.fCriteria);
            this.criteriaViewer.refresh(true);
        }
        this.updateEnablement();
        this.updateCount();
    }

    public void processRemovals(List<ISubsetCriteria> toRemove) {
        if (this.fCriteria == null || this.fCriteria.isEmpty() || toRemove == null || toRemove.isEmpty()) {
            return;
        }
        boolean refresh = false;
        block0: for (ISubsetCriteria nextRemoved : toRemove) {
            Iterator<Criteria> it = this.fCriteria.iterator();
            while (it.hasNext()) {
                Criteria next = it.next();
                if (!next.criteria.equals(nextRemoved)) continue;
                it.remove();
                refresh = true;
                continue block0;
            }
        }
        if (refresh) {
            ((BuildableSubsetEditor)this.getEditor()).contentsPage.updateCurrentCriteria(this.getCurrentCriteria());
        }
        if (refresh && this.criteriaViewer != null && !this.criteriaViewer.getTree().isDisposed()) {
            this.criteriaViewer.setInput(this.fCriteria);
            this.criteriaViewer.refresh(true);
        }
        this.updateCount();
    }

    public void finishAdd(BuildSubsetWorkItemSelectionDialog dialog) {
        if (dialog != null && dialog.getResultSubset(this.getTargetSubset()) != null) {
            this.finishAdd(dialog.getResultSubset(this.getTargetSubset()));
        }
    }

    @Override
    public void drop(ISubset subset) {
        this.finishAdd(subset);
    }

    @Override
    public ISubset getTargetSubset() {
        return (ISubset)this.getSubsetInput().getSubset().getWorkingCopy();
    }

    @Override
    public IBuildDefinitionHandle getBuildDefinitionHandle() {
        return this.getSubsetInput().getBuildDefinitionHandle();
    }

    public BuildableSubsetCriteriaPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.mainForm = managedForm.getForm();
        Composite body = this.mainForm.getBody();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)body);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(body);
        this.pageComposite = toolkit.createComposite(body);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.pageComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.pageComposite);
        this.createCriteriaSection(this.pageComposite, toolkit);
        managedForm.setInput((Object)this.getEditorInput());
    }

    private void createCriteriaSection(Composite parent, FormToolkit toolkit) {
        this.criteriaSection = toolkit.createSection(parent, 384);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.criteriaSection);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.criteriaSection);
        this.criteriaSection.setText(Messages.BuildableSubsetCriteriaPage_SECTION_CONTENTS);
        this.criteriaSection.setDescription(Messages.BuildableSubsetCriteriaPage_SECTION_CRITERIA_EXPLANATION);
        Composite criteriaComposite = toolkit.createComposite((Composite)this.criteriaSection);
        criteriaComposite.setLayoutData((Object)new GridData(768));
        criteriaComposite.setLayout((Layout)new GridLayout(2, false));
        this.createCriteriaComponents(criteriaComposite, toolkit);
        this.criteriaSection.setClient((Control)criteriaComposite);
        this.applyDefaultSortIfNeeded();
        this.criteriaViewer.setInput(this.fCriteria);
        this.criteriaViewer.refresh(true);
    }

    private void createCriteriaComponents(Composite parent, FormToolkit toolkit) {
        this.msgPermission2SaveDynamicCriteria = toolkit.createLabel(parent, Messages.BuildableSubsetCriteriaPage_MSG_PERMISSION_TO_SAVE_DYNAMIC_CRITERIA);
        this.msgPermission2SaveDynamicCriteria.setForeground(Display.getDefault().getSystemColor(8));
        GridDataFactory.fillDefaults().span(2, 1).applyTo(this.msgPermission2SaveDynamicCriteria);
        this.msgPermission2SaveDynamicCriteriaDecorator = new ControlDecoration(this.msgPermission2SaveDynamicCriteria, 16384);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
        Image img = fieldDecoration.getImage();
        this.msgPermission2SaveDynamicCriteriaDecorator.setImage(img);
        this.msgPermission2SaveDynamicCriteriaDecorator.setDescriptionText(Messages.BuildableSubsetCriteriaPage_MSG_PERMISSION_TO_SAVE_DYNAMIC_CRITERIA);
        this.totalCountLabel = new Link(parent, 16384);
        this.totalCountLabel.setEnabled(true);
        this.totalCountLabel.setBackground(parent.getBackground());
        this.totalCountLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildableSubsetCriteriaPage.this.displayWorkItemViewer(true);
            }
        });
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.totalCountLabel);
        Composite criteriaComposite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)criteriaComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(criteriaComposite);
        this.criteriaViewComposite = toolkit.createComposite(criteriaComposite);
        this.fCriteriaTree = toolkit.createTree(this.criteriaViewComposite, 268503810);
        this.fCriteriaTree.setLinesVisible(true);
        this.fCriteriaTree.setHeaderVisible(true);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        this.criteriaViewComposite.setLayout((Layout)treeColumnLayout);
        this.criteriaViewer = new TreeViewer(this.fCriteriaTree);
        this.criteriaViewer.setComparer((IElementComparer)new ItemComparer());
        this.criteriaViewer.setUseHashlookup(true);
        this.criteriaViewer.setContentProvider((IContentProvider)new CriteriaContentProvider(this.criteriaViewer));
        this.criteriaViewer.setData(CONTRIBUTOR_MAP, this.fContributors);
        BuildSubsetCriteriaDropTargetAdapter dropAdapter = BuildSubsetCriteriaDropTargetAdapter.installDropSupport((StructuredViewer)this.criteriaViewer, this.getTeamRepository(), this);
        this.criteriaViewer.setData(DROP_SUPPORT_ADAPTER, (Object)dropAdapter);
        BuildSubsetCriteriaDragSourceAdapter.installDragSupport((StructuredViewer)this.criteriaViewer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.criteriaViewer.getControl());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.criteriaViewComposite);
        this.fDefaultSort = this.createTreeColumn(this.fCriteriaTree, this.criteriaViewer, treeColumnLayout, Messages.BuildableSubsetCriteriaPage_WI_COLUMN_ID, 5, 16384, 0, Messages.BuildableSubsetCriteriaPage_WI_COLUMN_ID, 0);
        this.createTreeColumn(this.fCriteriaTree, this.criteriaViewer, treeColumnLayout, Messages.BuildableSubsetCriteriaPage_WI_COLUMN_SUMMARY, 30, 16384, 1, Messages.BuildableSubsetCriteriaPage_WI_COLUMN_SUMMARY, 0);
        this.createTreeColumn(this.fCriteriaTree, this.criteriaViewer, treeColumnLayout, Messages.BuildableSubsetCriteriaPage_WI_COLUMN_OWNER, 20, 16384, 2, Messages.BuildableSubsetCriteriaPage_WI_COLUMN_OWNER, 0);
        this.createTreeColumn(this.fCriteriaTree, this.criteriaViewer, treeColumnLayout, Messages.BuildableSubsetCriteriaPage_WI_COLUMN_CREATOR, 20, 16384, 3, Messages.BuildableSubsetCriteriaPage_WI_COLUMN_CREATOR, 0);
        TreeColumn treeColumn = this.createTreeColumn(this.fCriteriaTree, this.criteriaViewer, treeColumnLayout, Messages.BuildableSubsetCriteriaPage_WI_COLUMN_IMPACTED, 10, 16384, 4, Messages.BuildableSubsetCriteriaPage_WI_COLUMN_IMPACTED, 0);
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this.criteriaViewer, treeColumn);
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        viewerColumn.setEditingSupport((EditingSupport)new ComboEditSupport((ColumnViewer)this.criteriaViewer){

            @Override
            protected void updateModel(Object element, Object value) {
                if (((Integer)value).compareTo((Integer)this.getValue(element)) != 0) {
                    ((ICriteriaWorkItem)((Criteria)element).criteria).setIncludeImpacted((Integer)value == 0);
                    BuildableSubsetCriteriaPage.this.setDirty(true);
                }
            }

            @Override
            protected Object getValue(Object element) {
                return ((ICriteriaWorkItem)((Criteria)element).criteria).isIncludeImpacted() ? 0 : 1;
            }
        });
        treeColumn = this.createTreeColumn(this.fCriteriaTree, this.criteriaViewer, treeColumnLayout, Messages.BuildableSubsetCriteriaPage_WI_COLUMN_CHILDREN, 10, 16384, 5, Messages.BuildableSubsetCriteriaPage_WI_COLUMN_CHILDREN, 0);
        viewerColumn = new TreeViewerColumn(this.criteriaViewer, treeColumn);
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        viewerColumn.setEditingSupport((EditingSupport)new ComboEditSupport((ColumnViewer)this.criteriaViewer){

            @Override
            protected void updateModel(Object element, Object value) {
                if (((Integer)value).compareTo((Integer)this.getValue(element)) != 0) {
                    ((ICriteriaWorkItem)((Criteria)element).criteria).setIncludeChildren((Integer)value == 0);
                    BuildableSubsetCriteriaPage.this.setDirty(true);
                }
            }

            @Override
            protected Object getValue(Object element) {
                return ((ICriteriaWorkItem)((Criteria)element).criteria).isIncludeChildren() ? 0 : 1;
            }
        });
        this.criteriaViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        ViewerFilter[] filters = new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof Criteria) {
                    return BuildableSubsetCriteriaPage.isViewable(((Criteria)element).criteria);
                }
                return true;
            }
        }};
        this.criteriaViewer.setFilters(filters);
        TreeViewerEditor.create((TreeViewer)this.criteriaViewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.criteriaViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 2;
            }
        }, (int)1);
        this.criteriaViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BuildableSubsetCriteriaPage.this.updateEnablement();
            }
        });
        new TooltipSupport((Control)this.criteriaViewer.getTree(), true, true){

            protected Object mapElement(int x, int y) {
                Object result = null;
                Point point = new Point(x, y);
                TreeItem item = BuildableSubsetCriteriaPage.this.criteriaViewer.getTree().getItem(point);
                if (item == null) {
                    return null;
                }
                result = item.getData();
                Utils.ColumnPosition columnPosition = Utils.mapColumn((Tree)BuildableSubsetCriteriaPage.this.criteriaViewer.getTree(), (int)x);
                if (columnPosition != null) {
                    switch (columnPosition.creationIndex) {
                        case 2: {
                            result = ((Criteria)result).workItem.getOwner();
                            break;
                        }
                        case 3: {
                            result = ((Criteria)result).workItem.getCreator();
                            break;
                        }
                    }
                }
                return result;
            }

            protected String getMarkup(Object element, boolean isFocus) {
                if (element instanceof String) {
                    return (String)element;
                }
                IWorkItemHandle wiHandle = BuildableSubsetCriteriaPage.this.getWIHandle(element);
                return super.getMarkup(wiHandle != null ? wiHandle : element, isFocus);
            }

            protected void openRequested(Object element) {
                if (element instanceof IContributorHandle) {
                    EditorUtilities.openContributorEditor((IWorkbenchPage)BuildableSubsetCriteriaPage.this.getEditorSite().getPage(), (IContributorHandle)((IContributorHandle)element), null);
                } else {
                    BuildableSubsetCriteriaPage.this.openWorkItem(element);
                }
            }
        };
        this.criteriaViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection extended = (IStructuredSelection)selection;
                    Object element = extended.getFirstElement();
                    BuildableSubsetCriteriaPage.this.openWorkItem(element);
                }
            }
        });
        this.criteriaActionComposite = toolkit.createComposite(criteriaComposite);
        GridDataFactory.fillDefaults().grab(false, true).align(4, 4).applyTo((Control)this.criteriaActionComposite);
        GridLayoutFactory.fillDefaults().applyTo(this.criteriaActionComposite);
        this.addButton = toolkit.createButton(this.criteriaActionComposite, Messages.BuildableSubsetCriteriaPage_BUTTON_ADD, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.addButton);
        this.addButton.setEnabled(((BuildableSubsetEditor)this.getEditor()).isNewSubset());
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new AddCriteriaWithWorkItemsAction().run();
            }
        });
        this.removeButton = toolkit.createButton(this.criteriaActionComposite, Messages.BuildableSubsetCriteriaPage_BUTTON_REMOVE, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.removeButton);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildableSubsetCriteriaPage.this.deleteSelectedWorkItems();
            }
        });
        this.criteriaViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    BuildableSubsetCriteriaPage.this.deleteSelectedWorkItems();
                }
            }
        });
        this.previewButton = toolkit.createButton(this.criteriaActionComposite, Messages.BuildableSubsetCriteriaPage_BUTTON_PREVIEW, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.previewButton);
        this.previewButton.setEnabled(false);
        this.previewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildableSubsetEditor editor = (BuildableSubsetEditor)BuildableSubsetCriteriaPage.this.getEditor();
                ISubset subset = (ISubset)((BuildSubsetEditorInput)BuildableSubsetCriteriaPage.this.getEditorInput()).getSubset().getWorkingCopy();
                subset.setLabel(editor.getCurrentLabel());
                subset.setBuildDefinition(BuildableSubsetCriteriaPage.this.getBuildDefinitionHandle());
                IStructuredSelection listSelection = (IStructuredSelection)BuildableSubsetCriteriaPage.this.criteriaViewer.getSelection();
                ArrayList<Integer> workItems = new ArrayList<Integer>(listSelection.size());
                BuildableSubsetCriteriaPage.this.addCriteriaToWorkingSubset(subset);
                for (Object o : listSelection.toList()) {
                    if (!(o instanceof Criteria)) continue;
                    Criteria criterion = (Criteria)o;
                    if (criterion.workItem == null) continue;
                    workItems.add(criterion.workItem.getId());
                }
                if (subset.getCriteria().getReferences().isEmpty()) {
                    return;
                }
                Collections.sort(workItems);
                StringBuilder label = new StringBuilder(8 * workItems.size());
                for (Integer wi : workItems) {
                    if (label.length() > 0) {
                        label.append(", ");
                    }
                    label.append(wi);
                }
                List buildableFiles = subset.getFileDescs();
                subset.getFileDescs().clear();
                BuildSubsetFilesView.displayBuildSubsetFilesView(subset, ((BuildSubsetEditorInput)BuildableSubsetCriteriaPage.this.getEditorInput()).getTeamRepository(), true, false, NLS.bind((String)Messages.BuildSubsetFilesView_WORK_ITEMS_LABEL, (Object)label.toString(), (Object[])new Object[0]));
                subset.getFileDescs().addAll(buildableFiles);
            }
        });
        this.createContextMenu((ISelectionProvider)this.criteriaViewer, this.criteriaViewer.getControl());
        this.updateEnablement();
        this.updateCount();
    }

    private void deleteSelectedWorkItems() {
        IStructuredSelection listSelection = (IStructuredSelection)this.criteriaViewer.getSelection();
        this.setDirty(true);
        this.fCriteria.removeAll(listSelection.toList());
        this.updateCount();
        this.removeButton.setEnabled(this.fCriteria.size() > 0);
        this.criteriaViewer.setInput(this.fCriteria);
    }

    private boolean hasPermission2SaveDynamicCriteria() {
        try {
            BuildSubsetEditorInput input = (BuildSubsetEditorInput)this.getEditorInput();
            ITeamRepository repository = input.getTeamRepository();
            IBuildDefinition buildDefinition = ((BuildableSubsetEditor)this.getEditor()).getBuildDefinition();
            Object processAreaHandle = buildDefinition != null ? buildDefinition.getProcessArea() : input.getProjectAreaHandle();
            IProcessArea processArea = (IProcessArea)repository.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, null);
            IProcessClientService processService = (IProcessClientService)repository.getClientLibrary(IProcessClientService.class);
            IClientProcess clientProcess = processService.getClientProcess(processArea, null);
            boolean[] permitted = clientProcess.getPermittedActions(processArea, "com.ibm.teamz.langdef.buildablesubset.saveBuildableSubset", new String[]{"dynamic"}, null);
            return permitted[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean isViewable(ISubsetCriteria criteria) {
        return BuildableSubsetUtil.isDynamic((ISubsetCriteria)criteria);
    }

    public TreeColumn createTreeColumn(Tree tree, final TreeViewer fViewer, TreeColumnLayout treeColumnLayout, String columnName, int weight, int style, int index, String tooltip, int type) {
        TreeColumn treeColumn = new TreeColumn(tree, style, index);
        treeColumn.setText(columnName);
        treeColumn.setData((Object)index);
        treeColumn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                final TreeColumn treeCol = (TreeColumn)e.getSource();
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        int colIndex = (Integer)treeCol.getData();
                        int oldSortDir = treeCol == fViewer.getTree().getSortColumn() ? fViewer.getTree().getSortDirection() : 1024;
                        int newSortDir = 128;
                        switch (oldSortDir) {
                            case 128: {
                                newSortDir = 1024;
                                break;
                            }
                            case 1024: {
                                newSortDir = 128;
                            }
                        }
                        fViewer.getTree().setSortColumn(treeCol);
                        fViewer.getTree().setSortDirection(newSortDir);
                        fViewer.setComparator((ViewerComparator)new CriteriaComparator(colIndex, newSortDir));
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        treeColumn.setToolTipText(tooltip);
        treeColumnLayout.setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnWeightData(weight));
        return treeColumn;
    }

    private int getViewableCount(List<ISubsetCriteria> list, boolean includeVisible) {
        return this.getWorkItemsFromCriteria(list, includeVisible).size();
    }

    public int getCriteriaCount(boolean includeVisible) {
        BuildableSubsetEditor owningEditor;
        BuildSubsetEditorInput owningInput;
        ISubset subset;
        int result = 0;
        result = this.fCriteria != null ? this.getViewableCount(this.getCurrentCriteria(), includeVisible) : ((subset = (owningInput = (BuildSubsetEditorInput)(owningEditor = (BuildableSubsetEditor)this.getEditor()).getEditorInput()).getSubset()) == null || subset.getCriteria() == null ? 0 : this.getViewableCount(subset.getCriteria().getReferences(), includeVisible));
        return result;
    }

    private void updateCount() {
        String label;
        int wiCounts = this.getCriteriaCount(true);
        mapWorkItemsToHandles_.setMapSize(wiCounts);
        if (this.totalCountLabel != null && !this.totalCountLabel.isDisposed()) {
            label = NLS.bind((String)Messages.BuildableSubsetCriteriaPage_TOTAL_COUNT_LABEL, (Object)wiCounts, (Object[])new Object[0]);
            if (wiCounts > 0) {
                label = "<a>" + label + "</a>";
            }
            this.totalCountLabel.setText(label);
        }
        if (this.overviewWICriteriaSummary != null && !this.overviewWICriteriaSummary.isDisposed()) {
            label = NLS.bind((String)Messages.BuildableSubsetOverviewPage_CONTENTS_WI_SUMMARY, (Object)wiCounts, (Object[])new Object[0]);
            if (wiCounts > 0) {
                label = "<a>" + label + "</a>";
            }
            this.overviewWICriteriaSummary.setText(label);
        }
        if (this.overviewWIFileSummary != null && !this.overviewWIFileSummary.isDisposed()) {
            int count = this.getCriteriaCount(false);
            String label2 = NLS.bind((String)Messages.BuildableSubsetOverviewPage_CONTENTS_WI_FILE_SUMMARY, (Object)count, (Object[])new Object[0]);
            if (count > 0) {
                label2 = "<a>" + label2 + "</a>";
            }
            this.overviewWIFileSummary.setText(label2);
        }
    }

    @Override
    public void editorInitFinished() {
        BuildableSubsetEditor owningEditor = (BuildableSubsetEditor)this.getEditor();
        BuildSubsetEditorInput owningInput = (BuildSubsetEditorInput)owningEditor.getEditorInput();
        ISubset subset = (ISubset)owningInput.getSubset().getWorkingCopy();
        this.fCriteria = new HashSet<Criteria>();
        if (subset != null) {
            this.fCriteria.addAll(BuildableSubsetCriteriaPage.initCriteria(subset.getCriteria().getReferences()));
        }
        if (owningInput.getAdditionalCriteria() != null && !owningInput.getAdditionalCriteria().isEmpty()) {
            Map<ISubsetCriteria, List> criteriaMap = owningInput.getAdditionalCriteria().stream().collect(Collectors.toMap(c -> c, c -> subset.getFileDescs()));
            List newCriteria = BuildableSubsetUtil.merge3(this.getCurrentCriteria(), owningInput.getAdditionalCriteria(), (Collection)subset.getFileDescs());
            if (!newCriteria.isEmpty()) {
                this.setDirty(true);
                this.fCriteria.addAll(BuildableSubsetCriteriaPage.initCriteria(newCriteria));
            }
        }
        if (!this.fCriteria.isEmpty()) {
            this.fContributors.clear();
            this.resolveCriteriaJob(this.getCurrentCriteria()).schedule();
        }
        ((BuildableSubsetEditor)this.getEditor()).contentsPage.updateCurrentCriteria(this.getCurrentCriteria());
        this.updateCount();
    }

    private static Set<Criteria> initCriteria(List<ISubsetCriteria> list) {
        HashSet<Criteria> result = new HashSet<Criteria>();
        if (list != null) {
            for (ISubsetCriteria criterion : list) {
                result.add(new Criteria(criterion));
            }
        }
        return result;
    }

    private void applyDefaultSortIfNeeded() {
        this.criteriaViewer.getTree().setSortColumn(this.fDefaultSort);
        this.criteriaViewer.getTree().setSortDirection(1024);
        this.criteriaViewer.setComparator((ViewerComparator)new CriteriaComparator(0, 1024));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Job resolveCriteriaJob(final List<ISubsetCriteria> list) {
        final ITeamRepository repository = this.getTeamRepository();
        TeamBuildJob job = new TeamBuildJob(Messages.BuildableSubsetOverviewPage_JOB_CRITERIA_TITLE, false, repository){
            private boolean refreshList;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.refreshList = false;
            }

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                if (list != null && list.size() > 0) {
                    this.refreshList = this.resolveCriteria(monitor);
                }
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                14 thisJob = this;
                Display.getDefault().asyncExec(new Runnable((Job)thisJob){
                    private final /* synthetic */ Job val$thisJob;
                    {
                        this.val$thisJob = job;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (BuildableSubsetCriteriaPage.this.criteriaViewer != null && !BuildableSubsetCriteriaPage.this.criteriaViewer.getControl().isDisposed()) {
                                Object firstElement;
                                if (refreshList) {
                                    BuildableSubsetCriteriaPage.this.criteriaViewer.setInput((Object)BuildableSubsetCriteriaPage.this.fCriteria);
                                    BuildableSubsetCriteriaPage.this.criteriaViewer.refresh(true);
                                }
                                Object object = firstElement = BuildableSubsetCriteriaPage.this.criteriaViewer.getTree().getTopItem() == null ? null : BuildableSubsetCriteriaPage.this.criteriaViewer.getTree().getTopItem().getData();
                                if (firstElement != null) {
                                    BuildableSubsetCriteriaPage.this.criteriaViewer.setSelection((ISelection)new StructuredSelection(firstElement), true);
                                }
                            }
                            ((BuildableSubsetEditor)(this).BuildableSubsetCriteriaPage.this.getEditor()).contentsPage.updateCurrentCriteria(BuildableSubsetCriteriaPage.this.getCurrentCriteria());
                            BuildableSubsetCriteriaPage.this.updateEnablement();
                            BuildableSubsetCriteriaPage.this.updateCount();
                        }
                        catch (Throwable throwable) {
                            Object object = BuildableSubsetCriteriaPage.this.jobSync;
                            synchronized (object) {
                                if (BuildableSubsetCriteriaPage.this.currentCriteriaJob == this.val$thisJob) {
                                    BuildableSubsetCriteriaPage.this.currentCriteriaJob = null;
                                }
                            }
                            throw throwable;
                        }
                        Object object = BuildableSubsetCriteriaPage.this.jobSync;
                        synchronized (object) {
                            if (BuildableSubsetCriteriaPage.this.currentCriteriaJob == this.val$thisJob) {
                                BuildableSubsetCriteriaPage.this.currentCriteriaJob = null;
                            }
                        }
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void canceling() {
                Object object = BuildableSubsetCriteriaPage.this.jobSync;
                synchronized (object) {
                    if (BuildableSubsetCriteriaPage.this.currentCriteriaJob == this) {
                        BuildableSubsetCriteriaPage.this.currentCriteriaJob = null;
                    }
                }
            }

            private boolean resolveCriteria(IProgressMonitor monitor) throws TeamRepositoryException {
                ArrayList workItemHandles = new ArrayList();
                for (ISubsetCriteria criteria : list) {
                    Criteria c = new Criteria(criteria);
                    if (!(c.criteria instanceof ICriteriaWorkItem)) continue;
                    workItemHandles.addAll(((ICriteriaWorkItem)c.criteria).getWorkItems());
                }
                if (workItemHandles.size() > 0) {
                    ArrayList<IContributorHandle> contribHandles = new ArrayList<IContributorHandle>();
                    List wiList = repository.itemManager().fetchCompleteItems(workItemHandles, 0, monitor);
                    if (wiList != null) {
                        for (IWorkItem wi : wiList) {
                            for (Criteria c : BuildableSubsetCriteriaPage.this.fCriteria) {
                                if (!(c.criteria instanceof ICriteriaWorkItem)) continue;
                                ICriteriaWorkItem wiC = (ICriteriaWorkItem)c.criteria;
                                ArrayList<UUID> wiUUIDs = new ArrayList<UUID>();
                                for (Object o : wiC.getWorkItems()) {
                                    if (!(o instanceof IWorkItemHandle)) continue;
                                    wiUUIDs.add(((IWorkItemHandle)o).getItemId());
                                }
                                if (!wiUUIDs.contains(wi.getItemId())) continue;
                                c.workItem = wi;
                                IContributorHandle[] iContributorHandleArray = new IContributorHandle[]{wi.getOwner(), wi.getModifiedBy()};
                                int n = iContributorHandleArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IContributorHandle cHandle = iContributorHandleArray[n2];
                                    if (!BuildableSubsetCriteriaPage.this.fContributors.containsKey(cHandle.getItemId())) {
                                        BuildableSubsetCriteriaPage.this.fContributors.put(cHandle.getItemId(), null);
                                        contribHandles.add(cHandle);
                                    }
                                    ++n2;
                                }
                            }
                        }
                    }
                    List contribList = repository.itemManager().fetchCompleteItems(contribHandles, 0, monitor);
                    for (IContributor contrib : contribList) {
                        BuildableSubsetCriteriaPage.this.fContributors.put(contrib.getItemId(), contrib);
                    }
                }
                return true;
            }
        };
        Object object = this.jobSync;
        synchronized (object) {
            this.currentCriteriaJob = job;
        }
        return this.currentCriteriaJob;
    }

    @Override
    public void updateEnablement() {
        this.updateContentsEnablement();
    }

    private void updateContentsEnablement() {
        if (this.criteriaViewer != null && !this.criteriaViewer.getControl().isDisposed()) {
            new UIUpdaterJob(EMPTY_STRING){
                boolean hasPermission2SaveDynamicCriteria;
                {
                    this.hasPermission2SaveDynamicCriteria = false;
                }

                public IStatus runInBackground(IProgressMonitor monitor) {
                    this.hasPermission2SaveDynamicCriteria = BuildableSubsetCriteriaPage.this.hasPermission2SaveDynamicCriteria();
                    return Status.OK_STATUS;
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    BuildSubsetCriteriaDropTargetAdapter dropAdapter = (BuildSubsetCriteriaDropTargetAdapter)((Object)BuildableSubsetCriteriaPage.this.criteriaViewer.getData(BuildableSubsetCriteriaPage.DROP_SUPPORT_ADAPTER));
                    if (dropAdapter != null) {
                        dropAdapter.setEnabled(this.hasPermission2SaveDynamicCriteria);
                    }
                    boolean jobBasedEnableState = !((BuildableSubsetEditor)BuildableSubsetCriteriaPage.this.getEditor()).isInitBuildSubsetJobsRunning();
                    boolean selectionBasedEnableState = !BuildableSubsetCriteriaPage.this.criteriaViewer.getSelection().isEmpty();
                    BuildableSubsetCriteriaPage.this.criteriaViewer.setData(BuildableSubsetCriteriaPage.CELL_EDITING_ENABLED, (Object)this.hasPermission2SaveDynamicCriteria);
                    BuildableSubsetCriteriaPage.this.msgPermission2SaveDynamicCriteria.setVisible(!this.hasPermission2SaveDynamicCriteria);
                    ((GridData)((BuildableSubsetCriteriaPage)BuildableSubsetCriteriaPage.this).msgPermission2SaveDynamicCriteria.getLayoutData()).exclude = this.hasPermission2SaveDynamicCriteria;
                    if (this.hasPermission2SaveDynamicCriteria) {
                        BuildableSubsetCriteriaPage.this.msgPermission2SaveDynamicCriteriaDecorator.hide();
                    } else {
                        BuildableSubsetCriteriaPage.this.msgPermission2SaveDynamicCriteriaDecorator.show();
                    }
                    BuildableSubsetCriteriaPage.this.msgPermission2SaveDynamicCriteria.getParent().layout(false);
                    BuildableSubsetCriteriaPage.this.criteriaViewer.getControl().setEnabled(jobBasedEnableState);
                    BuildableSubsetCriteriaPage.this.addButton.setEnabled(jobBasedEnableState && ((BuildableSubsetEditor)BuildableSubsetCriteriaPage.this.getEditor()).getBuildDefinition() != null && this.hasPermission2SaveDynamicCriteria);
                    BuildableSubsetCriteriaPage.this.removeButton.setEnabled(jobBasedEnableState && selectionBasedEnableState && BuildableSubsetCriteriaPage.this.fCriteria != null && BuildableSubsetCriteriaPage.this.fCriteria.size() > 0 && this.hasPermission2SaveDynamicCriteria);
                    BuildableSubsetCriteriaPage.this.previewButton.setEnabled(jobBasedEnableState && selectionBasedEnableState && BuildableSubsetCriteriaPage.this.fCriteria != null && BuildableSubsetCriteriaPage.this.fCriteria.size() > 0);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public boolean isDirty() {
        return !this.isDirty ? super.isDirty() : this.isDirty;
    }

    @Override
    public void setDirty(boolean state) {
        this.isDirty = state;
        ((BuildableSubsetEditor)this.getEditor()).fireDirtyPropertyChangeEvent();
    }

    @Override
    public void doSave(ISubset subset, IProgressMonitor monitor) {
        super.doSave(monitor);
        ISubset workingSubset = subset.isWorkingCopy() ? subset : (ISubset)subset.getWorkingCopy();
        this.addCriteriaToWorkingSubset(workingSubset);
    }

    private void addCriteriaToWorkingSubset(ISubset workingSubset) {
        if (this.fCriteria != null && this.criteriaChanged(workingSubset)) {
            List criteriaList = this.fCriteria.stream().map(c -> ((Criteria)c).criteria).collect(Collectors.toList());
            List criteriaUUIDList = criteriaList.stream().map(c -> c.getInternalId()).collect(Collectors.toList());
            ArrayList<ISubsetCriteria> toRemove = new ArrayList<ISubsetCriteria>();
            for (ISubsetCriteria criterion : workingSubset.getCriteria().getReferences()) {
                if (criteriaUUIDList.contains(criterion.getInternalId())) continue;
                toRemove.add(criterion);
            }
            List workingSubsetCriteriaUUIDList = workingSubset.getCriteria().getReferences().stream().map(c -> c.getInternalId()).collect(Collectors.toList());
            ArrayList<ISubsetCriteria> toAdd = new ArrayList<ISubsetCriteria>();
            for (ISubsetCriteria criterion : criteriaList) {
                if (!workingSubsetCriteriaUUIDList.contains(criterion.getInternalId())) {
                    toAdd.add(criterion);
                    continue;
                }
                ISubsetCriteria currCriteria = workingSubset.getCriteria().getReferences().stream().filter(c -> criterion.getInternalId().equals((Object)c.getInternalId())).findFirst().orElse(null);
                if (currCriteria == null || !(currCriteria instanceof ICriteriaWorkItem) || !(criterion instanceof ICriteriaWorkItem)) continue;
                ICriteriaWorkItem currWorkItemCriteria = (ICriteriaWorkItem)currCriteria;
                ICriteriaWorkItem newWorkItemCriteria = (ICriteriaWorkItem)criterion;
                if (currWorkItemCriteria.isIncludeChildren() == newWorkItemCriteria.isIncludeChildren() && currWorkItemCriteria.isIncludeImpacted() == newWorkItemCriteria.isIncludeImpacted()) continue;
                toRemove.add(currCriteria);
                toAdd.add(criterion);
            }
            workingSubset.getCriteria().getReferences().removeAll(toRemove);
            this.addCriteria(workingSubset, toAdd);
        }
    }

    private void addCriteria(ISubset workingSubset, List<ISubsetCriteria> toAdd) {
        Map criteriaUUIDMap = toAdd.stream().collect(Collectors.toMap(Function.identity(), c -> c.getInternalId()));
        workingSubset.getCriteria().getReferences().addAll(toAdd);
        for (ISubsetCriteria criterion : workingSubset.getCriteria().getReferences()) {
            if (!criteriaUUIDMap.containsKey(criterion)) continue;
            criterion.setInternalId(criteriaUUIDMap.get(criterion));
        }
    }

    private boolean containsCriteria(List<ISubsetCriteria> criteriaList, ISubsetCriteria criterion) {
        return criteriaList.stream().anyMatch(c -> c.getInternalId().equals((Object)criterion.getInternalId()));
    }

    private boolean criteriaChanged(ISubset workingSubset) {
        List criteria = this.fCriteria.stream().map(criterion -> ((Criteria)criterion).criteria).collect(Collectors.toList());
        return !criteria.equals(workingSubset.getCriteria().getReferences());
    }

    @Override
    public void populateForPreview(ISubset subset) {
        ISubset workingSubset = subset.isWorkingCopy() ? subset : (ISubset)subset.getWorkingCopy();
        this.addCriteriaToWorkingSubset(workingSubset);
    }

    @Override
    public boolean validate(ISubset workingSubset) {
        boolean isWorking = true;
        return isWorking;
    }

    public IBuildDefinition getDefinitionFromHandle(IBuildDefinitionHandle handle) {
        IBuildDefinition buildDefinition = null;
        try {
            buildDefinition = (IBuildDefinition)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)handle, 0, null);
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        return buildDefinition;
    }

    @Override
    public void refresh() {
        BuildableSubsetEditor owningEditor = (BuildableSubsetEditor)this.getEditor();
        BuildSubsetEditorInput owningInput = (BuildSubsetEditorInput)owningEditor.getEditorInput();
        ISubset subset = (ISubset)owningInput.getSubset().getWorkingCopy();
        this.processAdditions(subset.getCriteria().getReferences(), true);
        this.setDirty(false);
    }

    public void displayWorkItemViewer(final boolean includeVisible) {
        new TeamBuildJob(EMPTY_STRING, true, this.getTeamRepository()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                try {
                    BuildSubsetEditorInput editorInput = (BuildSubsetEditorInput)BuildableSubsetCriteriaPage.this.getEditorInput();
                    final IProjectAreaHandle projectAreaHandle = editorInput.getProjectAreaHandle();
                    final List workItemHandles = BuildableSubsetCriteriaPage.this.getWorkItemsFromCriteria(BuildableSubsetCriteriaPage.this.getCurrentCriteria(), includeVisible);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            if (w != null) {
                                String subsetID = ((BuildableSubsetEditor)BuildableSubsetCriteriaPage.this.getEditor()).getCurrentLabel();
                                if (subsetID.trim().isEmpty()) {
                                    subsetID = Messages.BuildSubsetFilesView_NO_SUBSET_LABEL;
                                }
                                String title = NLS.bind((String)Messages.BuildableSubsetCriteriaPage_WORKITEM_VIEW_FOR_SUBSET, (Object)subsetID, (Object[])new Object[0]);
                                WorkItemUI.showWorkItems((IWorkbenchWindow)w, (IProjectAreaHandle)projectAreaHandle, (String)title, (IWorkItemHandle[])workItemHandles.toArray(new IWorkItemHandle[workItemHandles.size()]));
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    return new Status(4, "com.ibm.team.enterprise.build.ui", ex.getMessage(), (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    @Override
    public void populateOverview(Composite parent, FormToolkit toolkit) {
        this.overviewWILabel = toolkit.createLabel(parent, Messages.BuildableSubsetOverviewPage_CONTENTS_WORK_ITEMS);
        GridDataFactory.fillDefaults().indent(0, 15).align(1, 1).span(1, 2).grab(false, true).applyTo((Control)this.overviewWILabel);
        this.overviewWIFileSummary = new Link(parent, 16384);
        this.overviewWIFileSummary.setEnabled(true);
        this.overviewWIFileSummary.setBackground(parent.getBackground());
        this.overviewWIFileSummary.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildableSubsetCriteriaPage.this.displayWorkItemViewer(false);
            }
        });
        GridDataFactory.swtDefaults().indent(0, 15).align(4, 0x1000000).grab(true, false).applyTo((Control)this.overviewWIFileSummary);
        this.overviewWICriteriaSummary = new Link(parent, 16384);
        this.overviewWICriteriaSummary.setEnabled(true);
        this.overviewWICriteriaSummary.setBackground(parent.getBackground());
        this.overviewWICriteriaSummary.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildableSubsetCriteriaPage.this.displayWorkItemViewer(true);
            }
        });
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.overviewWICriteriaSummary);
        this.updateCount();
    }

    private Integer getWINumber(Object element) {
        Criteria c;
        Integer result = -1;
        if (element instanceof Criteria && (c = (Criteria)element).criteria instanceof ICriteriaWorkItem) {
            return c.workItem != null ? Integer.valueOf(c.workItem.getId()) : null;
        }
        return result;
    }

    private IWorkItemHandle getWIHandle(Object element) {
        ICriteriaWorkItem wiCriterion;
        Criteria c;
        if (element instanceof Criteria && (c = (Criteria)element).criteria instanceof ICriteriaWorkItem && !(wiCriterion = (ICriteriaWorkItem)c.criteria).getWorkItems().isEmpty()) {
            return (IWorkItemHandle)wiCriterion.getWorkItems().get(0);
        }
        return null;
    }

    private List<IWorkItemHandle> getWorkItemsFromCriteria(List<ISubsetCriteria> criteria, boolean includeVisible) {
        HashSet<IWorkItemHandle> result = new HashSet<IWorkItemHandle>();
        if (criteria != null) {
            for (ISubsetCriteria criterion : criteria) {
                if (criterion instanceof ICriteriaSubset) {
                    result.addAll(this.getWorkItemsFromCriteria(((ICriteriaSubset)criterion).getChildCriteria().getReferences(), includeVisible));
                    continue;
                }
                if (BuildableSubsetCriteriaPage.isViewable(criterion) != includeVisible) continue;
                ICriteriaWorkItem wiCriterion = (ICriteriaWorkItem)criterion;
                result.addAll(wiCriterion.getWorkItems());
                result.addAll(wiCriterion.getAdditionalWorkItems());
            }
        }
        return new ArrayList<IWorkItemHandle>(result);
    }

    public List<ISubsetCriteria> getCurrentCriteria() {
        return this.fCriteria == null ? new ArrayList<ISubsetCriteria>() : this.fCriteria.stream().map(next -> ((Criteria)next).criteria).collect(Collectors.toList());
    }

    public void resolveWorkItemIDFromHandle(List<IWorkItemHandle> workItems) {
        TeamBuildJob fetchWorkItemIdsJob = new TeamBuildJob("Fetching Work Item Ids", false, this.getTeamRepository()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                19 thisJob = this;
                Display.getDefault().asyncExec(new Runnable((Job)thisJob){
                    private final /* synthetic */ Job val$thisJob;
                    {
                        this.val$thisJob = job;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (BuildableSubsetCriteriaPage.this.criteriaViewer != null && !BuildableSubsetCriteriaPage.this.criteriaViewer.getControl().isDisposed()) {
                                Object firstElement;
                                Object object = firstElement = BuildableSubsetCriteriaPage.this.criteriaViewer.getTree().getTopItem() == null ? null : BuildableSubsetCriteriaPage.this.criteriaViewer.getTree().getTopItem().getData();
                                if (firstElement != null) {
                                    BuildableSubsetCriteriaPage.this.criteriaViewer.setSelection((ISelection)new StructuredSelection(firstElement), true);
                                }
                            }
                            ((BuildableSubsetEditor)(this).BuildableSubsetCriteriaPage.this.getEditor()).contentsPage.updateCurrentCriteria(BuildableSubsetCriteriaPage.this.getCurrentCriteria());
                            BuildableSubsetCriteriaPage.this.updateEnablement();
                            BuildableSubsetCriteriaPage.this.updateCount();
                        }
                        catch (Throwable throwable) {
                            Object object = BuildableSubsetCriteriaPage.this.jobSync;
                            synchronized (object) {
                                if (BuildableSubsetCriteriaPage.this.currentCriteriaJob == this.val$thisJob) {
                                    BuildableSubsetCriteriaPage.this.currentCriteriaJob = null;
                                }
                            }
                            throw throwable;
                        }
                        Object object = BuildableSubsetCriteriaPage.this.jobSync;
                        synchronized (object) {
                            if (BuildableSubsetCriteriaPage.this.currentCriteriaJob == this.val$thisJob) {
                                BuildableSubsetCriteriaPage.this.currentCriteriaJob = null;
                            }
                        }
                    }
                });
            }
        };
        fetchWorkItemIdsJob.schedule();
    }

    public static List<IWorkItemHandle> resolveWorkItemsToHandles(final ITeamRepository repo, Collection<Integer> workItemIDs) {
        final ArrayList<IWorkItemHandle> result = new ArrayList<IWorkItemHandle>();
        if (workItemIDs != null) {
            final ArrayList<Integer> idsToFetch = new ArrayList<Integer>();
            for (Integer workItemID : workItemIDs) {
                IWorkItemHandle wiHandle = (IWorkItemHandle)mapWorkItemsToHandles_.get(workItemID);
                if (wiHandle == null) {
                    idsToFetch.add(workItemID);
                    continue;
                }
                result.add(wiHandle);
            }
            if (!idsToFetch.isEmpty()) {
                UIUpdaterJob uiJob = new UIUpdaterJob(EMPTY_STRING){
                    IWorkItemCommon workItemClient;
                    List<IWorkItemHandle> fetchedHandles;

                    public IStatus runInBackground(IProgressMonitor monitor) {
                        this.workItemClient = (IWorkItemCommon)repo.getClientLibrary(IWorkItemCommon.class);
                        try {
                            this.fetchedHandles = this.workItemClient.findWorkItemsById((List)idsToFetch, null);
                            result.addAll(this.fetchedHandles);
                        }
                        catch (TeamRepositoryException e) {
                            e.printStackTrace();
                        }
                        return Status.OK_STATUS;
                    }

                    public IStatus runInUI(IProgressMonitor monitor) {
                        return Status.OK_STATUS;
                    }
                };
                uiJob.schedule();
                try {
                    uiJob.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private BuildSubsetEditorInput getSubsetInput() {
        BuildSubsetEditorInput editorInput = (BuildSubsetEditorInput)this.getEditorInput();
        return editorInput;
    }

    private ITeamRepository getTeamRepository() {
        return this.getSubsetInput().getTeamRepository();
    }

    private void openWorkItem(Object element) {
        ICriteriaWorkItem wiCriteria;
        Criteria c;
        if (element instanceof Criteria && (c = (Criteria)element).criteria instanceof ICriteriaWorkItem && !(wiCriteria = (ICriteriaWorkItem)c.criteria).getWorkItems().isEmpty()) {
            new UIUpdaterJob(EMPTY_STRING){
                List<IWorkItemHandle> wiHandles;

                public IStatus runInBackground(IProgressMonitor monitor) {
                    this.wiHandles = wiCriteria.getWorkItems();
                    return Status.OK_STATUS;
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    if (this.wiHandles != null && !this.wiHandles.isEmpty()) {
                        BuildableSubsetCriteriaPage.this.openWorkItem(this.wiHandles.get(0));
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private void openWorkItem(IWorkItemHandle wiHandle) {
        WorkItemUI.open((IWorkbenchPage)this.getEditorSite().getPage(), (Object)wiHandle);
    }

    @Override
    public void appendInput(BuildSubsetEditorInput input) {
        if (input.getAdditionalCriteria() != null && !input.getAdditionalCriteria().isEmpty()) {
            ISubset subset = (ISubset)input.getSubset().getWorkingCopy();
            List newCriteria = BuildableSubsetUtil.merge3(this.getCurrentCriteria(), input.getAdditionalCriteria(), (Collection)subset.getFileDescs());
            this.processAdditions(newCriteria, false);
        }
    }

    @Override
    public void buildDefinitionChanged(IBuildDefinition buildDef) {
        this.updateContentsEnablement();
    }

    public void setFocus() {
        this.fCriteriaTree.setFocus();
    }

    public Job getCurrentCriteriaJob() {
        return this.currentCriteriaJob;
    }

    private void createContextMenu(final ISelectionProvider selectionProvider, Control control) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ISelection s = selectionProvider.getSelection();
                IncludeImpactedAction includeImpactedAction = new IncludeImpactedAction(!s.isEmpty());
                MenuManager submenu = new MenuManager(Messages.BuildableSubsetCriteriaPage_WI_COLUMN_IMPACTED, null);
                submenu.add((IAction)includeImpactedAction);
                submenu.add((IAction)new DoNotIncludeImpactedAction(!s.isEmpty()));
                manager.add((IContributionItem)submenu);
                IncludeChildrenAction includeChildrenAction = new IncludeChildrenAction(!s.isEmpty());
                MenuManager submenu1 = new MenuManager(Messages.BuildableSubsetCriteriaPage_WI_COLUMN_CHILDREN, null);
                submenu1.add((IAction)includeChildrenAction);
                submenu1.add((IAction)new DoNotIncludeChildrenAction(!s.isEmpty()));
                manager.add((IContributionItem)submenu1);
            }
        });
        this.getSite().registerContextMenu(this.getId(), menuMgr, selectionProvider);
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    private class AddCriteriaWithWorkItemsAction
    extends Action {
        public AddCriteriaWithWorkItemsAction() {
            super(Messages.BuildableSubsetOverviewPage_ACTION_WORKITEMS);
        }

        public void run() {
            final BuildSubsetEditorInput editorInput = BuildableSubsetCriteriaPage.this.getSubsetInput();
            IProjectAreaHandle projectAreaHandle = editorInput.getProjectAreaHandle();
            final ITeamRepository repository = editorInput.getTeamRepository();
            IBuildDefinitionHandle fBuildDefHandle = editorInput.getBuildDefinitionHandle();
            if (fBuildDefHandle == null) {
                fBuildDefHandle = (IBuildDefinitionHandle)((BuildableSubsetEditor)BuildableSubsetCriteriaPage.this.getEditor()).getBuildDefinition().getItemHandle();
            }
            if (projectAreaHandle != null) {
                BuildableSubsetCriteriaPage.this.dialog = new BuildSubsetWorkItemSelectionDialog(BuildableSubsetCriteriaPage.this.getSite().getShell(), projectAreaHandle, fBuildDefHandle, true);
            } else {
                BuildableSubsetCriteriaPage.this.dialog = new BuildSubsetWorkItemSelectionDialog(BuildableSubsetCriteriaPage.this.getSite().getShell(), repository, fBuildDefHandle, true);
            }
            BuildableSubsetCriteriaPage.this.dialog.setDynamic(true);
            if (BuildableSubsetCriteriaPage.this.dialog.open() == 0) {
                new UIUpdaterJob(BuildableSubsetCriteriaPage.EMPTY_STRING){
                    ISubset subset;
                    List<UUID> beforeAdd;

                    public IStatus runInBackground(IProgressMonitor monitor) {
                        this.beforeAdd = BuildableSubsetUtil.collectSubsetFileDescUUIDs((Collection)editorInput.getSubset().getFileDescs());
                        this.subset = BuildableSubsetCriteriaPage.this.dialog.getResultSubset(editorInput.getSubset());
                        return Status.OK_STATUS;
                    }

                    public IStatus runInUI(IProgressMonitor monitor) {
                        if (this.subset != null) {
                            editorInput.setSubset(this.subset);
                            if (BuildableSubsetCriteriaPage.this.dialog.isShowingSummary()) {
                                List<ISubsetFileDesc> added = this.subset.getFileDescs();
                                added = added.stream().filter(file -> !BuildableSubsetUtil.containsFile((ISubsetFileDesc)file, this.beforeAdd)).collect(Collectors.toList());
                                ISubsetFileDesc[] buildableFileDescriptors = added.toArray(new ISubsetFileDesc[added.size()]);
                                IBuildSubsetRule subsetRule = BuildableSubsetCriteriaPage.this.dialog.getSubsetRule();
                                AddFileToSubsetSummaryDialog summaryDialog = new AddFileToSubsetSummaryDialog(subsetRule, buildableFileDescriptors, BuildableSubsetCriteriaPage.this.getSite().getShell(), repository, ((BuildableSubsetEditor)BuildableSubsetCriteriaPage.this.getEditor()).getBuildDefinition());
                                summaryDialog.open();
                            }
                            BuildableSubsetCriteriaPage.this.finishAdd(BuildableSubsetCriteriaPage.this.dialog);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
    }

    public static class ComboEditSupport
    extends EditingSupport {
        public ComboEditSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected void updateModel(Object element, Object value) {
        }

        protected Object getValue(Object element) {
            return 1;
        }

        protected void setValue(Object element, Object value) {
            this.updateModel(element, value);
            this.getViewer().update(element, null);
        }

        protected CellEditor getCellEditor(Object element) {
            ComboBoxCellEditor editor = new ComboBoxCellEditor((Composite)this.getViewer().getControl(), new String[]{Messages.BuildableSubsetEditorCriteriaPage_TRUE, Messages.BuildableSubsetEditorCriteriaPage_FALSE}, 8){};
            return editor;
        }

        protected boolean canEdit(Object element) {
            boolean result = false;
            try {
                Object editingEnabled = this.getViewer().getData(BuildableSubsetCriteriaPage.CELL_EDITING_ENABLED);
                result = editingEnabled != null && (Boolean)editingEnabled != false && element instanceof Criteria && ((Criteria)element).criteria instanceof ICriteriaWorkItem;
            }
            catch (Exception e) {
                result = false;
            }
            return result;
        }
    }

    public static class Criteria
    implements IAdaptable {
        protected IWorkItem workItem;
        private ISubsetCriteria criteria;

        public Criteria(ISubsetCriteria criterion) {
            this.criteria = criterion;
        }

        public int hashCode() {
            return this.criteria.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Criteria && this.criteria.equals(((Criteria)obj).criteria);
        }

        public Object getAdapter(Class adapter) {
            if (Criteria.class.equals((Object)adapter)) {
                return this;
            }
            if (ISubsetCriteria.class.equals((Object)adapter) || adapter.isInstance(this.criteria)) {
                return this.criteria;
            }
            if (IWorkItem.class.equals((Object)adapter) || IWorkItemHandle.class.equals((Object)adapter)) {
                return this.workItem;
            }
            return null;
        }
    }

    private class CriteriaComparator
    extends ViewerComparator {
        private int colIndex;
        private int sortDir;

        public CriteriaComparator(int colIndex, int sortDir) {
            this.colIndex = colIndex;
            this.sortDir = sortDir;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            try {
                Criteria c1 = (Criteria)e1;
                Criteria c2 = (Criteria)e2;
                int result = 0;
                switch (this.colIndex) {
                    case 0: {
                        Integer i1 = BuildableSubsetCriteriaPage.this.getWINumber(e1);
                        Integer i2 = BuildableSubsetCriteriaPage.this.getWINumber(e2);
                        result = Integer.valueOf(i1 != null ? i1 : -1).compareTo(i2 != null ? i2 : -1);
                        return this.sortDir == 128 ? result : result * -1;
                    }
                    case 1: {
                        result = c1.workItem.getHTMLSummary().getPlainText().compareTo(c2.workItem.getHTMLSummary().getPlainText());
                        return this.sortDir == 128 ? result : result * -1;
                    }
                    case 4: {
                        boolean b1 = ((ICriteriaWorkItem)c1.criteria).isIncludeImpacted();
                        boolean b2 = ((ICriteriaWorkItem)c2.criteria).isIncludeImpacted();
                        result = Boolean.valueOf(b1).compareTo(b2);
                        return this.sortDir == 128 ? result : result * -1;
                    }
                    case 5: {
                        boolean b1 = ((ICriteriaWorkItem)c1.criteria).isIncludeChildren();
                        boolean b2 = ((ICriteriaWorkItem)c2.criteria).isIncludeChildren();
                        result = Boolean.valueOf(b1).compareTo(b2);
                        return this.sortDir == 128 ? result : result * -1;
                    }
                    case 3: {
                        Map fContributors = (Map)viewer.getData(BuildableSubsetCriteriaPage.CONTRIBUTOR_MAP);
                        String name1 = ((IContributor)fContributors.get(c1.workItem.getOwner().getItemId())).getName();
                        String name2 = ((IContributor)fContributors.get(c2.workItem.getOwner().getItemId())).getName();
                        result = name1.compareTo(name2);
                        return this.sortDir == 128 ? result : result * -1;
                    }
                    case 2: {
                        Map fContributors = (Map)viewer.getData(BuildableSubsetCriteriaPage.CONTRIBUTOR_MAP);
                        String name1 = ((IContributor)fContributors.get(c1.workItem.getOwner().getItemId())).getName();
                        String name2 = ((IContributor)fContributors.get(c2.workItem.getOwner().getItemId())).getName();
                        result = name1.compareTo(name2);
                        return this.sortDir == 128 ? result : result * -1;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private static class CriteriaContentProvider
    implements ITreeContentProvider {
        private TreeViewer fTreeView = null;

        public CriteriaContentProvider(TreeViewer treeView) {
            this.fTreeView = treeView;
        }

        public void dispose() {
            this.fTreeView = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null && newInput instanceof Criteria[]) {
                this.fTreeView.setSelection((ISelection)new StructuredSelection());
            }
        }

        public Object[] getElements(Object inputElement) {
            return ((Set)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            Object result = null;
            return result;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class DoNotIncludeChildrenAction
    extends IncludeChildrenAction {
        public DoNotIncludeChildrenAction(boolean selection) {
            super(selection);
            this.setText(Messages.BuildableSubsetEditorCriteriaPage_FALSE);
        }

        @Override
        protected boolean isOn() {
            return false;
        }
    }

    private class DoNotIncludeImpactedAction
    extends IncludeImpactedAction {
        public DoNotIncludeImpactedAction(boolean selection) {
            super(selection);
            this.setText(Messages.BuildableSubsetEditorCriteriaPage_FALSE);
        }

        @Override
        protected boolean isOn() {
            return false;
        }
    }

    private class IncludeChildrenAction
    extends Action {
        public IncludeChildrenAction(boolean selection) {
            this.setText(Messages.BuildableSubsetEditorCriteriaPage_TRUE);
            this.setEnabled(selection);
        }

        protected boolean isOn() {
            return true;
        }

        public void run() {
            IStructuredSelection s = (IStructuredSelection)BuildableSubsetCriteriaPage.this.criteriaViewer.getSelection();
            Stream.of(s.toList()).filter(Criteria.class::isInstance).map(Criteria.class::cast).map(c -> ((Criteria)c).criteria).filter(ICriteriaWorkItem.class::isInstance).map(ICriteriaWorkItem.class::cast).filter(c -> !c.isIncludeChildren()).forEach(wiCriteria -> {
                wiCriteria.setIncludeChildren(true);
                BuildableSubsetCriteriaPage.this.setDirty(true);
                BuildableSubsetCriteriaPage.this.criteriaViewer.update(wiCriteria, null);
            });
        }
    }

    private class IncludeImpactedAction
    extends Action {
        public IncludeImpactedAction(boolean selection) {
            this.setText(Messages.BuildableSubsetEditorCriteriaPage_TRUE);
            this.setEnabled(selection);
        }

        protected boolean isOn() {
            return true;
        }

        public void run() {
            IStructuredSelection s = (IStructuredSelection)BuildableSubsetCriteriaPage.this.criteriaViewer.getSelection();
            Stream.of(s.toList()).filter(Criteria.class::isInstance).map(Criteria.class::cast).map(c -> ((Criteria)c).criteria).filter(ICriteriaWorkItem.class::isInstance).map(ICriteriaWorkItem.class::cast).filter(c -> !c.isIncludeImpacted()).forEach(wiCriteria -> {
                wiCriteria.setIncludeImpacted(true);
                BuildableSubsetCriteriaPage.this.setDirty(true);
                BuildableSubsetCriteriaPage.this.criteriaViewer.update(wiCriteria, null);
            });
        }
    }

    private final class LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider,
    ITableFontProvider {
        private LabelProvider() {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getColumnText(Object element, int columnIndex) {
            ICriteriaWorkItem c2;
            String result = null;
            Criteria criteria = (Criteria)element;
            ISubsetCriteria c = criteria.criteria;
            if (c instanceof ICriteriaWorkItem && (c2 = (ICriteriaWorkItem)c).getWorkItems().size() == 1 && criteria.workItem != null) {
                switch (columnIndex) {
                    case 0: {
                        result = Integer.toString(criteria.workItem.getId());
                        break;
                    }
                    case 1: {
                        try {
                            result = criteria.workItem.getHTMLSummary().getPlainText();
                        }
                        catch (Exception e) {
                            result = BuildableSubsetCriteriaPage.EMPTY_STRING;
                        }
                        break;
                    }
                    case 4: {
                        result = c2.isIncludeImpacted() ? Messages.BuildableSubsetEditorCriteriaPage_TRUE : Messages.BuildableSubsetEditorCriteriaPage_FALSE;
                        break;
                    }
                    case 5: {
                        result = c2.isIncludeChildren() ? Messages.BuildableSubsetEditorCriteriaPage_TRUE : Messages.BuildableSubsetEditorCriteriaPage_FALSE;
                        break;
                    }
                    case 2: {
                        try {
                            result = ((IContributor)BuildableSubsetCriteriaPage.this.fContributors.get(criteria.workItem.getOwner().getItemId())).getName();
                        }
                        catch (Exception e) {
                            result = BuildableSubsetCriteriaPage.EMPTY_STRING;
                        }
                        break;
                    }
                    case 3: {
                        try {
                            result = ((IContributor)BuildableSubsetCriteriaPage.this.fContributors.get(criteria.workItem.getCreator().getItemId())).getName();
                        }
                        catch (Exception e) {
                            result = BuildableSubsetCriteriaPage.EMPTY_STRING;
                        }
                        break;
                    }
                    default: {
                        result = BuildableSubsetCriteriaPage.EMPTY_STRING;
                    }
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ICriteriaWorkItem c2;
            Object result = null;
            Criteria criteria = (Criteria)element;
            ISubsetCriteria c = criteria.criteria;
            if (c instanceof ICriteriaWorkItem && (c2 = (ICriteriaWorkItem)c).getWorkItems().size() == 1) {
                result = null;
            }
            return result;
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Font getFont(Object element, int columnIndex) {
            return null;
        }
    }

    private static final class WorkItemIDMap
    extends LinkedHashMap<Integer, IWorkItemHandle> {
        private static final long serialVersionUID = 1L;
        int mapSize = 50;

        private WorkItemIDMap() {
        }

        public void setMapSize(int newSize) {
            this.mapSize = Math.max(this.mapSize, newSize);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, IWorkItemHandle> eldest) {
            return this.size() > this.mapSize;
        }
    }
}

