/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.enterprise.build.client.buildablesubset.ClientFactory;
import com.ibm.team.enterprise.build.common.DependencyBuildPropertyFactory;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.dialogs.AddFileToSubsetSummaryDialog;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetEditorInput;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetFileSelectionDialog;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetRuleSelectionDialog;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetSelectionDialog;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetWorkItemSelectionDialog;
import com.ibm.team.enterprise.build.ui.subset.dnd.BuildSubsetFilesDropTargetAdapter;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildableFilesViewer;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetEditor;
import com.ibm.team.enterprise.build.ui.subset.editors.ButtonUtils;
import com.ibm.team.enterprise.build.ui.subset.editors.IBuildableSubsetEditorPage;
import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.ISubsetBuildSubsetRule2;
import com.ibm.team.enterprise.buildablesubset.common.impl.SubsetBuildSubsetRule2;
import com.ibm.team.enterprise.buildablesubset.common.internal.model.StringHelper;
import com.ibm.team.enterprise.buildablesubset.common.model.ICriteriaSubset;
import com.ibm.team.enterprise.buildablesubset.common.model.ICriteriaWorkItem;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetCriteria;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetFileDesc;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetHandle;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetUtil;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.filesystem.common.internal.FileItem;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.Component;
import com.ibm.team.scm.common.internal.Folder;
import com.ibm.team.ui.editor.TeamFormPage;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class BuildableSubsetContentsPage
extends TeamFormPage
implements IBuildableSubsetEditorPage,
BuildableFilesViewer.IBuildableFilesListener,
BuildSubsetFilesDropTargetAdapter.IBuildSubsetDropTargetContext {
    private boolean isDirty = false;
    private Composite pageComposite;
    private ScrolledForm mainForm;
    private Section contentsSection;
    private final BuildableFilesViewer buildFileListViewer;
    private Composite buildableActionComposite;
    private Button addFileButton;
    private Button removeFileButton;
    private Button removeAllFilesButton;
    private Label buildableFilesLabel;
    private SelectionStatusDialog dialog;
    private Link totalCountLabel;
    private Link overviewFilesSummary;
    private Label overviewFilesLabel;
    private boolean isInitialized;

    private void finishAdd() {
        Object[] result = this.dialog.getResult();
        if (this.dialog != null && result.length > 0) {
            BuildSubsetEditorInput editorInput = (BuildSubsetEditorInput)this.getEditorInput();
            ISubset subset = editorInput.getSubset();
            List beforeAdd = BuildableSubsetUtil.collectSubsetFileDescUUIDs((Collection)subset.getFileDescs());
            List added = Arrays.asList(this.dialog.getResult()).stream().map(ISubsetFileDesc.class::cast).collect(Collectors.toList());
            added = added.stream().filter(file -> !BuildableSubsetUtil.containsFile((ISubsetFileDesc)file, (Collection)beforeAdd)).collect(Collectors.toList());
            subset = subset.isWorkingCopy() ? subset : (ISubset)subset.getWorkingCopy();
            subset.getFileDescs().addAll(added);
            this.finishAdd(subset);
        }
    }

    private void finishRemove(List<ISubsetFileDesc> files) {
        BuildSubsetEditorInput editorInput = (BuildSubsetEditorInput)this.getEditorInput();
        ISubset subset = editorInput.getSubset();
        subset = subset.isWorkingCopy() ? subset : (ISubset)subset.getWorkingCopy();
        List fileUUIDs = files.stream().map(file -> file.getFileItem().getItemId()).collect(Collectors.toList());
        ArrayList<ISubsetFileDesc> toRemove = new ArrayList<ISubsetFileDesc>();
        for (Object obj : subset.getFileDescs()) {
            ISubsetFileDesc file2;
            if (!(obj instanceof ISubsetFileDesc) || !fileUUIDs.contains((file2 = (ISubsetFileDesc)obj).getFileItem().getItemId())) continue;
            toRemove.add(file2);
        }
        subset.getFileDescs().removeAll(toRemove);
        editorInput.setSubset(subset);
    }

    private void finishAdd(ISubset subset) {
        ((BuildableSubsetEditor)this.getEditor()).processAdditions(subset);
    }

    public void processAdditions(final List<ISubsetFileDesc> addedFiles, final boolean isRefresh) {
        Job jobToWaitFor;
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BuildSubsetEditorInput editorInput = (BuildSubsetEditorInput)BuildableSubsetContentsPage.this.getEditorInput();
                if (addedFiles != null && !addedFiles.isEmpty()) {
                    if (!isRefresh) {
                        BuildableSubsetContentsPage.this.buildFileListViewer.setAddedBuildableFiles(addedFiles);
                    }
                    BuildableSubsetContentsPage.this.buildFileListViewer.resolvePaths(addedFiles);
                    ISubset workingSubset = (ISubset)editorInput.getSubset().getWorkingCopy();
                    List<ISubsetFileDesc> after = BuildableSubsetContentsPage.this.buildFileListViewer.getBuildableFiles();
                    if (!isRefresh) {
                        BuildableSubsetContentsPage.this.setDirty(true);
                    }
                }
                if (BuildableSubsetContentsPage.this.buildFileListViewer.getTableViewer() != null && !BuildableSubsetContentsPage.this.buildFileListViewer.getTableViewer().getControl().isDisposed()) {
                    if (isRefresh) {
                        BuildableSubsetContentsPage.this.buildFileListViewer.getTableViewer().getTable().removeAll();
                    }
                    BuildableSubsetContentsPage.this.buildFileListViewer.getTableViewer().setInput(BuildableSubsetContentsPage.this.buildFileListViewer.getBuildableFiles());
                    BuildableSubsetContentsPage.this.buildFileListViewer.getTableViewer().refresh(true);
                }
                BuildableSubsetContentsPage.this.updateEnablement();
                BuildableSubsetContentsPage.this.updateCounts();
            }
        };
        Job job = jobToWaitFor = addedFiles == null || addedFiles.isEmpty() ? null : ((BuildableSubsetEditor)this.getEditor()).criteriaPage.getCurrentCriteriaJob();
        if (jobToWaitFor != null) {
            new Job(jobToWaitFor.getName()){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        jobToWaitFor.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            runnable.run();
                        }
                    });
                    return Status.OK_STATUS;
                }
            }.schedule();
        } else {
            runnable.run();
        }
    }

    private IWorkspaceHandle getWorkspaceHandleFromBuildDefinition(IBuildDefinitionHandle bdHandle) {
        IBuildProperty buildProperty;
        block3: {
            ITeamRepository fRepository = ((BuildSubsetEditorInput)this.getEditorInput()).getTeamRepository();
            IWorkspaceHandle wsHandle = null;
            try {
                IBuildDefinition buildDef = (IBuildDefinition)fRepository.itemManager().fetchCompleteItem((IItemHandle)bdHandle, 0, null);
                String wsPropertyId = DependencyBuildPropertyFactory.getInstance().resolvePropertyId("teamz.scm.workspaceUUID", buildDef);
                buildProperty = buildDef.getProperty(wsPropertyId);
                if (buildProperty != null) break block3;
                return null;
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
                return wsHandle;
            }
        }
        return (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildProperty.getValue()), null);
    }

    public BuildableSubsetContentsPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
        BuildSubsetEditorInput input = (BuildSubsetEditorInput)editor.getEditorInput();
        this.buildFileListViewer = new BuildableFilesViewer(input.getTeamRepository(), input.getBuildDefinition(), this.getEditor().getSite(), true, false){

            @Override
            protected Text createFilterText(Composite parent) {
                Text filterText = super.createFilterText(parent);
                Label label = new Label(parent, 0);
                GridDataFactory.fillDefaults().applyTo((Control)label);
                return filterText;
            }
        };
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.mainForm = managedForm.getForm();
        Composite body = this.mainForm.getBody();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)body);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(body);
        this.pageComposite = toolkit.createComposite(body);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.pageComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.pageComposite);
        this.createContentsSection(this.pageComposite, toolkit);
        managedForm.setInput((Object)this.getEditorInput());
    }

    private void createContentsSection(Composite parent, FormToolkit toolkit) {
        this.contentsSection = toolkit.createSection(parent, 384);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.contentsSection);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.contentsSection);
        this.contentsSection.setText(Messages.BuildableSubsetContentsPage_SECTION_CONTENTS);
        this.contentsSection.setDescription(Messages.BuildableSubsetContentsPage_SECTION_CONTENTS_EXPLANATION);
        Composite contentsComposite = toolkit.createComposite((Composite)this.contentsSection);
        contentsComposite.setLayoutData((Object)new GridData(768));
        contentsComposite.setLayout((Layout)new GridLayout(2, false));
        this.createContentsComponents(contentsComposite, toolkit);
        this.contentsSection.setClient((Control)contentsComposite);
    }

    private void createContentsComponents(Composite parent, FormToolkit toolkit) {
        this.totalCountLabel = new Link(parent, 16384);
        this.totalCountLabel.setEnabled(true);
        this.totalCountLabel.setBackground(parent.getBackground());
        this.totalCountLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((BuildableSubsetEditor)BuildableSubsetContentsPage.this.getEditor()).criteriaPage.displayWorkItemViewer(false);
            }
        });
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.totalCountLabel);
        this.buildableFilesLabel = toolkit.createLabel(parent, Messages.BuildableSubsetOverviewPage_LABEL_BUILDABLE_FILES);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.buildableFilesLabel);
        Composite buildableFilesComposite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)buildableFilesComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(buildableFilesComposite);
        this.buildFileListViewer.createContents(buildableFilesComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.buildFileListViewer.getMainComposite());
        this.buildFileListViewer.addBuildableFilesListener(this);
        this.buildFileListViewer.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BuildableSubsetContentsPage.this.updateEnablement();
            }
        });
        BuildSubsetFilesDropTargetAdapter.installDropSupport((StructuredViewer)this.buildFileListViewer.getTableViewer(), ((BuildSubsetEditorInput)this.getEditorInput()).getTeamRepository(), this);
        this.buildableActionComposite = toolkit.createComposite(buildableFilesComposite);
        GridDataFactory.fillDefaults().grab(false, true).align(4, 4).applyTo((Control)this.buildableActionComposite);
        GridLayoutFactory.fillDefaults().applyTo(this.buildableActionComposite);
        MenuManager addFileMenu = new MenuManager("#Popup");
        addFileMenu.add((IAction)new AddFilesManuallyAction());
        addFileMenu.add((IAction)new AddFilesWithRulesAction());
        addFileMenu.add((IAction)new AddFilesWithWorkItemsAction());
        addFileMenu.add((IAction)new AddFilesWithSubsetAction());
        this.addFileButton = toolkit.createButton(this.buildableActionComposite, Messages.BuildableSubsetOverviewPage_POPUP_ADD, 0x4000008);
        GridDataFactory.fillDefaults().applyTo((Control)this.addFileButton);
        ButtonUtils.installMenu(this.addFileButton, addFileMenu);
        this.addFileButton.setEnabled(((BuildableSubsetEditor)this.getEditor()).isNewSubset());
        this.removeFileButton = toolkit.createButton(this.buildableActionComposite, Messages.BuildableSubsetOverviewPage_BUTTON_REMOVE, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.removeFileButton);
        this.removeFileButton.setEnabled(false);
        this.removeFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection listSelection = (IStructuredSelection)BuildableSubsetContentsPage.this.buildFileListViewer.getTableViewer().getSelection();
                BuildableSubsetContentsPage.this.removeFiles(listSelection.toList());
            }
        });
        this.buildFileListViewer.getTableViewer().getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    IStructuredSelection listSelection = (IStructuredSelection)BuildableSubsetContentsPage.this.buildFileListViewer.getTableViewer().getSelection();
                    BuildableSubsetContentsPage.this.removeFiles(listSelection.toList());
                }
            }
        });
        this.removeAllFilesButton = toolkit.createButton(this.buildableActionComposite, Messages.BuildableSubsetOverviewPage_BUTTON_REMOVEALL, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.removeAllFilesButton);
        this.removeAllFilesButton.setEnabled(false);
        this.removeAllFilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openConfirm((Shell)BuildableSubsetContentsPage.this.getSite().getShell(), (String)Messages.BuildableSubsetOverviewPage_DIALOG_REMOVE_TITLE, (String)Messages.BuildableSubsetOverviewPage_DIALOG_REMOVE_MESSAGE)) {
                    BuildableSubsetContentsPage.this.finishRemove(BuildableSubsetContentsPage.this.buildFileListViewer.getBuildableFiles());
                    BuildableSubsetContentsPage.this.buildFileListViewer.getBuildableFiles().clear();
                    BuildableSubsetContentsPage.this.handleRemovedFiles(BuildableSubsetContentsPage.this.buildFileListViewer.getBuildableFiles());
                    BuildableSubsetContentsPage.this.buildFileListViewer.getTableViewer().setInput(BuildableSubsetContentsPage.this.buildFileListViewer.getBuildableFiles());
                    BuildableSubsetContentsPage.this.removeFileButton.setEnabled(false);
                    BuildableSubsetContentsPage.this.removeAllFilesButton.setEnabled(false);
                    BuildableSubsetContentsPage.this.setDirty(true);
                }
            }
        });
        this.updateEnablement();
        this.updateCounts();
    }

    private void handleRemovedFiles(List removedFiles) {
        List<ISubsetCriteria> criteria = ((BuildableSubsetEditor)this.getEditor()).criteriaPage.getCurrentCriteria();
        ArrayList<ISubsetCriteria> toRemove = new ArrayList<ISubsetCriteria>(criteria.size());
        for (ISubsetCriteria criterion : criteria) {
            if (BuildableSubsetUtil.isDynamic((ISubsetCriteria)criterion)) continue;
            toRemove.add(criterion);
        }
        if (!this.buildFileListViewer.getBuildableFiles().isEmpty()) {
            ArrayList<ISubsetCriteria> criteriaStillReferenced = new ArrayList<ISubsetCriteria>(toRemove);
            this.removeUnreferencedCriteria(this.buildFileListViewer.getBuildableFiles(), criteriaStillReferenced);
            toRemove.removeAll(criteriaStillReferenced);
        }
        if (!toRemove.isEmpty()) {
            ((BuildableSubsetEditor)this.getEditor()).criteriaPage.processRemovals(toRemove);
        }
    }

    private void removeUnreferencedCriteria(List<ISubsetFileDesc> list, List<ISubsetCriteria> criteria) {
        ArrayList<ISubsetCriteria> unreferenced = new ArrayList<ISubsetCriteria>(criteria);
        for (ISubsetFileDesc fileDesc : list) {
            for (ISubsetCriteria criterion : unreferenced) {
                ICriteriaWorkItem wiCriterion;
                if (criterion instanceof ICriteriaSubset) {
                    this.removeUnreferencedCriteria(list, ((ICriteriaSubset)criterion).getChildCriteria().getReferences());
                    continue;
                }
                if (!(criterion instanceof ICriteriaWorkItem) || (wiCriterion = (ICriteriaWorkItem)criterion).getAdditionalWorkItems().isEmpty()) continue;
                BuildSubsetEditorInput editorInput = (BuildSubsetEditorInput)this.getEditorInput();
                ITeamRepository repository = editorInput.getTeamRepository();
                Map workItemsToIDMap = Collections.EMPTY_MAP;
                try {
                    workItemsToIDMap = ClientFactory.getBuildableSubsetClient((ITeamRepository)repository).getWorkItemNumbers(wiCriterion.getAdditionalWorkItems(), repository);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
                ArrayList<UUID> toRemove = new ArrayList<UUID>();
                for (Map.Entry wiEntry : workItemsToIDMap.entrySet()) {
                    boolean keepIt = false;
                    String searchPath = "/" + ((Integer)wiEntry.getValue()).toString();
                    String containedPath = String.valueOf(searchPath) + "/";
                    for (ISubsetFileDesc fileDesc2 : list) {
                        ArrayList<String> references = new ArrayList<String>();
                        for (Object o : fileDesc2.getCriteriaRefs()) {
                            if (!(o instanceof StringHelper)) continue;
                            references.add(((StringHelper)o).getValue());
                        }
                        for (String reference : references) {
                            if (!reference.endsWith(searchPath) && !reference.contains(containedPath)) continue;
                            keepIt = true;
                            break;
                        }
                        if (keepIt) break;
                    }
                    if (keepIt) continue;
                    toRemove.add((UUID)wiEntry.getKey());
                }
                List wisToRemove = Stream.of(wiCriterion.getAdditionalWorkItems()).map(IWorkItemHandle.class::cast).filter(wi -> toRemove.contains(wi.getItemId())).collect(Collectors.toList());
                wiCriterion.getAdditionalWorkItems().removeAll(wisToRemove);
            }
            if (unreferenced.isEmpty()) break;
        }
        if (!unreferenced.isEmpty()) {
            criteria.removeAll(unreferenced);
        }
    }

    public int getFileCount() {
        BuildableSubsetEditor owningEditor;
        BuildSubsetEditorInput owningInput;
        ISubset subset;
        int result = 0;
        result = this.isInitialized ? this.buildFileListViewer.getBuildableFiles().size() : ((subset = (owningInput = (BuildSubsetEditorInput)(owningEditor = (BuildableSubsetEditor)this.getEditor()).getEditorInput()).getSubset()) == null || subset.getFileDescs() == null ? 0 : subset.getFileDescs().size());
        return result;
    }

    private void updateCounts() {
        int fileCounts = this.getFileCount();
        if (this.totalCountLabel != null && !this.totalCountLabel.isDisposed()) {
            int count = ((BuildableSubsetEditor)this.getEditor()).criteriaPage.getCriteriaCount(false);
            String label = NLS.bind((String)Messages.BuildableSubsetCriteriaPage_TOTAL_COUNT_LABEL, (Object)count);
            if (count > 0) {
                label = "<a>" + label + "</a>";
            }
            this.totalCountLabel.setText(label);
        }
        if (this.buildableFilesLabel != null && !this.buildableFilesLabel.isDisposed()) {
            this.buildableFilesLabel.setText(NLS.bind((String)Messages.BuildableSubsetOverviewPage_LABEL_BUILDABLE_FILES, (Object)fileCounts));
        }
        if (this.overviewFilesSummary != null && !this.overviewFilesSummary.isDisposed()) {
            this.overviewFilesSummary.setText("<a>" + NLS.bind((String)Messages.BuildableSubsetOverviewPage_CONTENTS_FILE_SUMMARY, (Object)fileCounts) + "</a>");
        }
    }

    @Override
    public void editorInitFinished() {
        List newFiles;
        BuildableSubsetEditor owningEditor = (BuildableSubsetEditor)this.getEditor();
        BuildSubsetEditorInput owningInput = (BuildSubsetEditorInput)owningEditor.getEditorInput();
        ISubset subset = (ISubset)owningInput.getSubset().getWorkingCopy();
        this.isInitialized = true;
        this.buildFileListViewer.getBuildableFiles().clear();
        if (subset != null && subset.getFileDescs() != null) {
            this.buildFileListViewer.getBuildableFiles().addAll(subset.getFileDescs());
        }
        if (owningInput.getAdditionalFileDescs() != null && !owningInput.getAdditionalFileDescs().isEmpty() && !(newFiles = BuildableSubsetUtil.merge3(this.buildFileListViewer.getBuildableFiles(), new ArrayList<ISubsetFileDesc>(owningInput.getAdditionalFileDescs()))).isEmpty()) {
            this.buildFileListViewer.setAddedBuildableFiles(newFiles);
            this.setDirty(true);
        }
        if (!this.buildFileListViewer.getBuildableFiles().isEmpty()) {
            this.buildFileListViewer.resolvePaths(this.buildFileListViewer.getBuildableFiles());
        }
        this.updateCounts();
    }

    public void updateCurrentCriteria(List<ISubsetCriteria> list) {
        this.buildFileListViewer.setCriteria(list);
    }

    @Override
    public void updateEnablement() {
        this.updateContentsEnablement();
    }

    private void updateContentsEnablement() {
        if (this.buildFileListViewer.getTableViewer() != null && !this.buildFileListViewer.getTableViewer().getTable().isDisposed()) {
            boolean jobBasedEnableState = !((BuildableSubsetEditor)this.getEditor()).isInitBuildSubsetJobsRunning();
            boolean selectionBasedEnableState = !this.buildFileListViewer.getTableViewer().getSelection().isEmpty();
            this.buildFileListViewer.getTableViewer().getControl().setEnabled(jobBasedEnableState);
            this.addFileButton.setEnabled(jobBasedEnableState && ((BuildableSubsetEditor)this.getEditor()).getBuildDefinition() != null);
            this.removeFileButton.setEnabled(jobBasedEnableState && selectionBasedEnableState && this.buildFileListViewer.getBuildableFiles().size() > 0);
            this.removeAllFilesButton.setEnabled(this.buildFileListViewer.getBuildableFiles().size() > 0);
        }
    }

    public List<ISubsetFileDesc> getBuildableFileList() {
        return this.buildFileListViewer.getBuildableFiles();
    }

    public boolean isDirty() {
        return !this.isDirty ? super.isDirty() : this.isDirty;
    }

    @Override
    public void setDirty(boolean state) {
        this.isDirty = state;
        ((BuildableSubsetEditor)this.getEditor()).fireDirtyPropertyChangeEvent();
    }

    @Override
    public void doSave(ISubset subset, IProgressMonitor monitor) {
        super.doSave(monitor);
        ISubset workingSubset = subset.isWorkingCopy() ? subset : (ISubset)subset.getWorkingCopy();
        this.addFilesToWorkingSubset(workingSubset);
    }

    private void addFilesToWorkingSubset(ISubset workingSubset) {
        List<ISubsetFileDesc> buildableFilesList = this.buildFileListViewer.getBuildableFiles();
        List buildableFilesUUIDList = buildableFilesList.stream().map(file -> file.getFileItem().getItemId()).collect(Collectors.toList());
        ArrayList<ISubsetFileDesc> toRemove = new ArrayList<ISubsetFileDesc>();
        for (Object o : workingSubset.getFileDescs()) {
            ISubsetFileDesc buildableFile;
            if (!(o instanceof ISubsetFileDesc) || buildableFilesUUIDList.contains((buildableFile = (ISubsetFileDesc)o).getFileItem().getItemId())) continue;
            toRemove.add(buildableFile);
        }
        ArrayList<UUID> workingSubsetBuildableFilesUUIDList = new ArrayList<UUID>();
        ArrayList<ISubsetFileDesc> toAdd = new ArrayList<ISubsetFileDesc>();
        for (Object o : workingSubset.getFileDescs()) {
            if (!(o instanceof ISubsetFileDesc)) continue;
            ISubsetFileDesc file2 = (ISubsetFileDesc)o;
            workingSubsetBuildableFilesUUIDList.add(file2.getFileItem().getItemId());
        }
        for (ISubsetFileDesc buildableFile : buildableFilesList) {
            if (!workingSubsetBuildableFilesUUIDList.contains(buildableFile.getFileItem().getItemId())) {
                toAdd.add(buildableFile);
                continue;
            }
            ISubsetFileDesc currBuildableFile = null;
            for (Object o : workingSubset.getFileDescs()) {
                ISubsetFileDesc file3;
                if (!(o instanceof ISubsetFileDesc) || !(file3 = (ISubsetFileDesc)o).getFileItem().getItemId().equals((Object)buildableFile.getFileItem().getItemId())) continue;
                currBuildableFile = file3;
            }
            if (currBuildableFile == null || currBuildableFile.isAlwaysBuild() == buildableFile.isAlwaysBuild() && !this.criteriaRefsChanged(currBuildableFile, buildableFile)) continue;
            toRemove.add(currBuildableFile);
            toAdd.add(buildableFile);
        }
        workingSubset.getFileDescs().removeAll(toRemove);
        workingSubset.getFileDescs().addAll(toAdd);
    }

    private boolean criteriaRefsChanged(ISubsetFileDesc currBuildableFile, ISubsetFileDesc newBuildableFile) {
        List currRefs = new ArrayList(currBuildableFile.getCriteriaRefs()).stream().map(helper -> helper.getValue()).collect(Collectors.toList());
        List newRefs = new ArrayList(newBuildableFile.getCriteriaRefs()).stream().map(helper -> helper.getValue()).collect(Collectors.toList());
        if (currRefs.size() != newRefs.size()) {
            return true;
        }
        for (String ref : currRefs) {
            if (newRefs.contains(ref)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void populateForPreview(ISubset subset) {
        ISubset workingSubset = subset.isWorkingCopy() ? subset : (ISubset)subset.getWorkingCopy();
        this.addFilesToWorkingSubset(workingSubset);
    }

    @Override
    public boolean validate(ISubset workingSubset) {
        boolean isWorking = true;
        return isWorking;
    }

    public IBuildDefinition getDefinitionFromHandle(IBuildDefinitionHandle handle) {
        IBuildDefinition buildDefinition = null;
        try {
            buildDefinition = (IBuildDefinition)((BuildSubsetEditorInput)this.getEditorInput()).getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)handle, 0, null);
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        return buildDefinition;
    }

    @Override
    public void refresh() {
        BuildableSubsetEditor owningEditor = (BuildableSubsetEditor)this.getEditor();
        BuildSubsetEditorInput owningInput = (BuildSubsetEditorInput)owningEditor.getEditorInput();
        ISubset subset = (ISubset)owningInput.getSubset().getWorkingCopy();
        this.buildFileListViewer.getBuildableFiles().clear();
        this.buildFileListViewer.getBuildableFiles().addAll(subset.getFileDescs());
        this.processAdditions(this.buildFileListViewer.getBuildableFiles(), true);
        this.setDirty(false);
    }

    @Override
    public void populateOverview(Composite parent, FormToolkit toolkit) {
        this.overviewFilesLabel = toolkit.createLabel(parent, Messages.BuildableSubsetOverviewPage_CONTENTS_FILES);
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)this.overviewFilesLabel);
        this.overviewFilesSummary = new Link(parent, 16384);
        this.overviewFilesSummary.setEnabled(true);
        this.overviewFilesSummary.setBackground(parent.getBackground());
        this.overviewFilesSummary.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildableSubsetContentsPage.this.getEditor().setActivePage("com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetEditor.CONTENTS");
            }
        });
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.overviewFilesSummary);
        this.updateCounts();
    }

    @Override
    public void appendInput(BuildSubsetEditorInput input) {
        this.addFiles(input.getAdditionalFileDescs());
    }

    @Override
    public void addFiles(Collection<ISubsetFileDesc> files) {
        ISubset workingSubset;
        List newFiles;
        if (files != null && !files.isEmpty() && !(newFiles = BuildableSubsetUtil.merge3((List)(workingSubset = (ISubset)this.getSubsetInput().getSubset().getWorkingCopy()).getFileDescs(), new ArrayList<ISubsetFileDesc>(files))).isEmpty()) {
            this.buildFileListViewer.setAddedBuildableFiles(newFiles);
            ((BuildableSubsetEditor)this.getEditor()).processAdditions(workingSubset);
        }
    }

    @Override
    public void drop(ISubset subset) {
        this.finishAdd(subset);
    }

    @Override
    public ISubset getTargetSubset() {
        return (ISubset)((BuildSubsetEditorInput)this.getEditorInput()).getSubset().getWorkingCopy();
    }

    private BuildSubsetEditorInput getSubsetInput() {
        return (BuildSubsetEditorInput)this.getEditorInput();
    }

    @Override
    public IBuildDefinitionHandle getBuildDefinitionHandle() {
        BuildSubsetEditorInput input = (BuildSubsetEditorInput)this.getEditorInput();
        if (input.getBuildDefinition() != null) {
            return input.getBuildDefinition();
        }
        if (input.getBuildDefinitionHandle() != null) {
            return input.getBuildDefinitionHandle();
        }
        UUID buildUUID = null;
        if (input.getSubset() != null && input.getSubset().getBuildDefinition() != null) {
            buildUUID = input.getSubset().getBuildDefinition().getItemId();
        }
        if (buildUUID != null) {
            return (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(buildUUID, null);
        }
        return null;
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.updateCounts();
    }

    @Override
    public void filePathsChanged() {
        this.updateEnablement();
        this.updateCounts();
    }

    @Override
    public void filesModified() {
        this.setDirty(true);
    }

    @Override
    public void removeFiles(List<ISubsetFileDesc> files) {
        if (!files.isEmpty()) {
            this.finishRemove(files);
            this.buildFileListViewer.getBuildableFiles().removeAll(files);
            this.handleRemovedFiles(files);
            this.buildFileListViewer.getTableViewer().setInput(this.buildFileListViewer.getBuildableFiles());
            this.removeFileButton.setEnabled(this.buildFileListViewer.getBuildableFiles().size() > 0);
            this.removeAllFilesButton.setEnabled(this.buildFileListViewer.getBuildableFiles().size() > 0);
            this.setDirty(true);
        }
    }

    @Override
    public void buildDefinitionChanged(IBuildDefinition buildDef) {
        this.buildFileListViewer.setBuildDefinition(buildDef);
    }

    public void setFocus() {
        this.buildFileListViewer.getTableViewer().getTable().setFocus();
    }

    public Object getAdapter(Class adapter) {
        if (BuildableFilesViewer.class.equals((Object)adapter)) {
            return this.buildFileListViewer;
        }
        return super.getAdapter(adapter);
    }

    private class AddFilesManuallyAction
    extends Action {
        public AddFilesManuallyAction() {
            super(Messages.BuildableSubsetOverviewPage_ACTION_MANUAL);
        }

        public void run() {
            BuildSubsetEditorInput editorInput = (BuildSubsetEditorInput)BuildableSubsetContentsPage.this.getEditorInput();
            ITeamRepository fRepository = editorInput.getTeamRepository();
            IBuildDefinitionHandle fBuildDefHandle = editorInput.getBuildDefinitionHandle();
            if (fBuildDefHandle == null) {
                fBuildDefHandle = (IBuildDefinitionHandle)((BuildableSubsetEditor)BuildableSubsetContentsPage.this.getEditor()).getBuildDefinition().getItemHandle();
            }
            BuildableSubsetContentsPage.this.dialog = (SelectionStatusDialog)new BuildSubsetFileSelectionDialog(BuildableSubsetContentsPage.this.getSite().getShell(), fRepository, fBuildDefHandle);
            ((BuildSubsetFileSelectionDialog)BuildableSubsetContentsPage.this.dialog).setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    if (e1 instanceof Component && e2 instanceof Component) {
                        return super.getComparator().compare(((Component)e1).getName(), ((Component)e2).getName());
                    }
                    if (e1 instanceof Folder && e2 instanceof Folder) {
                        return super.getComparator().compare(((Folder)e1).getName(), ((Folder)e2).getName());
                    }
                    if (e1 instanceof FileItem && e2 instanceof FileItem) {
                        return super.getComparator().compare(((FileItem)e1).getName(), ((FileItem)e2).getName());
                    }
                    return 1;
                }
            });
            if (BuildableSubsetContentsPage.this.dialog.open() == 0) {
                BuildableSubsetContentsPage.this.finishAdd();
            }
        }
    }

    private class AddFilesWithRulesAction
    extends Action {
        public AddFilesWithRulesAction() {
            super(Messages.BuildableSubsetOverviewPage_ACTION_RULES);
        }

        public void run() {
            final BuildSubsetEditorInput editorInput = (BuildSubsetEditorInput)BuildableSubsetContentsPage.this.getEditorInput();
            final ITeamRepository repository = editorInput.getTeamRepository();
            final IBuildDefinition buildDefinition = ((BuildableSubsetEditor)BuildableSubsetContentsPage.this.getEditor()).getBuildDefinition();
            BuildableSubsetContentsPage.this.dialog = new BuildSubsetRuleSelectionDialog(BuildableSubsetContentsPage.this.getSite().getShell(), repository, BuildableSubsetContentsPage.this.getWorkspaceHandleFromBuildDefinition((IBuildDefinitionHandle)buildDefinition), (IBuildDefinitionHandle)buildDefinition);
            if (BuildableSubsetContentsPage.this.dialog.open() == 0) {
                new UIUpdaterJob(""){
                    ISubset subset;
                    List<UUID> beforeAdd;

                    public IStatus runInBackground(IProgressMonitor monitor) {
                        this.subset = editorInput.getSubset();
                        this.beforeAdd = BuildableSubsetUtil.collectSubsetFileDescUUIDs((Collection)this.subset.getFileDescs());
                        this.subset = ((BuildSubsetRuleSelectionDialog)BuildableSubsetContentsPage.this.dialog).getResultSubset(this.subset);
                        return Status.OK_STATUS;
                    }

                    public IStatus runInUI(IProgressMonitor monitor) {
                        if (this.subset != null) {
                            if (((BuildSubsetRuleSelectionDialog)BuildableSubsetContentsPage.this.dialog).isShowingSummary()) {
                                List<ISubsetFileDesc> added = this.subset.getFileDescs();
                                added = added.stream().filter(file -> !BuildableSubsetUtil.containsFile((ISubsetFileDesc)file, this.beforeAdd)).collect(Collectors.toList());
                                ISubsetFileDesc[] buildableFileDescriptors = added.toArray(new ISubsetFileDesc[added.size()]);
                                IBuildSubsetRule subsetRule = ((BuildSubsetRuleSelectionDialog)BuildableSubsetContentsPage.this.dialog).getSubsetRule();
                                AddFileToSubsetSummaryDialog summaryDialog = new AddFileToSubsetSummaryDialog(subsetRule, buildableFileDescriptors, BuildableSubsetContentsPage.this.getSite().getShell(), repository, buildDefinition, this.subset.getCriteria().getReferences());
                                summaryDialog.open();
                            }
                            BuildableSubsetContentsPage.this.finishAdd(this.subset);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
    }

    private class AddFilesWithSubsetAction
    extends Action {
        public AddFilesWithSubsetAction() {
            super(Messages.BuildableSubsetOverviewPage_ACTION_SUBSETS);
        }

        public void run() {
            BuildSubsetEditorInput editorInput = (BuildSubsetEditorInput)BuildableSubsetContentsPage.this.getEditorInput();
            IProjectAreaHandle projectAreaHandle = editorInput.getProjectAreaHandle();
            final ITeamRepository repository = editorInput.getTeamRepository();
            IBuildDefinition fBuildDefHandle = ((BuildableSubsetEditor)BuildableSubsetContentsPage.this.getEditor()).getBuildDefinition();
            final ISubset thisSubset = ((BuildSubsetEditorInput)BuildableSubsetContentsPage.this.getEditorInput()).getSubset();
            ViewerFilter filter = null;
            if (thisSubset != null || thisSubset != null && thisSubset.getBuildDefinition() != null) {
                filter = new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        if (element instanceof ISubset) {
                            ISubset otherHandle = (ISubset)element;
                            if (thisSubset != null) {
                                return !thisSubset.getLabel().trim().equals(otherHandle.getLabel().trim()) || !thisSubset.getBuildDefinition().equals((Object)otherHandle.getBuildDefinition());
                            }
                        }
                        return true;
                    }
                };
            }
            if (projectAreaHandle != null) {
                ISubset[] subsets;
                final boolean[] displaySummary = new boolean[1];
                BuildSubsetSelectionDialog sDialog = new BuildSubsetSelectionDialog(BuildableSubsetContentsPage.this.getSite().getShell(), repository, ((BuildableSubsetEditor)BuildableSubsetContentsPage.this.getEditor()).getBuildDefinition(), true, true, filter){
                    private static final String DO_NOT_SHOW_SUMMARY_SETTING = "doNotShowSummarySetting_AddSubset";
                    Button showSummary;

                    @Override
                    protected void createAdditionalDialogContents(Composite composite) {
                        super.createAdditionalDialogContents(composite);
                        this.showSummary = new Button(composite, 32);
                        this.showSummary.setText(Messages.BuildSubsetRuleSelectionDialog_SHOW_SUMMARY);
                        this.showSummary.setSelection(!Activator.getDefault().getDialogSettings().getBoolean(DO_NOT_SHOW_SUMMARY_SETTING));
                        GridDataFactory.fillDefaults().indent(-1, 4).applyTo((Control)this.showSummary);
                    }

                    @Override
                    protected void computeResult() {
                        displaySummary[0] = this.showSummary.getSelection();
                        Activator.getDefault().getDialogSettings().put(DO_NOT_SHOW_SUMMARY_SETTING, !displaySummary[0]);
                        super.computeResult();
                    }
                };
                if (sDialog.open() == 0 && (subsets = sDialog.getSelectedSubsets()).length > 0) {
                    new UIUpdaterJob("", (IBuildDefinitionHandle)fBuildDefHandle, displaySummary){
                        ISubset subset;
                        ISubsetBuildSubsetRule2 rule;
                        List<UUID> beforeAdd;
                        private final /* synthetic */ IBuildDefinitionHandle val$fBuildDefHandle;
                        private final /* synthetic */ boolean[] val$displaySummary;
                        {
                            this.val$fBuildDefHandle = iBuildDefinitionHandle;
                            this.val$displaySummary = blArray;
                            super($anonymous0);
                        }

                        public IStatus runInBackground(IProgressMonitor monitor) {
                            this.rule = new SubsetBuildSubsetRule2();
                            this.beforeAdd = BuildableSubsetUtil.collectSubsetFileDescUUIDs((Collection)BuildableSubsetContentsPage.this.getTargetSubset().getFileDescs());
                            if (thisSubset != null) {
                                this.rule.setTargetSubset((ISubsetHandle)thisSubset);
                            }
                            ISubset[] iSubsetArray = subsets;
                            int n = subsets.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ISubset subset = iSubsetArray[n2];
                                this.rule.addEntry(subset.getLabel(), (ISubsetHandle)subset);
                                ++n2;
                            }
                            try {
                                this.subset = ClientFactory.getBuildableSubsetClient((ITeamRepository)repository).processRule((IBuildSubsetRule)this.rule, this.val$fBuildDefHandle, thisSubset);
                            }
                            catch (TeamRepositoryException e) {
                                e.printStackTrace();
                            }
                            return Status.OK_STATUS;
                        }

                        public IStatus runInUI(IProgressMonitor monitor) {
                            if (this.subset != null) {
                                if (this.val$displaySummary[0]) {
                                    List<ISubsetFileDesc> added = this.subset.getFileDescs();
                                    added = added.stream().filter(file -> !BuildableSubsetUtil.containsFile((ISubsetFileDesc)file, this.beforeAdd)).collect(Collectors.toList());
                                    ISubsetFileDesc[] buildableFileDescriptors = added.toArray(new ISubsetFileDesc[added.size()]);
                                    AddFileToSubsetSummaryDialog summaryDialog = new AddFileToSubsetSummaryDialog((IBuildSubsetRule)this.rule, buildableFileDescriptors, BuildableSubsetContentsPage.this.getSite().getShell(), repository, ((BuildableSubsetEditor)BuildableSubsetContentsPage.this.getEditor()).getBuildDefinition(), this.subset.getCriteria().getReferences());
                                    summaryDialog.open();
                                }
                                BuildableSubsetContentsPage.this.finishAdd(this.subset);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
        }
    }

    private class AddFilesWithWorkItemsAction
    extends Action {
        public AddFilesWithWorkItemsAction() {
            super(Messages.BuildableSubsetOverviewPage_ACTION_WORKITEMS);
        }

        public void run() {
            final BuildSubsetEditorInput editorInput = (BuildSubsetEditorInput)BuildableSubsetContentsPage.this.getEditorInput();
            IProjectAreaHandle projectAreaHandle = editorInput.getProjectAreaHandle();
            final ITeamRepository repository = editorInput.getTeamRepository();
            IBuildDefinition buildDefHandle = ((BuildableSubsetEditor)BuildableSubsetContentsPage.this.getEditor()).getBuildDefinition();
            if (buildDefHandle == null) {
                buildDefHandle = (IBuildDefinitionHandle)((BuildableSubsetEditor)BuildableSubsetContentsPage.this.getEditor()).getBuildDefinition().getItemHandle();
            }
            if (projectAreaHandle != null) {
                BuildableSubsetContentsPage.this.dialog = (SelectionStatusDialog)new BuildSubsetWorkItemSelectionDialog(BuildableSubsetContentsPage.this.getSite().getShell(), projectAreaHandle, (IBuildDefinitionHandle)buildDefHandle, true);
            } else {
                BuildableSubsetContentsPage.this.dialog = (SelectionStatusDialog)new BuildSubsetWorkItemSelectionDialog(BuildableSubsetContentsPage.this.getSite().getShell(), repository, (IBuildDefinitionHandle)buildDefHandle, true);
            }
            ((BuildSubsetWorkItemSelectionDialog)BuildableSubsetContentsPage.this.dialog).setShowCreateLink(false);
            if (BuildableSubsetContentsPage.this.dialog.open() == 0) {
                new UIUpdaterJob(""){
                    ISubset subset;
                    List<ISubsetFileDesc> beforeAdd;

                    public IStatus runInBackground(IProgressMonitor monitor) {
                        this.beforeAdd = editorInput.getSubset().getFileDescs();
                        this.subset = ((BuildSubsetWorkItemSelectionDialog)BuildableSubsetContentsPage.this.dialog).getResultSubset(editorInput.getSubset());
                        return Status.OK_STATUS;
                    }

                    public IStatus runInUI(IProgressMonitor monitor) {
                        if (this.subset != null) {
                            editorInput.setSubset(this.subset);
                            if (((BuildSubsetWorkItemSelectionDialog)BuildableSubsetContentsPage.this.dialog).isShowingSummary()) {
                                List<ISubsetFileDesc> added = this.subset.getFileDescs();
                                added = added.stream().filter(file -> !BuildableSubsetUtil.containsFileWithRef((ISubsetFileDesc)file, this.beforeAdd)).collect(Collectors.toList());
                                ISubsetFileDesc[] buildableFileDescriptors = added.toArray(new ISubsetFileDesc[added.size()]);
                                IBuildSubsetRule subsetRule = ((BuildSubsetWorkItemSelectionDialog)BuildableSubsetContentsPage.this.dialog).getSubsetRule();
                                AddFileToSubsetSummaryDialog summaryDialog = new AddFileToSubsetSummaryDialog(subsetRule, buildableFileDescriptors, BuildableSubsetContentsPage.this.getSite().getShell(), repository, ((BuildableSubsetEditor)BuildableSubsetContentsPage.this.getEditor()).getBuildDefinition(), this.subset.getCriteria().getReferences());
                                summaryDialog.open();
                            }
                            BuildableSubsetContentsPage.this.finishAdd(this.subset);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
    }
}

