/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.subset.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.common.helper.ItemHandleAwareHashMap;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.build.client.buildablesubset.IBuildableSubsetClient;
import com.ibm.team.enterprise.build.common.DependencyBuildPropertyFactory;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.actions.OpenLocalFileDescAction;
import com.ibm.team.enterprise.build.ui.data.export.TableData;
import com.ibm.team.enterprise.build.ui.subset.dnd.BuildSubsetFilesDragSourceAdapter;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetCriteriaPage;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetCriteria;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetFileDesc;
import com.ibm.team.enterprise.common.common.utils.StringMatcher;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildUtils;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.ui.editors.component.ComponentEditor;
import com.ibm.team.filesystem.ui.editors.component.ComponentEditorInput;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.explorer.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;

public class BuildableFilesViewer {
    protected ITeamRepository repository;
    protected IBuildDefinition buildDefinition;
    protected boolean useFilterControl;
    protected boolean readOnly;
    protected IWorkbenchPartSite partSite;
    protected Composite tableComposite;
    protected TableViewer buildFileTableViewer;
    protected ITableLabelProvider labelProvider;
    protected Text filterText;
    protected ViewerFilter viewerFilter;
    protected StringMatcher matcher;
    private Map<String, Map<UUID, String>> scmPathMap;
    private Map<String, String> componentNameMap;
    protected final List<ISubsetFileDesc> fBuildableFileDescs;
    private List<ISubsetFileDesc> fAddedBuildableFileDescs;
    private List<ISubsetCriteria> fCriteria;
    private List<IBuildableFilesListener> buildableFilesListeners;
    private String initialFilterText;
    private boolean criteriaChanged;
    protected Map<ISubsetFileDesc, String> fileBackRefs;
    protected Map<ISubsetFileDesc, Integer[]> fileIntegerBackRefs;
    protected List<UUID> locallyResolvedUUIDs = new ArrayList<UUID>();
    private static final int COLUMN_COMPONENT = 0;
    private static final int COLUMN_PATH = 1;
    private static final int COLUMN_WORK_ITEMS = 2;
    private static final int COLUMN_ALWAYS_BUILD = 3;
    Image infoIcon = null;

    public BuildableFilesViewer(ITeamRepository repository, IBuildDefinition buildDefinition, IWorkbenchPartSite partSite, boolean useFilterControl, boolean readOnly) {
        this.repository = repository;
        this.buildDefinition = buildDefinition;
        this.partSite = partSite;
        this.useFilterControl = useFilterControl;
        this.readOnly = readOnly;
        this.fBuildableFileDescs = new ArrayList<ISubsetFileDesc>();
        this.setInitialFilterText(WorkbenchMessages.FilteredTree_FilterMessage);
    }

    public void setSite(IWorkbenchPartSite partSite) {
        this.partSite = partSite;
    }

    public void createContents(Composite parent) {
        if (this.useFilterControl) {
            this.filterText = this.createFilterText(parent);
        }
        this.tableComposite = new Composite(parent, 0);
        this.buildFileTableViewer = new TableViewer(this.tableComposite, 68354);
        this.buildFileTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return BuildableFilesViewer.this.fBuildableFileDescs.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (BuildableFilesViewer.this.buildableFilesListeners != null) {
                    for (IBuildableFilesListener listener : BuildableFilesViewer.this.buildableFilesListeners) {
                        listener.inputChanged(viewer, oldInput, newInput);
                    }
                }
            }
        });
        TableColumnLayout columnLayout = new TableColumnLayout();
        this.tableComposite.setLayout((Layout)columnLayout);
        TableColumn defaultSortColumn = this.createTableColumn(Messages.BuildableFilesViewer_COLUMN_COMPONENT, null, 16384, 0, 15, columnLayout);
        this.createTableColumn(Messages.BuildableFilesViewer_COLUMN_PATH, null, 16384, 1, 65, columnLayout);
        this.createTableColumn(Messages.BuildableFilesViewer_COLUMN_WORK_ITEMS, null, 16384, 2, 10, columnLayout);
        final TableColumn alwaysBuildColumn = this.createTableColumn(Messages.BuildableFilesViewer_COLUMN_ALWAYS_BUILD, Messages.BuildableFilesViewer_COLUMN_ALWAYS_BUILD_TOOLTIP, 16384, 3, 10, columnLayout);
        if (!this.readOnly) {
            TableViewerColumn viewerColumn = new TableViewerColumn(this.buildFileTableViewer, alwaysBuildColumn);
            viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
            viewerColumn.setEditingSupport((EditingSupport)new BuildableSubsetCriteriaPage.ComboEditSupport((ColumnViewer)this.buildFileTableViewer){

                @Override
                protected void updateModel(Object element, Object value) {
                    if (((Integer)value).compareTo((Integer)this.getValue(element)) != 0) {
                        ((ISubsetFileDesc)element).setAlwaysBuild((Integer)value == 0);
                        if (BuildableFilesViewer.this.buildableFilesListeners != null) {
                            for (IBuildableFilesListener listener : BuildableFilesViewer.this.buildableFilesListeners) {
                                listener.filesModified();
                            }
                        }
                        if (alwaysBuildColumn == BuildableFilesViewer.this.buildFileTableViewer.getTable().getSortColumn()) {
                            BuildableFilesViewer.this.buildFileTableViewer.refresh(false);
                        }
                    }
                }

                @Override
                protected Object getValue(Object element) {
                    return ((ISubsetFileDesc)element).isAlwaysBuild() ? 0 : 1;
                }

                @Override
                protected boolean canEdit(Object element) {
                    return !BuildableFilesViewer.this.readOnly && element instanceof ISubsetFileDesc;
                }
            });
        }
        BuildSubsetFilesDragSourceAdapter.installDragSupport((StructuredViewer)this.buildFileTableViewer);
        this.labelProvider = new BuildableFilesLabelProvider();
        this.buildFileTableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.buildFileTableViewer.getTable().setHeaderVisible(true);
        if (this.useFilterControl) {
            this.viewerFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (BuildableFilesViewer.this.matcher == null) {
                        return true;
                    }
                    int cols = BuildableFilesViewer.this.buildFileTableViewer.getTable().getColumnCount();
                    int i = 0;
                    while (i < cols) {
                        String label = BuildableFilesViewer.this.labelProvider.getColumnText(element, i);
                        if (label != null && BuildableFilesViewer.this.matcher.match(label)) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
            };
            this.buildFileTableViewer.addFilter(this.viewerFilter);
        }
        this.buildFileTableViewer.getTable().setSortColumn(defaultSortColumn);
        this.buildFileTableViewer.getTable().setSortDirection(128);
        this.buildFileTableViewer.setComparator((ViewerComparator)new BuildableFilesComparator(0, 128));
        if (this.partSite != null) {
            MenuManager menuManager = new MenuManager("#PopupMenu");
            menuManager.setRemoveAllWhenShown(true);
            this.partSite.registerContextMenu(this.partSite.getId(), menuManager, (ISelectionProvider)this.buildFileTableViewer);
            Menu menu = menuManager.createContextMenu((Control)this.buildFileTableViewer.getTable());
            this.buildFileTableViewer.getTable().setMenu(menu);
            this.buildFileTableViewer.addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    OpenLocalFileDescAction action = new OpenLocalFileDescAction();
                    action.setActivePart(null, BuildableFilesViewer.this.partSite.getPart());
                    action.selectionChanged(null, event.getSelection());
                    action.run(null);
                }
            });
        }
        this.installTableTooltipSupport();
        this.buildFileTableViewer.setInput(this.fBuildableFileDescs);
        this.buildFileTableViewer.refresh();
    }

    protected void installTableTooltipSupport() {
        new TooltipSupport((Control)this.buildFileTableViewer.getTable(), true, false){

            protected Object mapElement(int x, int y) {
                Utils.ColumnPosition columnPosition;
                this.setOpenable(false);
                Integer[] element = super.mapElement(x, y);
                if (element instanceof ISubsetFileDesc && (columnPosition = Utils.mapColumn((Table)BuildableFilesViewer.this.buildFileTableViewer.getTable(), (int)x)) != null) {
                    switch (columnPosition.creationIndex) {
                        case 3: {
                            if (((ISubsetFileDesc)element).isAlwaysBuild()) {
                                element = Messages.BuildableFilesViewer_ALWAYS_BUILD_TOOLTIP;
                                break;
                            }
                            element = Messages.BuildableFilesViewer_NOT_ALWAYS_BUILD_TOOLTIP;
                            break;
                        }
                        case 2: {
                            if (BuildableFilesViewer.this.fileIntegerBackRefs == null) break;
                            this.setOpenable(BuildableFilesViewer.this.partSite != null);
                            element = BuildableFilesViewer.this.fileIntegerBackRefs.get(element);
                            break;
                        }
                        case 0: {
                            this.setOpenable(BuildableFilesViewer.this.partSite != null);
                            element = ((ISubsetFileDesc)element).getComponent();
                            break;
                        }
                        case 1: {
                            this.setOpenable(BuildableFilesViewer.this.partSite != null);
                        }
                    }
                }
                return element;
            }

            protected String getMarkup(Object element, boolean isFocus) {
                if (element instanceof IComponentHandle) {
                    String name = null;
                    if (BuildableFilesViewer.this.componentNameMap != null) {
                        name = (String)BuildableFilesViewer.this.componentNameMap.get(((IComponentHandle)element).getItemId().getUuidValue());
                    }
                    if (name == null) {
                        name = ((IComponentHandle)element).getItemId().getUuidValue();
                    }
                    if (name != null) {
                        return XMLString.createFromXMLText(name).getXMLText();
                    }
                    return null;
                }
                if (element instanceof String) {
                    return XMLString.createFromPlainText((String)((String)element)).getXMLText();
                }
                if (element instanceof ISubsetFileDesc) {
                    String label = BuildableFilesViewer.this.labelProvider.getColumnText(element, 1);
                    return XMLString.createFromPlainText((String)label).getXMLText();
                }
                if (element instanceof Integer[]) {
                    List<IWorkItemHandle> wiHandles = BuildableSubsetCriteriaPage.resolveWorkItemsToHandles(BuildableFilesViewer.this.repository, Arrays.asList((Integer[])element));
                    if (wiHandles.size() == 1) {
                        element = wiHandles.get(0);
                        return super.getMarkup(element, isFocus);
                    }
                    try {
                        return BuildableFilesViewer.getMultiWorkItemTooltip(wiHandles, BuildableFilesViewer.this.repository, isFocus);
                    }
                    catch (TeamRepositoryException e) {
                        Activator.getDefault().logError(e);
                        return null;
                    }
                }
                return super.getMarkup(element, isFocus);
            }

            protected void openRequested(final Object element) {
                new UIUpdaterJob(""){
                    Object resolved;

                    public IStatus runInBackground(IProgressMonitor monitor) {
                        if (element instanceof Integer[]) {
                            this.resolved = BuildableSubsetCriteriaPage.resolveWorkItemsToHandles((this).BuildableFilesViewer.this.repository, Arrays.asList((Integer[])element));
                        } else if (element instanceof IComponentHandle) {
                            try {
                                this.resolved = (this).BuildableFilesViewer.this.repository.itemManager().fetchCompleteItem((IItemHandle)((IComponentHandle)element), 0, null);
                            }
                            catch (TeamRepositoryException e) {
                                return new Status(4, "com.ibm.team.enterprise.build.ui", e.getMessage(), (Throwable)e);
                            }
                        } else {
                            this.resolved = element;
                        }
                        return Status.OK_STATUS;
                    }

                    public IStatus runInUI(IProgressMonitor monitor) {
                        if (this.resolved instanceof List) {
                            for (Object object : (List)this.resolved) {
                                if (!(object instanceof IWorkItemHandle)) continue;
                                WorkItemUI.open((IWorkbenchPage)(this).BuildableFilesViewer.this.partSite.getPage(), object);
                            }
                        } else if (this.resolved instanceof IComponent) {
                            ComponentEditor.open((IWorkbenchPage)(this).BuildableFilesViewer.this.partSite.getPage(), (com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentEditorInput)ComponentEditorInput.newForEdit((ComponentWrapper)new ComponentWrapper((this).BuildableFilesViewer.this.repository, (IComponent)this.resolved)));
                        } else if (this.resolved instanceof ISubsetFileDesc) {
                            OpenLocalFileDescAction action = new OpenLocalFileDescAction();
                            action.setActivePart(null, (this).BuildableFilesViewer.this.partSite.getPart());
                            action.selectionChanged(null, (ISelection)new StructuredSelection(this.resolved));
                            action.run(null);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        };
    }

    public static String getMultiWorkItemTooltip(List<IWorkItemHandle> itemHandles, ITeamRepository repository, boolean isFocus) throws TeamRepositoryException {
        List items = repository.itemManager().fetchPartialItems(itemHandles, 0, Arrays.asList(IWorkItem.SMALL_PROFILE), null);
        StringBuilder buf = new StringBuilder(200);
        buf.append("<b>");
        buf.append(NLS.bind((String)Messages.BuildableFilesViewer_WORK_ITEMS_TOOLTIP_TITLE, (Object)items.size()));
        buf.append("</b><br><ul>");
        for (IWorkItem item : items) {
            buf.append("<li>");
            if (isFocus) {
                buf.append("<a href=\"");
                Location uri = Location.itemLocation((IItemHandle)item, (String)repository.getRepositoryURI());
                buf.append(uri.toAbsoluteUri());
                buf.append("\">");
            }
            buf.append(NLS.bind((String)Messages.BuildableFilesViewer_WORK_ITEM_TOOLTIP_LABEL, (Object)item.getId(), (Object)item.getHTMLSummary().getXMLText()));
            if (isFocus) {
                buf.append("</a>");
            }
            buf.append("</li>");
        }
        buf.append("</ul>");
        return buf.toString();
    }

    private TableColumn createTableColumn(String name, String tooltip, int flags, final int id, int weight, TableColumnLayout layout) {
        TableColumn column = new TableColumn(this.buildFileTableViewer.getTable(), 16384, id);
        column.setText(name);
        column.setToolTipText(tooltip);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final TableColumn tableCol = (TableColumn)e.getSource();
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        int oldSortDir = tableCol == (this).BuildableFilesViewer.this.buildFileTableViewer.getTable().getSortColumn() ? (this).BuildableFilesViewer.this.buildFileTableViewer.getTable().getSortDirection() : 1024;
                        int newSortDir = 128;
                        switch (oldSortDir) {
                            case 128: {
                                newSortDir = 1024;
                                break;
                            }
                            case 1024: {
                                newSortDir = 128;
                            }
                        }
                        (this).BuildableFilesViewer.this.buildFileTableViewer.getTable().setSortColumn(tableCol);
                        (this).BuildableFilesViewer.this.buildFileTableViewer.getTable().setSortDirection(newSortDir);
                        ((BuildableFilesComparator)(this).BuildableFilesViewer.this.buildFileTableViewer.getComparator()).update(id, newSortDir);
                        (this).BuildableFilesViewer.this.buildFileTableViewer.refresh();
                    }
                });
            }
        });
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight));
        return column;
    }

    protected Text createFilterText(Composite parent) {
        final Text filterText = new Text(parent, 2436);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)filterText);
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = filterText.getText();
                BuildableFilesViewer.this.matcher = text.isEmpty() || text.trim().equals(BuildableFilesViewer.this.initialFilterText) ? null : new StringMatcher("*" + text + "*", true, false);
                BuildableFilesViewer.this.buildFileTableViewer.refresh(true);
            }
        });
        filterText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    BuildableFilesViewer.this.buildFileTableViewer.getTable().setFocus();
                    if (BuildableFilesViewer.this.buildFileTableViewer.getTable().getItemCount() > 0) {
                        BuildableFilesViewer.this.buildFileTableViewer.getTable().select(0);
                        BuildableFilesViewer.this.buildFileTableViewer.setSelection(BuildableFilesViewer.this.buildFileTableViewer.getSelection(), true);
                    }
                }
            }
        });
        filterText.setMessage(this.initialFilterText);
        return filterText;
    }

    public void setAddedBuildableFiles(List<ISubsetFileDesc> addedBuildableFileDescs) {
        this.fAddedBuildableFileDescs = addedBuildableFileDescs;
    }

    public void setBuildDefinition(IBuildDefinition buildDefinition) {
        this.buildDefinition = buildDefinition;
        this.resolvePaths(this.fBuildableFileDescs);
    }

    public IBuildDefinition getBuildDefinition() {
        return this.buildDefinition;
    }

    public void setTeamRepository(ITeamRepository repository) {
        this.repository = repository;
    }

    public void setInitialFilterText(String text) {
        if (text == null) {
            text = "";
        }
        this.initialFilterText = text;
    }

    public void dispose() {
        if (this.buildFileTableViewer != null) {
            this.buildFileTableViewer.getControl().dispose();
        }
        if (this.filterText != null) {
            this.filterText.dispose();
        }
    }

    public TableViewer getTableViewer() {
        return this.buildFileTableViewer;
    }

    public Composite getMainComposite() {
        return this.tableComposite;
    }

    public Text getFilterText() {
        return this.filterText;
    }

    public List<ISubsetFileDesc> getBuildableFiles() {
        return this.fBuildableFileDescs;
    }

    public void addBuildableFilesListener(IBuildableFilesListener listener) {
        if (this.buildableFilesListeners == null) {
            this.buildableFilesListeners = new ArrayList<IBuildableFilesListener>();
        }
        this.buildableFilesListeners.add(listener);
    }

    public void removeBuildableFilesListener(IBuildableFilesListener listener) {
        if (this.buildableFilesListeners != null) {
            this.buildableFilesListeners.remove(listener);
        }
    }

    private void fetchComponentName(final IComponentHandle componentHandle) throws TeamRepositoryException {
        new UIUpdaterJob(""){

            public IStatus runInBackground(IProgressMonitor monitor) {
                String componentId = componentHandle.getItemId().getUuidValue();
                if (!BuildableFilesViewer.this.componentNameMap.containsKey(componentId)) {
                    String componentName = null;
                    IItem item = null;
                    try {
                        item = BuildableFilesViewer.this.repository.itemManager().fetchPartialItem((IItemHandle)componentHandle, 0, Arrays.asList(IComponent.NAME_PROPERTY), null);
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                    }
                    if (item instanceof IComponent) {
                        componentName = ((IComponent)item).getName();
                    }
                    BuildableFilesViewer.this.componentNameMap.put(componentId, componentName);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void resolvePaths(final List<ISubsetFileDesc> fileDescs) {
        TeamBuildJob resolveSubsetPathsJob = new TeamBuildJob(Messages.BuildableSubsetOverviewPage_JOB_SUBSETPATHS_TITLE, false, this.repository){
            private boolean refreshList;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.refreshList = false;
            }

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                this.refreshList = this.resolvePaths();
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (refreshList && (this).BuildableFilesViewer.this.buildFileTableViewer != null && !(this).BuildableFilesViewer.this.buildFileTableViewer.getControl().isDisposed()) {
                            (this).BuildableFilesViewer.this.buildFileTableViewer.setInput((this).BuildableFilesViewer.this.fBuildableFileDescs);
                            (this).BuildableFilesViewer.this.buildFileTableViewer.refresh();
                        }
                        if ((this).BuildableFilesViewer.this.buildFileTableViewer != null && !(this).BuildableFilesViewer.this.buildFileTableViewer.getControl().isDisposed()) {
                            if (BuildableFilesViewer.this.fAddedBuildableFileDescs != null && BuildableFilesViewer.this.fAddedBuildableFileDescs.size() > 0) {
                                BuildableFilesViewer.this.selectAddedBuildableFiles(BuildableFilesViewer.this.fAddedBuildableFileDescs);
                                BuildableFilesViewer.this.fAddedBuildableFileDescs = null;
                            } else {
                                Object firstElement = (this).BuildableFilesViewer.this.buildFileTableViewer.getElementAt(0);
                                if (firstElement != null) {
                                    (this).BuildableFilesViewer.this.buildFileTableViewer.setSelection((ISelection)new StructuredSelection(firstElement));
                                }
                            }
                        }
                        if (BuildableFilesViewer.this.buildableFilesListeners != null) {
                            for (IBuildableFilesListener listener : BuildableFilesViewer.this.buildableFilesListeners) {
                                listener.filePathsChanged();
                            }
                        }
                    }
                });
            }

            /*
             * Unable to fully structure code
             */
            private boolean resolvePaths() throws TeamRepositoryException {
                unresolvedUUIDs = new HashMap<String, ArrayList<E>>();
                BuildableFilesViewer.this.locallyResolvedUUIDs.clear();
                if (BuildableFilesViewer.this.repository == null || fileDescs == null) {
                    return false;
                }
                if (fileDescs.size() == 0 && !BuildableFilesViewer.access$9(BuildableFilesViewer.this)) {
                    return false;
                }
                if (fileDescs.size() > 0) {
                    if (BuildableFilesViewer.access$3(BuildableFilesViewer.this) == null) {
                        BuildableFilesViewer.access$10(BuildableFilesViewer.this, new HashMap<K, V>());
                    }
                    if (BuildableFilesViewer.access$1(BuildableFilesViewer.this) == null) {
                        BuildableFilesViewer.access$11(BuildableFilesViewer.this, new HashMap<K, V>());
                    }
                    componentVersionableMap = new HashMap<String, ItemHandleAwareHashMap>();
                    for (ISubsetFileDesc buildableFileDesc : fileDescs) {
                        componentUUID = buildableFileDesc.getComponent().getItemId().getUuidValue();
                        handlesToDescs = (ItemHandleAwareHashMap)componentVersionableMap.get(componentUUID);
                        if (handlesToDescs == null) {
                            handlesToDescs = new ItemHandleAwareHashMap();
                            componentVersionableMap.put(componentUUID, handlesToDescs);
                        }
                        handlesToDescs.put((Object)buildableFileDesc.getFileItem(), (Object)buildableFileDesc);
                    }
                    workspaceHandle = this.getWorkspaceHandle();
                    resolvedWorkspace = workspaceHandle == null ? null : new BuildUtils().getWorkspaceStream(workspaceHandle, BuildableFilesViewer.this.repository);
                    wsConn = resolvedWorkspace == null ? null : SCMPlatform.getWorkspaceManager((ITeamRepository)BuildableFilesViewer.this.repository).getWorkspaceConnection((IWorkspaceHandle)resolvedWorkspace, null);
                    block5: for (String componentId : componentVersionableMap.keySet()) {
                        componentPaths = (HashMap<UUID, String>)BuildableFilesViewer.access$3(BuildableFilesViewer.this).get(componentId);
                        if (componentPaths == null) {
                            componentPaths = new HashMap<UUID, String>();
                            BuildableFilesViewer.access$3(BuildableFilesViewer.this).put(componentId, componentPaths);
                        }
                        componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)componentId), null);
                        if (!BuildableFilesViewer.access$1(BuildableFilesViewer.this).containsKey(componentId)) {
                            componentName = null;
                            item = BuildableFilesViewer.this.repository.itemManager().fetchPartialItem((IItemHandle)componentHandle, 0, Arrays.asList(new String[]{IComponent.NAME_PROPERTY}), null);
                            if (item instanceof IComponent) {
                                componentName = ((IComponent)item).getName();
                            }
                            BuildableFilesViewer.access$1(BuildableFilesViewer.this).put(componentId, componentName);
                        }
                        handlesToDescs = (ItemHandleAwareHashMap)componentVersionableMap.get(componentId);
                        if (wsConn == null) {
                            for (IVersionableHandle versionableHandle : handlesToDescs.keySet()) {
                                componentPaths.put(versionableHandle.getItemId(), Messages.BuildableFilesViewer_NO_WORKSPACE);
                            }
                            continue;
                        }
                        component = null;
                        versionableHandles = new ArrayList<E>(handlesToDescs.keySet());
                        try {
                            configuration = wsConn.configuration(componentHandle);
                            reports = configuration.locateAncestors(versionableHandles, null);
                            if (reports == null || reports.size() == 0) continue;
                            deletedVersionableHandles = new ArrayList<IVersionableHandle>();
                            i = 0;
                            while (i < versionableHandles.size()) {
                                path = this.getPath((IAncestorReport)reports.get(i));
                                if (!path.isEmpty()) {
                                    componentPaths.put(((IVersionableHandle)versionableHandles.get(i)).getItemId(), path.toString());
                                } else {
                                    deletedVersionableHandles.add((IVersionableHandle)versionableHandles.get(i));
                                }
                                ++i;
                            }
                            if (deletedVersionableHandles.size() <= 0) continue;
                            historyReports = configuration.determineAncestorsInHistory(deletedVersionableHandles, null);
                            i = 0;
                            while (i < deletedVersionableHandles.size()) {
                                path = this.getPath((IAncestorReport)historyReports.get(i));
                                handle = (IVersionableHandle)deletedVersionableHandles.get(i);
                                if (!path.isEmpty()) {
                                    componentPaths.put(handle.getItemId(), NLS.bind((String)Messages.BuildableFilesViewer_DELETED_FILE_PATH, (Object)path.toString()));
                                } else {
                                    if (component == null) {
                                        component = (IComponent)BuildableFilesViewer.this.repository.itemManager().fetchPartialItem((IItemHandle)componentHandle, 0, Arrays.asList(new String[]{IVersionable.NAME_PROPERTY}), null);
                                    }
                                    if ((localPathValue = this.resolveLocallyInSandbox(component, pathValue = NLS.bind((String)Messages.BuildableFilesViewer_UNRESOLVED_FILE_PATH, (Object)component.getName(), (Object)resolvedWorkspace.getName()), desc = (ISubsetFileDesc)handlesToDescs.get((Object)handle))) != null) {
                                        pathValue = localPathValue;
                                    }
                                    componentPaths.put(handle.getItemId(), pathValue);
                                }
                                ++i;
                            }
                            continue;
                        }
                        catch (ComponentNotInWorkspaceException e) {
                            component = (IComponent)BuildableFilesViewer.this.repository.itemManager().fetchPartialItem((IItemHandle)componentHandle, 0, Arrays.asList(new String[]{IVersionable.NAME_PROPERTY}), null);
                            if (versionableHandles.isEmpty()) continue;
                            unresolvedUUIDs.put(componentId, versionableHandles);
                            ** for (handle : versionableHandles)
                        }
lbl-1000:
                        // 1 sources

                        {
                            componentPaths.put(handle.getItemId(), NLS.bind((String)Messages.BuildableFilesViewer_NO_COMPONENT_FILE_PATH, (Object)component.getName(), (Object)resolvedWorkspace.getName()));
                            continue;
lbl93:
                            // 1 sources

                        }
                    }
                    if (!unresolvedUUIDs.isEmpty()) {
                        buf = new StringBuilder(500);
                        buf.append(Messages.BuildableFilesViewer_LOG_UNRESOLVED_FILES_TITLE);
                        for (Map.Entry<K, V> entry : unresolvedUUIDs.entrySet()) {
                            buf.append('\n');
                            filesBuf = new StringBuilder(100);
                            for (IVersionableHandle v : (List)entry.getValue()) {
                                if (filesBuf.length() > 0) {
                                    filesBuf.append(", ");
                                }
                                filesBuf.append(v.getItemId().getUuidValue());
                            }
                            buf.append(NLS.bind((String)Messages.BuildableFilesViewer_LOG_UNRESOLVED_FILES_LISTING, entry.getKey(), (Object)filesBuf.toString()));
                        }
                        Activator.getDefault().getLog().log((IStatus)new Status(2, "com.ibm.team.enterprise.build.ui", buf.toString()));
                    }
                }
                try {
                    if (BuildableFilesViewer.access$9(BuildableFilesViewer.this)) {
                        BuildableFilesViewer.access$12(BuildableFilesViewer.this, false);
                        if (BuildableFilesViewer.this.fileBackRefs != null) {
                            BuildableFilesViewer.this.fileBackRefs.clear();
                        }
                        this.resolveCriteria(BuildableFilesViewer.this.fBuildableFileDescs);
                    } else if (fileDescs.size() > 0) {
                        this.resolveCriteria(fileDescs);
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().logError(e);
                }
                return true;
            }

            private String resolveLocallyInSandbox(IComponent component, String pathValue, ISubsetFileDesc desc) throws FileSystemException {
                IFileItemHandle fileHandle = (IFileItemHandle)desc.getFileItem();
                Collection shareables = SharingManager.getInstance().findShareables((IComponentHandle)component, (IVersionableHandle)fileHandle, null);
                if (shareables != null && shareables.size() != 0) {
                    if (shareables.size() == 1) {
                        String filename = ((IShareable)shareables.iterator().next()).getLocalPath().toString();
                        BuildableFilesViewer.this.locallyResolvedUUIDs.add(fileHandle.getItemId());
                        pathValue = NLS.bind((String)Messages.BuildableFilesViewer_UNRESOLVED_FILE_PATH_WITH_PREFIX, (Object)filename, (Object)pathValue);
                    } else if (shareables.size() > 1) {
                        String filename = null;
                        for (IShareable shareable : shareables) {
                            String shareableName = shareable.getLocalPath().getName();
                            if (filename == null) {
                                filename = shareableName;
                                continue;
                            }
                            if (filename.equals(shareableName)) continue;
                            filename = null;
                            break;
                        }
                        if (filename != null) {
                            BuildableFilesViewer.this.locallyResolvedUUIDs.add(fileHandle.getItemId());
                            pathValue = NLS.bind((String)Messages.BuildableFilesViewer_UNRESOLVED_FILE_PATH_WITH_PREFIX, (Object)filename, (Object)pathValue);
                        }
                    }
                }
                return pathValue;
            }

            private void resolveCriteria(List<ISubsetFileDesc> fBuildableFileDescs) {
                if (BuildableFilesViewer.this.fCriteria != null) {
                    if (BuildableFilesViewer.this.fileBackRefs == null) {
                        BuildableFilesViewer.this.fileBackRefs = new HashMap<ISubsetFileDesc, String>();
                    }
                    if (BuildableFilesViewer.this.fileIntegerBackRefs == null) {
                        BuildableFilesViewer.this.fileIntegerBackRefs = new HashMap<ISubsetFileDesc, Integer[]>();
                    }
                    for (ISubsetFileDesc file : fBuildableFileDescs) {
                        IBuildableSubsetClient client = (IBuildableSubsetClient)BuildableFilesViewer.this.repository.getClientLibrary(IBuildableSubsetClient.class);
                        List refs = null;
                        try {
                            refs = client.getReferencedCriterion(file, BuildableFilesViewer.this.fCriteria, BuildableFilesViewer.this.repository);
                        }
                        catch (TeamRepositoryException e) {
                            e.printStackTrace();
                        }
                        if (refs == null) continue;
                        ArrayList wiRefs = new ArrayList(refs.stream().map(obj -> {
                            if (obj != null && obj instanceof Integer) {
                                return (Integer)obj;
                            }
                            return null;
                        }).filter(i -> i != null).collect(Collectors.toSet()));
                        String wiList = wiRefs.stream().map(String::valueOf).collect(Collectors.joining(","));
                        BuildableFilesViewer.this.fileBackRefs.put(file, wiList);
                        BuildableFilesViewer.this.fileIntegerBackRefs.put(file, wiRefs.toArray(new Integer[wiRefs.size()]));
                    }
                }
            }

            private IWorkspaceHandle getWorkspaceHandle() {
                String workspaceUUID;
                block4: {
                    if (BuildableFilesViewer.this.buildDefinition == null) {
                        return null;
                    }
                    try {
                        String workspaceUUIDProperty = DependencyBuildPropertyFactory.getInstance().resolvePropertyId("teamz.scm.workspaceUUID", BuildableFilesViewer.this.buildDefinition);
                        workspaceUUID = BuildableFilesViewer.this.buildDefinition.getPropertyValue(workspaceUUIDProperty, null);
                        if (workspaceUUID != null) break block4;
                        return null;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                return (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceUUID), null);
            }

            private IPath getPath(IAncestorReport report) {
                Path path = new Path("");
                List pathnamePairs = report.getNameItemPairs();
                for (INameItemPair pair : pathnamePairs) {
                    if (pair.getName() == null) continue;
                    path = path.append(pair.getName());
                }
                return path;
            }
        };
        resolveSubsetPathsJob.schedule();
    }

    private void selectAddedBuildableFiles(List<ISubsetFileDesc> fileDescs) {
        if (fileDescs != null && fileDescs.size() > 0 && this.buildFileTableViewer != null && this.buildFileTableViewer.getTable() != null && !this.buildFileTableViewer.getTable().isDisposed()) {
            this.buildFileTableViewer.setSelection((ISelection)new StructuredSelection(fileDescs.toArray()));
        }
    }

    public void setCriteria(List<ISubsetCriteria> list) {
        this.fCriteria = list;
        this.criteriaChanged = true;
    }

    public TableData getTableData(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", this.buildFileTableViewer.getTable().getItemCount());
        TableData data = new TableData(this.buildFileTableViewer.getTable().getColumns());
        int i = 0;
        while (i < this.buildFileTableViewer.getTable().getItemCount()) {
            if (monitor.isCanceled()) break;
            data.addRow(this.buildFileTableViewer.getTable().getItem(i));
            monitor.worked(1);
            ++i;
        }
        return data;
    }

    public void childrenModified(List<ISubsetFileDesc> modifiedFiles) {
        if (!modifiedFiles.isEmpty()) {
            this.getTableViewer().refresh();
            for (IBuildableFilesListener listener : this.buildableFilesListeners) {
                listener.filesModified();
            }
        }
    }

    public void removeFiles(List<ISubsetFileDesc> files) {
        for (IBuildableFilesListener listener : this.buildableFilesListeners) {
            listener.removeFiles(files);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private Image getInfoIcon() {
        if (this.infoIcon == null) {
            FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
            this.infoIcon = fieldDecoration.getImage();
        }
        return this.infoIcon;
    }

    public String getScmLocation(String componentId, UUID versionableUuid) {
        Map<UUID, String> scmLocationMap = this.scmPathMap.get(componentId);
        if (scmLocationMap != null) {
            return scmLocationMap.get(versionableUuid);
        }
        return null;
    }

    static /* synthetic */ boolean access$9(BuildableFilesViewer buildableFilesViewer) {
        return buildableFilesViewer.criteriaChanged;
    }

    static /* synthetic */ void access$10(BuildableFilesViewer buildableFilesViewer, Map map) {
        buildableFilesViewer.scmPathMap = map;
    }

    static /* synthetic */ void access$11(BuildableFilesViewer buildableFilesViewer, Map map) {
        buildableFilesViewer.componentNameMap = map;
    }

    static /* synthetic */ void access$12(BuildableFilesViewer buildableFilesViewer, boolean bl) {
        buildableFilesViewer.criteriaChanged = bl;
    }

    private class BuildableFilesComparator
    extends ViewerComparator {
        private int colIndex;
        private final Map<Integer, Integer> sortingByColumn = new HashMap<Integer, Integer>();

        public BuildableFilesComparator(int colIndex, int sortDir) {
            this.update(colIndex, sortDir);
        }

        public void update(int colIndex, int sortDir) {
            this.colIndex = colIndex;
            this.sortingByColumn.put(colIndex, sortDir);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (BuildableFilesViewer.this.labelProvider == null) {
                return super.compare(viewer, e1, e2);
            }
            try {
                ISubsetFileDesc desc1 = (ISubsetFileDesc)e1;
                ISubsetFileDesc desc2 = (ISubsetFileDesc)e2;
                int result = 0;
                switch (this.colIndex) {
                    case 0: {
                        result = this.sortByColumn(desc1, desc2, 0);
                        if (result == 0) {
                            result = this.sortByColumn(desc1, desc2, 1);
                        }
                        return result;
                    }
                    case 1: {
                        result = this.sortByColumn(desc1, desc2, 1);
                        if (result == 0) {
                            result = this.sortByColumn(desc1, desc2, 0);
                        }
                        return result;
                    }
                    case 2: {
                        return this.sortByColumn(desc1, desc2, 2);
                    }
                    case 3: {
                        return this.sortByColumn(desc1, desc2, 3);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return super.compare(viewer, e1, e2);
        }

        private int sortByColumn(ISubsetFileDesc desc1, ISubsetFileDesc desc2, int column) {
            int result = column == 3 ? Boolean.valueOf(desc1.isAlwaysBuild()).compareTo(desc2.isAlwaysBuild()) : BuildableFilesViewer.this.labelProvider.getColumnText((Object)desc1, column).compareTo(BuildableFilesViewer.this.labelProvider.getColumnText((Object)desc2, column));
            if (result != 0) {
                Integer sortDir = this.sortingByColumn.get(column);
                result = sortDir == null || sortDir == 128 ? result : result * -1;
            }
            return result;
        }
    }

    private class BuildableFilesLabelProvider
    extends ColumnLabelProvider
    implements ITableLabelProvider {
        private BuildableFilesLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ISubsetFileDesc buildableFile;
            UUID fileItemId;
            Image result = null;
            if (1 == columnIndex && element instanceof ISubsetFileDesc && BuildableFilesViewer.this.locallyResolvedUUIDs.contains(fileItemId = (buildableFile = (ISubsetFileDesc)element).getFileItem().getItemId())) {
                result = BuildableFilesViewer.this.getInfoIcon();
            }
            return result;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == null) {
                return "";
            }
            if (element instanceof ISubsetFileDesc) {
                ISubsetFileDesc buildableFile = (ISubsetFileDesc)element;
                switch (columnIndex) {
                    case 0: {
                        String name = null;
                        if (BuildableFilesViewer.this.componentNameMap != null) {
                            name = (String)BuildableFilesViewer.this.componentNameMap.get(buildableFile.getComponent().getItemId().getUuidValue());
                        }
                        if (name == null && BuildableFilesViewer.this.componentNameMap != null) {
                            IComponentHandle compHandle = buildableFile.getComponent();
                            try {
                                BuildableFilesViewer.this.fetchComponentName(compHandle);
                            }
                            catch (TeamRepositoryException e) {
                                e.printStackTrace();
                            }
                            name = compHandle != null ? (String)BuildableFilesViewer.this.componentNameMap.get(compHandle.getItemId().getUuidValue()) : null;
                        }
                        return name == null ? "" : name;
                    }
                    case 1: {
                        Map componentPaths;
                        String path = null;
                        if (BuildableFilesViewer.this.scmPathMap != null && (componentPaths = (Map)BuildableFilesViewer.this.scmPathMap.get(buildableFile.getComponent().getItemId().getUuidValue())) != null) {
                            path = (String)componentPaths.get(buildableFile.getFileItem().getItemId());
                        }
                        return path == null ? "" : path;
                    }
                    case 2: {
                        String wiList = null;
                        if (BuildableFilesViewer.this.fileBackRefs != null) {
                            wiList = BuildableFilesViewer.this.fileBackRefs.get(buildableFile);
                        }
                        return wiList == null ? "" : wiList;
                    }
                    case 3: {
                        return buildableFile.isAlwaysBuild() ? Messages.BuildableSubsetEditorCriteriaPage_TRUE : Messages.BuildableSubsetEditorCriteriaPage_FALSE;
                    }
                }
            }
            return Messages.BuildableSubsetOverviewPage_ERROR_INVALID_FILETYPE;
        }

        public void update(ViewerCell cell) {
            super.update(cell);
            Table table = BuildableFilesViewer.this.buildFileTableViewer.getTable();
            int cols = table.getColumnCount();
            int i = 0;
            while (i < cols) {
                table.getColumn(i).pack();
                ++i;
            }
        }
    }

    public static interface IBuildableFilesListener {
        public void inputChanged(Viewer var1, Object var2, Object var3);

        public void filePathsChanged();

        public void filesModified();

        public void removeFiles(List<ISubsetFileDesc> var1);

        public void addFiles(Collection<ISubsetFileDesc> var1);
    }
}

